/*
 *	Program to manipulate DOS-style tapes (DEC)
 */

char usage[] "Usage: dostp [-][rtx][mh][0-7][s] [file] ...\n";

/*
 *	where one of [rtx] must be present with meaning make, list,
 *	extract resp. Files are extracted into the current directory.
 *	If no file names are mentioned, all files from the current
 *	directory down are put on the tape, or all files on the tape
 *	are listed or extracted.
 *	The tape unit density is specified by 'm' (800) or 'h' (1600).
 *	[0-7] is the tape unit number (0 default).
 *	The 's' flag specified that the files are to be processed by
 *	removing nulls and carriage-returns (for extract).
 *
 *	The standard name on the tape is a maximum of 6 (rad50) chars,
 *	followed by a '.', followed by a maximum of three (rad50) chars.
 *	Unix pathnames are zapped down to the last component,
 *	and altered accordingly.
 *
 *	NOTE: this program does not decode dates correctly yet!
 *
 *				Ian J & Kev	UNSW
 */

#define	MAXDIR	10		/* max. nr. dirs in path name */
#define	MAXPATH	128		/* max. nr. chars allowed in path name */

struct doslabel
{
	int dos_fname[3];		/* rad50 file name + extension */
	char dos_pnum;			/* programmer number */
	char dos_prnum;			/* project number */
	char dos_pcode;			/* protection code. 233(8) ok */
	char dos_dum1;			/* 1 byte of zero */
	struct				/* creation date */
	{
		int year  : 5;		/* year less 1972 */
		int day   : 5;		/* 1 thru 31 */
		int month : 5;		/* 1 thru 12 */
	} dos_cdate;
	char dos_dum2;			/* 1 byte of zero */
	char dos_dum3;			/* 1 byte of zero */
} doslabel;

struct dir
{
	int inum;
	char name[14];
	char pad;
} dir;

int fdstack[MAXDIR];
int fdsp;		/* for recursive descent down tree */
char pathn[MAXPATH];
char *pathp;
char indir;		/* flag - set while descending */

char heading;
char buf[512];	/* do tape i/o here */

int process;
int argn;
char **argp;

char magtape[] "/dev/rmt0";
#define	DENS	6	/* to zap the density */
#define	UNIT	8	/* to zap the '0' */
char nmagtape[] "/dev/rnmt0";
#define	RDENS	7	/* to zap the density */
#define	RUNIT	9	/* to zap the '0' */

main(argc, argv)
int argc;
char **argv;
{
	register char *cp;
	int (*func)();
	int xtract(), list(), make();

	if (argc < 2)
	{
		prints(2, usage);
		exit(1);
	}
	cp = argv[1];
	while (*cp)
		switch(*cp++)
		{
	    case '-':	continue;

	    case 'r':	func = make;
			continue;

	    case 't':	func = list;
			continue;

	    case 'x':	func = xtract;
			continue;

	    case 'm':
	    case 'h':	magtape[DENS] = cp[-1];
			nmagtape[RDENS] = cp[-1];
			continue;

	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':	magtape[UNIT] = cp[-1];
			nmagtape[RUNIT] = cp[-1];
			continue;

	    case 's':	process++;
			continue;

	    default:	prints(2, usage);
			exit(1);
		}

	argn = argc - 2;
	argp = &argv[2];	/* start of args left */
	(*func)();
	exit(0);
}


list()
{
	register nfile, tape, blks;
	int month;
	char fname[12];
	static char months[] "janfebmaraprmayjunjulaugsepoctnovdec???";

	if ((tape = open(magtape, 0)) < 0)
	{
		perror(magtape);
		exit(1);
	}
	nfile = 0;
	while (read(tape, &doslabel, sizeof doslabel) == sizeof doslabel)
	{
		blks = 0;
		dtou(doslabel.dos_fname, fname);
		nfile++;
		while (read(tape, buf, sizeof buf) > 0)
			blks++;
		if (match(fname, 0))
		{
			if (heading == 0)
			{
				heading++;
				printf(" BLKS PERM   DATE    NAME\n");
			}
			month = doslabel.dos_cdate.month - 1;
			if (month < 0 || month > 12) month = 12;
			month =* 3;
			printf(" %4d %3o  %2d-%3.3s-%2d %s\n",
				blks,
				doslabel.dos_pcode & 0377,
				doslabel.dos_cdate.day,
				&months[month],
				doslabel.dos_cdate.year+72,
				fname);
		}
	}
	if (argn == 0)
		printf("\n\t%d files on tape\n", nfile);
}

xtract()
{
	register i, n, tape;
	int an = argn;
	int nfiles = 0;
	int obuf[259];
	char fname[12];

	if ((tape = open(magtape, 0)) < 0)
	{
		perror(magtape);
		exit(1);
	}
	while (read(tape, buf, sizeof buf) == sizeof doslabel)
	{
		dtou((&buf)->dos_fname, fname);
		if (match(fname, 1))
		{
			nfiles++;
			printf(" x %s\n", fname);
			if (fcreat(fname, obuf) == -1)
			{
				perror(fname);
				goto flush;
			}
			while((n = read(tape, buf, sizeof buf)) > 0)
				for(i = 0; i < n; i++)
					if (process == 0 ||
					   (buf[i] != '\r') &&
					     (buf[i] != '\0'))
						putc(buf[i], obuf);
			fflush(obuf);
			close(obuf[0]);
			if (an == nfiles)
				break;
			continue;
		}
	flush:
		while (read(tape, buf, sizeof buf) > 0);
	}
	printf("%d files extracted\n", nfiles);
}


#include	<stat.h>

make()
{
	register char *cp;
	register nfile;
	register file;		/* file desc. */
	int n;			/* how much read */
	int tape;
	int *ip;
	long time();
	int *localtime();

	nfile = 0;
	if ((tape = open(nmagtape, 1)) < 0)
	{
		perror(nmagtape);
		exit(1);
	}
	ip = localtime(time());
	doslabel.dos_pcode = 0233;	/* protection code */
	doslabel.dos_cdate.year = ip[5] - 0110;
	doslabel.dos_cdate.day = ip[3];
	doslabel.dos_cdate.month = ip[4] + 1;

	if (argn == 0)
	{
		argn = 1;
		*argp = ".";	/* curr. dir by default */
	}

	while (file = nextfile())
	{
		nfile++;
		printf(" a %s\n", pathn);
		utod(pathn, doslabel.dos_fname);
		write(tape, &doslabel, sizeof doslabel);
		while ((n = read(file, buf, sizeof buf)) > 0)
		{
			if (n < 0)
			{
				perror(pathn);
				exit(1);
			}
			for (cp = &buf[n]; cp < &buf[sizeof buf]; *cp++ = 0);
			if (write(tape, buf, sizeof buf) != sizeof buf)
			{
				perror(nmagtape);
				exit(1);
			}
		}
		close(file);
		close(tape);		/* generate a TM */
		if (open(nmagtape, 1) != tape)
		{
			perror(nmagtape);
			exit(1);
		}
	}
	close(tape);
	close(open(magtape, 0));	/* rewind */
	printf("%d files added\n", nfile);
}

nextfile()
{
	register fd;

	if (! indir)
		if (argn--)
		{
			copy(*argp++, pathn, MAXPATH);
			if ((fd = open(pathn, 0)) < 0 || fstat(fd, buf) == -1)
			{
				perror(pathn);
				close(fd);
				return nextfile();
			}
			if ((buf->i_mode & IFMT) == 0)
				return fd;
			if ((buf->i_mode & IFMT) != IFDIR)
			{
				close(fd);
				printf("%s: not directory or plain file\n",
					pathn);
				return nextfile();
			}
			indir++;
			fdstack[0] = fd;
			fdsp = 0;
			pathp = pathn;
			while (*pathp++);
			*--pathp = '/';
		}
		else
			return 0;
	for (;;)
	{
		if (read(fdstack[fdsp], &dir, 16) != 16)
		{
			close(fdstack[fdsp]);
			if (--fdsp < 0)
			{
				indir = 0;
				return nextfile();
			}
			while (*--pathp != '/');
			continue;
		}
		if (dir.inum == 0 || dotname()) continue;
		if (copy(dir.name, pathp + 1, 14))
		{
			printf("%s: too long - omitted\n", pathn);
			continue;
		}
		if ((fd = open(pathn, 0)) < 0 || fstat(fd, buf) == -1)
		{
			close(fd);
			perror(pathn);
			continue;
		}
		if ((buf->i_mode & IFMT) == 0) return fd;
		if ((buf->i_mode & IFMT) != IFDIR)
		{
			close(fd);
			continue;
		}
		if (++fdsp >= MAXDIR)
		{
			printf("Down too deep - omit %s\n", pathn);
			fdsp--;
			close(fd);
			continue;
		}
		fdstack[fdsp] = fd;
		while (*pathp++);
		*--pathp = '/';
	}
}

copy(from, to, max)
register char *from, *to;
{
	register i;

	i = max;
	while (i-- && (*to++ = *from++))
		if (to >= &pathn[MAXPATH])
		{
			pathn[MAXPATH - 1] = 0;
			return 1;
		}
	return 0;
}

dotname()
{
	register union
	{
		char *cp;
		int *ip;
	}
		r;

	r.cp = dir.name;
	return *r.ip == '.\0' || *r.ip++ == '..' && *r.ip == 0;
}


match(f, zap)
char *f;
{
	register n;
	static char null[] "";

	if (argn == 0)
		return 1;
	for (n = 0; n < argn; n++)
		if (strcmp(f, argp[n]) == 0)
		{
			if (zap)
				argp[n] = null;
			return 1;
		}
	return 0;
}

/*
 *	place into the two words at 'rad' at most 6 ascii chars from 'asc'
 */

ator(asc, rad)
char *asc;
int *rad;
{
	register int r50, cc;
	register char c;
	int w;

	for (w = 0; w < 2 ; w++, *rad++ = r50)
		for (r50 = cc = 0; cc < 3 ; cc++)
		{
			if (c = *asc) asc++;
			r50 =* 050;
			if (c != ' ' && c != 0)
			{
				if (c >= 'a' && c <= 'z')
					r50 =+ c-'a'+1;
				else if (c >= 'A' && c <= 'Z')
					r50 =+ c-'A'+1;
				else if (c >= '0' && c <= '9')
					r50 =+ c-'0'+30;
				else if (c == '$')
					r50 =+ 27;
				else if (c == '.')
					r50 =+ 28;
				else
					r50 =+ 29;	/* unused */
			}
		}
}

/*
 *	place the three rad50 chars from the word 'rad' in string 'asc'
 */ 

rtoa(rad, asc)
register unsigned rad;
register char *asc;
{
	register char *ss = " abcdefghijklmnopqrstuvwxyz$._0123456789_";
	int n;

	n = rad % 050;
	rad =/ 050;
	*asc++ = ss[rad / 050];
	*asc++ = ss[rad % 050];
	*asc++ = ss[n];
}

/*
 *	take the unix pathname in 'unix' and produce dos filename in 'dos'
 *	use only filename from pathname, truncate if necessary, use extension
 *	'unix' addresses as ascii string, 'dos' addresses 3 rad50 words
 */

utod(unix, dos)
char *unix;
int *dos;
{
	register char *p, *q, *r;
	char filen[7], extn[4];
	int radf[2], rade[2];

	p = unix;
	while (*p++);
	p =- 2;
	while (*p == '/')
		*p-- = 0;		/* trailing slashes removed */
	q = p = unix;
	while (*p)
		if (*p++ == '/')
			q = p;		/* q now addresses name */
	p = filen;
	r = extn;
	while (*q)
	{
		if (*q == '.')
		{
			q++;
			while (*q)
				if (r > &extn[2])
					break;
				else
					*r++ = *q++;
			goto done;
		}
		if (p > &filen[5])
			q++;
		else
			*p++ = *q++;
	}
done:
	*p = 0;		/* filen now contains dos filename */
	*r = 0;		/* extn now contains dos extension */

	ator(filen, radf);
	ator(extn,  rade);
	dos[0] = radf[0];
	dos[1] = radf[1];
	dos[2] = rade[0];
}

/*
 *	take the dos filename in 'dos' (three rad50 words) and place
 *	the equivalent ascii string in 'unix', removing embedded blanks
 *	and adding '.'.
 */

dtou(dos, unix)
int dos[3];
char *unix;
{
	register char *p;

	rtoa(dos[0], unix);
	rtoa(dos[1], unix + 3);
	p = &unix[6];
	while (*--p == ' ' && p >= unix);
	*++p = '.';
	rtoa(dos[2], ++p);
	p =+ 3;
	while (*--p == ' ');
	if (*p++ == '.') p--;
	*p = 0;
}
