
#include "gremlin.h"
#include "grem2.h"

extern char *Editfile;
extern Cursor Page_Cursor, Text_Cursor;
extern TextMode, window_num;
extern (*(shrtns[]))();
extern (*(lrtns[]))();
extern int (*last_function)();
extern char shcmds[];
extern char lcmds[];
extern int	window_num;
extern OpaqueFrame FrameList[];
extern int CBRUSH, CFONT, CSIZE, CJUST, CBUF, CGRID, Consume, Gridon, bang;
extern int Consume, CSETPOINTS;
extern Font text_win_font, pointfont;
extern GetNumParm();
extern GRBlankGrid(), GRDisplayGrid();
extern LGShowPoints(), LGHidePoints();
extern ELT *cset;
extern POINT* PTInit();
extern short icons[NUM_WINDOWS][114];
extern short brush_icons[4][114];
extern short size_icons[4][114];
extern short font_icons[4][114];
extern short just_icons[16][114];
extern short adjust_icons[4][114];
extern short buffer_icons[5][114];
extern icon_light[];
extern error();
extern Adjustment, csetoff;

int	halftone = 0;

FontInfo *text_font[5][5];

char input_buffer[90];

/*
 *  text to clear a line of the text window.
 */
char *erase = "                                                                                          ";

/*
 *  0 elements aren't used.
 */
char* text_font_names[5][5] =
{
	"00","01","02","03","04",
	"10","R6","R8","R10","R12",
	"20","I6","I8","I10","I12",
	"30","B6","B8","B10","B12",
	"40","6x10","6x13","8x13","9x15"
};

/*
 *  change current brush
 */
XChangeBrush(Inc)
int Inc;
{
	CBRUSH = (CBRUSH+NBRUSHES+Inc) % NBRUSHES;
	if (CBRUSH == 0) CBRUSH = NBRUSHES;
	XBitmapBitsPut(FrameList[6].self,0,0,38,38,brush_icons[CBRUSH],BlackPixel,WhitePixel,0,icon_light[6],AllPlanes);
	Consume = FALSE;
}

XUpBrush(){
	XChangeBrush(1);
}

XDownBrush(){
	XChangeBrush(-1);
}

/*
 *  change grid size
 */
XChangeGrid()
{
	int size, index;
	char num[5];
	
	index = 0;
	size = GetNumParm(input_buffer,&index);
	if(size<2)
	{
		error("Change Grid:  bad arguments.");
		return;
	}
	if(Gridon) GRBlankGrid();
	CGRID = size;
	sprintf(num,"%d",size);
	XBitmapBitsPut(FrameList[14].self,0,0,38,38,icons[14],BlackPixel,WhitePixel,0,icon_light[14],AllPlanes);
	XText(FrameList[14].self,10,10,num,strlen(num),pointfont,WhitePixel,BlackPixel);
	if(Gridon) GRDisplayGrid();
	Consume = FALSE;
}

/*
 *  change font type.
 */
XChangeFont(Inc)
int Inc;
{
	CFONT = (CFONT + 4 + Inc) % 4;
	if (CFONT == 0) CFONT = 4;
	XBitmapBitsPut(FrameList[7].self,0,0,38,38,font_icons[CFONT],BlackPixel,WhitePixel,0,icon_light[7],AllPlanes);
	Consume = FALSE;
}

XUpFont(){
	XChangeFont(1);
}

XDownFont(){
	XChangeFont(-1);
}

/*
 *  change font size.
 */
XChangeSize(Inc)
int Inc;
{
	CSIZE = (CSIZE + 4 + Inc) % 4;
	if (CSIZE == 0) CSIZE = 4;
	XBitmapBitsPut(FrameList[9].self,0,0,38,38,size_icons[CSIZE],BlackPixel,WhitePixel,0,icon_light[9],AllPlanes);
	Consume = FALSE;
}

XUpSize(){
	XChangeSize(1);
}

XDownSize(){
	XChangeSize(-1);
}

/*
 *  increment the adjustment mode.
 */
XChangeAdjust(Inc)
int Inc;
{
	Adjustment = (Adjustment+4+Inc) % 4;
	XBitmapBitsPut(FrameList[10].self,0,0,38,38,adjust_icons[Adjustment],BlackPixel,WhitePixel,0,icon_light[10],AllPlanes);
	Consume = FALSE;
}

XUpAdjust(){
	XChangeAdjust(1);
}

XDownAdjust(){
	XChangeAdjust(-1);
}

/*
 *  toggle the bang mode.  bang decreases by one each time throught the
 *  command loop.
 */
XBang()
{
	if(bang)
	{
		MNUnHighLt(12);
		bang = 0;
	}
	else
	{
		MNHighLt(12);
		bang = 12;
	}
	Consume = FALSE;
}

/*
 *  change justification.
 */
XChangeJust(Inc)
int Inc;
{
	/*
	 *  justification values are wierd: 0-2, 10-15.  See gremlin.h
	 */
	CJUST += Inc;
	if (CJUST==3) CJUST=10;
	else if (CJUST == 9) CJUST = 2;
	else if(CJUST>15) CJUST=0;
	else if (CJUST < 0) CJUST = 15;
	XBitmapBitsPut(FrameList[8].self,0,0,38,38,just_icons[CJUST],BlackPixel,WhitePixel,0,icon_light[8],AllPlanes);
	Consume = FALSE;
}

XUpJust(){
	XChangeJust(1);
}

XDownJust(){
	XChangeJust(-1);
}

/*
 *  Change the current buffer.
 */
XChangeBuffer(Inc)
int Inc;
{
	CBUF = (CBUF + 5 + Inc) % 5;
	XBitmapBitsPut(FrameList[28].self,0,0,38,38,buffer_icons[CBUF],BlackPixel,WhitePixel,0,icon_light[28],AllPlanes);
	Consume = FALSE;
}

XUpBuffer(){
	XChangeBuffer(1);
}

XDownBuffer(){
	XChangeBuffer(-1);
}

/*
 *  dead routine.  Replaced by the halftoning.
 */
XCSet()
{
	ELT *e1;
	if(DBNullelt(cset))
	{
		error("no current set.");
		return;
	}
	e1 = cset;
	if(csetoff)
	{
		MNUnHighLt(35);
		while(!DBNullelt(e1))
		{
			DISScreenAdd(e1);
			e1 = DBNextofSet(e1);
		}
		csetoff=0;
	}
	else
	{
		MNHighLt(35);
		while(!DBNullelt(e1))
		{
			DISScreenErase(e1);
			e1 = DBNextofSet(e1);
		}
		csetoff=1;
	}
	Consume = FALSE;
}

/*
 *  stuffs a string into the text window on the message line.
 *  Confusing with PutText.
 */
TextPut(msg)
char* msg;
{
	char buff[50];
	int foo;

	strcpy(buff,msg);
	for(foo=strlen(msg);foo<50;foo++)
		strcat(buff," ");
	XText(FrameList[PAGE_WIN+1].self,9,33,buff,strlen(buff),text_win_font,BlackPixel,WhitePixel);
}

/*
 *  redraws the text window.
 */
RedrawText()
{
	XClear(FrameList[PAGE_WIN+1].self);
	if(strlen(Editfile))
		XText(FrameList[PAGE_WIN+1].self,9,2,Editfile,strlen(Editfile),text_win_font,BlackPixel,WhitePixel);
	else
		XText(FrameList[PAGE_WIN+1].self,9,2,"(none)",6,text_win_font,BlackPixel,WhitePixel);
	XText(FrameList[PAGE_WIN+1].self,9,17,input_buffer,strlen(input_buffer),text_win_font,BlackPixel,WhitePixel);
}

/*
 *  interprets a character.  
 */
InputText(chr)
char* chr;
{
	static int zonk=0, numchars=0;
	int *next, foo;

	if(window_num<=PAGE_WIN && !TextMode)
	{
		/*
		 *  colon or tab?
		 */
		if(*chr==':' || *chr==9)
		{
			ToggleText();
			return;
		}
		else
		{
			if((foo=SHLookup(*chr,shcmds))>=0)
			{
				if(CSETPOINTS) DoBlink(0);
				(*shrtns[foo])();
				last_function = shrtns[foo];
				if(Consume) CP();
				if(bang)
					if(!--bang)
						MNUnHighLt(12);
			}
			else
				XFeep(0);
			return;
		}
	}
	if(*chr==13) /* ^M */
	{
		zonk++;
		if(strlen(input_buffer)==1)
		{
			if((foo=SHLookup(input_buffer[0],shcmds))>=0)
			{
				if(CSETPOINTS) DoBlink(0);
				(*shrtns[foo])();
				last_function = shrtns[foo];
			}
		}
		else
		{
			foo = LGLookup(&input_buffer[0],lcmds,next);
			if(foo>=0)
			{
				int count=0;
				/* (*next)++; */
				if(CSETPOINTS) DoBlink(0);
				while((input_buffer[count++]=input_buffer[++(*next)]));
				(*lrtns[foo])();
				last_function = lrtns[foo];
			}
		}
		if(TextMode)
			ToggleText();
		if(foo>=0)
		{
			zonk = 0;
			*input_buffer = '\0';
			XText(FrameList[PAGE_WIN+1].self,9,17,erase,90,text_win_font,BlackPixel,WhitePixel);
			numchars = 0;
			if(Consume) CP();
			if(bang)
				if(!--bang)
					MNUnHighLt(12);
		}
		else
			XFeep(0);
		return;
	}
	else
	if(*chr==21)
	{
		XClear(FrameList[PAGE_WIN+1].self);
		if(strlen(Editfile))
			XText(FrameList[PAGE_WIN+1].self,9,2,Editfile,strlen(Editfile),text_win_font,BlackPixel,WhitePixel);
		else
			XText(FrameList[PAGE_WIN+1].self,9,2,"(none)",6,text_win_font,BlackPixel,WhitePixel);
		*input_buffer = '\0';
		numchars = 0;
		return;
	}
	if(*chr==8) /* \b */
	{
		int length;
		if(numchars<=0)
		{
			XFeep(0);
			return;
		}
		XText(FrameList[PAGE_WIN+1].self,numchars*9,17," ",1,text_win_font,BlackPixel,WhitePixel);
		input_buffer[--numchars] = '\0';
	} else if (*chr == 23) /* ^W */
	{
		int length;
		do {
			if(numchars<=0)
			{
				XFeep(0);
				return;
			}
			XText(FrameList[PAGE_WIN+1].self,numchars*9,17," ",1,text_win_font,BlackPixel,WhitePixel);
			input_buffer[--numchars] = '\0';
		} while (input_buffer[numchars-1] != ' ');
	} else if(numchars>=90)
	{
		error("Gremlin:  too many characters in input line.");
		return;
	}
	else
	{
		if(zonk)
		{
			zonk = 0;
			*input_buffer = '\0';
			numchars = 0;
			XClear(FrameList[PAGE_WIN+1].self);
			if(strlen(Editfile))
				XText(FrameList[PAGE_WIN+1].self,9,2,Editfile,strlen(Editfile),text_win_font,BlackPixel,WhitePixel);
			else
				XText(FrameList[PAGE_WIN+1].self,9,2,"(none)",6,text_win_font,BlackPixel,WhitePixel);
		}
		strncat(input_buffer,chr,1);
		numchars++;
		XText(FrameList[PAGE_WIN+1].self,9*numchars,17,chr,1,text_win_font,BlackPixel,WhitePixel);
	}
}


/*
 *  unused routine.  was called when an expose region event was generated.
 *  attempts to remove all excess expose region events.
 */
Strip()
{
XEvent	event_array[10];
int count, numevents, again = 0;

numevents = XPending();
if(numevents<=0) return;
if(numevents>10)
	{
		again = TRUE;
		numevents = 10;
	}
	for(count=0;count<numevents;count++)
		XNextEvent(&event_array[count]);
	if(again)
		Strip();
	for(count=numevents-1;count>=0;count--)
		if(event_array[count].window != FrameList[PAGE_WIN].self ||
		   event_array[count].type != ExposeWindow)
		{
			printf("putting one back.\n");
			XPutBackEvent(&event_array[count]);
		}

	return;
}

/*
 *  unused routine.  not working either.  should draw circles/arcs using 
 *  X splines.
 */
XArc(center,cpoint,angle,style,pos_points)
POINT *center, *cpoint, *pos_points;
double angle;
int style;
{
}

/*
 *  toggles the text mode
 */
ToggleText()
{
	if(TextMode)
	{
		TextMode = 0;
		XDefineCursor(FrameList[PAGE_WIN].self,Page_Cursor);
	}
	else
	{
		TextMode = 1;
		XDefineCursor(FrameList[PAGE_WIN].self,Text_Cursor);
	}
}

/*
 *  current set halftoning function.  redraws the current set with the
 *  proper X brush.
 */
DoBlink(on)
int	on;
{
	ELT *elist;
	POINT *p1;
	int pno;

	elist = cset;
	while ( !DBNullelt(elist) )
	{
		halftone = TRUE;
		if(TEXT(elist->type))
		{
			if(on)
				DISScreenAdd(elist,0);
			else
				DISScreenErase(elist,0);
		}
		else
		{
			halftone = on;
			DISScreenAdd(elist);
		}
		elist = DBNextofSet(elist);
	}  /* end while */
	halftone = FALSE;
}
