.TH XINIT 1 "25 January 1986" "X Version 10"
.SH NAME
xinit - X window system initializer
.SH SYNOPSIS
.B xinit
[[client] options] [-- [server] [display] options]
.SH DESCRIPTION
.I Xinit
is intended to be used when the X window system server is not run automatically
from \fIinit(8)\fP,
and the window system must be started from a shell running on
the display.  This might be true, for example, if a normal login is run in a
glass-tty emulator on a workstation console, so that different window systems
can easily be run on the display at different times.
.PP
\fIXinit\fP starts up the server and a single client application,
which is typically
\fIxterm(1)\fP.
When the client eventually terminates, \fIxinit\fP automatically kills off
the server and then itself terminates.
.PP
By default, 
\fIxinit\fP expects the server to exist in an executable named ``X'' in
the search path, 
and for \fIxterm(1)\fP to also exist in the search path.  
It starts
up the X server on display 0, and then starts up
.br
	xterm =+1+1 -n login unix:0
.br
.PP
A different client and/or server can be specified in the command line, and
command line options can be passed to both the server and the client.  The
client and its options come first in the command line.  The server and its
options must be preceded by ``--''.
If the first argument to xinit begins with `/' or a letter, it is taken to
be the client program to use instead of xterm, and none of the default xterm
options are used.  Otherwise, the first and subsequent arguments are
simply appended as further options to the default \fIxterm\fP command line.
.PP
Following the ``--'' argument,
if the next argument begins with `/' or a letter,
it is taken to be the server program to use instead of ``X''.  If the next
argument begins with a digit, it is taken to be the display number; otherwise
display 0 is assumed.  The remaining arguments are added as options to the
server command line.
.PP
Examples:
.sp
xinit =80x65+10+10 -fn 8x13 -j -fg white -bg navy
.br
xinit -e widgets -- Xsun -l -c
.br
xinit rsh fasthost cpupig workstation:1 -- 1 -a 2 -t 5
.br
.SH AUTHOR
Copyright (c) 1986 by Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a complete copyright notice.
.br
Bob Scheifler, MIT Laboratory for Computer Science
.SH "SEE ALSO"
X(8C), xterm(1)
