.TH PIKAPIX 1 "16 September 1985" "X Version 10"
.SH NAME
pikapix - recolor an X window snapshot
.SH SYNOPSIS
.B pikapix
[ -s ] [ host:number ]
.SH DESCRIPTION
.PP
\fIPikapix\fP takes a snapshot of an existing window,
and then lets you change colors
in the snapshot.  This can be a convenient way to choose sets of colors for
applications.
.PP
When started, \fIpikapix\fP grabs the mouse,
and waits for you to select the window
you want to recolor.  Clicking the right button on a window selects the entire
top-level window.  Clicking the middle button on a window selects the first
level subwindow under the mouse, or the top-level window if there is no
subwindow.  Clicking the left button on a top-level window selects the lowest
subwindow under the mouse, or the top-level window if there is no subwindow.
After a few moments, a snapshot of the window will appear in the same place
as the original window.  Move the snapshot with your window manager if you
want to compare the snapshot with the original window.
.PP
As you move the cursor around in the snapshot, it will change color to reflect
whatever pixel it is pointing at.
.PP
If you click the middle mouse button, you will get a popup text window.  The
prompt indicates the current color value in hexadecimal notation as described
in \fIX(1)\fP.
To change the color, simply type in a color name (or a color value
in hexadecimal notation), followed by carriage return.  Rubout and control-U
can be used for editing.  To abort, simply click any mouse button in the popup,
or type control-C or control-D.
.PP
If you click the left mouse button, you will restore the color to its value in
the original snapshot.
.PP
If you click the right mouse button, you will get a popup mix window.  At the
top are three squares with the red, green, and blue primaries, and at the
bottom is the combined color and its hexadecimal notation.  Clicking the
left button in a primary decrements its value, and clicking the right button
increments its value.  If you press the middle button in a primary and then
move around, the vertical position of the mouse controls the value, with zero
intensity at the top of the window, and full intensity at the bottom of the
window; releasing the mouse button sets the final value.  Clicking the right
button in the combined color will exit the popup and change to the new color.
Clicking the middle button in the combined color will restore the values to
their current state in the snapshot.  Clicking the left button in the combined
color will restore the values to their state in the original snapshot.
.PP
Typing control-C or control-D in the snapshot will terminate the program.
.PP
By default, once the snapshot is created, it no longer depends on the existence
of the original window, and the color in the snapshot will dynamically track
the color in the popup mix window.  However, a potentially large number of
color map entries may be required for this mode.  If not enough entries are
available, the ``-s'' can be used.  When run with the ``-s'' option,
the snapshot
continues to depend on colors from the original window, new colors are shared
when possible, and the snapshot is completely repainted after every change in
color.
.SH ENVIRONMENT
DISPLAY	This program gets the display to use by default from this variable.
.SH BUGS
Redisplay is very slow on all but small windows.
.SH AUTHOR
Bob Scheifler, MIT Laboratory for Computer Science.
.br
Copyright (c) 1985, Massachusetts Institute of Technology
.SH "SEE ALSO"
X(1)
