.TH KEYCOMP 1 "18 August 1985" "X Version 10"
.SH NAME
keycomp - X window system keyboard mapping file compiler
.SH SYNOPSIS
.B keycomp
< input_file > output_file
.SH DESCRIPTION
Programs that use the X window system, such as \fIxterm(1)\fP, need some way
to translate the user's key strokes into character strings.  Such
programs look up this keyboard-to-character string mapping in a binary
keymap file by calling the library routine \fIXLookupMapping\fP.  Initially,
this routine looks for the file \fI.Xkeymap\fP in the user's home directory;
if this file doesn't exist, uses a built in table.
.PP
The compiled file format produced by \fIkeycomp\fP should be portable across
machine architectures.
.PP
The \fIkeycomp\fP program (an abbreviation for ``keymap compiler'') reads in a
textual description of this mapping and produces a binary keymap file on
its standard output.
.PP
Each key may have up to 16 different bindings, depending on what
combinations of the Shift, Lock, Control, and Meta keys are depressed.
For instance, in a conventional QWERTY keyboard mapping, pressing the ``A''
key produces a capital ``A'' when the Shift or Lock key is down, an
octal 001 when the Control key is down, and a small ``a'' when no
other key is down.

The input file to \fIkeycomp\fP consists of one or more lines.  Each line
begins with an octal or decimal number designating an X keyboard code.
After the key code, the line should contain either 1 or 16 items, each
representing the binding for a particular combination of the Control,
Meta, Shift, and Lock keys.  The items should be separated by white
space; the format of the items is described later.  The bindings should
be in this order:

#1	``unshifted'':  none of Shift, Lock, Control, or Meta keys down
.br
#2	Lock key down
.br
#3	Shift key down
.br
#4	Shift and Lock keys down
.br
#5	Meta key down
.br
#6	Meta and Lock keys down
.br
#7	Meta and Shift keys down
.br
#8	Meta, Shift, and Lock keys down
.br
#9	Control key down
.br
#10	Control and Lock keys down
.br
#11	Control and Shift keys down
.br
#12	Control, Shift, and Lock keys down
.br
#13	Control and Meta keys down
.br
#14	Control, Meta, and Lock keys down
.br
#15	Control, Meta, and Shift keys down
.br
#16	Control, Meta, Shift, and Lock keys down

If only one item is present on the line, then it represents the binding
for this key regardless of the positions of the Control, Meta, Shift,
and Lock keys.

Each item should be one of the following:

    An octal or decimal number, indicating a character code

    A C character literal, surrounded by single quotes.  Escape
sequences (such as `\n' or `\252') are allowed, as described in the C
Reference Manual.

    A C string literal, surrounded by double quotes.  Again, standard C
escape sequences are allowed within the string.

    The letter U, indicating ``no binding''.  If there is no binding,
then XLookupMapping will return an empty string for this key
combination.

A comma may, but need not, follow each item.  Whether or not a comma
is present, white space (spaces or tabs) must separate the items.  All
text to the right of the 16th item is ignored; comments may appear here.

Completely blank lines are ignored, as are lines beginning with the '#'
character.  Furthermore, all text between a `#' character and the
following newline is ignored, provided that the `#' is not part of a
string enclosed in single or double quotes.  This allows you to place
comments at the end of a line that contains only a single item.

You can look at the file \fI<X/Xkeyboard.h>\fP for a list of key codes and
key names of function keys.

.SH FILES
$HOME/.Xkeymap, /usr/lib/Xkeymap.txt, <X/Xkeyboard.h>
.SH SEE ALSO
X(1), xterm(1)
.SH DIAGNOSTICS
``Couldn't fseek output file''
.br
The standard output must be a file, not a pipe or a terminal.

``Error writing beginning of output file''
.br
``Error writing extension to output file''
.br
\fIkeycomp\fP couldn't write the output file.  Maybe the file system
is out of space.

``Parse error at item <number> on line <number>:
.br
	<message>''
.br
The source file has a syntax error.  Possible <message>s include:

``Line doesn't begin with key''
.br
The first few characters in the line, which should be a key number,
were not recognizable as an octal or decimal number.

``Keycode is too big''
.br
The key at the beginning of the line was greater than 0377 (octal).

``Line doesn't have 1 or 16 entries''
.br
After the key, more than one but less than 16 items were found.  Or 
no items were found at all.

``Number after backslash is too big for a character constant''
.br
In a character constant of the form `\nnn', the octal number was
greater than 377 (octal).

``Closing single quote not found''
.br
A single quote (') was encountered, but the end of the line was reached
before finding the matching closing single quote.

``String is too long''
.br
More than 80 characters are not allowed between double quotes.

``Closing double quote not found''
.br
A double quote (") was encountered, but the end of the line was reached
before finding the matching closing double quote.

``Too many characters for single character constant''
.br
Too many characters appear between single quotes.  If you want to
bind a key to a multiple-character sequence, use double quotes.

``Not a U, number, single- or double-quoted string''
.br
\fIkeycomp\fP can't parse this item; it is neither the letter U, nor an
octal or decimal number, nor a string enclosed in single or double
quotes.
.SH AUTHOR
Ron Newman, MIT Project Athena
.br
Copyright 1985, 1986, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full copyright notice.
