


MSH(1)              UNIX Programmer's Manual               MSH(1)



NAME
     msh - MH shell (and BBoard reader)

SYNOPSIS
     msh [-prompt string] [-scan] [-noscan] [-topcur] [-notopcur]
          [file] [-help]
9     _m_s_h is an interactive program that implements a subset of
     the normal _M_H commands operating on a single file in _p_a_c_k_f'd
     format.  That is, _m_s_h is used to read a file that contains a
     number of messages, as opposed to the standard _M_H style of
     reading a number of files, each file being a separate mes-
     sage in a folder.  _m_s_h's chief advantage is that the normal
     _M_H style does not allow a file to have more than one message
     in it.  Hence, _m_s_h is ideal for reading _B_B_o_a_r_d_s, as these
     files are delivered by the transport system in this format.
     In addition, _m_s_h can be used on other files, such as message
     archives which have been _p_a_c_ked (see _p_a_c_k_f (1)).  Finally,
     _m_s_h is an excellent _M_H tutor.  As the only commands avail-
     able to the user are _M_H commands, this allows _M_H beginners
     to concentrate on how commands to _M_H are formed and (more or
     less) what they mean.

     When invoked, _m_s_h reads the named file, and enters a command
     loop.  The user may type most of the normal _M_H commands.
     The syntax and semantics of these commands typed to _m_s_h are
     identical to their _M_H counterparts.  In cases where the
     nature of _m_s_h would be inconsistent (e.g., specifying a
     `+folder' with some commands), _m_s_h will duly inform the
     user.  The commands that _m_s_h currently supports (in some
     slightly modified or restricted forms) are:

          ali
          burst
          comp
          dist
          folder
          forw
          inc
          mark
          mhmail
          msgchk
          next
          packf
          pick
          prev
          refile
          repl
          rmm
          scan
          send
          show
          sortm



Printed 1/10/87                MH                               1


9


MSH(1)              UNIX Programmer's Manual               MSH(1)



          whatnow
          whom

     In addition, _m_s_h has a "help" command which gives a brief
     overview.  To terminate _m_s_h, type CTRL-D, or use the "quit"
     command.  If _m_s_h is being invoked from _b_b_c, then typing
     CTRL-D will also tell _b_b_c to exit as well, while using the
     "quit" command will return control to _b_b_c, and _b_b_c will con-
     tinue examining the list of BBoards that it is scanning.

     If the file is writable and has been modified, then using
     "quit" will query the user if the file should be updated.

     The `-prompt string' switch sets the prompting string for
     _m_s_h.

     You may wish to use an alternate _M_H profile for the commands
     that _m_s_h executes; see _m_h-_p_r_o_f_i_l_e (5) for details about the
     $MH envariable.

     When invoked from _b_b_c, two special features are enabled:
     First, the `-scan' switch directs _m_s_h to do a `scan unseen'
     on start-up if new items are present in the BBoard.  This
     feature is best used from _b_b_c, which correctly sets the
     stage.  Second, the _m_a_r_k command in _m_s_h acts specially when
     you are reading a BBoard, since _m_s_h will consult the
     sequence "unseen" in determining what messages you have
     actually read.  When _m_s_h exits, it reports this information
     to _b_b_c.  In addition, if you give the _m_a_r_k command with no
     arguments, _m_s_h will interpret it as
     `mark -sequence unseen -delete -nozero all' Hence, to dis-
     card all of the messages in the current BBoard you're read-
     ing, just use the _m_a_r_k command with no arguments.

     Normally, the "exit" command is identical to the "quit" com-
     mand in _m_s_h.  When run under _b_b_c however, "exit" directs _m_s_h
     to mark all messages as seen and then "quit".  For speedy
     type-in, this command is often abbreviated as just "e".

     When invoked from _v_m_h, another special feature is enabled:
     The `topcur' switch directs _m_s_h to have the current message
     "track" the top line of the _v_m_h scan window.  Normally, _m_s_h
     has the current message "track" the center of the window
     (under `-notopcur', which is the default).

     _m_s_h supports an output redirection facility.  Commands may
     be followed by one of

          > _f_i_l_e     write output to _f_i_l_e
          >> _f_i_l_e    append output to _f_i_l_e
          | _c_o_m_m_a_n_d  pipe output to UNIX _c_o_m_m_a_n_d




Printed 1/10/87                MH                               2






MSH(1)              UNIX Programmer's Manual               MSH(1)



     If _f_i_l_e starts with a `~' (tilde), then a _c_s_h-like expansion
     takes place.  Note that _c_o_m_m_a_n_d is interpreted by _s_h (1).
     Also note that _m_s_h does NOT support history substitutions,
     variable substitutions, or alias substitutions.

     When parsing commands to the left of any redirection symbol,
     _m_s_h will honor `\' (back-slash) as the quote next-character
     symbol, and `"' (double-quote) as quote-word delimiters.
     All other input tokens are separated by whitespace (spaces
     and tabs).

FILES
     $HOME/.mh_profile                  The user profile
     /usr/misc/mh/lib/mtstailor         tailor file

PROFILE COMPONENTS
     Path:                To determine the user's MH directory
     Msg-Protect:         To set mode when creating a new `file'
     fileproc:            Program to file messages
     showproc:            Program to show messages

SEE ALSO
     bbc(1)

DEFAULTS
     `file' defaults to "./msgbox"
     `-prompt (msh) '
     `-noscan'
     `-notopcur'

CONTEXT
     None

BUGS
     The argument to the `-prompt' switch must be interpreted as
     a single token by the shell that invokes _m_s_h.  Therefore,
     one must usually place the argument to this switch inside
     double-quotes.

     There is a strict limit of messages per file in _p_a_c_k_f'd for-
     mat which _m_s_h can handle.  Usually, this limit is 1000 mes-
     sages.

     Please remember that _m_s_h is not the _C_S_h_e_l_l, and that a lot
     of the nice facilities provided by the latter are not
     present in the former.

     In particular, _m_s_h does not understand back-quoting, so the
     only effective way to use _p_i_c_k inside _m_s_h is to always use
     the `-seq select' switch.  Clever users of _M_H will put the
     line




Printed 1/10/87                MH                               3






MSH(1)              UNIX Programmer's Manual               MSH(1)



          pick: -seq select -list

     in their .mh_profile file so that _p_i_c_k works equally well
     from both the shell and _m_s_h.

     The _m_s_h program inherits most (if not all) of the bugs from
     the _M_H commands it implements.
















































Printed 1/10/87                MH                               4



