


CI(1)               UNIX Programmer's Manual                CI(1)



NAME
     ci - check in RCS revisions

SYNOPSIS
     ci [ options ] file ...

DESCRIPTION
     _C_i stores new revisions into RCS files.  Each file name end-
     ing in `,v' is taken to be an RCS file, all others are
     assumed to be working files containing new revisions.  _C_i
     deposits the contents of each working file into the
     corresponding RCS file.

     Pairs of RCS files and working files may be specified in 3
     ways (see also the example section of _c_o (1)).

     1) Both the RCS file and the working file are given. The RCS
     file name is of the form _p_a_t_h_1/_w_o_r_k_f_i_l_e,v and the working
     file name is of the form _p_a_t_h_2/_w_o_r_k_f_i_l_e, where _p_a_t_h_1/ and
     _p_a_t_h_2/ are (possibly different or empty) paths and _w_o_r_k_f_i_l_e
     is a file name.

     2) Only the RCS file is given. Then the working file is
     assumed to be in the current directory and its name is
     derived from the name of the RCS file by removing _p_a_t_h_1/ and
     the suffix `,v'.

     3) Only the working file is given. Then the name of the RCS
     file is derived from the name of the working file by remov-
     ing _p_a_t_h_2/ and appending the suffix `,v'.

     If the RCS file is omitted or specified without a path, then
     _c_i looks for the RCS file first in the directory ./RCS and
     then in the current directory.

     For _c_i to work, the caller's login must be on the access
     list, except if the access list is empty or the caller is
     the superuser or the owner of the file.  To append a new
     revision to an existing branch, the tip revision on that
     branch must be locked by the caller. Otherwise, only a new
     branch can be created. This restriction is not enforced for
     the owner of the file, unless locking is set to _s_t_r_i_c_t (see
     _r_c_s (1)).  A lock held by someone else may be broken with
     the _r_c_s command.

     Normally, _c_i checks whether the revision to be deposited is
     different from the preceding one. If it is not different, _c_i
     either aborts the deposit (if -q is given) or asks whether
     to abort (if -q is omitted). A deposit can be forced with
     the -f option.





Printed 1/10/87              6/29/83                            1






CI(1)               UNIX Programmer's Manual                CI(1)



     For each revision deposited, _c_i prompts for a log message.
     The log message should summarize the change and must be ter-
     minated with a line containing a single `.' or a control-D.
     If several files are checked in, _c_i asks whether to reuse
     the previous log message.  If the std. input is not a termi-
     nal, _c_i suppresses the prompt and uses the same log message
     for all files.  See also -m.

     The number of the deposited revision can be given by any of
     the options -r, -f, -k, -l, -u, or -q (see -r).

     If the RCS file does not exist, _c_i creates it and deposits
     the contents of the working file as the initial revision
     (default number: 1.1).  The access list is initialized to
     empty.  Instead of the log message, _c_i requests descriptive
     text (see -t below).

     -r[_r_e_v]   assigns the revision number _r_e_v to the checked-in
               revision, releases the corresponding lock, and
               deletes the working file. This is also the
               default.

               If _r_e_v is omitted, _c_i derives the new revision
               number from the caller's last lock. If the caller
               has locked the tip revision of a branch, the new
               revision is appended to that branch. The new revi-
               sion number is obtained by incrementing the tip
               revision number.  If the caller locked a non-tip
               revision, a new branch is started at that revision
               by incrementing the highest branch number at that
               revision.  The default initial branch and level
               numbers are 1.  If the caller holds no lock, but
               he is the owner of the file and locking is not set
               to _s_t_r_i_c_t, then the revision is appended to the
               trunk.

               If _r_e_v indicates a revision number, it must be
               higher than the latest one on the branch to which
               _r_e_v belongs, or must start a new branch.

               If _r_e_v indicates a branch instead of a revision,
               the new revision is appended to that branch. The
               level number is obtained by incrementing the tip
               revision number of that branch.  If _r_e_v indicates
               a non-existing branch, that branch is created with
               the initial revision numbered _r_e_v._1.

               Exception: On the trunk, revisions can be appended
               to the end, but not inserted.

     -f[_r_e_v]   forces a deposit; the new revision is deposited
               even it is not different from the preceding one.



Printed 1/10/87              6/29/83                            2






CI(1)               UNIX Programmer's Manual                CI(1)



     -k[_r_e_v]   searches the working file for keyword values to
               determine its revision number, creation date,
               author, and state (see _c_o (1)), and assigns these
               values to the deposited revision, rather than com-
               puting them locally.  A revision number given by a
               command option overrides the number in the working
               file.  This option is useful for software distri-
               bution. A revision that is sent to several sites
               should be checked in with the -k option at these
               sites to preserve its original number, date,
               author, and state.

     -l[_r_e_v]   works like -r, except it performs an additional _c_o
               -_l for the deposited revision. Thus, the deposited
               revision is immediately checked out again and
               locked.  This is useful for saving a revision
               although one wants to continue editing it after
               the checkin.

     -u[_r_e_v]   works like -l, except that the deposited revision
               is not locked.  This is useful if one wants to
               process (e.g., compile) the revision immediately
               after checkin.

     -q[_r_e_v]   quiet mode; diagnostic output is not printed.  A
               revision that is not different from the preceding
               one is not deposited, unless -f is given.

     -m_m_s_g     uses the string _m_s_g as the log message for all
               revisions checked in.

     -n_n_a_m_e    assigns the symbolic name _n_a_m_e to the number of
               the checked-in revision.  _C_i prints an error mes-
               sage if _n_a_m_e is already assigned to another
               number.

     -N_n_a_m_e    same as -n, except that it overrides a previous
               assignment of _n_a_m_e.

     -s_s_t_a_t_e   sets the state of the checked-in revision to the
               identifier _s_t_a_t_e.  The default is _E_x_p.

     -t[_t_x_t_f_i_l_e]
               writes descriptive text into the RCS file (deletes
               the existing text).  If _t_x_t_f_i_l_e is omitted, _c_i
               prompts the user for text supplied from the std.
               input, terminated with a line containing a single
               `.' or control-D.  Otherwise, the descriptive text
               is copied from the file _t_x_t_f_i_l_e.  During initiali-
               zation, descriptive text is requested even if -t
               is not given.  The prompt is suppressed if std.
               input is not a terminal.



Printed 1/10/87              6/29/83                            3






CI(1)               UNIX Programmer's Manual                CI(1)



DIAGNOSTICS
     For each revision, _c_i prints the RCS file, the working file,
     and the number of both the deposited and the preceding revi-
     sion.  The exit status always refers to the last file
     checked in, and is 0 if the operation was successful, 1 oth-
     erwise.

FILE MODES
     An RCS file created by _c_i inherits the read and execute per-
     missions from the working file. If the RCS file exists
     already, _c_i preserves its read and execute permissions.  _C_i
     always turns off all write permissions of RCS files.

FILES
     The caller of the command must have read/write permission
     for the directories containing the RCS file and the working
     file, and read permission for the RCS file itself.  A number
     of temporary files are created.  A semaphore file is created
     in the directory containing the RCS file.  _C_i always creates
     a new RCS file and unlinks the old one.  This strategy makes
     links to RCS files useless.

IDENTIFICATION
     Author: Walter F. Tichy, Purdue University, West Lafayette,
     IN, 47907.
     Revision Number: 3.1 ; Release Date: 83/04/04 .
     Copyright 8c9 1982 by Walter F. Tichy.

SEE ALSO
     co (1), ident(1), rcs (1), rcsdiff (1), rcsintro (1),
     rcsmerge (1), rlog (1), rcsfile (5), sccstorcs (8).
     Walter F. Tichy, "Design, Implementation, and Evaluation of
     a Revision Control System," in _P_r_o_c_e_e_d_i_n_g_s _o_f _t_h_e _6_t_h _I_n_t_e_r_-
     _n_a_t_i_o_n_a_l _C_o_n_f_e_r_e_n_c_e _o_n _S_o_f_t_w_a_r_e _E_n_g_i_n_e_e_r_i_n_g, IEEE, Tokyo,
     Sept. 1982.

BUGS















Printed 1/10/87              6/29/83                            4






