
# line 2 "commands.y"

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)commands.y	5.3 (Berkeley) 5/31/85
 */

static char rcsid[] = "$Header: commands.y,v 1.1 86/08/26 21:33:23 root Exp $";

/*
 * Yacc grammar for debugger commands.
 */

#include "defs.h"
#include "symbols.h"
#include "operators.h"
#include "tree.h"
#include "process.h"
#include "source.h"
#include "scanner.h"
#include "keywords.h"
#include "names.h"
#include "lists.h"

private String curformat = "X";


# line 51 "commands.y"
typedef union  {
    Name y_name;
    Symbol y_sym;
    Node y_node;
    Integer y_int;
    Operator y_op;
    long y_long;
    char y_char;
    double y_real;
    String y_string;
    Boolean y_bool;
    Cmdlist y_cmdlist;
    List y_list;
} YYSTYPE;
# define ALIAS 257
# define AND 258
# define ASSIGN 259
# define AT 260
# define CALL 261
# define CATCH 262
# define CONT 263
# define DEBUG 264
# define DELETE 265
# define DIV 266
# define DOWN 267
# define DUMP 268
# define EDIT 269
# define FILE 270
# define FUNC 271
# define GRIPE 272
# define HELP 273
# define IF 274
# define IGNORE 275
# define IN 276
# define LIST 277
# define MOD 278
# define NEXT 279
# define NEXTI 280
# define NIL 281
# define NOT 282
# define OR 283
# define PRINT 284
# define PSYM 285
# define QUIT 286
# define RERUN 287
# define RETURN 288
# define RUN 289
# define SET 290
# define SH 291
# define SKIP 292
# define SOURCE 293
# define STATUS 294
# define STEP 295
# define STEPI 296
# define STOP 297
# define STOPI 298
# define TRACE 299
# define TRACEI 300
# define UNALIAS 301
# define UNSET 302
# define UP 303
# define USE 304
# define WHATIS 305
# define WHEN 306
# define WHERE 307
# define WHEREIS 308
# define WHICH 309
# define INT 310
# define CHAR 311
# define REAL 312
# define NAME 313
# define STRING 314
# define ARROW 315
# define REDIRECT 316
# define UNARYSIGN 317
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 158,
	276, 0,
	-2, 204,
-1, 280,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 11,
-1, 297,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 166,
-1, 300,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 168,
-1, 305,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 170,
-1, 325,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 171,
-1, 329,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 167,
-1, 330,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 172,
-1, 331,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 169,
-1, 332,
	60, 0,
	61, 0,
	62, 0,
	33, 0,
	-2, 173,
	};
# define YYNPROD 238
# define YYLAST 2386
short yyact[]={

  77, 343,  78, 310,  73,  75, 279,  76,  80, 269,
 268, 235, 271, 262, 144, 168, 145, 252, 165, 214,
 243, 190, 234, 298, 299, 210, 143, 233, 256, 338,
 326, 165, 178, 251, 146, 200, 198, 196, 199, 155,
 195,  67,  70, 302, 239, 342, 336, 307, 248, 147,
 200, 198, 237, 199, 197, 324, 339, 266,  77, 340,
  78, 154,  73,  75, 200,  76,  80, 337, 169, 163,
 209, 213, 156, 212, 328, 172, 189, 258, 139,  49,
 314, 281,   6, 259, 313,  23,   5,   3,   2, 142,
  68,   1, 320, 255, 201, 202, 203, 150, 311,  19,
   7,  74, 162, 171,  42, 207,  27,  86,  69, 270,
  28,  29,   0,   0,   0,   0,  77,   0,  78,   0,
  73,  75,   0,  76,  80,   0,   0,   0, 261,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 301,
 312,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 232,   0,   0,  77, 236,  78, 240,  73,  75,
   0,  76,  80, 273,   0,   0, 254,   0,   0, 188,
   0, 259,  63,   0,  66, 188,  64,   0, 287,  65,
  62, 181, 249,   0,   0,   0,   0,   0, 193,   0,
 194, 267,   0,   0,   0,   0,   0,   0,   0,  87,
  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,
  98,  99, 100, 101, 102, 103, 261, 104, 105, 106,
 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 135, 136,
 137, 138,  81,  82,  83,  85,  84,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,
 100, 101, 102, 103, 211, 104, 105, 106, 107, 108,
 109, 110, 111, 112, 113, 114, 115, 116, 117, 118,
 119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
 129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
  81,  82,  83,  85,  84,  87,  88,  89,  90,  91,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
 102, 103, 260, 104, 105, 106, 107, 108, 109, 110,
 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
 121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
 131, 132, 133, 134, 135, 136, 137, 138,  81,  82,
  83,  85,  84,  87,  88,  89, 159,  91,  92,  93,
  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
 165, 104, 158, 106, 107, 108, 109, 110, 111, 112,
 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,
 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
 133, 134, 135, 136, 137, 138,  81,  82,  83,  85,
 161,  77, 335,  78, 323,  73,  75, 316,  76,  80,
 260, 191, 192, 187,  61,  58, 180, 247,   0, 187,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 341,  77,
   0,  78,   0,  73,  75,   0,  76,  80,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 204, 205,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  77,   0,  78,
   0,  73,  75,   0,  76,  80,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  77,   0,  78,   0,  73,
  75,   0,  76,  80,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 272,   0, 275, 276, 277,   0,   0,   0,
  87,  88,  89, 159,  91,  92,  93,  94,  95,  96,
  97,  98,  99, 100, 101, 102, 103, 157, 104, 158,
 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
 136, 137, 138,  81,  82,  83,  85, 161,  87,  88,
  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,
  99, 100, 101, 102, 103, 265, 104, 105, 106, 107,
 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 129, 130, 131, 132, 133, 134, 135, 136, 137,
 138,  81,  82,  83,  85,  84,  87,  88,  89, 159,
  91,  92,  93,  94,  95,  96,  97,  98,  99, 100,
 101, 102, 103,   0, 104, 158, 106, 107, 108, 109,
 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
 120, 121, 122, 123, 124, 125, 126, 127, 128, 129,
 130, 131, 132, 133, 134, 135, 136, 137, 138,  81,
  82,  83,  85,  84,  87,  88,  89,  90,  91,  92,
  93,  94,  95,  96,  97,  98,  99, 100, 101, 102,
 103,   0, 104,   0, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 135, 136, 137, 138,  81,  82,  83,
  85,  84, 188, 148,   0,   0,   0,   0,   0,   0,
   0,   0,  80,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 152, 164,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 170,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 182,
   0,   0, 186,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  87,  88,  89,  90,  91,  92,  93,  94,
  95,  96,  97,  98,  99, 100, 101, 102, 103,   0,
 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
 134, 135, 136, 137, 138, 286,   0,   0,  85, 264,
   0,   0,   0,  80,   0,  87,  88,  89,  90,  91,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
 102, 103,   0, 104, 105, 106, 107, 108, 109, 110,
 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
 121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
 131, 132, 133, 134, 135, 136, 137, 138, 140,   0,
  80,  85,   0, 241, 242,   0,   0,   0,   0,   0,
 250, 253,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 285,   0,   0,
   0,   0,   0,  87,  88,  89,  90,  91,  92,  93,
  94,  95,  96,  97,  98,  99, 100, 101, 102, 103,
 183, 104, 105, 106, 107, 108, 109, 110, 111, 112,
 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,
 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
 133, 134, 135, 136, 137, 138, 187, 309,   0,  85,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 327,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  87,  88,  89,  90,  91,  92,
  93,  94,  95,  96,  97,  98,  99, 100, 101, 102,
 103,   0, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 135, 136, 137, 138,   0,   0,   0,
  85,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 288, 104,
 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
 115, 116, 117, 118, 119, 120, 121, 122, 123, 124,
 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
 135, 136, 137, 138,   0,   0,   0,  85,   0, 176,
   0,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103,   0, 104,
 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
 115, 116, 117, 118, 119, 120, 121, 122, 123, 124,
 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
 135, 136, 137, 138,   0,   0,   0,  85,  87,  88,
  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,
  99, 100, 101, 102, 103,   0, 104, 105, 106, 107,
 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 129, 130, 131, 132, 133, 134, 135, 136, 137,
 138,  63,   0,  66,  85,  64,   0,   0,  65,  62,
  38,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  39,   4,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  63,   0,  66, 282,  64,
   0,   0,  65,  62,  38,   0,   0,   0,   0,  72,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  39,   0,   0,   0,   0, 149, 246,   0, 334,   0,
   0,   0, 149,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 149,   0, 315, 175,   0,   0,
 319,   0,   0, 179,   0, 149,   0, 225, 149,   0,
   0,   0,   0,   0, 214, 303, 217, 215,   0, 216,
 210, 218,   0, 179,   0, 185,   0,   0,   0,   0,
   0,   0,   0, 225, 223, 238, 224,   0,  79,   0,
 214, 278, 217, 215,   0, 216, 210, 218, 141, 141,
   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,
 223, 238, 224, 153,   0, 209, 213,   0, 212, 166,
 167,   0,   0,   0,   0, 174,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 184,   0,   0,   0,
   0, 209, 213,   0, 212,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  47,   0,   8,   0,  43,   9,  10,  44,  11, 231,
  12,  45,  13,  14,  15,  16,  17,   0,  18,   0,
  48,   0,  52,  53,   0,   0,   0,  40,  20,  21,
  60,  22,  59,  24,  25,   0,  26,  46,  50,  51,
  54,  55,  56,  57,  30,  31,  32,  33,  34,  35,
  41,  36,  37,  61,  47,   0,   8,   0,  43,   9,
  10,  44,  11, 149,  12,  45,  13,  14,  15,  16,
  17,   0,  18,   0,  48,   0,  52,  53,   0,   0,
   0,  40,  20,  21,  60,  22,  59,  24,  25,   0,
  26,  46,  50,  51,  54,  55,  56,  57,  30,  31,
  32,  33,  34,  35,  41,  36,  37,  61,   0,   0,
   0,   0, 231, 263,   0, 308,  63,   0,  66,   0,
  64,   0, 221,  65,  62,  38, 274,   0,   0,   0,
 219,   0,   0, 322,   0,   0, 149,   0,   0, 283,
 284,  39, 220,   0,   0,   0,   0, 222, 221,   0,
   0,   0,   0,   0,   0,   0, 219,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 304,   0, 220,   0,
   0,   0,   0, 222, 333,   0,   0,   0,   0, 211,
   0,   0,   0,   0,   0,   0,   0,   0, 317, 318,
   0,   0,   0,   0, 321,   0,   0,   0,   0, 274,
   0,   0,   0,   0,   0, 211,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 177,   0,   0,   0, 225,   0,   0,   0,   0,
  71,   0, 214,   0, 217, 215, 257, 216, 210, 218,
   0,   0, 151, 274,   0,   0,   0,   0,   0,   0,
 160, 160, 223, 238, 224,   0,   0, 173,   0, 344,
 214,   0, 217, 225,   0,   0, 210, 218,   0,   0,
 214,   0, 217, 215,   0, 216, 210, 218,   0,   0,
   0,   0,   0, 209, 213,   0, 212,   0, 206,   0,
 223, 238, 224,   0,   0, 226,   0, 227, 228, 229,
 230,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 209, 213,   0, 212,   0,   0,   0,   0,   0,
   0, 209, 213,   0, 212,  47,   0,   8,   0,  43,
   9,  10,  44,  11,   0,  12,  45,  13,  14,  15,
  16,  17,   0,  18,   0,  48,   0,  52,  53,   0,
   0,   0,  40,  20,  21,  60,  22,  59,  24,  25,
   0,  26,  46,  50,  51,  54,  55,  56,  57,  30,
  31,  32,  33,  34,  35,  41,  36,  37,  61, 244,
 245,   0,   0,   0,   0,   0,   0, 244,   0,   0,
 225,   0,   0,   0,   0,   0,   0, 214,   0, 217,
 215,   0, 216, 210, 218,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 223, 208, 224,
 214,   0, 217, 215,   0, 216, 210, 218,   0,   0,
 280,   0,   0,   0,   0,   0,   0, 289, 290, 291,
 292, 293, 294, 295, 296, 297, 300,   0, 209, 213,
 221, 212,   0,   0,   0,   0,   0,   0, 219,   0,
 305, 306,   0,   0,   0,   0,   0,   0,   0,   0,
 220, 209, 213, 245, 212, 222,   0,   0, 221,   0,
   0,   0,   0,   0,   0,   0, 219,   0, 221,   0,
   0,   0,   0,   0,   0,   0, 219,   0, 220,   0,
   0,   0,   0, 325,   0,   0,   0, 211, 220,   0,
   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,
 329, 330,   0, 331, 332,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 211,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 211,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 221,   0,   0,   0,   0,
   0,   0,   0, 219,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 220,   0,   0, 221,   0,
 222,   0,   0,   0,   0,   0, 219,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 220,   0,
   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,
   0,   0, 211,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 211 };
short yypact[]={

-1000,1477,-1000,  31,-1000,-1000, -20,-1000, 471, 768,
 768,-296,-294,-1000,-1000,1034,-1000,-1000, 768,-1000,
 471,-1000,1034,-1000,1151,-1000,-1000,-1000, 413, 136,
1151,1151,-295,-1000,1034, 529,1151,1034,-1000,-1000,
 471,-1000,-1000,1034, 156,1094,-1000,1151, 866, 148,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  -7,-1000,
-1000,-1000,-1000,1034, 154, 154, 471,-1000,-1000,-1000,
-1000,2047,-1000, 471,-1000, 471, 471, 471, 471,-1000,
1151,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-296,-1000,-302,-302,   6,-1000,
-1000,1920,   6, -17,-302,-256,-256, 471, 587, 153,
1920, -10,-243,-256,-1000, 471,-1000,-1000,-1000,-1000,
   6, -95,-1000,1920,-1000,-1000,-1000,1882,  37,-1000,
-1000,-297,   6,1151, 705,  13,   6,-1000,-1000, 148,
-1000,-1000,-1000,-303,-304,-298, 154,1151, 154, 154,
 154,-1000,-1000, 145,  22,  22,1570,-307,  20, 471,
1151,1151,-1000, 977, 471, 471, 471, 471, 471, 471,
 471, 471, 471, -38,  78, -18,1910,1910,1910,1910,
1544,-1000,-1000,-1000,-1000,-1000,-1000,1151,  20, 471,
-1000,-1000,-1000,-1000,1920,1920,-1000, -11, 159,-256,
-1000, 471, 153,-1000,-1000,-310,1758, 471, 471,1151,
1151, 471,-1000,-1000,-1000,1151, 159,-1000,-1000,-1000,
1151,-1000,   8,-1000,-1000,  22,  22,-1000,-1000,-1000,
2070, 471, -63,-1000,-1000,   6,1034,  33,-1000,1910,
1910, -21, -21, -21, -21, -21,1910,2070, 471, 471,
2070, 471, 471,-1000,-1000,2070,1920, 159,-1000,-1000,
-1000,1423, -13,-1000,-1000,-1000,  26,-1000,-1000, -64,
  15,-1000,-1000,-1000,1151,2070,-1000,   6,-1000,2070,
2070,2070,2070,-1000,-1000, -14,-1000,-1000,-1000,-313,
1151,-1000,-1000,-1000,-1000 };
short yypgo[]={

   0, 111, 110, 109,  78, 108,  22,  27, 183,1608,
 107, 903,1529,  84,  80, 140, 106,  72,  39, 104,
 103, 198, 927,1308,1911,  32,  20, 101, 465,  26,
 100,  99,1546,  98,  93,  92,  91,  88,  87,  34,
  85,  79,  76,  21 };
short yyr1[]={

   0,  36,  36,  37,  37,  37,  38,  38,   5,   5,
  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,
  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,
  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,
  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,
  13,  13,  13,  13,  13,  13,  13,   4,   4,  40,
  40,  41,  41,  42,  42,  43,  43,  43,  43,  16,
  16,  16,  16,  39,  34,  34,  20,  20,  33,  33,
  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  30,  30,  30,  30,  30,  35,  35,   1,
   1,   2,   2,  17,  17,  18,  18,  18,   6,   7,
   7,  21,  21,  31,  31,  31,  31,  29,  29,  32,
  32,  19,  19,  19,  28,  28,  28,  28,  28,  28,
  28,  28,  28,  25,  25,  25,  25,   3,   3,   8,
   8,  22,  22,  23,  23,  24,  24,  24,  24,  24,
  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,
  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,
  24,  24,  24,  24,  24,  26,  27,  27,  27,  27,
  11,  11,  12,  12,   9,   9,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  10 };
short yyr2[]={

   0,   2,   0,   2,   2,   1,   1,   2,   3,   0,
   1,   4,   2,   1,   1,   2,   2,   1,   2,   3,
   3,   1,   2,   1,   1,   2,   1,   1,   2,   1,
   1,   2,   1,   4,   2,   1,   1,   3,   1,   3,
   3,   3,   4,   3,   3,   2,   2,   2,   1,   2,
   3,   2,   5,   2,   2,   1,   1,   1,   1,   2,
   1,   2,   2,   2,   1,   1,   1,   2,   2,   1,
   1,   1,   1,   0,   2,   0,   1,   1,   3,   2,
   1,   1,   2,   1,   1,   5,   2,   3,   2,   2,
   1,   1,   3,   3,   6,   2,   1,   3,   1,   1,
   1,   1,   1,   1,   3,   2,   2,   4,   1,   0,
   1,   1,   0,   1,   2,   4,   2,   1,   2,   1,
   1,   4,   5,   3,   1,   1,   2,   3,   3,   3,
   2,   2,   3,   1,   3,   3,   4,   0,   1,   1,
   0,   0,   2,   1,   3,   1,   4,   3,   3,   2,
   2,   3,   4,   4,   1,   2,   2,   2,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   4,   3,   4,
   3,   4,   4,   4,   3,   1,   1,   1,   1,   1,
   1,   3,   1,   2,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1 };
short yychk[]={

-1000, -36, -37, -38,  10, -13, -14, -30, 259, 262,
 263, 265, 267, 269, 270, 271, 272, 273, 275, -31,
 285, 286, 288, -40, 290, 291, 293, -16,  -2,  -1,
 301, 302, 303, 304, 305, 306, 308, 309,  47,  63,
 284, 307, -19, 261, 264, 268, 294, 257, 277, -41,
 295, 296, 279, 280, 297, 298, 299, 300, -28, 289,
 287, 310,  46,  38,  42,  45,  40,  10,  59,  -5,
  62, -24, -12,  42, -27,  43,  45,  38,  40,  -9,
  46, 310, 311, 312, 314, 313, -10, 257, 258, 259,
 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
 270, 271, 272, 273, 275, 276, 277, 278, 279, 280,
 281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
 291, 292, 293, 294, 295, 296, 297, 298, 299, 300,
 301, 302, 303, 304, 305, 306, 307, 308, 309,  -4,
 310,  -9,  -4, -29, 310, 310, -39, -39, -11, -12,
  -4, -24, -11,  -9, -39, -18, -17, 274, 276, 260,
 -24, 314, -17, -18, -22, 274,  -9,  -9, 310, -39,
 -11, -20, -18, -24,  -9, -12, -23, -24, -25, -12,
 310,  45, -11,  46,  -9, -32, -11, 310,  36, -42,
 -43, 313, 314,  60,  62,  47,  44,  61,  43,  45,
  42, -39, -39, -25, -28, -28, -24, -39,  61,  91,
  46, 315,  94,  92,  40,  43,  45,  42,  47, 266,
 278, 258, 283,  60,  62,  33, -24, -24, -24, -24,
 -24,  -9, -29,  -7,  -6, 313,  -7,  46,  61,  61,
  -6, -22, -22, -26, -24, -24, -32, 314,  58, -18,
 -22, 276, 260, -22, -26, -34, 123,  44,  40,  46,
 315,  91, 310,  -9, 314,  40,  44, -43, 313, 313,
  -3, 310, -28,  -8,  -9, -28, -28, -28,  41, 313,
 -24,  61, -23,  -9,  -9, -11,  38, -21, -23, -24,
 -24, -24, -24, -24, -24, -24, -24, -24,  61,  62,
 -24,  61,  61,  41,  -9, -24, -24,  58, -32, -22,
 313, -33, -15, -13, -14, -23, -21,  -9,  -9, -23,
 -35,  -9, -32,  -8,  47, -24,  93, -11,  41, -24,
 -24, -24, -24, -32, 125, -15,  59,  41,  93,  41,
  44,  -8,  59, 314,  -9 };
short yydef[]={

   2,  -2,   1,   0,   5,   6,   9,  10,   0,  13,
  14,   0,  17,  73,  73,  21,  23,  24,  26,  27,
   0,  29,  30,  32,  35,  36,  73,  38,   0, 141,
   0,   0,  48,  73,   0,   0,   0,   0,  55,  56,
   0,  83,  84,   0,   0,  90,  91,  96, 113,  60,
  69,  70,  71,  72, 101, 102,  99, 100,   0,  73,
  73, 124, 125,   0,   0,   0,   0,   3,   4,   7,
  73,   0, 145,   0, 154,   0,   0,   0,   0, 182,
   0, 176, 177, 178, 179, 184, 185, 186, 187, 188,
 189, 190, 191, 192, 193, 194, 195, 196, 197, 198,
 199, 200, 201, 202, 203, 204, 205, 206, 207, 208,
 209, 210, 211, 212, 213, 214, 215, 216, 217, 218,
 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
 229, 230, 231, 232, 233, 234, 235, 236, 237,  12,
  57,  58,  15,  16, 117,  18, 109, 109,  22, 180,
  25,  28,  31,  34,   0, 141, 141,   0,  -2, 189,
 103, 179, 141, 141,  45,   0,  46,  47,  49,  75,
  51,   0,  76,  77,  53,  54,  82, 143,   0, 133,
  86,   0,  88,  89,  95, 114, 116, 119, 120,  59,
  64,  65,  66,   0,   0, 137,   0, 140,   0,   0,
   0,  61,  62, 126, 130, 131,   0,   0,   0,   0,
   0,   0, 150,   0, 112,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 149, 155, 156, 157,
   0, 183, 118,  19, 110, 108,  20,   0,   0,   0,
  37,  39,  40,  41, 175, 105, 106,   0,   0, 141,
  44,   0,   0,  43, 142,  50,   0,   0, 112,   0,
   0,   0,  87,  92,  93,   0,   0,  63,  67,  68,
 140, 138,   0, 123, 139, 127, 128, 129, 132,   8,
  -2,   0,   0, 147, 148, 151,   0,   0, 111, 158,
 159, 160, 161, 162, 163, 164, 165,  -2,   0,   0,
  -2,   0,   0, 174, 181,  -2,  33,   0, 104,  42,
  74,   0,   0,  80,  81, 144,   0, 134, 135,   0,
   0,  98, 115, 121, 140,  -2, 146, 152, 153,  -2,
  -2,  -2,  -2, 107,  52,   0,  79,  85, 136,   0,
   0, 122,  78,  94,  97 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 4:
# line 98 "commands.y"
{
	chkalias = true;
} break;
case 6:
# line 107 "commands.y"
{
	if (yypvt[-0].y_node != nil) {
	    topeval(yypvt[-0].y_node);
	}
} break;
case 7:
# line 114 "commands.y"
{
	if (yypvt[-1].y_node != nil) {
	    if (yypvt[-0].y_string != nil) {
		setout(yypvt[-0].y_string);
		topeval(yypvt[-1].y_node);
		unsetout();
	    } else {
		topeval(yypvt[-1].y_node);
	    }
	}
} break;
case 8:
# line 128 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
} break;
case 9:
# line 133 "commands.y"
{
	yyval.y_string = nil;
} break;
case 10:
# line 143 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 11:
# line 148 "commands.y"
{
	yyval.y_node = build(O_ASSIGN, unrval(yypvt[-2].y_node), yypvt[-0].y_node);
} break;
case 12:
# line 153 "commands.y"
{
	yyval.y_node = build(O_CATCH, yypvt[-0].y_long);
} break;
case 13:
# line 158 "commands.y"
{
	yyval.y_node = build(O_CATCH, 0);
} break;
case 14:
# line 163 "commands.y"
{
	yyval.y_node = build(O_CONT, (long) DEFSIG);
} break;
case 15:
# line 168 "commands.y"
{
	yyval.y_node = build(O_CONT, yypvt[-0].y_long);
} break;
case 16:
# line 173 "commands.y"
{
	yyval.y_node = build(O_DELETE, yypvt[-0].y_node);
} break;
case 17:
# line 178 "commands.y"
{
	yyval.y_node = build(O_DOWN, build(O_LCON, (long) 1));
} break;
case 18:
# line 183 "commands.y"
{
	yyval.y_node = build(O_DOWN, build(O_LCON, (long) yypvt[-0].y_long));
} break;
case 19:
# line 188 "commands.y"
{
	yyval.y_node = build(O_EDIT, yypvt[-0].y_string);
} break;
case 20:
# line 193 "commands.y"
{
	yyval.y_node = build(O_CHFILE, yypvt[-0].y_string);
} break;
case 21:
# line 198 "commands.y"
{
	yyval.y_node = build(O_FUNC, nil);
} break;
case 22:
# line 203 "commands.y"
{
	yyval.y_node = build(O_FUNC, yypvt[-0].y_node);
} break;
case 23:
# line 208 "commands.y"
{
	yyval.y_node = build(O_GRIPE);
} break;
case 24:
# line 213 "commands.y"
{
	yyval.y_node = build(O_HELP);
} break;
case 25:
# line 218 "commands.y"
{
	yyval.y_node = build(O_IGNORE, yypvt[-0].y_long);
} break;
case 26:
# line 223 "commands.y"
{
	yyval.y_node = build(O_IGNORE, 0);
} break;
case 27:
# line 228 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 28:
# line 233 "commands.y"
{
	yyval.y_node = build(O_PSYM, unrval(yypvt[-0].y_node));
} break;
case 29:
# line 238 "commands.y"
{
	if (not popinput()) {
	    quit(0);
	} else {
	    yyval.y_node = nil;
	}
} break;
case 30:
# line 247 "commands.y"
{
	yyval.y_node = build(O_RETURN, nil);
} break;
case 31:
# line 252 "commands.y"
{
	yyval.y_node = build(O_RETURN, yypvt[-0].y_node);
} break;
case 32:
# line 257 "commands.y"
{
	run();
	/* NOTREACHED */
} break;
case 33:
# line 263 "commands.y"
{
	yyval.y_node = build(O_SET, build(O_NAME, yypvt[-2].y_name), yypvt[-0].y_node);
} break;
case 34:
# line 268 "commands.y"
{
	yyval.y_node = build(O_SET, build(O_NAME, yypvt[-0].y_name), nil);
} break;
case 35:
# line 273 "commands.y"
{
	yyval.y_node = build(O_SET, nil, nil);
} break;
case 36:
# line 278 "commands.y"
{
	shellline();
	yyval.y_node = nil;
} break;
case 37:
# line 284 "commands.y"
{
	yyval.y_node = build(O_SOURCE, yypvt[-0].y_string);
} break;
case 38:
# line 289 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 39:
# line 294 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 40:
# line 299 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, yypvt[-1].y_node, nil, yypvt[-0].y_node);
} break;
case 41:
# line 304 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, nil, yypvt[-0].y_node);
} break;
case 42:
# line 309 "commands.y"
{
	yyval.y_node = build(yypvt[-3].y_op, yypvt[-2].y_node, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 43:
# line 314 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, nil, yypvt[-1].y_node, yypvt[-0].y_node);
} break;
case 44:
# line 319 "commands.y"
{
	yyval.y_node = build(yypvt[-2].y_op, yypvt[-1].y_node, nil, yypvt[-0].y_node);
} break;
case 45:
# line 324 "commands.y"
{
	yyval.y_node = build(yypvt[-1].y_op, nil, nil, yypvt[-0].y_node);
} break;
case 46:
# line 329 "commands.y"
{
	yyval.y_node = build(O_UNALIAS, build(O_NAME, yypvt[-0].y_name));
} break;
case 47:
# line 334 "commands.y"
{
	yyval.y_node = build(O_UNSET, build(O_NAME, yypvt[-0].y_name));
} break;
case 48:
# line 339 "commands.y"
{
	yyval.y_node = build(O_UP, build(O_LCON, (long) 1));
} break;
case 49:
# line 344 "commands.y"
{
	yyval.y_node = build(O_UP, build(O_LCON, (long) yypvt[-0].y_long));
} break;
case 50:
# line 349 "commands.y"
{
	String dir;

	yyval.y_node = nil;
	if (list_size(yypvt[-0].y_list) == 0) {
	    foreach (String, dir, sourcepath)
		printf("%s ", dir);
	    endfor
	    printf("\n");
	} else {
	    foreach (String, dir, sourcepath)
		list_delete(list_curitem(sourcepath), sourcepath);
	    endfor
	    sourcepath = yypvt[-0].y_list;
	}
} break;
case 51:
# line 367 "commands.y"
{
	yyval.y_node = build(O_WHATIS, yypvt[-0].y_node);
} break;
case 52:
# line 372 "commands.y"
{
	yyval.y_node = build(O_ADDEVENT, yypvt[-3].y_node, yypvt[-1].y_cmdlist);
} break;
case 53:
# line 377 "commands.y"
{
	yyval.y_node = build(O_WHEREIS, build(O_SYM, lookup(yypvt[-0].y_name)));
} break;
case 54:
# line 382 "commands.y"
{
	yyval.y_node = build(O_WHICH, yypvt[-0].y_node);
} break;
case 55:
# line 387 "commands.y"
{
	yyval.y_node = build(O_SEARCH,
	    build(O_LCON, (long) '/'),
	    build(O_SCON, strdup(scanner_linebuf))
	);
	gobble();
	insertinput("\n");
} break;
case 56:
# line 397 "commands.y"
{
	yyval.y_node = build(O_SEARCH,
	    build(O_LCON, (long) '?'),
	    build(O_SCON, strdup(scanner_linebuf))
	);
	gobble();
	insertinput("\n");
} break;
case 57:
# line 408 "commands.y"
{
	yyval.y_long = yypvt[-0].y_long;
} break;
case 58:
# line 413 "commands.y"
{
	yyval.y_long = siglookup(ident(yypvt[-0].y_name));
} break;
case 61:
# line 424 "commands.y"
{
	arginit();
	fflush(stdout);
} break;
case 62:
# line 430 "commands.y"
{
	fflush(stdout);
} break;
case 65:
# line 441 "commands.y"
{
	newarg(ident(yypvt[-0].y_name));
} break;
case 66:
# line 446 "commands.y"
{
	newarg(yypvt[-0].y_string);
} break;
case 67:
# line 451 "commands.y"
{
	inarg(ident(yypvt[-0].y_name));
} break;
case 68:
# line 456 "commands.y"
{
	outarg(ident(yypvt[-0].y_name));
} break;
case 69:
# line 462 "commands.y"
{
	yyval.y_node = build(O_STEP, true, false);
} break;
case 70:
# line 467 "commands.y"
{
	yyval.y_node = build(O_STEP, false, false);
} break;
case 71:
# line 472 "commands.y"
{
	yyval.y_node = build(O_STEP, true, true);
} break;
case 72:
# line 477 "commands.y"
{
	yyval.y_node = build(O_STEP, false, true);
} break;
case 73:
# line 483 "commands.y"
{
	beginshellmode();
} break;
case 74:
# line 489 "commands.y"
{
	yyval.y_list = yypvt[-1].y_list;
	list_append(list_item(ident(yypvt[-0].y_name)), nil, yyval.y_list);
} break;
case 75:
# line 495 "commands.y"
{
	yyval.y_list = list_alloc();
} break;
case 78:
# line 506 "commands.y"
{
	yyval.y_cmdlist = yypvt[-2].y_cmdlist;
	cmdlist_append(yypvt[-1].y_node, yyval.y_cmdlist);
} break;
case 79:
# line 512 "commands.y"
{
	yyval.y_cmdlist = list_alloc();
	cmdlist_append(yypvt[-1].y_node, yyval.y_cmdlist);
} break;
case 82:
# line 528 "commands.y"
{
	yyval.y_node = build(O_PRINT, yypvt[-0].y_node);
} break;
case 83:
# line 533 "commands.y"
{
	yyval.y_node = build(O_WHERE);
} break;
case 84:
# line 538 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 85:
# line 543 "commands.y"
{
	yyval.y_node = build(O_CALLPROC, yypvt[-3].y_node, yypvt[-1].y_node);
} break;
case 86:
# line 548 "commands.y"
{
 	yyval.y_node = build(O_DEBUG, yypvt[-0].y_long);
} break;
case 87:
# line 553 "commands.y"
{
	yyval.y_node = build(O_DEBUG, -yypvt[-0].y_long);
} break;
case 88:
# line 558 "commands.y"
{
	yyval.y_node = build(O_DUMP, yypvt[-0].y_node);
} break;
case 89:
# line 563 "commands.y"
{
	yyval.y_node = build(O_DUMP, nil);
} break;
case 90:
# line 568 "commands.y"
{
	yyval.y_node = build(O_DUMP, build(O_SYM, curfunc));
} break;
case 91:
# line 573 "commands.y"
{
	yyval.y_node = build(O_STATUS);
} break;
case 92:
# line 579 "commands.y"
{
	yyval.y_node = build(O_ALIAS, build(O_NAME, yypvt[-1].y_name), build(O_NAME, yypvt[-0].y_name));
} break;
case 93:
# line 584 "commands.y"
{
	yyval.y_node = build(O_ALIAS, build(O_NAME, yypvt[-1].y_name), build(O_SCON, yypvt[-0].y_string));
} break;
case 94:
# line 589 "commands.y"
{
	yyval.y_node = build(O_ALIAS,
	    build(O_COMMA, build(O_NAME, yypvt[-4].y_name), (Node) yypvt[-2].y_list),
	    build(O_SCON, yypvt[-0].y_string)
	);
} break;
case 95:
# line 597 "commands.y"
{
	yyval.y_node = build(O_ALIAS, build(O_NAME, yypvt[-0].y_name), nil);
} break;
case 96:
# line 602 "commands.y"
{
	yyval.y_node = build(O_ALIAS, nil, nil);
} break;
case 97:
# line 608 "commands.y"
{
	yyval.y_list = yypvt[-2].y_list;
	list_append(list_item(yypvt[-0].y_name), nil, yyval.y_list);
} break;
case 98:
# line 614 "commands.y"
{
	yyval.y_list = list_alloc();
	list_append(list_item(yypvt[-0].y_name), nil, yyval.y_list);
} break;
case 99:
# line 621 "commands.y"
{
	yyval.y_op = O_TRACE;
} break;
case 100:
# line 626 "commands.y"
{
	yyval.y_op = O_TRACEI;
} break;
case 101:
# line 632 "commands.y"
{
	yyval.y_op = O_STOP;
} break;
case 102:
# line 637 "commands.y"
{
	yyval.y_op = O_STOPI;
} break;
case 103:
# line 643 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 104:
# line 648 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, yypvt[-2].y_string), yypvt[-0].y_node);
} break;
case 105:
# line 654 "commands.y"
{
	yyval.y_node = unrval(yypvt[-0].y_node);
} break;
case 106:
# line 659 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, strdup(cursource)), yypvt[-0].y_node);
} break;
case 107:
# line 664 "commands.y"
{
	yyval.y_node = build(O_QLINE, build(O_SCON, yypvt[-2].y_string), yypvt[-0].y_node);
} break;
case 108:
# line 670 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
} break;
case 109:
# line 676 "commands.y"
{
	yyval.y_string = nil;
} break;
case 110:
# line 681 "commands.y"
{
	yyval.y_string = yypvt[-0].y_string;
} break;
case 111:
# line 687 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 112:
# line 692 "commands.y"
{
	yyval.y_node = nil;
} break;
case 113:
# line 698 "commands.y"
{
	yyval.y_node = build(O_LIST,
	    build(O_LCON, (long) cursrcline),
	    build(O_LCON, (long) cursrcline + 9)
	);
} break;
case 114:
# line 706 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-0].y_node, yypvt[-0].y_node);
} break;
case 115:
# line 711 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 116:
# line 716 "commands.y"
{
	yyval.y_node = build(O_LIST, yypvt[-0].y_node);
} break;
case 117:
# line 722 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 118:
# line 727 "commands.y"
{
	yyval.y_node = build(O_COMMA, build(O_LCON, yypvt[-1].y_long), yypvt[-0].y_node);
} break;
case 119:
# line 733 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 120:
# line 738 "commands.y"
{
	yyval.y_node = build(O_LCON, (long) LASTLINE);
} break;
case 121:
# line 744 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-3].y_node, nil, yypvt[-1].y_long);
} break;
case 122:
# line 749 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-4].y_node, yypvt[-2].y_node, 0);
} break;
case 123:
# line 754 "commands.y"
{
	yyval.y_node = build(O_EXAMINE, yypvt[-0].y_string, yypvt[-2].y_node, nil, 0);
} break;
case 124:
# line 760 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 125:
# line 765 "commands.y"
{
	yyval.y_node = build(O_LCON, (long) prtaddr);
} break;
case 126:
# line 770 "commands.y"
{
	yyval.y_node = amper(yypvt[-0].y_node);
} break;
case 127:
# line 775 "commands.y"
{
	yyval.y_node = build(O_ADD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 128:
# line 780 "commands.y"
{
	yyval.y_node = build(O_SUB, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 129:
# line 785 "commands.y"
{
	yyval.y_node = build(O_MUL, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 130:
# line 790 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-0].y_node);
} break;
case 131:
# line 795 "commands.y"
{
	yyval.y_node = build(O_NEG, yypvt[-0].y_node);
} break;
case 132:
# line 800 "commands.y"
{
	yyval.y_node = yypvt[-1].y_node;
} break;
case 133:
# line 806 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 134:
# line 811 "commands.y"
{
	yyval.y_node = unrval(dot(yypvt[-2].y_node, yypvt[-0].y_name));
} break;
case 135:
# line 816 "commands.y"
{
	yyval.y_node = unrval(dot(yypvt[-2].y_node, yypvt[-0].y_name));
} break;
case 136:
# line 821 "commands.y"
{
	yyval.y_node = unrval(subscript(yypvt[-3].y_node, yypvt[-1].y_node));
} break;
case 137:
# line 827 "commands.y"
{
	yyval.y_long = 1;
} break;
case 138:
# line 832 "commands.y"
{
	yyval.y_long = yypvt[-0].y_long;
} break;
case 139:
# line 838 "commands.y"
{
	yyval.y_string = ident(yypvt[-0].y_name);
	curformat = yyval.y_string;
} break;
case 140:
# line 844 "commands.y"
{
	yyval.y_string = curformat;
} break;
case 141:
# line 850 "commands.y"
{
	yyval.y_node = nil;
} break;
case 142:
# line 855 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 143:
# line 861 "commands.y"
{
	yyval.y_node = build(O_COMMA, yypvt[-0].y_node, nil);
} break;
case 144:
# line 866 "commands.y"
{
	yyval.y_node = build(O_COMMA, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 145:
# line 872 "commands.y"
{
	yyval.y_node = build(O_RVAL, yypvt[-0].y_node);
} break;
case 146:
# line 877 "commands.y"
{
	yyval.y_node = subscript(unrval(yypvt[-3].y_node), yypvt[-1].y_node);
} break;
case 147:
# line 882 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 148:
# line 887 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 149:
# line 892 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-0].y_node);
} break;
case 150:
# line 897 "commands.y"
{
	yyval.y_node = build(O_INDIR, yypvt[-1].y_node);
} break;
case 151:
# line 902 "commands.y"
{
	yyval.y_node = build(O_TYPERENAME, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 152:
# line 907 "commands.y"
{
	yyval.y_node = renameptr(yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 153:
# line 912 "commands.y"
{
	yyval.y_node = build(O_CALL, unrval(yypvt[-3].y_node), yypvt[-1].y_node);
} break;
case 154:
# line 917 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 155:
# line 922 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 156:
# line 927 "commands.y"
{
	yyval.y_node = build(O_NEG, yypvt[-0].y_node);
} break;
case 157:
# line 932 "commands.y"
{
	yyval.y_node = amper(yypvt[-0].y_node);
} break;
case 158:
# line 937 "commands.y"
{
	yyval.y_node = build(O_ADD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 159:
# line 942 "commands.y"
{
	yyval.y_node = build(O_SUB, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 160:
# line 947 "commands.y"
{
	yyval.y_node = build(O_MUL, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 161:
# line 952 "commands.y"
{
	yyval.y_node = build(O_DIVF, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 162:
# line 957 "commands.y"
{
	yyval.y_node = build(O_DIV, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 163:
# line 962 "commands.y"
{
	yyval.y_node = build(O_MOD, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 164:
# line 967 "commands.y"
{
	yyval.y_node = build(O_AND, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 165:
# line 972 "commands.y"
{
	yyval.y_node = build(O_OR, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 166:
# line 977 "commands.y"
{
	yyval.y_node = build(O_LT, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 167:
# line 982 "commands.y"
{
	yyval.y_node = build(O_LE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 168:
# line 987 "commands.y"
{
	yyval.y_node = build(O_GT, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 169:
# line 992 "commands.y"
{
	yyval.y_node = build(O_GE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 170:
# line 997 "commands.y"
{
	yyval.y_node = build(O_EQ, yypvt[-2].y_node, yypvt[-0].y_node);
} break;
case 171:
# line 1002 "commands.y"
{
	yyval.y_node = build(O_EQ, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 172:
# line 1007 "commands.y"
{
	yyval.y_node = build(O_NE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 173:
# line 1012 "commands.y"
{
	yyval.y_node = build(O_NE, yypvt[-3].y_node, yypvt[-0].y_node);
} break;
case 174:
# line 1017 "commands.y"
{
	yyval.y_node = yypvt[-1].y_node;
} break;
case 175:
# line 1023 "commands.y"
{
	chkboolean(yypvt[-0].y_node);
	yyval.y_node = yypvt[-0].y_node;
} break;
case 176:
# line 1030 "commands.y"
{
	yyval.y_node = build(O_LCON, yypvt[-0].y_long);
} break;
case 177:
# line 1035 "commands.y"
{
	yyval.y_node = build(O_CCON, yypvt[-0].y_char);
} break;
case 178:
# line 1040 "commands.y"
{
	yyval.y_node = build(O_FCON, yypvt[-0].y_real);
} break;
case 179:
# line 1045 "commands.y"
{
	yyval.y_node = build(O_SCON, yypvt[-0].y_string);
} break;
case 180:
# line 1051 "commands.y"
{
	yyval.y_node = yypvt[-0].y_node;
} break;
case 181:
# line 1056 "commands.y"
{
	yyval.y_node = dot(yypvt[-2].y_node, yypvt[-0].y_name);
} break;
case 182:
# line 1062 "commands.y"
{
	yyval.y_node = findvar(yypvt[-0].y_name);
	if (yyval.y_node == nil) {
	    yyval.y_node = build(O_SYM, which(yypvt[-0].y_name));
	}
} break;
case 183:
# line 1070 "commands.y"
{
	yyval.y_node = dot(build(O_SYM, program), yypvt[-0].y_name);
} break;
case 184:
# line 1076 "commands.y"
{
	yyval.y_name = yypvt[-0].y_name;
} break;
case 185:
# line 1081 "commands.y"
{
	yyval.y_name = yypvt[-0].y_name;
} break;
		}
		goto yystack;  /* stack new state and value */

	}
