.TH RCSINTRO 1 6/29/83 "Purdue University"
.SH NAME
rcsintro - introduction to RCS commands
.SH DESCRIPTION
The Revision Control System (RCS) manages multiple revisions of text files.
RCS automates the storing, retrieval, logging, identification, and merging
of revisions. RCS is useful for text that is revised frequently, for example
programs, documentation, graphics, papers, form letters, etc.
.PP
The basic user interface is extremely simple. The novice only needs
to learn two commands:
.I ci
and
.I co.
\fICi\fR, short for "checkin", deposits the contents of a
text file into an archival file called an RCS file. An RCS file
contains all revisions of a particular text file.
\fICo\fR, short for "checkout", retrieves revisions from an RCS file.
.PP
.B "Functions of RCS"
.PP
.IP \(bu
Storage and retrieval of multiple revisions of text. RCS saves all old
revisions in a space efficient way.
Changes no longer destroy the original, because the
previous revisions remain accessible. Revisions can be retrieved according to
ranges of revision numbers, symbolic names, dates, authors, and
states.
.IP \(bu
Maintenance of a complete history of changes. RCS logs all changes automatically.
Besides the text of each revision, RCS stores the author, the date and time of
checkin, and a log message summarizing the change.
The logging makes it easy to find out
what happened to a module, without having to compare
source listings or having to track down colleagues.
.IP \(bu
Resolution of access conflicts. When two or more programmers wish to
modify the same revision, RCS alerts the programmers and prevents one
modification from corrupting the other.
.IP \(bu
Maintenance of a tree of Revisions. RCS can maintain separate lines of development
for each module. It stores a tree structure that represents the
ancestral relationships among revisions.
.IP \(bu
Merging of revisions and resolution of conflicts.
Two separate lines of development of a module can be coalesced by merging.
If the revisions to be merged affect the same sections of code, RCS alerts the
user about the overlapping changes.
.IP \(bu
Release and configuration control. Revisions can be assigned symbolic names
and marked as released, stable, experimental, etc.
With these facilities, configurations of modules can be
described simply and directly.
.IP \(bu
Automatic identification of each revision with name, revision number,
creation time, author, etc.
The identification is like a stamp that can be embedded at an appropriate place
in the text of a revision.
The identification makes it simple to determine which
revisions of which modules make up a given configuration.
.IP \(bu
Minimization of secondary storage. RCS needs little extra space for
the revisions (only the differences). If intermediate revisions are
deleted, the corresponding deltas are compressed accordingly.
.sp
.PP
.B "Getting Started with RCS"
.PP
Suppose you have a file f.c that you wish to put under control of RCS. 
Invoke the checkin command
.PP
		ci  f.c 
.PP
This command creates the RCS file f.c,v, stores f.c into it as revision 1.1, and
deletes f.c.  It also asks you for a description. The description
should be a synopsis of the contents of the file. All later checkin
commands will ask you for a log entry, which should summarize the
changes that you made.
.PP
Files ending in ,v are called RCS files (`v' stands for `versions'),
the others are called working files.
To get back the working file f.c in the previous example, use the checkout
command
.PP
		co  f.c
.PP
This command extracts the latest revision from f.c,v and writes
it into f.c. You can now edit f.c and check it back in by invoking
.PP
		ci  f.c
.PP
\fICi\fR increments the revision number properly. 
If \fIci\fR complains with the message
.PP
		ci error: no lock set by <your login>
.PP
then your system administrator has decided to create all RCS files
with the locking attribute set to `strict'. In this case, you should
have locked the revision during the previous checkout. Your last checkout
should have been
.PP
		co  -l  f.c
.PP
Of course, it is too late now to do the checkout with locking, because you
probably modified f.c already, and a second checkout would
overwrite your modifications. Instead, invoke
.PP
		rcs  -l  f.c
.PP
This command will lock the latest revision for you, unless somebody
else got ahead of you already. In this case, you'll have to negotiate with 
that person.
.PP
Locking assures that you, and only you, can check in the next update, and
avoids nasty problems if several people work on the same file.
Even if a revision is locked, it can still be checked out for
reading, compiling, etc. All that locking
prevents is a CHECKIN by anybody but the locker.
.PP
If your RCS file is private, i.e., if you are the only person who is going
to deposit revisions into it, strict locking is not needed and you
can turn it off.
If strict locking is turned off,
the owner off the RCS file need not have a lock for checkin; all others
still do. Turning strict locking off and on is done with the commands
.PP
		rcs  -U  f.c       and         rcs  -L  f.c
.PP
If you don't want to clutter your working directory with RCS files, create 
a subdirectory called RCS in your working directory, and move all your RCS 
files there. RCS commands will look first into that directory to find 
needed files. All the commands discussed above will still work, without any 
modification. 
(Actually, pairs of RCS and working files can be specified in 3 ways:
(a) both are given, (b) only the working file is given, (c) only the
RCS file is given. Both RCS and working files may have arbitrary path prefixes;
RCS commands pair them up intelligently).
.PP
To avoid the deletion of the working file during checkin (in case you want to
continue editing), invoke
.PP
		ci  -l  f.c        or          ci  -u  f.c
.PP
These commands check in f.c as usual, but perform an implicit
checkout. The first form also locks the checked in revision, the second one
doesn't. Thus, these options save you one checkout operation.
The first form is useful if locking is strict, the second one if not strict.
Both update the identification markers in your working file (see below).
.PP
You can give \fIci\fR the number you want assigned to a checked in
revision. Assume all your revisions were numbered 1.1, 1.2, 1.3, etc.,
and you would like to start release 2.
The command
.PP
		ci  -r2  f.c       or          ci  -r2.1  f.c
.PP
assigns the number 2.1 to the new revision.
From then on, \fIci\fR will number the subsequent revisions
with 2.2, 2.3, etc. The corresponding \fIco\fR commands
.PP
		co  -r2  f.c       and         co  -r2.1  f.c
.PP
retrieve the latest revision numbered 2.x and the revision 2.1,
respectively. \fICo\fR without a revision number selects
the latest revision on the "trunk", i.e., the highest
revision with a number consisting of 2 fields. Numbers with more than 2
fields are needed for branches.
For example, to start a branch at revision 1.3, invoke
.PP
		ci  -r1.3.1  f.c
.PP
This command starts a branch numbered 1 at revision 1.3, and assigns
the number 1.3.1.1 to the new revision. For more information about
branches, see \fIrcsfile\fR(5).
.sp
.PP
.B "Automatic Identification"
.PP
RCS can put special strings for identification into your source and object
code. To obtain such identification, place the marker
.PP
		$\&Header$
.PP
into your text, for instance inside a comment.
RCS will replace this marker with a string of the form
.PP
		$\&Header:  filename  revision_number  date  time  author  state $
.PP
With such a marker on the first page of each module, you can
always see with which revision you are working.
RCS keeps the markers up to date automatically.
To propagate the markers into your object code, simply put
them into literal character strings. In C, this is done as follows:
.PP
		static char rcsid[] = "$\&Header$";
.PP
The command \fIident\fR extracts such markers from any file, even object code
and dumps.
Thus, \fIident\fR lets you find out
which revisions of which modules were used in a given program. 
.PP
You may also find it useful to put the marker $\&Log$
into your text, inside a comment. This marker accumulates
the log messages that are requested during checkin.
Thus, you can maintain the complete history of your file directly inside it.
There are several additional identification markers; see \fIco\fR(1) for
details.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.br
Revision Number:
.VL $Revision: 3.0 $
; Release Date:
.VL $Date: 83/05/11 14:04:38 $
\&.
.br
Copyright \(co 1982 by Walter F. Tichy.
.SH SEE ALSO
ci(1), co(1), ident(1), merge(1), rcs(1), rcsdiff(1), rcsmerge(1), rlog(1), rcsfile(5).
.br
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \fIProceedings of the 6th International Conference on Software
Engineering\fR, IEEE, Tokyo, Sept. 1982.


