.\"	This file is automatically generated.  Do not edit!
.\" include the -mh macro file
.so /usr/misc/mh/lib/tmac.h
.\"	This file is automatically generated.  Do not edit!
.SC MH\-FORMAT 5
.NA
mh\-format \- format file for MH message system
.SY
some \fIMH\fR commands
.DE
Several \fIMH\fR commands utilize either a \fIformat\fR string or a
\fIformat\fR file during their execution.
For example,
\fIscan\fR\0(1) uses a format string which directs it how to generate the
scan listing for each message;
\fIrepl\fR\0(1) uses a format file which directs it how to generate the
reply to a message, and so on.

Format strings are designed to be efficiently parsed by \fIMH\fR since they
represent an integral part of \fIMH\fR.
This means that novice, casual, or even advanced users of \fIMH\fR should
deal with them.
It suffices to have your local \fIMH\fR expert actually write new format
commands or modify existing ones.
This manual section explains how to do just that.

A format string is similar to a \fIprintf\fR\0(3) string,
but uses multi\-letter `%'\-escapes.
When specifying a string,
the usual C backslash characters are honored:
`\\b', `\\f', `\\n', `\\r', and `\\t'.
Continuation lines in format files end with `\\' followed by the newline
character.

The interpretation model is based on a simple machine with two registers,
\fInum\fR and \fIstr\fR.
The former contains an integer value, the latter a string value.
When an escape is processed,
if it requires an argument,
it reads the current value of either \fInum\fR or \fIstr\fR;
and,
if it returns a value, it writes either \fInum\fR or \fIstr\fR.

Escapes are of three types:
\fIcomponents\fR, \fIfunctions\fR, and, \fIcontrol\fR.
A component escape is specified as `%{name}',
and is created for each header found in the message being processed.
For example `%{date} refers to the \*(lqDate:\*(rq field of the appropriate
message.
A component escape is always string valued.

A control escape is one of: `%<escape', `%|', and `%>',
which correspond to if\-then\-else constructs:
if `escape' is non\-zero (for integer\-valued escapes),
or non\-empty (for string\-valued escapes),
then everything up to `%|' or `%>' (whichever comes first) is interpreted;
otherwise, then skip to `%|' or `%>' (whichever comes first)
and start interpreting again.

A function escape is specified as `%(name)',
and is statically defined.
Here is the list:
.nf
.ta \w'formataddr  'u +\w'argument  'u +\w'returns  'u
\fIescape\fR	\fIargument\fR	\fIreturns\fR	\fIinterpretation\fR
nonzero	integer	integer	\fInum\fR is non\-zero
zero	integer	integer	\fInum\fR is zero
eq	integer	integer	\fInum\fR == width
ne	integer	integer	\fInum\fR != width
gt	integer	integer	width > \fInum\fR
null	string	integer	\fIstr\fR is empty
nonnull	string	integer	\fIstr\fR is non\-empty
putstr	string		print \fIstr\fR
putstrf	string		print \fIstr\fR in the specified width
			(e.g., %20(putstrf{subject})
putnum	integer		print \fInum\fR
putnumf	integer		print \fInum\fR in the specified width
			(e.g., %4(putnumf(msg))
msg		integer	message number
cur		integer	message is current
size		integer	size of message
strlen	string	integer	length of \fIstr\fR
me		string	the user's mailbox
plus		integer	add width to \fInum\fR
minus		integer	subtract \fInum\fR from width
charleft		integer	space left in output buffer
timenow		integer	seconds since the UNIX epoch
.re
.fi

When \fIstr\fR is a date, these escapes are useful:
.nf
.ta \w'formataddr  'u +\w'argument  'u +\w'returns  'u
\fIescape\fR	\fIargument\fR	\fIreturns\fR	\fIinterpretation\fR
sec	string	integer	seconds of the minute
min	string	integer	minutes of the day
hour	string	integer	hours of the day (24 hour clock)
mday	string	integer	day of the month
mon	string	integer	month of the year
wday	string	integer	day of the week (Sunday=0)
year	string	integer	year of the century
yday	string	integer	day of the year
dst	string	integer	daylight savings in effect
zone	string	integer	timezone
sday	string	integer	day of the week known
			1 for explicit in date
			0 for implicit (\fIMH\fR figured it out)
			\-1 for unknown (\fIMH\fR couldn't figure it out)
clock	string	integer	seconds since the UNIX epoch
rclock	string	integer	seconds prior to current time
month	string	string	month of the year
lmonth	string	string	month of the year (long form)
tzone	string	string	timezone
day	string	string	day of the week
weekday	string	string	day of the week (long)
tws	string	string	official 822 rendering of the date
pretty	string	string	a more user\-friendly rendering
nodate	string		date wasn't parseable
.re
.fi

When \fIstr\fR is an address, these escapes are useful:
.nf
.ta \w'formataddr  'u +\w'argument  'u +\w'returns  'u
\fIescape\fR	\fIargument\fR	\fIreturns\fR	\fIinterpretation\fR
pers	string	string	the personal name of the address
mbox	string	string	the local part of the address
host	string	string	the domain part of the address
path	string	string	the route part of the address
type	string	integer	the type of host
			\-1 for uucp
			0 for local
			1 for network
			2 for unknown
nohost	string	integer	no host was present in the address
ingrp	string	integer	the address appeared inside a group
gname	string	string	name of the group (present for first
			address only)
note	string	string	commentary text
proper	string	string	official 822 rendering of the address
friendly	string	string	a more user\-friendly rendering
mymbox	string		the address refers to the user's mailbox
formataddr	string		print \fIstr\fR in an address list
.re
.fi

With all this in mind,
here's the default format string for \fIscan\fR.
It's been divided into several pieces for readability.
The first part is:

.ti +.5i
%4(putnumf(msg))%<(cur)+%| %>%<{replied}\-%| %>

which says that the message number should be printed in four digits,
if the message is the current message then a `+' else a space should be
printed,
and if a \*(lqReplied:\*(rq field is present then a `\-' else a space should
be printed.
Next:

.ti +.5i
%02(putnumf(mon{date}))/%02(putnumf(mday{date}))

the hours and minutes are printed in two digits (zero filled).
Next,

.ti +.5i
%<{date} %|*>

If no \*(lqDate:\*(rq field was present,
then a `*' is printed, otherwise a space.
Next,

.ti +.5i
%<(mymbox{from})To:%14(putstrf(friendly{to}))

if the message is from me,
print `To:' followed by a \*(lquser\-friendly\*(rq rendering of the 
first address in the \*(lqTo:\*(rq field.
Continuing,

.ti +.5i
%|%17(putstrf(friendly{from}))%>

if the message isn't from me,
then the print the \*(lqFrom:\*(rq address is printed.
And finally,

.ti +.5i
%{subject}%<{body}<<%{body}%>

the subject and initial body are printed.

Although this seems complicated,
in point of fact,
this method is flexible enough to extract individual fields and print them in
any format the user desires.

If the `\-form\ formatfile' switch is given,
\fIscan\fR will treat each line in the named file as a format string and act
accordingly.
This lets the user employ canned scan listing formats.
Take a look at the three files
/usr/misc/mh/lib/scan.time, /usr/misc/mh/lib/scan.size, and /usr/misc/mh/lib/scan.timely.
.Fi
None
.Pr
None
.Sa
ap(8), dp(8)
.De
None
.Co
None
.Bu
On hosts where \fIMH\fR was configured with the BERK option,
address parsing is not enabled.
.En
