.TH DITROFF 1 
.SH NAME
troff \- text formatting and typesetting
.SH SYNOPSIS
.B ditroff
[ option ] ...
[ file ] ...
.SH DESCRIPTION
.I Ditroff
formats text in the named
.I files
for printing on one of a few printers.
Different output devices are selected through the \-P option.
Output will go to those devices unless one of the
.B \-t
or
.B \-a
options is specified.
.BR 
.IB Troff 's
capabilities are described in the
.I Nroff/Troff user's manual.
.PP
If no
.I file
argument is present, the standard input is read.
An argument consisting of a single minus
.RB ( \- )
is taken to be
a file name corresponding to the standard input.
The options are:
.TP "\w'\f3\-m\f1name 'u"
.BI \-o list
Print only pages whose page numbers appear in
the comma-separated
.I list
of numbers and ranges.
A range
.IB N \- M
means pages
.I N
through
.IR M ;
an initial
.I \-N
means
from the beginning to page
.IR N ;
and a final
.IR N \-
means
from
.I N
to the end.
.TP
.BI \-n N
Number first generated page
.IR N .
.TP
.BI \-m name
Prepend the macro file
.BI /usr/lib/ditmac/tmac. name
to the input
.IR files .
.TP
.BI \-P dest
Prepare output for typesetter
.IR dest .
.B \-Pva
(or
.B \-Pvarian )
= Benson-Varian Raster plotter (default),
.B \-Pvp
(or
.B \-Pversatec )
= Versatec Electrostatic Plotter,
.B \-Pip
(or
.B \-Pimagen )
= Canon/Imagen Laser Printer, 
.B \-Pter
= Line Printer (or terminals if
.B \-t
is specified).
.TP
.B \-I
Prepare the ditroff output for the imagen printer.
.TP
.B \-W
Prepare the ditroff output for the versatec printer.
.TP
.B \-t
Send the ditroff output to standard output.
.TP
.BI \-u N
Set the emboldening factor to
.IR N .
.TP
.BI \-r aN
Set register
.I a
(one character name) to
.IR N .
.TP
.B \-i
Read standard input after the input files are exhausted.
.TP
.B \-q
Invoke the simultaneous input-output mode of the
.B rd
request.
.TP
.B \-a
Send a printable ASCII approximation
of the results to the standard output.
.TP
.BI \-F dir
Use font directory
.I dir
instead of /usr/lib/font.
.SH FILES
.ta \w'/usr/lib/ditmac/tmac.*  'u
.br
/usr/lib/ditmac/tmac.*	standard macro files
.br
/usr/lib/font/dev*	font width tables
.SH BUGS
.PP
The
.B \-F
option is not very useful since the same directory
must be available on the machine that drives the printer.
.SH "SEE ALSO"
trchange(l) for a list of differences, in
.IR ditroff ,
to TROFF commands
.br
J. F. Ossanna,
.I Nroff/Troff user's manual
.br
B. W. Kernighan,
.I
A TROFF Tutorial
.br
eqn(1), grn(1), ideal(1), pic(1), refer(1),
.br
tbl(1), dterm(1), lpr(1), font(1)
