


XDEMO(1)            UNIX Programmer's Manual             XDEMO(1)



NAME
     xdemo - demonstration program for X window system

SYNOPSIS
     xdemo [ options ] demo [ =_g_e_o_m_e_t_r_y ] [ _h_o_s_t:_n_u_m_b_e_r ]

DESCRIPTION
     _X_d_e_m_o is a demonstration program for the X window system.
     By default, the host and display number are extracted from
     the environment variable ``DISPLAY''.  One can, however,
     specify a different display.  _H_o_s_t specifies the host, and
     _n_u_m_b_e_r specifies the number of the display.  For example,
     ``xdemo star orpheus:1'' will put the star demo on display
     one on machine orpheus.  Demo can be any of: balls, bounce,
     circle, circles, colors, cookie, draw, life, lines, menu-
     life, motion, plaid, qix, rgb, shades, slide, star, tetra,
     wallpaper, web, and xor.  The colors, rgb, and shades demos
     will only work on color displays.

     The window is created in the usual way using one of the
     mouse buttons.  Using the center button, depress the button
     to define one corner of the window, move the cursor to where
     the opposite corner of the window should be and release the
     button.  Using the right button, depress the button to
     define the default size window, move the cursor to position
     the window, and release the button.  Using the left button
     for all demos but colors, life, and menulife, click the left
     button to place the default size window in the upper left
     corner of the screen.  Using the left button for the colors,
     life, and menulife demos, depress the button to define the
     default size window, move the cursor to position the window,
     and release the button.

     The window can also be placed, or given a default size, with
     the standard geometry specification:
          =_g_e_o_m_e_t_r_y
     The geometry specification can be used to set the size and
     location of the window.  See _X(_1) for details.

     Most of the demos run without user input: balls, bounce,
     circle, circles, colors, lines, plaid, qix, slide, star,
     tetra, wallpaper, web, and xor.  Most of these have random
     number generators built in, and will produce different
     results each time they are run, or each time the window is
     resized.

MOUSE USAGE
     Mouse usage only applies on the demos draw, life, menulife,
     motion, rgb, and shades.

     In the draw demo, clicking the left button defines points
     that will be connected by a spline when the center button is



Printed 12/6/86         12 December 1985                        1






XDEMO(1)            UNIX Programmer's Manual             XDEMO(1)



     clicked.  If the center button is clicked twice in a row,
     the window is cleared.  Clicking the right button defines
     points to be connected by straight lines when the center
     button is clicked.  Left and right button clicks can be com-
     bined in a single shape.  Clicking any button in one of the
     selection boxes at the upper left selects a drawing mode:
     patterned gray line, solid white line, solid black line,
     dashed white line, dashed black line, filled black, filled
     white, and filled gray.  The drawing function can be
     selected by placing the cursor over the function box at the
     top right and typing a single hexadecimal digit (correspond-
     ing to the characteristic function).  For line drawing, the
     brush height and width can be adjusted by placing the cursor
     over the height or width box and typing a single hexadecimal
     digit.  Text can be put into the picture by positioning the
     mouse and typing.  The color of the text is determined from
     the line/fill color, and the display function is applied.

     The motion demo uses the mouse to define points of a shape
     just as in the draw demo, but moves the line drawing around
     the window, bouncing off the walls, while randomly changing
     the points relative to each other.

     The life demo uses the left button to randomly insert occu-
     pied cells into the window and start the life program ini-
     tially.  Clicking the center button will turn life on and
     off, so you can look at interesting intermediate patterns,
     and the right button is used to clear the `universe'.

     The menulife demo uses the left button to set/clear indivi-
     dual cells while the button is held down.  The right button
     and the space bar can be used to single step the genera-
     tions.  The middle button pops up a pull down menu.  Release
     the middle button on a selection for it to take effect;
     release outside of all selections to abort.  Changing rules
     takes a long time.

     The rgb demo uses button operations in the three boxes at
     the top of the window to change color values.  The left but-
     ton decrements the value, the right button increments the
     value.  If you press the middle button and then move around,
     the vertical position of the mouse controls the value, with
     zero intensity at the top of the box, and full intensity at
     the bottom of the box; releasing the mouse button sets the
     final value.

     The shades demo uses button clicks to change color values.
     A matrix of two primary colors of varying intensity, with a
     third primary of constant intensity is displayed.  The right
     button increments the value of the third primary, the left
     button decrements the value, and the middle button switches
     to a different pair of initial primaries.



Printed 12/6/86         12 December 1985                        2






XDEMO(1)            UNIX Programmer's Manual             XDEMO(1)



OPTIONS
     On color displays, colors can be specified in the command
     line:

          -fg=_c_o_l_o_r      foreground (lines, text, etc.)
          -bg=_c_o_l_o_r      background
          -bd=_c_o_l_o_r      border
          -ms=_c_o_l_o_r      mouse
          -fn=_f_o_n_t       font

     Many demos ignore the foreground color and do random color
     selection.

X DEFAULTS
     For the following defaults, you can also give a demo-
     specific default by prepending the demo name and a separat-
     ing period, e.g., ``Plaid.Foreground''.

     Background
             To determine the background color.

     Border  To determine the border color.

     BorderWidth
             To determine the border width.

     BodyFont
             To determine text font.

     Foreground
             To determine the foreground color.

     Mouse   To determine the mouse cursor color.

     MenuBackground
             To determine the menu background color in menulife.

     MenuForeground
             To determine the menu text color in menulife.

     MenuFont
             To determine menu text font.

     MenuMouse
             To determine the menu mouse cursor color in menu-
             life.

COOKIE
     The cookie monster wants you to give it a ``cookie'', of
     course.





Printed 12/6/86         12 December 1985                        3






XDEMO(1)            UNIX Programmer's Manual             XDEMO(1)



ENVIRONMENT
     DISPLAY   This program gets the display to use by default
     from this variable.

AUTHOR
     Bob Scheifler, MIT Laboratory for Computer Science.  Many of
     the demos are ripoffs: balls, bounce, circle, circles,
     lines, plaid, slide, tetra, wallpaper, and xor were taken
     from Lucasfilm, web was taken from Steve Ward, and qix from
     Symbolics.  Menulife written by Paul Johnson, MIT Laboratory
     for Computer Science.
     Copyright (c) 1985, Massachusetts Institute of Technology

SEE ALSO
     X(1), xterm(1), xwm(1)








































Printed 12/6/86         12 December 1985                        4



