


PSDIT(1)            UNIX Programmer's Manual             PSDIT(1)



NAME
     psdit - convert ditroff intermediate format to POSTSCRIPT
     format

SYNOPSIS
     psdit [ -F_f_o_n_t_d_i_r ] [ -p_p_r_o_l_o_g_u_e ] [ -o_l_i_s_t ] [ _f_i_l_e ]

DESCRIPTION
     _p_s_d_i_t translates a _f_i_l_e created by device-independent
     [_d_i]_t_r_o_f_f(1) to POSTSCRIPT format for printing on a
     POSTSCRIPT printer.  If no _f_i_l_e is mentioned, the standard
     input is used.  The POSTSCRIPT file is sent to the standard
     output.  The options are:

     -F _f_o_n_t_d_i_r
          take font information from _f_o_n_t_d_i_r instead of the
          default (see below).

     -p _p_r_o_l_o_g_u_e
          use the contents of _p_r_o_l_o_g_u_e instead of the default
          POSTSCRIPT prologue (see below).

     -o _l_i_s_t
          prints pages whose numbers are given in the comma-
          separated _l_i_s_t.  The list contains single numbers _N and
          ranges _N_1-_N_2.  A missing _N_1 means the lowest-numbered
          page, a missing _N_2 means the highest.

     Note: the input for _p_s_d_i_t should be prepared with the
     corresponding -Tpsc option of [_d_i]_t_r_o_f_f, _p_i_c, etc.
     _e_q_n should be run with the flags -r576 and -m2 to produce
     suitable output.
     _p_i_c should be run with the -D flag.  With DWB _p_i_c, use -T576
     to set the correct resolution.

     _p_s_d_i_t allows for users to cause _t_r_o_f_f to include arbitrary
     POSTSCRIPT code in the generated POSTSCRIPT file.  _p_s_d_i_t
     recognizes the heretofore undefined ``%'' command in the
     ditroff intermediate file format to signal the start of raw
     POSTSCRIPT to be placed _a_s _i_s in the the output file.
     Everthing between (but not including) the percent sign and a
     line containing a single period (``.'') will be placed in
     the generated POSTSCRIPT output.  This POSTSCRIPT is not
     insulated from the _d_i_t_r_o_f_f coordinate system or the state of
     the generated POSTSCRIPT. However, two functions are defined
     in the prologue so that user's may insulate themselves if
     they so desire.  The PB function (for _p_i_c_t_u_r_e _b_e_g_i_n) will
     perform a POSTSCRIPT save operation, translate the
     POSTSCRIPT coordinate system to _d_i_t_r_o_f_f'_s idea of the
     current position on the page, and change the scale and orie-
     nation of the coordinate system axes to be the standard
     POSTSCRIPT 72 units per inch.  The PE macro (for _p_i_c_t_u_r_e



Printed 1/10/87            12 Nov 1985                          1






PSDIT(1)            UNIX Programmer's Manual             PSDIT(1)



     _e_n_d) will end this protected environment.

     Several methods may be employed to incorporated such
     included POSTSCRIPT into the ditroff intermediate file.  The
     ``.cf'' ``.sy'' and ``\!'' _t_r_o_f_f commands may be useful.
     For example, the following sequence may appear in _t_r_o_f_f
     input:
          (usual troff input)
          \!%PB
          .cf mypic.ps
          \!PE
          \!.
          (more regular troff input)
     to include _m_y_p_i_c._p_s as an illustration.  This facility is
     both powerful and useful, but indiscriminate inclusion of
     badly-behaving POSTSCRIPT code may be dangerous to your
     document's health.

ENVIRONMENT
     PSLIBDIR
          path name of a directory to use instead of
          /usr/misc/lib/ps for psdit prologue.

FILES
     /usr/misc/lib/font/devpsc/*
                           _d_i_t_r_o_f_f default description files for
                           POSTSCRIPT virtual device.

     /usr/misc/lib/ps/psdit.pro
                           default POSTSCRIPT prologue.

SEE ALSO
     psroff(1).
     4.2bsd: ditroff(1), lpr(1).
     System V: troff(1), lp(1).
     _A _T_y_p_e_s_e_t_t_e_r-_i_n_d_e_p_e_n_d_e_n_t _T_R_O_F_F Brian W. Kernighan, Bell
     Laboratories 1982
     _D_o_c_u_m_e_n_t_e_r'_s _W_o_r_k_b_e_n_c_h

AUTHOR
     Adobe Systems Incorporated

BUGS
     The versions of _e_q_n and _p_i_c distributed with ditroff (from
     AT&T) have the device names compiled in (so much for device
     independence!).  They should just read the device descrip-
     tion file for the information they need.  You must be care-
     ful to know which version of _e_q_n you are running or you will
     get undesirable results.
     The B-splines generated by _d_i_t_r_o_f_f are drawn with an approx-
     imation.  The functions D~ and D~~ in the prologue need a
     little work.



Printed 1/10/87            12 Nov 1985                          2






PSDIT(1)            UNIX Programmer's Manual             PSDIT(1)



NOTES
     POSTSCRIPT is a trademark of Adobe Systems Incorporated.
     Documenter's Workbench is a trademark of AT&T Technologies.




















































Printed 1/10/87            12 Nov 1985                          3



