.\" Copyright (c) 1980 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	@(#)ch8.n	6.3 (Berkeley) 4/17/91
.\"
." $Header: ch8.n,v 1.4 83/07/27 15:12:22 layer Exp $
.Lc Functions,\ Fclosures,\ and\ Macros 8
.sh 2 valid\ function\ objects \n(ch 1
.pp
There are many different objects which can occupy the function field of 
a symbol object.
Table 8.1, on the following page,
shows all of the possibilities, how to recognize them,
and where to look for documentation.
.(z
.sp 1v
.TS
box center ;
c | c | c .
informal name	object type	documentation 
=
interpreted	list with \fIcar\fP	8.2
lambda function	\fIeq\fP to lambda
_
interpreted	list with \fIcar\fP	8.2
nlambda function	\fIeq\fP to nlambda
_
interpreted	list with \fIcar\fP	8.2
lexpr function	\fIeq\fP to lexpr
_
interpreted	list with \fIcar\fP	8.3
macro	\fIeq\fP to macro
_
fclosure	vector with \fIvprop\fP	8.4
	\fIeq\fP to fclosure
_
compiled	binary with discipline	8.2
lambda or lexpr	\fIeq\fP to lambda
function
_
compiled	binary with discipline	8.2
nlambda function	\fIeq\fP to nlambda
_
compiled	binary with discipline	8.3
macro	\fIeq\fP to macro
_
foreign	binary with discipline	8.5
subroutine	of \*(lqsubroutine\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
function	of \*(lqfunction\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
integer function	of \*(lqinteger-function\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
real function	of \*(lqreal-function\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
C function	of \*(lqc-function\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
double function	of \*(lqdouble-c-function\*(rq\*[\(dg\*]
_
foreign	binary with discipline	8.5
structure function	of \*(lqvector-c-function\*(rq\*[\(dg\*]
_
array	array object	9
.TE
.tl ''Table 8.1''
.(f
\*[\(dg\*]Only the first character of the string is significant (i.e \*(lqs\*(rq
is ok for \*(lqsubroutine\*(rq)
.)f
.)z
.br
.sh 2 functions
.pp
The basic Lisp function is the lambda function.
When a lambda function is called, the actual arguments are
evaluated from left to right and are lambda-bound to the
formal parameters of the lambda function.
.pp
An nlambda function is usually used for functions which are invoked
by the user at top level.
Some built-in functions which evaluate their arguments in special ways are
also nlambdas (e.g \fIcond\fP, \fIdo\fP, \fIor\fP).
When an nlambda function is called, the list of unevaluated arguments
is lambda bound to the single formal parameter of the nlambda function.
.pp
Some programmers will use an nlambda function 
when they are not sure how many arguments
will be passed.
Then, the first thing the nlambda function does is map \fIeval\fP over
the list of unevaluated arguments it has been passed.
This is usually the wrong thing to do, as it will not work compiled if
any of the arguments are local variables. 
The solution is to use a lexpr.
When a lexpr function is called, the arguments
are evaluated and a fixnum whose value is
the number of arguments is lambda-bound to the single
formal parameter of the lexpr function.
The lexpr can then access the arguments using the \fIarg\fP function.
.pp
When a function is compiled,
.i special 
declarations may be needed to 
preserve its behavior.
An argument is not lambda-bound to the name of
the corresponding formal parameter 
unless that formal parameter has been declared 
.i special 
(see \(sc12.3.2.2).
.pp
Lambda and lexpr functions both compile into a binary object with
a discipline of lambda.
However, a compiled lexpr still acts like an interpreted lexpr.
.sh 2 macros
.pp
An important feature of Lisp 
is its ability to manipulate programs as data.
As a result of this, most Lisp implementations
have very powerful macro facilities.
The Lisp language's macro facility
can be used to incorporate popular features of the other
languages into Lisp.
For example, there are macro packages 
which allow one to create records (ala Pascal) 
and refer to elements of those records by the field names.
The 
.i struct
package imported from Maclisp does this.
Another popular use for macros is to create more readable control 
structures which expand into 
.i cond , 
.i or 
and 
.i and .
One such example is the If macro.
It allows you to write
.sp 1v
.nf
.ft I
(If (equal numb 0) then (print 'zero) (terpr)
\ elseif (equal numb 1) then (print 'one) (terpr)
\ else (print '|I give up|))
.ft P
.sp 1v
which expands to 
.sp 1v
.ft I
(cond 
\ \ \ \ ((equal numb 0) (print 'zero) (terpr))
\ \ \ \ ((equal numb 1) (print 'one) (terpr))
\ \ \ \ (t (print '|I give up|)))
.ft P
.sp 1v
.fi
.sh 3  macro\ forms
.pp
A macro is a function which accepts a Lisp expression as input and returns
another Lisp expression.
The action the macro takes is called macro expansion.
Here is a simple example:
.sp 1v
.nf
\-> \fI(def first (macro (x) (cons 'car (cdr x))))\fP
first
\-> \fI(first '(a b c))\fP
a
\-> \fI(apply 'first '(first '(a b c)))\fP
(car '(a b c))
.fi
.sp 1v
The first input line defines a macro called 
.i first .
Notice that the macro has one formal parameter, \fIx\fP.  
On the second input line, we ask the interpreter to evaluate
\fI(first\ '(a\ b\ c))\fP.
.i Eval 
sees that 
.i first
has a function definition of type macro, so it evaluates 
.i first 's 
definition,
passing to 
.i first ,
as an argument, the form 
.i eval 
itself
was trying to
evaluate: \fI(first\ '(a\ b\ c))\fP.
The 
.i first 
macro chops off the car of the argument with
.i cdr ,
cons' a 
.i car
at the beginning of the list and returns \fI(car\ '(a\ b\ c))\fP,
which
.i eval 
evaluates.
The value
.i a
is returned as the value of \fI(first\ '(a\ b\ c))\fP.
Thus whenever 
.i eval
tries to evaluate a list whose car has a macro definition
it ends up doing (at least) two operations, the first of which
is a call to the macro
to let it macro expand the form, and the other is the evaluation of the
result of the macro.
The result of the macro may be yet another call to a macro, so 
.i eval
may have to do even more evaluations until it can finally determine
the  value of an expression.
One way to see how a macro will expand is to use
.i apply
as shown on the third input line above.
.sh +0 defmacro
.pp
The macro 
.i defmacro
makes it easier to define macros because it allows you to name the arguments
to the macro call.
For example, suppose we find ourselves often writing code like
\fI(setq\ stack\ (cons\ newelt\ stack)\fP.
We could define a macro named \fIpush\fP to do this for us.
One way to define it is:
.nf
.sp 1v
\-> \fI(de\kAf push 
\h'|\nAu'(macro (x) (list 'setq (caddr x) (list 'cons (cadr x) (caddr x)))))\fP
push
.fi
.sp 1v
then \fI(push\ newelt\ stack)\fP will expand to the form mentioned above.
The same macro written using defmacro would be:
.nf
.sp 1v
\->\fI\kA (defmacro push (value stack)
  \h'|\nAu'(list 'setq ,stack (list 'cons ,value ,stack)))\fP
push
.fi
.sp 1v
Defmacro allows you to name the arguments of the macro call, and makes the 
macro definition look more like a function definition.
.sh +0 the\ backquote\ character\ macro
.pp
The default syntax for 
.Fr
has four characters with associated character macros.
One is semicolon for comments.
Two others are the backquote and comma which are
used by the backquote character
macro.
The fourth is the sharp sign macro described in the next section.
.pp
The backquote macro is used to create lists where many of the elements are
fixed (quoted). 
This makes it very useful for creating macro definitions.
In the simplest case, a backquote acts just like a single quote:
.sp 1v
.nf
\->\fI`(a b c d e)\fP
(a b c d e)
.fi
.sp 1v
If a comma precedes an element of a backquoted list then that element is
evaluated and its value is put in the list.
.sp 1v
.nf
\->\fI(setq d '(x y z))\fP
(x y z)
\->\fI`(a b c ,d e)\fP
(a b c (x y z) e)
.fi
.sp 1v
If a comma followed by an at sign precedes an element in a backquoted list,
then that element is evaluated and spliced into the list with 
.i append .
.nf
.sp 1v
\->\fI`(a b c ,@d e)\fP
(a b c x y z e)
.sp 1v
.fi
Once a list begins with a backquote, the commas may appear anywhere in the
list as this example shows:
.nf
.sp 1v
\->\fI`(a b (c d ,(cdr d)) (e f (g h ,@(cddr d) ,@d)))\fP
(a b (c d (y z)) (e f (g h z x y z)))
.sp 1v
.fi
It is also possible and sometimes even useful to use the 
backquote macro within itself.
As a final demonstration of the backquote macro, we shall define the 
first and push macros using all the power at our disposal: defmacro
and the backquote macro.
.sp 1v
.nf
\->\fI(defmacro first (list) `(car ,list))\fP
first
\->\fI(defmacro push (value stack) `(setq ,stack (cons ,value ,stack)))\fP
stack
.fi
.sh +0 sharp\ sign\ character\ macro
.pp
The sharp sign macro can perform a number of
different functions  at read time.
The character directly following the sharp sign determines which function
will be done, and following Lisp s-expressions may serve as arguments.
.sh +1 conditional\ inclusion
.lp
If you plan to run one source file in more than one environment then 
you may want to some pieces of code to be included  or not included
depending on the environment.  
The C language uses \*(lq#ifdef\*(lq and \*(lq#ifndef\*(rq for this 
purpose, and Lisp uses \*(lq#+\*(rq and \*(lq#\-\*(rq.
The environment that the sharp sign macro checks is the 
\fI(status\ features)\fP list which is initialized when the Lisp
system is built  and which may be  altered by 
\fI(sstatus\ feature\ foo)\fP and \fI(sstatus\ nofeature\ bar)\fP
The form  of conditional inclusion is
.br
.tl ''\fI#+when what\fP''
where 
.i when 
is either a symbol or an expression involving symbols and the functions
.i and ,
.i or ,
and
.i not .
The meaning is that 
.i what
will only be read in if  
.i when
is true.
A symbol in 
.i when
is true only if it appears in the 
.i (status\ features)
list.
.Eb
; suppose we want to write a program which references a file
; and which can run at ucb, ucsd and cmu where the file naming conventions
; are different.
;
\-> \fI(de\kAfun howold (name)
   \h'|\nAu'\kC(terpr)
   \h'|\nCu'\kB(load #\kA+(or ucb ucsd) "/usr/lib/lisp/ages.l"
          \h'|\nAu'#+cmu "/usr/lisp/doc/ages.l")
   \h'|\nBu'\kA(patom name)
   \h'|\nBu'\kA(patom " is ")
   \h'|\nAu'\kB(print (cdr (assoc name agefile)))
   \h'|\nBu'\kA(patom "years old")
   \h'|\nAu'(terpr))\fP
.Ee
The form
.br
.tl ''\fI#\-when what\fP''
is equivalent to
.br
.tl ''\fI#+(not when) what\fP''
.sh +0 fixnum\ character\ equivalents
.lp
When working with fixnum equivalents of characters, it is often hard to
remember the number corresponding to a character.
The form
.br
.tl ''\fI#/c\fP''
is equivalent to the fixnum representation of character c.
.Eb
; a function which returns t if the user types y else it returns nil.
;
\-> \fI(de\kBfun yesorno nil
   \h'|\nBu'(progn \kA(ans)
          \h'|\nAu'\kB(setq ans (tyi))
          \h'|\nBu'(cond \kA((equal ans #/y) t)
                \h'|\nAu'(t nil))))\fP
.Ee
.sh +0 read\ time\ evaluation
.lp
Occasionally you want to express a constant as a Lisp expression, yet you
don't want to pay the penalty of evaluating this expression each time it
is referenced.
The form
.br
.tl ''\fI#.expression\fP''
evaluates the expression at read time and returns its value.
.Eb
; a function to test if any of bits 1 3 or 12 are set in a fixnum.
;
\-> \fI(de\kCfun testit (num)
   \h'|\nCu'(cond \kA(\kB(zerop (boole 1 num #.(+ (lsh 1 1) (lsh 1 3) (lsh 1 12))))
          \h'|\nBu'nil)
         \h'|\nAu'(t t)))\fP
.Ee
.sh 2 fclosures
.pp
Fclosures are a type of functional object.
The purpose is to remember the values of some variables 
between invocations of the functional object and to protect this
data from being inadvertently overwritten by other Lisp functions.
Fortran programs usually exhibit this behavior for their variables.
(In fact, some versions of Fortran would require the
variables to be in COMMON).
Thus it is easy to write a linear congruent random number generator
in Fortran, merely by keeping the seed as a variable in the function.
It is much more risky to do so in Lisp, since any special variable you
picked, might be used by some other function.
Fclosures are an attempt to provide most of the same functionality as
closures in Lisp Machine Lisp, to users of
.Fr .
Fclosures are related to closures in this way:
.br
(fclosure '(a b) 'foo) <==>
.br
	(let ((a a) (b b)) (closure '(a b) 'foo))
.sh 3 an\ example
.sp 1v
.in 0
.nf
.sz -2
.hl
% \fBlisp\fP
Franz Lisp, Opus 38.60
\->\fB(defun code (me count)
  (print (list 'in x))
  (setq x (+ 1 x))
  (cond ((greaterp count 1) (funcall me me (sub1 count))))
  (print (list 'out x)))\fP
code
\->\fB(defun tester (object count)
  (funcall object object count) (terpri))\fP
tester
\->\fB(setq x 0)\fP
0
\->\fB(setq z (fclosure '(x) 'code))\fP
fclosure[8]
\->\fB (tester z 3)\fP
(in 0)(in 1)(in 2)(out 3)(out 3)(out 3)
nil
\->\fBx\fP
0
.hl
.fi
.sz +2
.sp 3v
.pp
The function \fIfclosure\fP creates a new object
that we will call an fclosure,
(although it is actually a vector).
The fclosure contains a functional object, and a set of symbols and
values for the symbols.  In the above example, the fclosure functional
object is the function code.
The set of symbols and values just contains the symbol `x' and
zero, the value of `x' when the fclosure was created.
.lp
When an fclosure is funcall'ed:
.ip 1)
The Lisp system lambda binds the symbols in the fclosure to their values in the fclosure.
.ip 2)
It continues the funcall on the functional object of the fclosure.
.ip 3)
Finally, it un-lambda binds the symbols in the fclosure and at the
same time stores the current values of the symbols in the fclosure.
.sp 1v
.pp
Notice that the fclosure is saving the value of the symbol `x'.
Each time a fclosure is created, new space is allocated for saving
the values of the symbols. Thus if we execute fclosure again, over
the same function, we can have two independent counters:
.sp 1v
.in 0
.nf
.sz -2
.hl
\-> \fB(setq zz (fclosure '(x) 'code))\fP
fclosure[1]
\-> \fB(tester zz 2)\fP
(in 0)(in 1)(out 2)(out 2)
\-> \fB(tester zz 2)\fP
(in 2)(in 3)(out 4)(out 4)
\-> \fB(tester z 3)\fP
(in 3)(in 4)(in 5)(out 6)(out 6)(out 6)
.hl
.fi
.sz +2
.sp 3v
.sh 3 useful\ functions
.pp
Here are some quick some summaries of functions dealing with closures.
They are more formally defined in \(sc2.8.4.
To recap, fclosures are made by
\fI(fclosure 'l_vars 'g_funcobj)\fP.
l_vars is a list of symbols (not containing nil),
g_funcobj is any object that can be funcalled.
(Objects which can be funcalled, include compiled Lisp functions,
lambda expressions, symbols, foreign functions, etc.)
In general, if you want a compiled function to be closed over a
variable, you must declare the variable to be special within the function.
Another example would be:
.(l
	(fclosure '(a b) #'(lambda (x) (plus x a)))
.)l
Here, the #' construction will make the compiler compile the lambda expression.
.pp
There are times when you want to share variables between fclosures.
This can be done if the fclosures are created at the same time using
\fIfclosure-list\fP.
The function \fIfclosure-alist\fP returns an assoc list giving
the symbols and values in the fclosure.  The predicate
\fIfclosurep\fP returns t iff its argument is a fclosure.
Other functions imported from Lisp Machine Lisp are
.i symeval-in-fclosure,
.i let-fclosed,
and
.i set-in-fclosure.
Lastly, the function \fIfclosure-function\fP returns the function argument.
.sh 3 internal\ structure
.pp
Currently, closures are implemented as vectors, with property being the
symbol fclosure.  The functional object is the first entry.
The remaining entries are structures which point to the symbols
and values for the closure, (with a reference count to determine
if a recursive closure is active).
.sh 2 foreign\ subroutines\ and\ functions
.pp
.Fr 
has the ability to dynamically load object files produced by other compilers
and to call functions defined in those files.
These functions are called 
.i foreign
functions.*
.(f
*This topic is also discussed in Report PAM-124 of the Center for
Pure and Applied Mathematics, UCB, entitled ``Parlez-Vous Franz?
An Informal Introduction to Interfacing Foreign Functions to Franz LISP'',
by James R. Larus
.)f
There are seven types of foreign functions.
They are characterized by
the type of result they return, and by differences in the interpretation
of their arguments.
They come from two families: a group suited for languages which pass
arguments by reference (e.g. Fortran), and a group suited for languages
which pass arguments by value (e.g. C).
.sp 1v
.lp
There are four types in the first group:
.ip \fBsubroutine\fP
This does not return anything. 
The Lisp system
always returns t after calling a subroutine.
.ip \fBfunction\fP
This returns whatever the function returns.
This must be a valid Lisp object or it may cause the Lisp system to fail.
.ip \fBinteger-function\fP
This returns an integer which the Lisp system makes into a fixnum and returns.
.ip \fBreal-function\fP
This returns a double precision real number which the Lisp
system makes into a flonum and returns.
.sp 1v
.lp
There are three types in the second group:
.ip \fBc-function\fP
This is like an integer function, except for its different interpretation
of arguments.
.ip \fBdouble-c-function\fP
This is like a real-function.
.ip \fBvector-c-function\fP
This is for C functions which return a structure.
The first argument to such functions must be a vector (of type vectori),
into which the result is stored.
The second Lisp argument
becomes the first argument to the C function, and so on
.lp
A foreign function is accessed through a binary object just like a 
compiled Lisp function.
The difference is that the discipline field of a binary object
for a foreign function is a string 
whose first character is given in the following table:
.(b
.TS
box center ;
c | c .
letter	type
=
s	subroutine
_
f	function
_
i	integer-function
_
r	real-function.
_
c	c-function
_
v	vector-c-function
_
d	double-c-function
_
.TE
.)b
Two functions are provided for setting-up foreign functions.
.i Cfasl
loads an object file into the Lisp system and sets up one foreign
function binary object.
If there are more than one function in an object file, 
.i getaddress
can be used to set up additional foreign function objects.
.pp
Foreign  functions are called just like other functions, e.g 
\fI(funname\ arg1\ arg2)\fP.
When a function in the Fortran group is called,
the arguments are evaluated and then examined.
List, hunk and symbol arguments are passed unchanged to 
the foreign function.
Fixnum and flonum arguments are copied into a temporary location and
a pointer to the value is passed (this is because Fortran uses call
by reference and it is dangerous to modify the contents of a fixnum
or flonum which something else might point to).
If the argument is an array object,
the data field of the array object is
passed to the foreign function
(This is the easiest way to send large
amounts of data to and receive large amounts of data from a foreign
function).
If a binary object is an argument, the entry field of that object is
passed to the foreign function (the entry field is the address of a function,
so this amounts to passing a function as an argument).
.pp
When a function in the C group is called,
fixnum and flownum arguments are passed by value.
For almost all other arguments,
the address is merely provided to the C routine.
The only exception arises when you want to invoke a C routine
which expects a ``structure'' argument.  Recall that a (rarely used)
feature of the C language is the ability to pass structures by value.
This copies the structure onto the stack.  Since the Franz's nearest
equivalent to a C structure is a vector, we provide an escape clause
to copy the contents of an immediate-type vector by value.  If the
property field of a vectori argument, is the symbol
\*(lqvalue-structure-argument\*(rq,
then the binary data of this immediate-type vector is copied
into the argument list of the C routine.
.pp
The method a foreign function uses to access the arguments provided 
by Lisp is dependent on the language of the foreign function.
The following scripts demonstrate how how Lisp can interact with three
languages: C, Pascal and Fortran.
C and Pascal have pointer types and the first script shows how to use
pointers to extract information from Lisp objects.
There are two functions defined for each language.
The first (cfoo in C, pfoo in Pascal) is given four arguments, a 
fixnum, a flonum-block array, a hunk of at least two
fixnums and a list of 
at least two fixnums.
To demonstrate that the values were passed, each ?foo function prints
its arguments (or parts of them).
The ?foo function then modifies the second element of 
the flonum-block array and returns a 3 to Lisp.
The second function (cmemq in C, pmemq in Pascal) acts just like the
Lisp
.i memq
function (except it won't work for fixnums whereas the lisp 
.i memq
will work for small fixnums).
In the script, typed input is in 
.b bold ,
computer output is in roman
and comments are in
.i italic.
.in 0
.nf
.sp 2v
.sz -2
.hl
\fIThese are the C coded functions  \fP
% \fBcat ch8auxc.c\fP
/* demonstration of c coded foreign integer-function */

/* the following will be used to extract fixnums out of a list of fixnums */
struct listoffixnumscell
{    struct listoffixnumscell *cdr;
     int *fixnum;
};

struct listcell
{	struct listcell *cdr;
	int car;
};

cfoo(a,b,c,d)
int *a;
double b[];
int *c[];
struct listoffixnumscell *d;
{
    printf("a: %d, b[0]: %f, b[1]: %f\n", *a, b[0], b[1]);
    printf(" c (first): %d   c (second): %d\n",
	       *c[0],*c[1]);
    printf(" ( %d %d ... )\n ", *(d->fixnum), *(d->cdr->fixnum));
    b[1] = 3.1415926;
    return(3);
}

struct listcell *
cmemq(element,list)
int element;
struct listcell *list;
{   
   for( ; list && element != list->car ;  list = list->cdr);
   return(list);
}
.sp 2v
\fIThese are the Pascal coded functions \fP
% \fBcat ch8auxp.p\fP
type 	pinteger = ^integer;
	realarray = array[0..10] of real;
	pintarray = array[0..10] of pinteger;
	listoffixnumscell = record  
				cdr  : ^listoffixnumscell;
				fixnum : pinteger;
			    end;
	plistcell = ^listcell;
	listcell = record
		      cdr : plistcell;
		      car : integer;
		   end;

function pfoo ( var a : integer ; 
		var b : realarray;
		var c : pintarray;
		var d : listoffixnumscell) : integer;
begin
   writeln(' a:',a, ' b[0]:', b[0], ' b[1]:', b[1]);
   writeln(' c (first):', c[0]^,' c (second):', c[1]^);
   writeln(' ( ', d.fixnum^, d.cdr^.fixnum^, ' ...) ');
   b[1] := 3.1415926;
   pfoo := 3
end ;

{ the function pmemq looks for the Lisp pointer given as the first argument
  in the list pointed to by the second argument.
  Note that we declare " a : integer " instead of " var a : integer " since
  we are interested in the pointer value instead of what it points to (which
  could be any Lisp object)
}
function pmemq( a : integer; list : plistcell) : plistcell;
begin
 while (list <> nil) and (list^.car <> a) do list := list^.cdr;
 pmemq := list;
end ;
.sp 2v
\fIThe files are compiled\fP
% \fBcc -c ch8auxc.c\fP
1.0u 1.2s 0:15 14% 30+39k 33+20io 147pf+0w
% \fBpc -c ch8auxp.p\fP
3.0u 1.7s 0:37 12% 27+32k 53+32io 143pf+0w
.sp 2v
% \fBlisp\fP
Franz Lisp, Opus 38.60
.ft I
.fi
First the files are loaded and we set up one foreign function binary.
We have two functions in each file so we must choose one to tell cfasl about.
The choice is arbitrary.
.ft P
.br 
.nf
\->\fB (cfasl 'ch8auxc.o '_cfoo 'cfoo "integer-function")\fP
/usr/lib/lisp/nld -N -A /usr/local/lisp -T 63000 ch8auxc.o -e _cfoo -o /tmp/Li7055.0  -lc
#63000-"integer-function"
\->\fB (cfasl 'ch8auxp.o '_pfoo 'pfoo "integer-function" "-lpc")\fP
/usr/lib/lisp/nld -N -A /tmp/Li7055.0 -T 63200 ch8auxp.o -e _pfoo -o /tmp/Li7055.1 -lpc -lc
#63200-"integer-function"
.ft I
Here we set up the other foreign function binary objects
.ft P
\->\fB (getaddress '_cmemq 'cmemq "function" '_pmemq 'pmemq "function")\fP
#6306c-"function"
.ft I
.fi
We want to create and initialize an array to pass to the cfoo function.
In this case we create an unnamed array and store it in the value cell of
testarr. 
When we create an array to pass to the Pascal program we will use a named
array just to demonstrate the different way that named and unnamed arrays
are created and accessed.
.br
.nf
.ft P
\->\fB (setq testarr (array nil flonum-block 2))\fP
array[2]
\->\fB (store (funcall testarr 0) 1.234)\fP
1.234
\->\fB (store (funcall testarr 1) 5.678)\fP
5.678
\->\fB (cfoo 385 testarr (hunk 10 11 13 14) '(15 16 17))\fP
a: 385, b[0]: 1.234000, b[1]: 5.678000
 c (first): 10   c (second): 11
 ( 15 16 ... )
 3
.ft I
.fi
Note that cfoo has returned 3 as it should.
It also had the side effect of changing the second value of the array to
3.1415926  which check next.
.br
.nf
.ft P
\->\fB (funcall testarr 1)\fP
3.1415926
.sp 2v
.fi
.ft I
In preparation for calling pfoo we create an array.
.ft P
.nf
\->\fB (array test flonum-block 2)\fP
array[2]
\->\fB (store (test 0) 1.234)\fP
1.234
\->\fB (store (test 1) 5.678)\fP
5.678
\->\fB (pfoo 385 (getd 'test) (hunk 10 11 13 14) '(15 16 17))\fP
 a:       385 b[0]:  1.23400000000000E+00 b[1]:  5.67800000000000E+00
 c (first):        10 c (second):        11
 (         15        16 ...) 
3
\->\fB (test 1)\fP
3.1415926
.sp 1v
\fI Now to test out the memq's
\-> \fB(cmemq 'a '(b c a d e f))\fP
(a d e f)
\-> \fB(pmemq 'e '(a d f g a x))\fP
nil
.hl
.fi
.sz +2
.sp 3v
.pp
The Fortran example will be much shorter since in Fortran 
you can't follow pointers
as you can in other languages.
The Fortran function ffoo is given three arguments: a fixnum, a 
fixnum-block array and a flonum.
These arguments are printed out to verify that they made it and
then the first value of the array is modified.
The function returns a double precision value which is converted to a flonum
by lisp and printed.
Note that the entry point corresponding to the Fortran function ffoo is
_ffoo_ as opposed to the C and Pascal convention of preceding the name with
an underscore.
.sp 1v
.in 0
.nf
.sz -2
.hl

% \fBcat ch8auxf.f\fP
	double precision function ffoo(a,b,c)
	integer a,b(10)
	double precision c
	print 2,a,b(1),b(2),c
2	format(' a=',i4,', b(1)=',i5,', b(2)=',i5,' c=',f6.4)
	b(1) = 22
	ffoo = 1.23456
	return
	end
% \fBf77 -c ch8auxf.f\fP
ch8auxf.f:
   ffoo:
0.9u 1.8s 0:12 22% 20+22k 54+48io 158pf+0w
% \fBlisp\fP
Franz Lisp, Opus 38.60
\-> \fB(cfasl 'ch8auxf.o '_ffoo_ 'ffoo "real-function" "-lF77 -lI77")\fP
/usr/lib/lisp/nld -N -A /usr/local/lisp -T 63000 ch8auxf.o -e _ffoo_ 
-o /tmp/Li11066.0 -lF77 -lI77 -lc
#6307c-"real-function"
.sp 1v
\-> \fB(array test fixnum-block 2)\fP
array[2]
\->\fB (store (test 0) 10)\fP
10
\-> \fB(store (test 1) 11)\fP
11
\-> \fB(ffoo 385 (getd 'test) 5.678)\fP
 a= 385, b(1)=   10, b(2)=   11 c=5.6780
1.234559893608093
\-> \fB(test 0)\fP
22

.hl
