/*
 * Configuration information for use by NNTP server and support
 * programs.  Change these as appropriate for your system.
 */

/*
 * Compile time options.
 */

#undef	ALONE		/* True if we're running without inetd */
#undef	FASTFORK	/* True if we don't want to read active file on start */
#undef	BSD_42		/* 4.2 compatability code -- if this is defined, */
			/* DBM probably wants to be defined as well. */
#undef	DBM		/* True if we want to use the old dbm(3x) libraries */
			/* IF YOU DEFINE THIS, change CFLAGS in makefile to */
			/* be -ldbm */

/*
 * If you DON'T have vfork, make this "#define vfork fork"
 * vfork will speed up article transfer nntpds by about 2.5 times.
 */

#undef	vfork


/*
 * If you have the syslog library routine, define SYSLOG to
 * be thef syslog facility name under which stats should be
 * logged.  Newer 4.3 systems might choose LOG_NEWS;
 * LOG_LOCAL7 is an acceptable substitute.
 *
 * If you don't have support for syslog, #undef it.
 * Obviously, this means that you can't define LOG, either.
 */

#define	SYSLOG	LOG_NEWS

#ifdef SYSLOG		/* Define LOG if you want copious logging info */
#	define LOG	/* undef it if you don't */
#endif			/* but you can only have LOG if you have SYSLOG */

#ifdef BSD_42		/* This is a logical, warranted assumption */
#   ifndef DBM		/* which will probably get me in trouble. */
#	define DBM	/* Kill it if you have 4.2 *and* ndbm.  */
#   endif
#endif

#undef	IHAVE_DEBUG	/* Copious debugging output from ihave */

#define	XHDR		/* Optional XHDR command.  Defining this will */
			/* speed up '=' command in rn, but will load */
			/* the server more.  If your server is heavily */
			/* loaded already, defining this may be a bad idea */

#define	SUBNET		/* If you have 4.3 subnetting */
#undef	DAMAGED_NETMASK	/* If your subnet mask is not a multiple of */
			/* four bits (e.g., UCSD) */
#undef	DECNET		/* If you want decnet support */

#define	GHNAME		/* Define if you have gethostname() */
#undef	UUNAME		/* Define to use /etc/uucpname */
			/* If neither of these are defined, */
			/* inews will use the contents of */
			/* /usr/include/whoami.h */

/*
 * How long you want nntp servers to hang out without receiving
 * commands before they close the connection with an error message.
 *
 * You CANNOT have TIMEOUT while running in standalone (ALONE) mode,
 * as SIGALRM is used for different things.
 *
 * If you don't want any timeout, #undef it, i.e.,
 *
 *	#undef	TIMEOUT
 *
 * TIMEOUT should be at least two hours, which allows users some time
 * away from their terminal (e.g., at lunch) while reading news.
 */

#ifndef ALONE
#    define	TIMEOUT	(2 * 3600)
#endif ALONE

/*
 * How long you want nntp servers to wait without receiving data
 * during article transfers.  You CANNOT have XFER_TIMEOUT while
 * running in standalond (ALONE) mode.
 *
 * If you don't want any transfer timeouts, #undef it, as above.
 */

#ifndef ALONE
#   define	XFER_TIMEOUT	(30 * 60)
#endif ALONE

/*
 * Your domain.  This is for the inews generated From: line,
 * assuming that it doesn't find one in the article's head.
 * Suggestions are .UUCP if you don't belong to the Internet.
 * If your hostname returns the fully-qualified domain name
 * as some 4.3 BSD systems do, simply undefine DOMAIN.
 *
 * e.g.  #define	DOMAIN		"berkeley.edu"
 */

#define	DOMAIN	"uucp"

/*
 * A file containing the name of the host which is running
 * the news server.  This will have to match what rrn thinks,
 * too.
 */

#define	SERVER_FILE	"/usr/local/lib/rn/server"

/*
 * Person (user name) to post news as.
 */

#define	POSTER		"news"

/*
 * These files are generated by the support programs, and are needed
 * by the NNTP server.  Make sure that whatever directory you
 * decide these files should go is writable by whatever uid you
 * have the sypport programs run under.
 */

#define STAT_FILE	"/usr/lib/news/mgdstats"
#define NGDATE_FILE	"/usr/lib/news/groupdates"

/*
 * Some commonly used programs and files.
 */

#define	ACTIVE_FILE	"/usr/lib/news/active"
#define ACCESS_FILE	"/usr/lib/news/nntp_access"
#define HISTORY_FILE	"/usr/lib/news/history"
#define	SPOOLDIR	"/usr/spool/news"
#define INEWS		"/usr/lib/news/inews"
#define RNEWS		"/usr/bin/rnews"		/* Link to inews? */

/*
 * Some miscellaneous stuff
 */

#define	MAX_ARTICLES	4096		/* Maximum number of articles/group */
#define READINTVL	60 * 10		/* 10 minutes b/n chking active file */
