.TH FORW 1 "3 August 1983"
.UC 4
.SH NAME
forw \- forward messages
.SH SYNOPSIS
.B forw
[ +folder ] [ msgs ] [ \-editor editor ] [ \-form formfile ]
[ \-annotate ] [ \-noannotate ]
[ \-inplace ]  [ \-noinplace ] [ \-help ]
.SH DESCRIPTION
\fIForw\fR may be used to prepare a message containing other
messages.
It constructs the new message from the components file
or `\-form formfile' (see
.IR comp (1)),
with a body composed of the message(s) to be forwarded.
An editor is invoked as in \fIcomp\fR,
and after editing is complete, the user is prompted before the message
is sent.
.PP
If the `\-annotate' switch is given, each message being
forwarded will be annotated with the lines
.nf

     Forwarded: \*(<<date\*(>>
     Forwarded: To: names
     Forwarded: cc: names

.fi
where each \*(lqTo:\*(rq and \*(lqcc:\*(rq list contains as many lines as required.
This annotation will be done only if the message is sent directly
from \fIforw\fR.
If the message is not sent immediately from \fIforw\fR,
\*(lqcomp \-use\*(rq may be used in a later session to re-edit and send
the constructed message, but the annotations won't take place.
The `\-inplace' switch permits annotating a message in place in
order to preserve its links.
.PP
See \fIcomp\fR for a description of the `\-editor' switch.
.SH FILES
.nf
.ta \w'or <mh-dir>/components    'u
/etc/mh/components	The message skeleton
or <mh-dir>/components	Rather than the standard skeleton
$HOME/\*.mh\(ruprofile	The user profile
<mh-dir>/draft	The default message file
/usr/bin/send	To send the composed message
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'<lasteditor>\-next:    'u
Path:	To determine the user's MH directory
Editor:	To override the use of /bin/ned as the default editor
Current-Folder:	To find the default current folder
<lasteditor>\-next:	editor to be used after exit from <lasteditor>
.fi
.SH DEFAULTS
.nf
`+folder' defaults to the current folder
`msgs' defaults to cur
`\-editor' defaults to /bin/ned
`\-noannotate'
`\-noinplace'
.fi
.SH CONTEXT
If a +folder is specified, it will become
the current folder, and the current message will be set to
the first message being forwarded.
