.TH MKPROJECT 1P "22 June 1983"
.UC 4
.SH NAME
mkproject \- make a project root directory
.SH SYNOPSIS
.B mkproject
[{+\^\-}\fBd\fR]
[{+\^\-}\fBN\fR alias]
[{+\^\-}\fBT\fR type[,type ...]]
projectname ...
.SH DESCRIPTION
.I Mkproject
creates a directory called
.I projectname.
The directory is known as a
.I project root directory
and is the focus for a project.
Standard entries, `.', for the directory itself, `..', for its parent,
and `...' for the project link directory, are made automatically.
After the directory has been created,
.I mkproject
prompts the user for a line describing the purpose of the project.
.PP
If the name of the directory conflicts with an existing project,
an alternative alias for the project may be specified via the
.B \-N
option. However, even if this option is used, the name of the directory
will be recognized as a project unless it is disguised as a regular
pathname. For example, to create another project called `spms'
with alias `newspms', type:
.PP
		mkproject  \-N newspms  ./spms
.PP
.I Mkproject
may also be used to convert an existing regular directory to a
project root directory.
.PP
.I Mkproject
requires write permission in the parent directory.
.SH OPTIONS
.IP "\fB+d\fR"
Change the description of an existing project.
.IP "\fB\-d\fR"
Turn
.B off
prompting for the description of a new project.
.IP "\fB\+N\fI alias\fR"
Change the alias of the project.
.IP "\fB\-N\fI alias\fR"
Specify an alternative alias for a new project.
.IP "\fB\+T\fI type\fR"
Add a type label to an existing project root directory. If the type label
already exists but has a different priority, then it must be removed using
the
.I rmproject
command.
.IP "\fB\-T\fI type\fR"
Specify a type label for a new project root directory.
.SH FILES
.ta \w'..._temp'u+.5i
\&...	Project link directory.
.br
\&..._temp	Temporary project link directory.
.DT
.SH LIMITATIONS
Project descriptions can be no longer than 128 characters.
.SH "SEE ALSO"
mkdir(1), rmproject(1P)
.SH DIAGNOSTICS
The error message, ``mkproject: \fIproject\fR/... temporarily unavailable'',
indicates that a `..._temp' temporary project link directory exists. This could
be because another user is altering the project link directory, or because a
system crash terminated
.I mkproject
prematurely. If the latter case, then removing the temporary file will fix
the problem.
.PP
Exit status 0 is normal. Exit status 1 indicates an error.
.SH AUTHOR
Peter J. Nicklin
.SH BUGS
The root project, `^', cannot have an alternative alias.
.PP
Directory aliases must not include the characters `:' or `|'.
.PP
Type labels must not include the characters `:' or `/'.
