.TH PICK 1 "3 August 1983"
.UC 4
.SH NAME
pick \- select messages by content
.SH SYNOPSIS
.fc ^ ~
.ta .4i 1.8i
.nf
.in .5i
^pick~^^\0\-cc~^ \%[\-src\ +folder] \%[msgs] \%[\-help] \%[\-scan] \%[\-noscan]
^^^\0\-date~^   \%[\-show] \%[\-noshow] \%[\-nofile] \%[\-nokeep]
^^^\0\-from~^
^^^\s+2\b'\(lt\(bv\(bv\(lk\(bv\(bv\(lb'\s0 \-search~\s+2\b'\(rt\(bv\(bv\(rk\(bv\(bv\(rb'\s0^ pattern
^^^\0\-subject~^
^^^\0\-to~^ \%[\-file \%[\-preserve] \%[\-link] \%+folder\ ... \%[\-nopreserve] \%[\-nolink] ]
^^^\0\-\-component~^ \%[\-keep \%[\-stay] \%[\-nostay] \%[+folder\ ...]\ ]
.fi
.fc

.re
.ti .5i
typically:
.in 1i
pick\0\-from\0jones\0\-scan
.br
pick\0\-to\0holloway
.br
pick\0\-subject\0ned\0\-scan\0\-keep
.SH DESCRIPTION
\fIPick\fR searches messages within a folder for the specified
contents, then performs several operations on the selected
messages.
.PP
A modified \fIgrep\fR(I) is used to perform the searching, so the
full regular expression (see \fIed\fR(I)) facility is available
within `pattern'.
With `\-search', pattern is used directly,
and with the others, the grep pattern constructed is:
.nf

.ti +.5i
\*(lq^component:\*.\*(**pattern\*(rq

.fi
This means that the pattern specified for a `\-search' will be
found everywhere in the message, including the header and the body,
while the other search requests are limited to the single
specified component.
The expression `\-\-component pattern'
is a shorthand for
specifying `\-search \*(lqcomponent:\*.\*(**pattern\*(rq\ '; it is used to pick
a component not in the set [cc date from subject to].
An
example is \*(lqpick \-\-reply\-to pooh \-show\*(rq.
.PP
Searching is performed on a per-line basis.
Within the header of
the message, each component is treated as one long line, but in
the body, each line is separate.
Lower-case letters in the
search pattern will match either lower or upper case in the
message, while upper case will match only upper case.
.PP
Once the search has been performed, the selected messages
are scanned (see \fIscan\fR) if the `\-scan' switch is given, and
then they are shown (see \fIshow\fR) if the `\-show' switch is
given.
After these two operations, the file operations (if
requested) are performed.
.PP
The `\-file' switch operates exactly like the \fIfile\fR command, with the
same meaning for the `\-preserve' and `\-link' switches.
.PP
The `\-keep' switch is similar to `\-file', but it produces a folder that
is a subfolder of the folder being searched and defines it as
the current folder (unless the `\-stay' flag is used).
This
subfolder contains the messages which matched the search
criteria.
All of the MH commands may be used with the sub-folder
as the current folder.
This gives the user considerable power
in dealing with subsets of messages in a folder.
.PP
The messages in a folder produced by `\-keep' will always have the
same numbers as they have in the source folder (i.e., the
`\-preserve' switch is automatic).
This way, the message
numbers are consistent with the folder from which the messages
were selected.
Messages are not removed from the source folder
(i.e., the `\-link' switch is assumed).
If a `+folder' is not
specified, the standard name \*(lqselect\*(rq will be used.
(This is the
meaning of \*(lq(select)\*(rq when it appears in the output of the
\fIfolder\fR command.) If `+folder' arguments are given to
`\-keep', they will be used rather than \*(lqselect\*(rq for the names
of the subfolders.
This allows for several subfolders to be
maintained concurrently.
.PP
When a `\-keep' is performed, the subfolder becomes the current folder.
This can be overridden by use
of the `\-stay' switch.
.PP
Here's an example:

.nf
\01  % folder +inbox
\02           inbox+ has  16 messages (  3\- 22); cur=  3.
\03  % pick \-from dcrocker
\04  6 hits.
\05  [+inbox/select now current]
\06  % folder
\07    inbox/select+ has  \06 messages (  3\- 16); cur=  3.
\08  % scan
.ds p \\h'\\w'+'u'
\09   \03+  6/20   Dcrocker          Re: ned file update issue...
10   \06\*p  6/23   Dcrocker          removal of files from /tm...
11   \08\*p  6/27   Dcrocker          Problems with the new ned...
12   13\*p  6/28   d\h'\w'D'u-\w'd'u'crocker          newest nned  \*(<<I would ap...
13   15\*p  7/\05   Dcrocker          nned  \*(<<Last week I asked...
14   16\*p  7/\05   d\h'\w'D'u-\w'd'u'crocker          message id format  \*(<<I re...
15  % show all | print
16     [produce a full listing of this set of messages on the line printer.]
17  % folder \-up
18            inbox+ has  16 messages (  3\- 22); cur=  3; (select).
19  % folder \-down
20   inbox/select+ has   6 messages (  3\- 16); cur=  3.
21  % rmf
22  [+inbox now current]
23  % folder
24            inbox+ has  16 messages (  3\- 22); cur=  3.
.fi

This is a rather lengthy example, but it shows the power of the
MH package.
In item 1, the current folder is set to inbox.
In 3,
all of the messages from dcrocker are found in inbox and linked
into the folder \*(lqinbox/select\*(rq.
(Since no action switch is
specified, `\-keep' is assumed.)  Items 6 and 7 show that this
subfolder is now the current folder.
Items 8 through 14 are a
\fIscan\fR of the selected messages (note that they are all from dcrocker
and are all in upper and lower case).
Item 15 lists all of the messages to
the high-speed printer.
Item 17 directs \fIfolder\fR to set the
current folder to the parent of the selection-list folder, which
is now current.
Item 18 shows that this has been done.
Item 19 resets
the current folder to the selection list, and 21 removes the
selection-list folder and resets the current folder to the
parent folder, as shown in 22 and 23.
.SH FILES
.nf
.ta \w'$HOME/\*.mh\(ruprofile    'u
$HOME/\*.mh\(ruprofile	The user profile
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'Current-Folder:    'u
Path:	To determine the user's MH directory
Folder\-Protect:	For protection on new folders
Current-Folder:	To find the default current folder
.fi
.SH DEFAULTS
.nf
`\-src +folder' defaults to current
`msgs' defaults to all
`\-keep +select' is the default if no `\-scan', `\-show', or `\-file' is specified
.fi
.SH CONTEXT
If a `\-src +folder' is specified, it will
become the current folder, unless a `\-keep' with 0 or 1
folder arguments makes the selection-list subfolder the
current folder.
Each selection-list folder will have its
current message set to the first of the messages linked into
it unless the selection list already existed, in which case the
current message won't be changed.
