.TH IDECRYPT 8 "19 May 1996"
.SH NAME
idecrypt \- Decrypt tokens obtained from identd
.SH SYNOPSIS
.B /usr/sbin/idecrypt
.SH DESCRIPTION
.B idecrypt
is a utility for decrypting the encrypted tokens that
.BR identd (8)
provided instead of usernames when it is
run in encrypted-token mode (that is, with the
.B \-C
flag).
.PP
.B idecrypt
reads up to 1024 lines from the
.B /etc/identd.key
file, converting each line to a DES key using
.BR des_string_to_key (3).
It then reads standard input, searching for encrypted tokens
in the format produced by
.BR identd (8),
decrypts the tokens if possible, and copies all unrecognised text from
standard input to standard output without modification.
.PP
If more than one key appears in the key file, then
.BR identd (8)
will use the first key for encryption, and
.B idecrypt
will attempt to use all the keys for decryption.
This allows new keys to be used by
.BR identd (8)
without losing the ability for
.B idecrypt
to decrypt old tokens (until there are more than 1024 keys in the key file).
.PP
Each encrypted token consists of 32 base64 characters, enclosed in
square brackets.  To make it easier to process logs generated by
versions of
.B tcpd (8)
that convert the square brackets to underlines,
.B idecrypt
permits underline characters instead of square brackets
in its input.
.PP
.BR idecrypt 's
output from decrypting each token is a human readable string
containing the timestamp (displayed as a local time in
.BR ctime (3)
format), the numeric uid, the local IP address, the local port number,
the remote IP address and the remote port number.
.SH EXAMPLE
Suppose that the local host has IP address 10.2.3.4, the local
.B /etc/identd.key
file contains
.PP
foobar
.PP
and the local host is running the
.BR identd (8)
server in encrypted-token mode.
.PP
Now, if a local user
with uid 501 telnets to a remote host with IP address 10.9.8.7,
the remote host may choose to make an ident query back to the
local host, in order to obtain some information to be logged for
possible use later.  The local
.BR identd (8)
might send the following encrypted token to the remote host
instead of sending a username:
.PP
[aALdNYxh2496K4DDTel2Nk0Jzj5mRbok]
.PP
If the administrator of the remote host later provides the administrator
of the local host with a copy of the encrypted token, and if
the secret key has not been removed from the local
.B /etc/identd.key
file, then the administrator of the local host can run
.B idecrypt
and can provide the encrypted token in standard input.
.PP
.B idecrypt
will then print the following decrypted information:
.PP
Sun May 19 00:25:23 1996 501 10.2.3.4 2304 10.9.8.7 23
.PP
This represents the time the encrypted token was created,
the local user id, the local IP address and port number, and the
remote IP address and port number.
.SH SEE ALSO
.BR identd (8)
.BR tcpd (8)
.SH BUGS
The handling of fatal errors could be better.
