/* read stats file generated by atc */

#define STATSFILE "/usr/games/lib/atc/stats"

#include <stdio.h>

#define AMAX 20 /* no more than 20 airspaces yet */
#define UMAX 100 /* number of likely users */

struct
{       char month[5];  /* Apr 15 17:04 */
	char date[5];
	int dhour;
	int dmin;
	char user[9];
	int crashes;
	int system;
	int towtruck;
	int boundary;
	int goaround;
	int remain;
	int seed;
	int rtime;
	int gas;
	int cmds;
	char airspace[50];
} r;

struct          /* record with each airspace */
{       char recordholder[9];
	int time;
	char smo[5];
	char sdate[5];
	int shour;
	int smin;
	char airspname[50];
} s[AMAX];

int nairspace = 0;

int users = 0;

struct  /* user */
{       char uname[9];
	int minutes;    /* total time played */
	int start;
	int ucrashes;
	int usystem;
	int utowtruck;
	int uboundary;
	int ugoaround;
	int through;
	int urtime;
	int ugas;
	int ucmds;
} u[UMAX];

#define BUFSIZE 80
#define SKIP while (*c != ' ') c++;

main(argc,argv)
int argc;
char **argv;
{       FILE *sfile;
	char buf[BUFSIZE],*c;
	int dump,i,j,done,ok;


	if ((sfile = fopen(STATSFILE,"r")) == NULL)
	{       fprintf(stderr,"No stats file.\n");
		exit(1);
	}
	if (argc == 2)  /* don't want the beginning */
		if (-1 == fseek(sfile,-atoi(argv[1]),2))/* seek forward from end */
			printf("Couldn't seek.\n");
	while (fgets(buf,BUFSIZE,sfile) != NULL)
	{       if ((j = sscanf(buf,"%s%s%d:%d:%s %d%d%d%d%d%d%d%d.%d%d %s\n",
		       r.month,r.date,&r.dhour,&r.dmin,
		       r.user,&r.crashes,&r.system,&r.towtruck,
		       &r.boundary,&r.goaround,&r.gas,&r.cmds,
		       &r.remain,
		       &r.seed,&r.rtime,
		       r.airspace)) == 0) continue;
		for (c = r.user; *c; c++) if (*c == ':') *c = 0;
		if (strcmp("CR",r.month) == 0) continue;
		for (i=0; i<users; i++)
			if (strcmp(u[i].uname,r.user) == 0) break;
		if (i == users) strcpy(u[users++].uname,r.user);
		if (j < 13)
		{       u[i].start = 60*r.dhour+r.dmin;
			continue;
		}

		if (u[i].start == 0) continue;
		done = 60*r.dhour+r.dmin;
		u[i].minutes += done - u[i].start;
		u[i].ucrashes += r.crashes;
		u[i].usystem += r.system;
		u[i].utowtruck += r.towtruck;
		u[i].uboundary += r.boundary;
		u[i].ugoaround += r.goaround;
		u[i].urtime += r.rtime;
		u[i].ugas += r.gas;
		u[i].ucmds += r.cmds;
		ok = 26-r.remain-r.crashes-r.towtruck-r.boundary-2*r.system;
		if (ok > 0) u[i].through += ok;
		if (done - u[i].start < 0) u[i].minutes += 24*60;

		if (r.remain+r.crashes+r.system+r.towtruck+r.boundary
		    != 0) continue; /* need only perfect games */

		for (i=0; i<nairspace; i++)
			if (strcmp(r.airspace,s[i].airspname) == 0) break;

		if (i != nairspace && s[i].time <= r.rtime) continue;
		strcpy(s[i].airspname,r.airspace);
		strcpy(s[i].recordholder,r.user);
		s[i].time = r.rtime;
		strcpy(s[i].smo,r.month);
		s[i].shour = r.dhour;
		s[i].smin = r.dmin;
		strcpy(s[i].sdate,r.date);
		if (i == nairspace) nairspace++;
	}
	printf("           RECORDHOLDERS\n\n");
	for (i=0; i<nairspace; i++)
		printf("%s %s %2d:%02d %s: %s in %d minutes\n",
			s[i].smo,s[i].sdate,s[i].shour,s[i].smin,
			s[i].recordholder,s[i].airspname,s[i].time);

	printf("\nINDIVIDUAL STATS: per declared hour\n\n");
	printf("            Time  SYS GAS CMD  CR TT BD GA    OK\n");
	for (i=0; i<users; i++)
	{       if (u[i].minutes <= 0) continue;
		printf("%8s:%4d:%02d %3d%5d%4d%4d%3d%3d%3d%6d\n",u[i].uname,
		       u[i].urtime/60, u[i].urtime%60,
		       60 * u[i].usystem/u[i].urtime,
		       60 * u[i].ugas/u[i].urtime,
		       60 * u[i].ucmds/u[i].urtime,
		       60 * u[i].ucrashes/u[i].urtime,
		       60 * u[i].utowtruck/u[i].urtime,
		       60 * u[i].uboundary/u[i].urtime,
		       60 * u[i].ugoaround/u[i].urtime,
		       60 * u[i].through/u[i].urtime);
	}
	printf("\nINDIVIDUAL STATS: per real hour\n\n");
	printf("            Time  SYS GAS CMD  CR TT BD GA    OK\n");
	for (i=0; i<users; i++)
	{       if (u[i].minutes <= 0) continue;
		printf("%8s:%4d:%02d %3d%5d%4d%4d%3d%3d%3d%6d\n",u[i].uname,
		       u[i].minutes/60, u[i].minutes%60,
		       60 * u[i].usystem/u[i].minutes,
		       60 * u[i].ugas/u[i].minutes,
		       60 * u[i].ucmds/u[i].minutes,
		       60 * u[i].ucrashes/u[i].minutes,
		       60 * u[i].utowtruck/u[i].minutes,
		       60 * u[i].uboundary/u[i].minutes,
		       60 * u[i].ugoaround/u[i].minutes,
		       60 * u[i].through/u[i].minutes);
	}
}


