
# line 24 "gram.y"
#include "cfront.h"
#include "size.h"
// include tqueue.h after YYSTYPE is defined ...

#define YYMAXDEPTH 600

#ifdef DBG
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#endif

static init_seen = 0;
static cdi = 0;
static Pnlist cd = 0, cd_vec[BLMAX];
static char stmt_seen = 0, stmt_vec[BLMAX];

//local class
static Plist tn_vec[BLMAX], lcl_tn_vec[BLMAX], lcl_blk_vec[BLMAX];
extern void local_restore();
extern void local_name();

//nested class
static Plist nested_tn_vec[BLMAX], nested_type_vec[BLMAX];
extern void nested_restore();
extern char *class_typedef;

static Pname err_name = 0;

// fcts put into norm2.c just to get them out of gram.y
void sig_name(Pname);	
Ptype tok_to_type(TOK);
void memptrdcl(Pname, Pname, Ptype, Pname);

static Pptr doptr(TOK p, TOK t)
{
	Pptr r = new ptr(p,0);
	switch (t) {
	case CONST:
		r->rdo = 1;
               // if (p == RPTR) error('w',"redundant `const' after &");
		break;
	case VOLATILE:
		error('w',"\"volatile\" not implemented (ignored)");
		break;
	default:
		error("syntax error: *%k",t);
	}
	return r;
}

static Pbcl dobase(TOK pr, Pname n, TOK v = 0)
{
	Pbcl b = new basecl(0,0);

	if (pr == PROTECTED) {
		pr = PUBLIC;
		error("protectedBC");
	}
	b->ppp = pr;	// save protection indicator

	if (n) {
		if (n->base != TNAME) {
			error("BN%n not aTN",n);
			return 0;
		}

		Pbase bt = Pbase(n->tp);
		while (bt->base == TYPE) bt = Pbase(bt->b_name->tp);

		if (bt->base != COBJ) {
			error("BN%n not aCN",n);
			return 0;
		}

		if (v) {
			if (v != VIRTUAL) error("syntax error:%k inBCD",v);
			b->base = VIRTUAL;
		}
		else
			b->base = NAME;

		b->bclass = Pclass(bt->b_name->tp);
	}

	return b;
}


#define Ndata(a,b)	b->normalize(Pbase(a),0,0)
#define Ncast(a,b)	b->normalize(Pbase(a),0,1)
#define Nfct(a,b,c)	b->normalize(Pbase(a),Pblock(c),0)
#define Ncopy(n)	(n->base==TNAME)?new name(n->string):n

#define Finit(p)	Pfct(p)->f_init
#define Fargdcl(p,q,r)	Pfct(p)->argdcl(q,r)
#define Freturns(p)	Pfct(p)->returns
#define Vtype(v)	Pvec(v)->typ
#define Ptyp(p)		Pptr(p)->typ

		/* avoid redefinitions */
#undef EOFTOK
#undef ASM
#undef BREAK
#undef CASE
#undef CONTINUE
#undef DEFAULT
#undef DELETE
#undef DO
#undef ELSE
#undef ENUM
#undef FOR
#undef FORTRAN 
#undef GOTO
#undef IF
#undef NEW
#undef OPERATOR
#undef RETURN
#undef SIZEOF
#undef SWITCH
#undef THIS
#undef WHILE
#undef LP
#undef RP
#undef LB
#undef RB
#undef REF
#undef DOT	
#undef NOT	
#undef COMPL	
#undef MUL	
#undef AND	
#undef PLUS	
#undef MINUS	
#undef ER	
#undef OR	
#undef ANDAND
#undef OROR
#undef QUEST
#undef COLON
#undef ASSIGN
#undef CM
#undef SM	
#undef LC	
#undef RC
#undef ID
#undef STRING
#undef ICON
#undef FCON	
#undef CCON	
#undef ZERO
#undef ASOP
#undef RELOP
#undef EQUOP
#undef DIVOP
#undef SHIFTOP
#undef ICOP
#undef TYPE
#undef TNAME
#undef EMPTY
#undef NO_ID
#undef NO_EXPR
#undef FDEF
#undef ELLIPSIS
#undef AGGR
#undef MEM
#undef MEMPTR
#undef PR
#undef TSCOPE
#undef DECL_MARKER
#undef REFMUL
#undef LDOUBLE
#undef LINKAGE
#undef LOCAL 
#undef NESTED

# line 201 "gram.y"
typedef union  {
	char*	s;
	TOK	t;
	int	i;
	loc	l;
	Pname	pn;
	Ptype	pt;
	Pexpr	pe;
	Pstmt	ps;
	Pbase	pb;
	Pnlist	nl;
	Pslist	sl;
	Pelist	el;
	Pbcl	pbc;
	Pptr	pp;
	PP	p;	// fudge: pointer to all class node objects
	Plist	pl;
	toknode* q;	// token queue
} YYSTYPE;

# line 221 "gram.y"
#include "tqueue.h"
extern YYSTYPE yylval, yyval;
extern int yyparse();

// in_typedef should allow for nested in_typedef
extern int	declTag;	 // !1: inline, virtual mod permitted
int		in_sizeof = 0;
Ptype 		in_typedef = 0;  // catch redefinition of TNAME
Pname		in_tag = 0;      // handle complex typedefs: int (*)()
extern int	defer_check;	 // redefinition typedef check delay
Pname		curr_scope;

extern int 	must_be_id;	 // !0, TNAME => ID, i.e., int X
int	DECL_TYPE = 0; 	 // lalex() wants this set for global x(*fp)()
int	in_arg_list=0; 	 // !0 when parsing argument list
static int in_binit_list=0;
int	in_class_decl=0; // !0 when processing class definition
int	parsing_class_members=0; // !0 when parsing class def but not member function body
int	in_mem_fct=0;    // !0 when parsing member function definition

#define yylex lalex
#define NEXTTOK() ( (yychar==-1) ? (yychar=yylex(),yychar) : yychar )
#define EXPECT_ID() must_be_id = 1
#define NOT_EXPECT_ID() must_be_id = 0

Pname syn()
{
ll:
	switch (yyparse()) {
	case 0:		return 0;	// EOF
	case 1:		goto ll;	// no action needed
	default:	return yyval.pn;
	}
}

# define EOFTOK 0
# define ASM 1
# define BREAK 3
# define CASE 4
# define CONTINUE 7
# define DEFAULT 8
# define DELETE 9
# define DO 10
# define ELSE 12
# define ENUM 13
# define FOR 16
# define FORTRAN 17
# define GOTO 19
# define IF 20
# define NEW 23
# define OPERATOR 24
# define RETURN 28
# define SIZEOF 30
# define SWITCH 33
# define THIS 34
# define WHILE 39
# define LP 40
# define RP 41
# define LB 42
# define RB 43
# define REF 44
# define DOT 45
# define NOT 46
# define COMPL 47
# define MUL 50
# define AND 52
# define PLUS 54
# define MINUS 55
# define ER 64
# define OR 65
# define ANDAND 66
# define OROR 67
# define QUEST 68
# define COLON 69
# define ASSIGN 70
# define CM 71
# define SM 72
# define LC 73
# define RC 74
# define MEMPTR 173
# define ID 80
# define STRING 81
# define ICON 82
# define FCON 83
# define CCON 84
# define ZERO 86
# define ASOP 90
# define RELOP 91
# define EQUOP 92
# define DIVOP 93
# define SHIFTOP 94
# define ICOP 95
# define TYPE 97
# define TNAME 123
# define EMPTY 124
# define NO_ID 125
# define NO_EXPR 126
# define FDEF 127
# define ELLIPSIS 155
# define AGGR 156
# define MEM 160
# define PR 175
# define TSCOPE 178
# define DECL_MARKER 179
# define REFMUL 180
# define LDOUBLE 181
# define LINKAGE 182
# define LOCAL 183
# define NESTED 190
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1988 "gram.y"


static void
check_tag()
/*
        Allow the case of inline/virtual/overload as 
        modifiers of return type of form struct/class/union x foo() 
        SM, COLON, LC ==> real class declaration, not return type
*/
{
	switch ( NEXTTOK() ) {
	case SM: case COLON: case LC:
    		declTag = 1;
    		break;
	default:
    		declTag = 0;
    		break;
        }
}

static void
end_al( Plist mtn, int rst )
// unhide type names hidden by arg names
// mtn == saved modified_tn
{
	if ( rst == 0 ) {
		// not really an arg list, or we are entering a function def
		// merge modified_tn and don't restore
		if ( modified_tn == 0 ) modified_tn = mtn;
		else {
			for ( Plist l = modified_tn; l->l; l = l->l ) ;
			l->l = mtn;
		}
	} else {
		restore();
		modified_tn = mtn;
	}
}
static void
arg_redec( Pname fn )
{
	if ( fn==0 || fn->tp->base != FCT )
		error('i',"bad inline rewrite!");
	Pname al = Pfct(fn->tp)->argtype;
	Pname n = 0;
	for ( ;  al;  al = al->n_list ) {
		DB( if(Ydebug>=1)error('d',"arg_redec:  %n  %d",al,al->lex_level); );
		// nested function args should have lex_level >= 1
		if ( al->lex_level==1 && (n=ktbl->look(al->string,0)) )
			n->hide();
		else if ( al->lex_level>1 && (n=ktbl->look(al->string,LOCAL)) )
			n->hide();
		DB( if(Ydebug>=1)error('d',"   %n",n); );
	}
}


short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 40,
	71, 31,
	72, 31,
	-2, 30,
-1, 57,
	155, 310,
	-2, 247,
-1, 62,
	13, 305,
	97, 305,
	123, 305,
	155, 305,
	156, 305,
	160, 305,
	178, 305,
	179, 305,
	182, 305,
	-2, 247,
-1, 111,
	73, 71,
	-2, 66,
-1, 348,
	1, 166,
	3, 166,
	4, 166,
	7, 166,
	8, 166,
	9, 166,
	10, 166,
	13, 166,
	16, 166,
	19, 166,
	20, 166,
	23, 166,
	24, 166,
	28, 166,
	30, 166,
	33, 166,
	34, 166,
	39, 166,
	40, 166,
	46, 166,
	47, 166,
	50, 166,
	52, 166,
	54, 166,
	55, 166,
	72, 166,
	73, 166,
	80, 166,
	81, 166,
	82, 166,
	83, 166,
	84, 166,
	86, 166,
	95, 166,
	97, 166,
	123, 166,
	156, 166,
	160, 166,
	178, 166,
	179, 166,
	182, 166,
	-2, 0,
	};
# define YYNPROD 323
# define YYLAST 2514
short yyact[]={

 129, 464, 347, 426, 262, 159,   7,   8, 266, 393,
 238, 131, 142,  58, 169, 291, 338, 335, 273, 240,
  12, 201, 168, 390, 140,  16, 188,  55, 200,  63,
 402,  29,  50,  30, 292,  76,  77,   9,  78,  64,
  20, 269,  28,  61,  69, 165, 236, 350, 232, 265,
 233, 235,  20,  57,  10, 156, 158,  19,  63,  20,
  20,  67, 109, 108, 107,  68,  22, 155, 151, 111,
 118,  27,  61, 524, 160,  69, 120, 171,  73,  45,
  57, 449, 258,  23, 171, 489,  63,  32, 202,  63,
 296, 180,  67, 372,  26, 296,  46,  29, 295,  30,
  61, 231,  37,  61, 301, 302, 427, 126, 177,  68,
 476,  57, 213, 415,  57, 175, 192, 114, 193,  32,
  36,  66, 346, 463, 149, 270, 348,  17, 226,  29,
  12,  30, 241, 242, 243, 244, 245, 246, 247, 248,
 249, 160, 237, 239,  73,  27,  37, 289, 194,  67,
  20, 250, 495, 482,  31, 219, 207, 203, 265, 274,
  25, 189, 252,  20,  36, 195, 114,  25,  26, 340,
  25, 123, 124, 416,  38, 364,  73, 242, 205,  29,
 299,  30, 286, 294, 285, 260, 234, 280, 256,  29,
 257,  30, 297,  67, 365, 271, 472,  37, 251, 470,
  20, 181,  25, 261,  37, 391,  67,  37, 282,  25,
 300, 276, 369, 263, 264,  36, 283,  67, 469,  20,
  31, 303,  36, 288, 265,  36,  73,  45, 287, 275,
 322, 199, 298,  59, 182, 330, 186,  60,  45,  37,
  67, 325, 324, 326,  46,  65,  37, 189,  57, 413,
  59, 241,  31, 185,  60,  46, 116,  36, 328, 252,
 331, 293,  25, 114,  36, 304, 305, 306, 307, 308,
 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
 319, 320, 333, 321, 114, 334, 354, 355, 327, 171,
 343, 341, 352, 342, 359, 360,  35, 114, 336,  37,
 537, 356,  31, 373, 344, 345,  25,  45, 458,  27,
 339, 430,  31, 409, 367, 276, 276,  36, 370,  45,
  65,  57, 388, 154,  46,  32, 476,  25, 366, 368,
 474, 475,  26, 275, 275,  29,  46,  30, 340, 465,
  25, 387, 380,  37, 125,  32, 252,  59,  29, 381,
  30,  60, 383, 371, 382, 254, 385, 386, 384,  59,
 396,  36, 119,  60,  37,  17, 379, 483, 481, 482,
 480, 361, 377, 355, 355, 357, 407,  37, 255, 376,
  21, 403,  36, 351, 395, 279, 267, 356, 356, 399,
 400, 411, 410, 412, 336,  36, 381, 339, 339, 383,
 383,  32, 404,  59, 405, 491,  25,  60,  25, 421,
 113, 253, 419, 394, 476, 204, 184, 114, 474, 475,
 423, 422, 412, 164, 467, 432, 429, 425, 418, 457,
 406, 440, 252,  32, 438, 459, 439, 259, 258,  34,
 417, 424,  39,  37, 466,  37, 468, 536,  12,  54,
 230, 395, 528, 114,  68, 397, 492, 482,  31, 494,
  25,  36,  24,  36, 431, 161, 497, 506, 498,  35,
 500,  31, 502, 230, 457, 457, 457, 457, 457, 457,
 457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
 121,  37, 462, 471, 523, 526,  25,  37,  35, 476,
  56, 504,  59, 474, 475, 530,  60, 531, 532,  36,
 534, 229, 503,  35, 501,  36, 112, 461, 236, 460,
 232, 499, 233, 235, 490, 230, 389, 505, 363,  62,
 122,  59, 540,  37, 284,  60, 457, 542, 544, 545,
  32, 206, 482, 480, 209, 349, 420, 548, 290, 525,
  29,  36,  30,  21, 551, 507, 508, 509, 510, 511,
 512, 513, 514, 515, 516, 517, 518, 519, 520, 521,
 522, 153,  15, 231, 198, 401, 268, 166, 170,  25,
 274,  13,  21, 539,  44, 103, 541,  56,  35,  59,
  27,  72,  75,  60,  40, 141, 167,  43, 434, 105,
 213,  71,  74, 549, 211, 212, 115, 115,  25, 433,
 254, 353,  34,  26, 428, 340,  37, 543, 414,  41,
  35,  27, 191,  25, 110,  29, 162,  30,  33, 173,
 117,  27,  14, 255,  36,  24, 162,   1, 161, 392,
  32,  34,   2, 219,  26,  37,  70,  32, 150,  18,
  29,   0,  30,   0,  26,   0,  34,  29,   0,  30,
  37,  49,   0,  36,  24,   0, 253, 161,  49,  49,
   0,  35,  43,  31,   0, 187, 106,  70,  36,  47,
 274, 190,  15, 106, 106,   0,   0,  17,   0,  68,
   0,   0,   0, 162,   0,  75, 213,   0,  25,   0,
 211, 212, 162, 163,  21, 208, 174,   0,  29,  68,
  30,   0,   0, 163, 173,  32, 398,  59,   0,   0,
  68,  60,   0, 105,   0,   0,  37,  56, 362,  59,
  25,  34,  44,  60,   0,  37,   0, 220, 218, 219,
 217,   0, 208, 272,  36,  66,  37,   0,  31,   0,
   0,  75, 106,  36,  47,  43,   0,  37,   0, 197,
   0, 281,   0,  34,  36,  66,   0,  37,   0,   0,
 163, 115,  49,  31,   0,  36,   0,   0,   0, 163,
  31,  25, 196,   0,   0,  36,  24,   0,   0, 161,
 213, 174,   0,   0, 211, 212,   0,  56, 183,  59,
 106,   0, 162,  60,   0, 329,   0, 332,   0,  49,
   0, 173, 272,   0,  34,   0,   0,   0,  37,  56,
 106,  59,   0,   0, 272,  60, 105, 115,  49,   0,
   0,  31,   0, 219, 217,   0,  36,  47,   0, 127,
   0, 162,   0,  35,   0,   0,   0, 358, 106,  52,
   0,  53,   0, 130, 151,   0,   0,   0,   0,   0,
 139,   0,   0,   0, 148, 115, 115,   0,   0,   0,
 154,   0,   0,   0,  27,   0, 136, 137,   0, 163,
 132,   0, 133,   0, 135, 134,   0,   0, 174, 106,
  32, 476,   0, 477,   0, 474, 475,  26, 173,   0,
  29, 106,  30, 106, 106, 479, 478, 484, 485, 488,
 149, 146, 144, 145, 147,   0, 143,   0, 163,  51,
   0, 115,   0,   0, 106, 138,   0, 172,   0,   0,
  48,   0, 483, 481, 482, 480,   0, 115,   0, 115,
   0, 115, 106, 106,   0,   0,   0,   0,   0,   0,
   0,   0, 162,  25,   0, 546,   0,   0,   0,   0,
   0,   0, 213,   0, 214,   0, 211, 212,   0,   0,
   0,   0,   0,  25,   0, 174, 216, 215, 221, 222,
 225, 162, 210, 224, 162,   0,  34,   0, 115,   0,
 128,   0,   0,   0,   0,   0,   0,   0, 106,   0,
 173,   0, 223, 220, 218, 219, 217,   0,  36,  24,
  37,   0, 161,   0, 106,   0, 106,   0, 106,   0,
   0,   0,   0,  31,   0,   0,   0,   0,  36, 163,
 454,   0, 450, 447,   0,   0, 451, 448, 455, 453,
   0,   0,  35,   0,   0, 443,   0,   0, 452, 441,
   0,   0, 130, 151,   0,   0,   0, 436, 163, 139,
   0, 163, 444, 148,   0, 106,   0,   0, 442, 154,
   0,   0,   0,   0,   0, 136, 137, 174,   0, 132,
   0, 133,   0, 135, 134,   0,   0,   0,   0, 476,
   0, 477,   0, 474, 475, 476,   0, 477,   0, 474,
 475, 435, 348, 479, 127,   0,   0,   0,  35, 445,
 146, 144, 145, 147,   0, 143,   0,   0, 130, 151,
   0,   0,   0,   0, 138, 139, 437,   0,   0, 148,
 483, 481, 482, 480,   0, 154, 483, 481, 482, 480,
   0, 136, 137,   0,   0, 132,   0, 133,   0, 135,
 134,   0, 446,   0,   0,   0, 213,   0, 214,   0,
 211, 212, 213,   0, 214,   0, 211, 212, 157,   0,
 216, 215, 221, 222, 225, 149, 146, 144, 145, 147,
   0, 143,  99,   0,   0,  34,   0,   0,   0, 456,
 138,   0, 172,   0,   0,   0,  98, 220, 218, 219,
 217,   0,   0, 220, 218, 219, 217,  36,  24,   0,
   0, 161,   0,  91,   0,  92,   0, 100,  25,  93,
  94,   0,   0,  81,   0,  82,   0,  79,  80,   0,
   0,   0,   0,   0,   0,   0,   0,  84,  83,  89,
  90,   0, 476,  97, 101,   0, 474, 475, 213,   0,
 214,  34, 211, 212,   0, 128,   0, 127,   0,   0,
   0,   0, 216,  96,  88,  86,  87,  85,  95,   0,
 104, 130, 151,  36,  24, 213,   0, 161, 139, 211,
 212,   0, 148, 483,   0, 482, 480,   0, 154, 220,
 218, 219, 217,   0, 136, 137,  25,   0, 132,   0,
 133,   0, 135, 134,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 220,   0, 219, 217,
   0, 157,   0, 127,   0,   0,   0,   0, 149, 146,
 144, 145, 147,  37, 143,   0,   0, 130, 151,   0,
   0,   0, 455, 138, 139, 152,   0,   0, 148,   0,
   0,  36,   0, 102, 154,   0, 130, 151,   0,   0,
 136, 137,   0, 139, 132,   0, 133, 148, 135, 134,
   0,  25,   0, 154,   0,   0,   0,   0,   0, 136,
 137,   0,   0, 132,   0, 133,   0, 135, 134,   0,
   0,   0,   0,   0, 149, 146, 144, 145, 147,   0,
 143,   0,   0,   0,   0,   0,   0,   0, 128, 138,
   0, 152,   0, 149, 146, 144, 145, 147,   0, 143,
   0,   0, 130, 151,   0,   0,  36,   0, 138, 139,
 152,   0,   0, 148,   0,   0,   0,  25,   0, 154,
   0, 527,   0,   0,   0, 136, 137,   0,   0, 132,
   0, 133,   0, 135, 134,   0,  25,   0, 476,   0,
 477,   0, 474, 475,   0,   0,   0,   0,   0,   0,
   0,   0, 479, 478, 128,   0,   0,   0,   0, 149,
 146, 144, 145, 147,   0, 143,   0,   0,   0,   0,
   0,   0,  36, 456, 138,   0, 152, 130, 151, 483,
 481, 482, 480,   0, 139,   0,   0,   0, 148,   0,
   0,  36,   0,   0, 154,   0, 493,   0,   0,   0,
 136, 137,  25,   0, 132,   0, 133,   0, 135, 134,
   0,   0, 476,   0, 477,   0, 474, 475,   0,   0,
   0,   0,   0,   0,   0,   0, 479, 478, 484,   0,
   0,   0,   0,   0, 149, 146, 144, 145, 147, 228,
 143, 130, 151,   0,   0,   0,   0,   0, 139, 138,
   0, 152, 148, 483, 481, 482, 480,  36, 154,   0,
 323,   0,   0,   0, 136, 137,   0,   0, 132,   0,
 133,   0, 135, 134,   0,   0,   0,  25,   0,   4,
  11,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  35,   0,   0,   0,   0,   0, 149, 146,
 144, 145, 147,  27, 143,   0,   0,   0,   0,   0,
   0, 130, 151, 138, 228, 152,   0,   0, 139,  32,
   0,   0, 148,   0,   0,   0,  26,   0, 154,  29,
 227,  30,  36,   0, 136, 137,   0,   0, 132,   0,
 133,  25, 135, 134,   0,   0,   0,   0,   0,   0,
  35,   3,   0,   6,   0,   0,   0,   0,   0,  17,
   0,  27,   0,   0,   0,   0,   0,   0, 149, 146,
 144, 145, 147,   0, 143,   0,  21,  32, 228,   0,
   0,   0,   0, 138,  26, 152,   0,  29,   0,  30,
   0,   0,   0,   0,   0,   0,  36,   0,   0,   0,
   0,   0,  25,   0,   0,   0,  51,   0,   0,  42,
   0,  25,   0, 130, 151,   0,   0,  48,   0,   0,
 139,   0,   0,   0, 148,   0,   0,   0,   0,   0,
 154,   0,   0,   0,  43,  34, 136, 137,   0,  37,
 132,   0, 133,   0, 135, 134,   0,   0, 228,   0,
   0,   0,  31,   0,   0,   0,   0,  36,  24,   0,
  25,   5,   0,   0,   0,   0,  36,   0,   0,   0,
 149, 146, 144, 145, 147,   0, 143, 130, 151,   0,
   0,   0,   0,   0, 139, 138,   0, 152, 148,   0,
   0,   0,   0,  34, 154,   0,   0,  37,   0,   0,
 136, 137,   0,   0, 132,   0, 133,   0, 135, 134,
  31,   0,   0,  25,   0,  36,  47,   0,   0,   0,
   0,   0, 130, 151,   0,   0,   0,   0,   0, 139,
   0,   0,   0, 148, 278, 146, 144, 145, 147, 154,
 143,   0,   0,   0,   0, 136, 137,   0,   0, 138,
 228, 152,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  36,   0,
   0,   0, 127,   0,   0,   0,   0,  25,   0, 149,
 146, 144, 145, 147,   0, 143, 130, 151,   0,   0,
   0,   0,   0, 139, 138,   0, 152, 148,   0,   0,
   0,   0,   0, 154, 178,   0,   0,   0,   0, 136,
 137,   0,   0, 176, 228, 133,   0, 135, 134,   0,
   0,   0,  25,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  36,   0,   0,   0, 157,   0,   0, 550,
   0,   0,   0, 149, 146, 144, 145, 147, 213, 143,
 214,   0, 211, 212,   0,   0,   0,   0, 138, 228,
   0,   0, 216, 215, 221, 222, 225,   0, 210, 224,
   0,   0,   0,   0,   0,   0,   0,  36,   0, 213,
   0, 214,   0, 211, 212,   0,   0,   0, 223, 220,
 218, 219, 217, 216, 215, 221, 222, 225,   0, 210,
 224, 547,   0, 538,   0,   0,   0,   0,   0,   0,
 213,   0, 214,   0, 211, 212,   0,   0,   0, 223,
 220, 218, 219, 217, 216, 215, 221, 222, 225,   0,
 210, 224,   0,   0,   0,   0, 179,   0,   0,   0,
   0, 476,   0, 477,   0, 474, 475,   0,   0,   0,
 223, 220, 218, 219, 217, 479, 478, 484, 485, 488,
 535, 473, 487,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 213,   0, 214,   0, 211, 212,   0,   0,
   0, 486, 483, 481, 482, 480, 216, 215, 221, 222,
 225, 533, 210, 224, 529,   0,   0,   0,   0,   0,
   0,   0,   0, 213,   0, 214,   0, 211, 212,   0,
   0,   0, 223, 220, 218, 219, 217, 216, 215, 221,
 222, 225,   0, 210, 224,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 213,   0, 214,   0, 211, 212,
   0,   0,   0, 223, 220, 218, 219, 217, 216, 215,
 221, 222, 225,   0, 210, 224, 496,   0, 408,   0,
   0,   0,   0,   0,   0, 213,   0, 214,   0, 211,
 212,   0,   0,   0, 223, 220, 218, 219, 217, 216,
 215, 221, 222, 225,   0, 210, 224,   0,   0, 378,
   0,   0,   0,   0,   0,   0, 213,   0, 214,   0,
 211, 212,   0,   0,   0, 223, 220, 218, 219, 217,
 216, 215, 221, 222, 225,   0, 210, 224,   0,   0,
 375,   0,   0,   0,   0,   0,   0, 213,   0, 214,
   0, 211, 212,   0,   0,   0, 223, 220, 218, 219,
 217, 216, 215, 221, 222, 225,   0, 210, 224,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 213,   0,
 214,   0, 211, 212,   0,   0,   0, 223, 220, 218,
 219, 217, 216, 215, 221, 222, 225, 374, 210, 224,
 337,   0,   0,   0,   0,   0,   0,   0,   0, 213,
   0, 214,   0, 211, 212,   0,   0,   0, 223, 220,
 218, 219, 217, 216, 215, 221, 222, 225,   0, 210,
 224,   0,   0, 277,   0,   0,   0,   0,   0,   0,
 213,   0, 214,   0, 211, 212,   0,   0,   0, 223,
 220, 218, 219, 217, 216, 215, 221, 222, 225,   0,
 210, 224,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 476,   0, 477,   0, 474, 475,   0,   0,   0,
 223, 220, 218, 219, 217, 479, 478, 484, 485, 488,
   0, 473, 487,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 476,   0, 477,   0, 474, 475,   0,   0,
   0, 486, 483, 481, 482, 480, 479, 478, 484, 485,
 488, 213, 473, 214,   0, 211, 212,   0,   0,   0,
   0,   0,   0,   0,   0, 216, 215, 221, 222, 225,
   0, 210, 486, 483, 481, 482, 480,   0,   0,   0,
   0,   0, 213,   0, 214,   0, 211, 212,   0,   0,
   0, 223, 220, 218, 219, 217, 216, 215, 221, 213,
   0, 214,   0, 211, 212,   0,   0,   0,   0,   0,
   0,   0,   0, 216, 215,   0,   0,   0,   0,   0,
   0,   0,   0, 220, 218, 219, 217,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 220, 218, 219, 217 };
short yypact[]={

1599,-1000,-1000,-1000,-1000, 101,-1000,-1000,-1000,-1000,
-1000, 402,1657, 779,-1000, 489,-1000, 200, 566,  47,
 285,-1000,-1000,-1000,-1000,-1000, -88,1173,-1000, -33,
 -34, -35,-1000,-1000, 337, 183,-1000,-1000,-1000,  -5,
 460, 100,-1000,-1000, 489,-1000,-1000,-1000, 275, 597,
-1000,1314,1248,-1000, 485,-1000, 382,1095,-1000,1314,
-1000,-1000,1883,-1000, 485, 121,-1000,-1000,-1000,-1000,
 189, 547, 489,-1000, 757, 489,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000, 375, 210,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000, 139,-1000,-1000, -14,-1000,-1000,-1000,
 607, 162,-1000,-1000,-1000,-1000,   8,  84,-1000,-1000,
 374, 485,-1000, 850,-1000,-1000,2371,1608, 502,   6,
 283,1710,1710,1710,1710,1710,1710,1710,1710,1710,
-1000,-1000, 830,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
 331,1173, 398, 397,-1000, 113,2371,1248,  89,-1000,
1657,-1000,-1000, -58,-1000, 345, -30, 124,-1000,-1000,
-1000, 500, 398, 397, 586,2290,1774, 344,-1000, 285,
-1000,-1000, 121,-1000,-1000,-1000,-1000,-1000,-1000, -19,
-1000,-1000,-1000, 112, 110,-1000, 159, 566,  74,  86,
  24,-1000, 122,   8, 108, -20,1248,-1000, 460,1314,
1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,
1314,1314,1314,1314,1314,1314,   6,1314, 427,1538,
 283,-1000,1314,  44,1710,  44,1248,-1000,-1000,1095,
 658, 478,   6,   6,   6,   6, 478, 478, 478, 478,
1819,2259, 575,-1000,1173, 204,-1000,-1000,1248,1248,
-1000,  48,  53,-1000,-1000,-1000, -50,-1000, 342, 456,
-1000,1248,-1000, 305,-1000,  79, 600,-1000, 330,-1000,
 -50, 687,-1000,-1000,-1000,-1000,-1000,-1000, 103,-1000,
 123,-1000,-1000, 217,  37,-1000,   8,1314,  19,-1000,
  53,-1000,-1000,-1000,2371,2371,  62,  62,-1000, 646,
1198,1112, 550,1225,-1000, 740,2419,2402,2371,2371,
2228,2197,   6,1314,-1000,-1000,1095,2166,-1000,-1000,
 478,-1000,-1000, 325, 301, 191, -19,-1000, 317, 129,
 298,-1000,-1000,-1000, 300, 281,-1000,-1000, -51, 373,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000, 361,
 675, 393, 393, -97,-1000,  86,-1000, 204,-1000, 204,
-1000,2371,-1000,-1000,1314,1710,2135, 272,-1000,-1000,
 283,-1000, 191,-1000,-1000, 191, 208,-1000,-1000,-1000,
-1000,  39, 102,-1000,1248, 388, -50,1248,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,1106,   6,1710, 283,
-1000,-1000, 485, 361,  32,-1000, 373, 270,1248,-1000,
 155,   6,-1000,-1000,-1000,-1000,-1000,-1000,1029,-1000,
-1000, 267,  53,-1000,-1000,-1000,1314,  42,-1000,-1000,
-1000, 299, 299, 384, 299, 149, 130,-1000, 127,2321,
-1000,-1000,   5,-1000, 365,1474, 450,   6,-1000,-1000,
-1000,  80,2104,  53,-1000,1314,-1000,-1000,-1000,-1000,
-1000,1314,-1000,1333,1333,1333,1333,1333,1333,1333,
1333,1333,1333,1333,1333,1333,1333,1333,1333,-1000,
-1000,  -8,   6,1314,1399,-1000,-1000,-1000, 440,2073,
-1000,-1000,-1000,-1000,-1000,2042,-1000,2352,  60,  60,
-1000, 276,1039,1045, 364,1192,-1000, 449,1408,1482,
2352,2352,2011, 408, 259,1980,   6,1314,-1000,-1000,
1314,-1000,-1000,-1000,-1000,1333, 299,-1000,1710, 912,
-1000,1949,-1000, 841,-1000,   6,1710,1314,   6,1918,
-1000,-1000 };
short yypgo[]={

   0, 642,  54,  37,   7, 449,   4, 639,   9,   5,
 637,  13,  57,  19, 632,  83,  28,  21,  34, 630,
 628,  66, 624, 622,  32, 619,  25, 581,  14, 618,
   3, 614,   2, 609, 598, 596,  45,  55,  81,   0,
  24, 595,  16,  11,  26,  38, 585,  18,  22, 578,
  27, 577,  17,  10,   1,  42, 648, 571,  36, 576,
 575, 574, 548,  15,   8,  39,  56, 546, 545, 544,
 541, 534, 528, 526, 524, 519, 517, 514, 512, 501,
 493, 467,  12, 455 };
short yyr1[]={

   0,  10,  10,  10,  10,  10,   1,   1,   1,   1,
   1,   2,   2,   4,   4,   4,   3,   3,   3,  67,
  60,  66,  68,   6,   6,   7,   7,   8,   8,   5,
   5,  24,  69,  24,  24,  70,  24,  25,  25,   9,
   9,  14,  14,  14,  14,  14,  14,  14,  13,  13,
  13,  13,  13,  13,  19,  19,  15,  15,  15,  16,
  16,  17,  17,  17,  71,  21,  21,  21,  72,  72,
  61,  61,  62,  62,  63,  63,  63,  63,  63,  20,
  20,  18,  18,  22,  22,  23,  23,  23,  23,  23,
  23,  23,  23,  26,  26,  26,  26,  58,  58,  58,
  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
  58,  56,  56,  57,  57,  64,  64,  27,  27,  27,
  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,
  27,  27,  27,  27,  47,  47,  47,  47,  47,  47,
  47,  52,  52,  52,  42,  42,  42,  42,  42,  44,
  44,  29,  29,  30,  31,  54,  73,  32,  32,  32,
  34,  34,  34,  34,  74,  34,  34,  76,  75,  33,
  33,  33,  33,  33,  33,  33,  33,  33,  33,  77,
  33,  33,  78,  33,  79,  33,  80,  33,  81,  33,
  36,  35,  35,  28,  28,  38,  38,  38,  38,  38,
  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,
  38,  38,  38,  38,  38,  38,  37,  37,  37,  37,
  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,
  37,  37,  37,  37,  37,  37,  37,  37,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,  41,  41,
  41,  41,  41,  41,  41,  55,  55,  40,  40,  40,
  40,  40,  40,  40,  43,  82,  46,  46,  46,  46,
  45,  53,  49,  83,  49,  65,  50,  51,  51,  48,
  48,  59,  59,  59,  12,  12,  12,  12,  12,  12,
  12,  11,  11 };
short yyr2[]={

   0,   1,   1,   1,   2,   1,   1,   1,   1,   1,
   5,   4,   2,   6,   5,   5,   5,   4,   4,   0,
   4,   0,   0,   3,   0,   1,   3,   3,   4,   2,
   0,   1,   0,   4,   2,   0,   4,   1,   3,   3,
   2,   1,   1,   1,   2,   1,   1,   1,   1,   2,
   2,   2,   2,   2,   1,   1,   4,   5,   2,   1,
   3,   1,   3,   0,   0,   5,   2,   2,   0,   2,
   2,   0,   1,   3,   1,   2,   2,   3,   3,   2,
   4,   1,   1,   2,   0,   1,   2,   2,   1,   1,
   1,   2,   3,   1,   2,   2,   2,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   2,   2,   1,   0,   2,   2,   4,   2,
   4,   6,   4,   4,   6,   1,   3,   2,   4,   2,
   2,   2,   2,   3,   1,   2,   0,   2,   2,   2,
   3,   0,   2,   2,   0,   2,   2,   4,   4,   0,
   2,   0,   2,   2,   0,   3,   0,   4,   2,   3,
   1,   1,   1,   2,   0,   5,   4,   0,   2,   2,
   1,   3,   3,   1,   1,   1,   3,   5,   3,   0,
   9,   3,   0,   4,   0,   4,   0,   5,   0,   4,
   1,   1,   3,   1,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   5,   2,   5,   3,   6,   1,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   5,   2,   5,   3,   6,   1,   0,   2,   2,
   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   4,   3,   3,   3,   3,   3,   1,
   1,   3,   1,   1,   1,   1,   1,   1,   4,   4,
   5,   5,   6,   6,   4,   1,   1,   1,   2,   2,
   3,   2,   3,   3,   4,   1,   1,   1,   2,   2,
   2,   2,   2,   0,   5,   1,   5,   3,   1,   1,
   0,   0,   1,   2,   1,   1,   2,   2,   2,   1,
   2,   3,   1 };
short yychk[]={

-1000, -10,  -1,  72,   0, 182,  74,  -9,  -4,  -3,
  -2,   1, -13, -27, -14, -57, -26,  80, -56, -12,
 -65,  97, -21, -15, 179, 123,  47,  24, -55,  50,
  52, 173,  40, -20, 156,  13, 178, 160,  73,  40,
 -27, -25,  72,  97, -57, -21, -15, 179,  80, -56,
 -24,  69,  70,  72,  -5, -50,  40, -65, -11,  42,
  46, -50,  40, -11, -65,  45, 179, -55, 123, -26,
  80, -27, -57,  97, -27, -57, 123, -58, -45,  54,
  55,  50,  52,  65,  64,  94,  92,  93,  91,  66,
  67,  40,  42,  46,  47,  95,  90,  70,  23,   9,
  44,  71, 180, -46,  97, -57, -56,  97,  97,  97,
 -22, -18, 179,  73,  80, -57,  73, -19, -18, 179,
  81,  -5,  70,  71,  72,  69, -37,   9, 160, -39,
  23, -43,  50,  52,  55,  54,  46,  47,  95,  30,
 -40, -41, -82,  86,  82,  83,  81,  84,  34,  80,
 -56,  24,  97, -57,  40, -28, -37,  73, -66,  -9,
 -13, 182, -57, -56,  41, -36, -51, -35, -48, -28,
 -49, -13,  97, -57, -56, -37,  50, -36,  41, 173,
 -26,  80,  45,  41,  41,  43,  97, -57, -44, -12,
  74, -23,  -9,  -4,  -3,  -2, 175, -56, -61,  69,
 -16, -17,  80,  73,  41, -66, -70, -24, -27, -69,
  70,  54,  55,  50,  52,  65,  64,  94,  92,  93,
  91,  66,  67,  90,  71,  68, -39,  42, 160,   9,
  23,  95,  42,  44, 180,  45,  40, -43, -53, -82,
 -13, -39, -39, -39, -39, -39, -39, -39, -39, -39,
 -43, -37, -13,  80,  24,  47, -58, -45,  40,  40,
  72, -36,  -6, 124, 125,  69, -64,  41, -59,  71,
 155,  71, -57, -47,  80, -12, -65,  43,  80,  41,
 -64, -27, -26, -44, -71,  72,  72,  69, -26,  73,
 -62, -63, -18, 175,  97,  74,  71,  70, -16,  72,
  -6, 124, 125, -28, -37, -37, -37, -37, -37, -37,
 -37, -37, -37, -37, -37, -37, -37, -37, -37, -37,
 -37, -37, -39,  42, -43, -53, -82, -37, -40, -57,
 -39, -40, -57, -36, -36, -52, -12,  41, -42, -12,
  40, -58, -45, -18, -36, -36,  74, -32,  73, -68,
  97,  41, -48, 155, -28, -11, -50,  70, -57, -47,
 -47,  41,  41, -72,  72,  71, -18,  97, -18, 175,
 -17, -37,  74, -32,  69,  43, -37, -36,  43,  41,
  41, -11, -52, -11,  41, -42, -42,  41,  41, -73,
  74, 256,  -7,  -8,  40, -18, -64, -83,  41, -50,
 -50, -60, 127, -63, -18, -18, -37, -39,  43,  41,
 -43, -53, -82,  41, -29,  74,  71, -36,  40, -28,
 -67, -39, -43, -53, -50, -11, -30,  74, -31,  -8,
  41, -36,  -6, -33, -34,  72,  28,  97,  -9,  -4,
 -32,  20,  39,  16,  33,  80, 123,   4,   8, -38,
   3,   7,  19,  10,   1,   9, 160, -39,  41, -32,
 -75, -76, -37,  81, -54,  40, -54,  40, -54,  69,
  69, -80,  69,  70,  54,  55,  50,  52,  65,  64,
  94,  92,  93,  91,  66,  67,  90,  71,  68,  80,
 -74,  40, -39,  42,   9,  72,  72, -32, -30, -37,
 -30, -77, -30, -78, -79, -37, -81, -38, -38, -38,
 -38, -38, -38, -38, -38, -38, -38, -38, -38, -38,
 -38, -38, -38, -30,  81, -37, -39,  42,  12,  41,
 -30, -30, -30,  69, -30,  69,  39,  41,  43, -37,
 -30, -37, -30, -38, -54, -39,  43,  72, -39, -37,
  41, -30 };
short yydef[]={

   0,  -2,   1,   2,   3,  42,   5,   6,   7,   8,
   9,   0,   0,  30,  48,  43, 135,  93,   0,   0,
   0,  41,  45,  46,  47, 124,   0,   0, 121, 314,
 315, 319, 305,  84,   0,   0, 285, 286,   4,   0,
  -2,   0,  40,  49,  50,  51,  52,  53,  93,   0,
  37, 247, 247,  12,  21, 127, 305,  -2, 142, 247,
 322, 129,  -2, 141, 310,   0,  44, 122, 123, 137,
  93, 139, 140, 317,   0,   0,  94,  95,  96,  97,
  98,  99, 100, 101, 102, 103, 104, 105, 106, 107,
 108,   0,   0, 111, 112, 113, 114, 115, 116, 117,
 118, 119, 120, 159, 296, 297,   0, 316, 318, 320,
   0,  -2,  67,  79,  81,  82,  63,  58,  54,  55,
   0,  21,  35,   0,  39,  32,  34,   0, 286, 246,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 269, 270, 247, 272, 273, 274, 275, 276, 277, 287,
   0,   0,   0,   0, 295,   0, 203, 247,  24,  29,
   0,  42,  43,   0, 125,   0, 311, 200, 308, 201,
 309, 146,  41,  43,   0,   0,   0,   0, 125,   0,
 136,  93,   0, 143, 109, 110, 298, 299, 300, 159,
  64,  83,  85,  89,  88,  90,   0,   0,   0,   0,
   0,  59,  61,  63,   0,  24, 247,  38,  31, 247,
 247, 247, 247, 247, 247, 247, 247, 247, 247, 247,
 247, 247, 247, 247, 247, 247, 242, 247, 286,   0,
   0, 252, 247,   0,   0,   0, 247, 248, 249, 247,
 151, 253, 254, 255, 256, 257, 258, 259, 260, 261,
 262,   0, 154, 288,   0,   0, 289, 291, 247, 247,
  11,   0,   0,  17,  18,  22, 128, 130,   0, 310,
 312, 247,  50, 302, 144, 146, 146, 321, 287, 132,
 133,   0, 138, 160,  68,  86,  87,  91, 137,  80,
  70,  72,  74,   0,   0,  56,  63, 247,   0,  10,
   0,  14,  15,  36,  33, 226, 227, 228, 229, 230,
 231, 232, 233, 234, 235, 236, 237, 238, 239, 240,
   0,   0, 244, 247, 250, 251, 247,   0, 264, 266,
 265, 267, 268,   0,   0, 301, 151, 271,   0, 154,
 154, 290, 292, 293,   0,   0, 204,  16,  -2,   0,
 126, 125, 307, 313, 202, 148, 149, 303, 145, 147,
   0,   0,   0,  65,  92,   0,  75,   0,  76,   0,
  60,  62,  57,  13, 247,   0,   0,   0, 263, 284,
   0, 153, 152, 156, 294, 155,   0, 278, 279, 161,
 168,   0,  23,  25, 247,   0, 306, 247, 150, 131,
 134,  69,  19,  73,  77,  78, 241, 243,   0,   0,
 280, 281,   0,   0, 164, 169,   0,   0, 247, 304,
  24, 245, 282, 283, 157, 158, 162, 167,   0,  26,
  27,   0,   0, 163, 177, 180, 247,  41, 183, 184,
 185,   0,   0,   0,   0, 287, 124, 196,   0, 170,
 171, 172,   0, 174,   0,   0, 286, 225,  28,  20,
 179,   0,   0,   0, 164, 247, 164, 189, 164, 192,
 194, 247, 198,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 173,
 164,   0, 221, 247,   0, 178, 181, 182, 186,   0,
 188, 164, 191, 164, 164,   0, 164, 205, 206, 207,
 208, 209, 210, 211, 212, 213, 214, 215, 216, 217,
 218, 219,   0,   0,   0,   0, 223, 247, 164, 165,
 247, 193, 195, 164, 199,   0,   0, 176,   0,   0,
 187,   0, 197, 220, 175, 222,   0, 247, 224,   0,
 164, 190 };
# ifdef YYDEBUG
# include "y.debug"
# endif

# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse()
{	short yys[YYMAXDEPTH];
	int yyj, yym;
	register YYSTYPE *yypvt;
	register int yystate, yyn;
	register short *yyps;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

yystack:    /* put a state and value onto the stack */
#ifdef YYDEBUG
	if(yydebug >= 3)
		if(yychar < 0 || yytoknames[yychar] == 0)
			printf("char %d in %s", yychar, yystates[yystate]);
		else
			printf("%s in %s", yytoknames[yychar], yystates[yystate]);
#endif
	if( ++yyps >= &yys[YYMAXDEPTH] ) { 
		yyerror( "yacc stack overflow" ); 
		return(1); 
	}
	*yyps = yystate;
	++yypv;
	*yypv = yyval;
yynewstate:
	yyn = yypact[yystate];
	if(yyn <= YYFLAG) goto yydefault; /* simple state */
	if(yychar<0) {
		yychar = yylex();
#ifdef YYDEBUG
		if(yydebug >= 2) {
			if(yychar <= 0)
				printf("lex EOF\n");
			else if(yytoknames[yychar])
				printf("lex %s\n", yytoknames[yychar]);
			else
				printf("lex (%c)\n", yychar);
		}
#endif
		if(yychar < 0)
			yychar = 0;
	}
	if((yyn += yychar) < 0 || yyn >= YYLAST)
		goto yydefault;
	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
	}
yydefault:
	/* default state action */
	if( (yyn=yydef[yystate]) == -2 ) {
		if(yychar < 0) {
			yychar = yylex();
#ifdef YYDEBUG
			if(yydebug >= 2)
				if(yychar < 0)
					printf("lex EOF\n");
				else
					printf("lex %s\n", yytoknames[yychar]);
#endif
			if(yychar < 0)
				yychar = 0;
		}
		/* look through exception table */
		for(yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate);
			yyxi += 2 ) ; /* VOID */
		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
		}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
	}
	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */
		switch( yyerrflag ){
		case 0:   /* brand new error */
#ifdef YYDEBUG
			yyerror("syntax error\n%s", yystates[yystate]);
			if(yytoknames[yychar])
				yyerror("saw %s\n", yytoknames[yychar]);
			else if(yychar >= ' ' && yychar < '\177')
				yyerror("saw `%c'\n", yychar);
			else if(yychar == 0)
				yyerror("saw EOF\n");
			else
				yyerror("saw char 0%o\n", yychar);
#else
			yyerror( "syntax error" );
#endif
yyerrlab:
			++yynerrs;
		case 1:
		case 2: /* incompletely recovered error ... try again */
			yyerrflag = 3;
			/* find a state where "error" is a legal shift action */
			while ( yyps >= yys ) {
				yyn = yypact[*yyps] + YYERRCODE;
				if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
					yystate = yyact[yyn];  /* simulate a shift of "error" */
					goto yystack;
				}
				yyn = yypact[*yyps];
				/* the current yyps has no shift onn "error", pop stack */
#ifdef YYDEBUG
				if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
				--yyps;
				--yypv;
			}
			/* there is no state on the stack with an error shift ... abort */
yyabort:
			return(1);
		case 3:  /* no shift yet; clobber input char */
#ifdef YYDEBUG
			if( yydebug ) {
				printf("error recovery discards ");
				if(yytoknames[yychar])
					printf("%s\n", yytoknames[yychar]);
				else if(yychar >= ' ' && yychar < '\177')
					printf("`%c'\n", yychar);
				else if(yychar == 0)
					printf("EOF\n");
				else
					printf("char 0%o\n", yychar);
			}
#endif
			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */
		}
	}
	/* reduction by production yyn */
#ifdef YYDEBUG
	if(yydebug) {	char *s;
		printf("reduce %d in:\n\t", yyn);
		for(s = yystates[yystate]; *s; s++) {
			putchar(*s);
			if(*s == '\n' && *(s+1))
				putchar('\t');
		}
	}
#endif
	yyps -= yyr2[yyn];
	yypvt = yypv;
	yypv -= yyr2[yyn];
	yyval = yypv[1];
	yym=yyn;
	/* consult goto table to find next state */
	yyn = yyr1[yyn];
	yyj = yypgo[yyn] + *yyps + 1;
	if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
	switch(yym){
		
case 1:
# line 415 "gram.y"
{	return 2; } break;
case 2:
# line 416 "gram.y"
{	return 1; } break;
case 3:
# line 417 "gram.y"
{	return 0; } break;
case 4:
# line 419 "gram.y"
{
				set_linkage(yypvt[-1].s);
				bl_level--;
				return 1;
			} break;
case 5:
# line 425 "gram.y"
{
				set_linkage(0);
				bl_level++;
				return 1;
			} break;
case 6:
# line 433 "gram.y"
{	
			/* if function declartion with arguments
			 * need to make sure modified_tn is traversed */
			if ( yypvt[-0].pn != 0 
				&& yypvt[-0].pn->tp->base == FCT 
				&& Pfct(yypvt[-0].pn->tp)->nargs !=0 ) 
					goto mod;
			else {
				modified_tn = 0;
				curr_scope = 0;
				if (yypvt[-0].pn==0) yyval.i = 1; 
			     }
			} break;
case 7:
# line 447 "gram.y"
{	goto mod; } break;
case 8:
# line 449 "gram.y"
{	goto mod; } break;
case 9:
# line 451 "gram.y"
{ mod:	if (modified_tn) {
					restore();
					modified_tn = 0;
				}
				local_blk = 0;
				curr_scope = 0;
				if (local_tn) {
					local_restore();
					local_tn = 0;
				}
				
				if (nested_tn) { // x::f(){}
					nested_restore();
					nested_tn = 0;
					nested_type = 0;
				}
			} break;
case 10:
# line 469 "gram.y"
{	Pname n = new name(make_name('A'));
				n->tp = new basetype(ASM,0);
				Pbase(n->tp)->b_name = Pname(yypvt[-2].s);
				yyval.p = n;
			} break;
case 11:
# line 477 "gram.y"
{
				err_name = yypvt[-3].pn;
				if(err_name) err_name->n_initializer = yypvt[-1].pe;
				goto fix;
			} break;
case 12:
# line 483 "gram.y"
{
				Ptype t;
				err_name = yypvt[-1].pn;
			fix:
				if (err_name == 0) {
					error("syntax error:TX");
					yyval.p = Ndata(defa_type,err_name);
				}
				else if ((t=err_name->tp) == 0) {
					error("TX for%n",err_name);
					yyval.p = Ndata(defa_type,err_name);
				}
				else if (t->base==FCT) {
					if (Pfct(t)->returns==0)
						yyval.p = Nfct(defa_type,err_name,0);
					else
						yyval.p = Ndata(0,err_name);
				}
				else {
					error("syntax error:TX for%k%n",t->base,err_name);
					yyval.p = Ndata(defa_type,err_name);
				}
			} break;
case 13:
# line 509 "gram.y"
{	Pname n = Nfct(yypvt[-5].p,yypvt[-4].pn,yypvt[-0].p);
				Fargdcl(n->tp,name_unlist(yypvt[-3].nl),n);
				Finit(n->tp) = yypvt[-1].pn;
				yyval.p = n;
				NOT_EXPECT_ID();
			//???POP_SCOPE(); // undef arg names
			} break;
case 14:
# line 517 "gram.y"
{
				Pname n = Nfct(yypvt[-4].p,yypvt[-3].pn,dummy);
				Fargdcl(n->tp,name_unlist(yypvt[-2].nl),n);
				yypvt[-0].q->retval.pn = n;
				yyval.p = n;
				NOT_EXPECT_ID();
			} break;
case 15:
# line 525 "gram.y"
{
				error(&yypvt[-3].pn->where,"syntax error -- did you forget a ';'?");
				Pname n = Nfct(yypvt[-4].p,yypvt[-3].pn,0);
				yyval.p = n;
				NOT_EXPECT_ID();
			//???POP_SCOPE(); // undef arg names
			} break;
case 16:
# line 535 "gram.y"
{	Pname n = Nfct(defa_type,yypvt[-4].pn,yypvt[-0].p);
				Fargdcl(n->tp,name_unlist(yypvt[-3].nl),n);
				if ( yypvt[-1].pn && yypvt[-1].pn->n_list && 
     					ccl && ccl->csu == UNION )  
						error( "multiple initializers in unionK %s::%n", yypvt[-4].pn->string, yypvt[-4].pn );
				Finit(n->tp) = yypvt[-1].pn;
				yyval.p = n;
				NOT_EXPECT_ID();
			//???POP_SCOPE(); // undef arg names
			} break;
case 17:
# line 546 "gram.y"
{
				Pname n = Nfct(defa_type,yypvt[-3].pn,dummy);
				Fargdcl(n->tp,name_unlist(yypvt[-2].nl),n);
				yypvt[-0].q->retval.pn = n;
				yyval.p = n;
				NOT_EXPECT_ID();
			} break;
case 18:
# line 554 "gram.y"
{
				error(&yypvt[-3].pn->where,"badD of%n -- did you forget a ';'?",yypvt[-3].pn);
				Pname n = Nfct(defa_type,yypvt[-3].pn,0);
				yyval.p = n;
				NOT_EXPECT_ID();
			//???POP_SCOPE(); // undef arg names
			} break;
case 19:
# line 564 "gram.y"
{// PUSH_ARG_SCOPE
			arg_redec(yypvt[-0].pn);
		   } break;
case 20:
# line 568 "gram.y"
{
				Finit(yypvt[-3].pn->tp) = yypvt[-1].pn;
				Pfct(yypvt[-3].pn->tp)->body = Pblock(yypvt[-0].p);
				yyval.pn = yypvt[-3].pn;
				NOT_EXPECT_ID();
			//???POP_SCOPE(); // undef arg names
			} break;
case 21:
# line 579 "gram.y"
{
			// if parsing implicit inline def, save body
			//   of function for parsing after class def
			switch ( NEXTTOK() ) {
			case LC: case COLON:
				if ( in_class_decl ) {
					// mem or friend inline def
					// save text of mem_init & ftn
					la_backup(yychar,yylval);
					// yylval used as dummy...
					la_backup(FDEF, yylval);
					if ( yylval.q = save_text() )
						yychar = EMPTY;
					else { // syntax error
						// just parse in place
						yylex(); // FDEF
						yychar = yylex();
					}
				} // if in_class_decl
				break;
			default:
				la_backup(yychar,yylval);
				yychar = NO_ID; // 'graceful' recovery
				break;
			}
		   } break;
case 22:
# line 607 "gram.y"
{ ++in_binit_list; } break;
case 23:
# line 608 "gram.y"
{	
				yyval.p = yypvt[-0].p; 
				in_arg_list = 0;
				--in_binit_list;
			} break;
case 24:
# line 614 "gram.y"
{	yyval.p = 0; } break;
case 25:
# line 618 "gram.y"
{ yyval.p = yypvt[-0].p; } break;
case 26:
# line 620 "gram.y"
{ yyval.pn = yypvt[-0].pn;  yyval.pn->n_list = yypvt[-2].pn; } break;
case 27:
# line 624 "gram.y"
{
				yyval.pn = new name;
				yyval.pn->n_initializer = yypvt[-1].pe;
			} break;
case 28:
# line 629 "gram.y"
{
				Pname n = Ncopy(yypvt[-3].pn);
				n->base = yypvt[-3].pn->base;
				n->tp = yypvt[-3].pn->tp;
				n->n_initializer = yypvt[-1].pe;
				yyval.pn = n;
			} break;
case 29:
# line 653 "gram.y"
{	if (yypvt[-0].pn == 0)
					error("badAD");
				else if (yypvt[-0].pn->tp->base == FCT)
					error("FD inAL (%n)",yypvt[-0].pn);
				else if (yypvt[-1].p)
                                        yypvt[-1].nl->add_list(yypvt[-0].pn);
				else
					yyval.nl = new nlist(yypvt[-0].pn);
			} break;
case 30:
# line 663 "gram.y"
{
                                yyval.p = 0; 
			} break;
case 32:
# line 670 "gram.y"
{
				if ( in_typedef ) {
					error("Tdef field");
					in_typedef = 0;
				}
			//	ENTER_NAME(yypvt[-1].pn);
			} break;
case 33:
# line 678 "gram.y"
{	yyval.p = yypvt[-3].pn;
				yyval.pn->tp = new basetype(FIELD,yypvt[-0].pn);
		 	} break;
case 34:
# line 682 "gram.y"
{	yyval.p = new name;
				yyval.pn->tp = new basetype(FIELD,yypvt[-0].pn);
				if ( in_typedef ) {
					error("Tdef field");
					in_typedef = 0;
				}
			} break;
case 35:
# line 690 "gram.y"
{
			//	ENTER_NAME(yypvt[-1].pn);
			} break;
case 36:
# line 694 "gram.y"
{	Pexpr e = yypvt[-0].pe;
				if (e == dummy) error("emptyIr");
				yypvt[-3].pn->n_initializer = e;
				init_seen = 0;
			} break;
case 37:
# line 702 "gram.y"
{	
				if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); 
				if ( NEXTTOK() == CM && la_look() == TNAME ) 
					EXPECT_ID();
			} break;
case 38:
# line 708 "gram.y"
{	if (yypvt[-2].p)
					if (yypvt[-0].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else
						error("DL syntax");
				else {
					if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn);
					error("DL syntax");
				}
				if ( NEXTTOK() == CM && la_look() == TNAME ) 
					EXPECT_ID();
			} break;
case 39:
# line 723 "gram.y"
{ 
				extern int co_hack;
				co_hack = 1;
				/*$$ = Ndata($1,name_unlist($<nl>2));*/
				Pname n = Ndata(yypvt[-2].p,name_unlist(yypvt[-1].nl)); 
				if ( in_typedef && in_tag ) { 
					if ( n->tp->check( in_tag->tp, 0 ))
    						error("%nredefined: previous: %t now: %t", in_tag, in_tag->tp, n->tp );
				}
				in_typedef = 0;
				class_typedef = 0;
				in_tag = 0;
				co_hack = 0;
				DECL_TYPE = 0; 
				yyval.p = n;
			} break;
case 40:
# line 740 "gram.y"
{
				yyval.p = yypvt[-1].pb->aggr(); 
				in_typedef = 0;
				class_typedef = 0;
				in_tag = 0;
				DECL_TYPE = 0; 
			} break;
case 41:
# line 751 "gram.y"
{ 
				yyval.p = new basetype(yypvt[-0].t,0); 
				if ( yypvt[-0].t == TYPEDEF ) in_typedef = yyval.pt;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 42:
# line 757 "gram.y"
{	yyval.p = new basetype(EXTERN,0);
				yyval.pb->b_linkage = yypvt[-0].s;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 43:
# line 762 "gram.y"
{ 
				yyval.p = new basetype(TYPE,yypvt[-0].pn); 
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 44:
# line 767 "gram.y"
{ // modified tn_list TNAME
				yyval.p = new basetype(TYPE,yypvt[-0].pn);
				//xxx qualifier currently ignored...
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 47:
# line 775 "gram.y"
{ 
				if (DECL_TYPE == TNAME)
					yyval.p = new basetype(TYPE,yypvt[-0].pn); 
		//	else if (DECL_TYPE == TSCOPE)
		//	yyval.p = 0;
				else
				if (DECL_TYPE == 0 &&
					yypvt[-0].p->base == TNAME)
						yyval.p = new basetype(TYPE,yypvt[-0].pn); 
				else
					yyval.p = new basetype(yypvt[-0].t,0); 
				DECL_TYPE = -1;
			} break;
case 49:
# line 792 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) 
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t); 
				DECL_TYPE = 0;
			} break;
case 50:
# line 798 "gram.y"
{
//error('d',"decl_type: %d  $1: %t  $2: %n",DECL_TYPE,yypvt[-1].pb,yypvt[-0].pn);
				if ( DECL_TYPE != -1 ) 
			 		yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn);
			/*XXX*/	else if(yypvt[-1].pb==0) yyval.p=new basetype(TYPE,yypvt[-0].pn);
				DECL_TYPE = 0;
			} break;
case 51:
# line 805 "gram.y"
{ yyval.p = yypvt[-1].pb->base_adj(yypvt[-0].pb); } break;
case 52:
# line 806 "gram.y"
{ yyval.p = yypvt[-1].pb->base_adj(yypvt[-0].pb); } break;
case 53:
# line 808 "gram.y"
{ 
				if (DECL_TYPE == TYPE)
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t);  
			/*XXX*/	else if (DECL_TYPE == TSCOPE) {
			/*XXX*/		error('i',"type decl_marker(tscope)");
			/*XXX*/	//	yyval.p = yypvt[-1].p;//ignore(?)
			/*XXX*/	}
				else
					yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn); 
				DECL_TYPE = -1;
			} break;
case 54:
# line 824 "gram.y"
{ enumcheck:
			Ptype tx = yypvt[-0].pn->tp;
			yyval.p = yypvt[-0].p;
			if ( tx->base == TYPE ) {
				yyval.p = Pbase(tx)->b_name;
				tx = yyval.pn->tp;
				if ( tx->base != EOBJ
				||   strcmp(yyval.pn->string,yypvt[-0].pn->string)
				)
					error("%n of type%t redeclared as enum.",yypvt[-0].pn,tx);
			} else if ( tx->base != EOBJ )
				error("%n of type%t redeclared as enum",yypvt[-0].pn,tx);
		} break;
case 55:
# line 837 "gram.y"
{ goto enumcheck; } break;
case 56:
# line 840 "gram.y"
{ yyval.p = end_enum(0,yypvt[-1].pn); } break;
case 57:
# line 841 "gram.y"
{ yyval.p = end_enum(yypvt[-3].pn,yypvt[-1].pn); } break;
case 58:
# line 842 "gram.y"
{ yyval.pb = (Pbase)yypvt[-0].pn->tp; } break;
case 59:
# line 846 "gram.y"
{	if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); } break;
case 60:
# line 848 "gram.y"
{	if( yypvt[-0].p)
					if (yypvt[-2].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else
						yyval.nl = new nlist(yypvt[-0].pn);
			} break;
case 61:
# line 857 "gram.y"
{	yyval.p = yypvt[-0].pn; yyval.pn->tp = moe_type; } break;
case 62:
# line 859 "gram.y"
{	yyval.p = yypvt[-2].pn;
				yyval.pn->tp = moe_type;
				yyval.pn->n_initializer = yypvt[-0].pe;
			} break;
case 63:
# line 864 "gram.y"
{	yyval.p = 0; } break;
case 64:
# line 868 "gram.y"
{	parsing_class_members = 0;
				switch ( NEXTTOK() ) {
				case TYPE: case AGGR: case ENUM: case EOFTOK:
					error("`;' or declaratorX afterCD");
					la_backup(yychar,yylval);
					yychar = SM;
					break;
				}
				la_backup(yychar,yylval);
				yychar = -1;
				restore_text();
				++bl_level; // scope weirdness!
				++in_mem_fct;
			} break;
case 65:
# line 883 "gram.y"
{
				--in_mem_fct;
				--bl_level; // scope weirdness!
				if ( yychar == ID ) {
					// (yuk!) adjust lex level
					--yylval.pn->lex_level;
				}
				ccl->mem_list = name_unlist(yypvt[-3].nl);
				if ( --in_class_decl )  // nested class
					// continue to parse enclosing class
					parsing_class_members = 1;
				ccl->nest_list = nested_type;
				if ( nested_tn ) nested_restore();
				nested_type = nested_type_vec[in_class_decl];
				nested_tn = nested_tn_vec[in_class_decl];
				end_cl();
				declTag = 1;
			//POP_SCOPE();
			} break;
case 66:
# line 903 "gram.y"
{ aggrcheck:
				yyval.pb = (Pbase)yypvt[-0].pn->tp; 
				if ( yyval.p->base == TYPE ) {
					Pname nx = yyval.pb->b_name;
					yyval.pb = (Pbase)nx->tp;
					if ( yyval.p->base != COBJ
					||   strcmp(nx->string,yypvt[-0].pn->string)
					)
						error("%n of type%t redeclared as%k.",yypvt[-0].pn,yyval.pb,yypvt[-1].t);
				} else if ( yyval.p->base != COBJ )
					error("%n of type%t redeclared as%k",yypvt[-0].pn,yyval.pb,yypvt[-1].t);
				check_tag();
			} break;
case 67:
# line 918 "gram.y"
{
				goto aggrcheck;
			} break;
case 70:
# line 928 "gram.y"
{ yyval.pbc = yypvt[-0].pbc; } break;
case 71:
# line 929 "gram.y"
{ yyval.pbc = 0; } break;
case 73:
# line 934 "gram.y"
{	if (yypvt[-0].pbc) { yyval.pbc = yypvt[-0].pbc; yyval.pbc->next = yypvt[-2].pbc; } } break;
case 74:
# line 937 "gram.y"
{ yyval.pbc = dobase(0,yypvt[-0].pn); } break;
case 75:
# line 938 "gram.y"
{ yyval.pbc = dobase(yypvt[-1].t,yypvt[-0].pn); } break;
case 76:
# line 939 "gram.y"
{ yyval.pbc = dobase(0,yypvt[-0].pn,yypvt[-1].t); } break;
case 77:
# line 940 "gram.y"
{ yyval.pbc = dobase(yypvt[-2].t,yypvt[-0].pn,yypvt[-1].t); } break;
case 78:
# line 941 "gram.y"
{ yyval.pbc = dobase(yypvt[-1].t,yypvt[-0].pn,yypvt[-2].t); } break;
case 79:
# line 945 "gram.y"
{//PUSH_CLASS_SCOPE(0);
			 	parsing_class_members = 1;
				yyval.p = start_cl(yypvt[-1].t,0,0); 
				nested_tn_vec[in_class_decl] = nested_tn;
				nested_type_vec[in_class_decl++] = nested_type;
				nested_tn = nested_type = 0;
			} break;
case 80:
# line 954 "gram.y"
{//PUSH_CLASS_SCOPE(yypvt[-2].pn->string);
			 	parsing_class_members = 1;
				yyval.p = start_cl(yypvt[-3].t,yypvt[-2].pn,yypvt[-1].pbc);
				nested_tn_vec[in_class_decl] = nested_tn;
				nested_type_vec[in_class_decl++] = nested_type;
				nested_tn = nested_type = 0;
			} break;
case 81:
# line 963 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 82:
# line 964 "gram.y"
{ yyval.p=yypvt[-0].p; } break;
case 83:
# line 968 "gram.y"
{
				if (yypvt[-0].p) {
					if (yypvt[-1].p)
						yypvt[-1].nl->add_list(yypvt[-0].pn);
					else
						yyval.nl = new nlist(yypvt[-0].pn);
				}
			} break;
case 84:
# line 977 "gram.y"
{	yyval.p = 0; } break;
case 91:
# line 987 "gram.y"
{	yyval.p = new name;
				yyval.pn->base = yypvt[-1].t;
			} break;
case 92:
# line 997 "gram.y"
{	Pname n = Ncopy(yypvt[-1].pn);
				if (n->n_oper == TYPE) {
					error('s',"visibilityD for conversion operator");
					// n->tp = Ptype(n->n_initializer);
					n->tp = Ptype(n->cond);
					n->cond = 0;
					// n->n_initializer = 0;
					n->n_oper = 0;
					sig_name(n);
				}
				n->n_qualifier = yypvt[-2].pn;
				n->base = PR;
				yyval.p = n;
			} break;
case 93:
# line 1026 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 94:
# line 1028 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = DTOR;
			} break;
case 95:
# line 1032 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
			} break;
case 96:
# line 1036 "gram.y"
{	Pname n = yypvt[-0].pn;
				n->string = "_type";
				n->n_oper = TYPE;
				n->cond = Pexpr(n->tp);
				// n->n_initializer = Pexpr(n->tp);
				n->tp = 0;
				yyval.p = n;
			} break;
case 109:
# line 1058 "gram.y"
{	yyval.t = CALL; } break;
case 110:
# line 1059 "gram.y"
{	yyval.t = DEREF; } break;
case 116:
# line 1065 "gram.y"
{	yyval.t = NEW; } break;
case 117:
# line 1066 "gram.y"
{	yyval.t = DELETE; } break;
case 118:
# line 1067 "gram.y"
{	yyval.t = REF; } break;
case 119:
# line 1068 "gram.y"
{	yyval.t = CM; } break;
case 120:
# line 1069 "gram.y"
{	yyval.t = REFMUL;
					if (yypvt[-0].t == DOT) error(".* cannot be overloaded");
				} break;
case 121:
# line 1075 "gram.y"
{   if ( yypvt[-0].pn != sta_name ) {
// error('d',"tn_list: tscope: pn1: %s", yypvt[-0].pn->string);
				Ptype t = yypvt[-0].pn->tp;
				while ( t->base == TYPE )
					t = Pbase(t)->b_name->tp;
				Pname n = Pbase(t)->b_name;
				if (NEXTTOK() == TNAME
				&& strcmp(n->string,yylval.pn->string)==0){
					// ctor -- change to ID to avoid
					//    parsing as type spec
					yychar = ID;
					yylval.pn = Ncopy(yylval.pn);
					yylval.pn->n_oper = TNAME;
				}
			    }
			    yyval.pn = yypvt[-0].pn;
			} break;
case 122:
# line 1093 "gram.y"
{ error('s', "CNs do not nest, use typedef x::y y_in_x"); } break;
case 123:
# line 1098 "gram.y"
{	yyval.pn = yypvt[-0].pn;
				//xxx qualifier currently ignored...
				// yyval.pn = Ncopy( yypvt[-0].pn );
				// yyval.pn->n_oper = TNAME;
				// yyval.pn->n_qualifier = yypvt[-1].pn;
			} break;
case 124:
# line 1105 "gram.y"
{	yyval.pn = yypvt[-0].pn;
			//	yyval.pn = Ncopy( yypvt[-0].pn );
			//	yyval.pn->n_oper = TNAME;
			} break;
case 125:
# line 1112 "gram.y"
{ yyval.i = 0; } break;
case 126:
# line 1114 "gram.y"
{ /* const/volatile function */
				switch ( yypvt[-0].t ) {
				case VOLATILE:
					error('s',"volatile functions");
					break;
				case CONST:
					yyval.i = (yypvt[-1].i | 1);
					break;
				default:
					if ( NEXTTOK() != SM
					&&   yychar != COLON
					&&   yychar != LC ) {
						la_backup(yychar,yylval);
						yylval.t = yypvt[-0].t;
						la_backup(TYPE,yylval);
						yylval.t = SM;
						yychar = SM;
						error("syntax error: unexpected%k (did you forget a `;'?)",yypvt[-0].t);
					} else error("FD syntax: unexpected%k",yypvt[-0].t);
					break;
				}
 			} break;
case 127:
# line 1139 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = yypvt[-0].pt;
			} break;
case 128:
# line 1143 "gram.y"
{ /* function with no argument */
 				yypvt[-3].pn->tp = new fct(yypvt[-3].pn->tp,0,1);
 				Pfct(yypvt[-3].pn->tp)->f_const = (yypvt[-0].i & 1);
 			} break;
case 129:
# line 1148 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = Ncopy(n);
			//??? what if tname is qualified ???
				if (ccl && strcmp(n->string,ccl->string)) n->hide();
				yyval.pn->n_oper = TNAME;
				Freturns(yypvt[-0].p) = yyval.pn->tp;
				yyval.pn->tp = yypvt[-0].pt;
			} break;
case 130:
# line 1161 "gram.y"
{	
				yypvt[-3].pn->tp = new fct(yypvt[-3].pn->tp,yypvt[-1].pn,1); 
 				in_arg_list = 0;
 				end_al(yypvt[-2].pl,0);
 			//POP_SCOPE(); // similar to end_al()
			} break;
case 131:
# line 1168 "gram.y"
{
				Pptr p = new ptr( PTR, 0 );
				Ptyp(p) = new basetype(TYPE,yypvt[-5].pn);
				Freturns( yypvt[-0].p ) = Ptype(p);
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].pn;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 132:
# line 1177 "gram.y"
{	yyval.p = Ncopy(yypvt[-3].pn);
				yyval.pn->n_oper = TNAME;
				yyval.pn->tp = new fct(0,yypvt[-1].pn,1);
			} break;
case 133:
# line 1182 "gram.y"
{ /* function with no argument */
				yyval.p = Ncopy(yypvt[-3].pn);
 				yyval.pn->n_oper = TNAME;
 				yyval.pn->tp = new fct(0,0,1);
 				Pfct(yypvt[-3].pn->tp)->f_const = (yypvt[-0].i & 1);
			} break;
case 134:
# line 1189 "gram.y"
{	memptrdcl(yypvt[-3].pn,yypvt[-5].pn,yypvt[-0].pt,yypvt[-2].pn);
				yyval.p = yypvt[-2].p;
			} break;
case 136:
# line 1194 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
				error(strict_opt?0:'w',"`.' used for qualification; please use `::' (anachronism)");
			} break;
case 137:
# line 1199 "gram.y"
{	yyval.p = yypvt[-0].p;
				if ( yypvt[-1].pn != sta_name ) {
    					set_scope(yypvt[-1].pn); 
    					yyval.pn->n_qualifier = yypvt[-1].pn;
				}
			} break;
case 138:
# line 1206 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
				error(ansi_opt?0:'w',"anachronism `.' used for qualification; please use `::'");
				if ( yypvt[-3].pn != sta_name ) {
    					set_scope(yypvt[-3].pn); 
    					yypvt[-2].pn->n_qualifier = yypvt[-3].pn;
				}
			} break;
case 139:
# line 1224 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = yypvt[-1].pt;
				yyval.p = yypvt[-0].p;
			} break;
case 140:
# line 1229 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = TNAME;
				// cannot evaluate at this point: defer until data_dcl
				if ( in_typedef ) {
					defer_check = 1;
					in_tag = yypvt[-0].pn;
				}
				yypvt[-0].pn->hide();
				defer_check = 0;
				yyval.pn->tp = yypvt[-1].pt;
			} break;
case 141:
# line 1241 "gram.y"
{	yyval.p = Ncopy(yypvt[-1].pn);
				yyval.pn->n_oper = TNAME;
				if ( in_typedef ) {
     					defer_check = 1;
     					in_tag = yypvt[-0].pn;
				}
				yypvt[-1].pn->hide();
				defer_check = 0;
				yyval.pn->tp = yypvt[-0].pt;
			} break;
case 142:
# line 1252 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = yypvt[-0].pt;
			} break;
case 143:
# line 1269 "gram.y"
{ 
				yyval.p = yypvt[-1].p; 
				in_arg_list = 0;
				end_al(yypvt[-2].pl,0);
			//POP_SCOPE(); // similar to end_al()
			} break;
case 144:
# line 1278 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 145:
# line 1280 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = TNAME;
				yypvt[-0].pn->hide();
				yyval.pn->tp = yypvt[-1].pt;
			} break;
case 146:
# line 1286 "gram.y"
{	
				yyval.p = new name; 
				NOT_EXPECT_ID();
			} break;
case 147:
# line 1291 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
			} break;
case 148:
# line 1296 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 149:
# line 1300 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 150:
# line 1316 "gram.y"
{ 
// error('d', "arg_lp arg_decl rp in_arg_list: %d", in_arg_list );
				yyval.p = yypvt[-1].p; 
				in_arg_list = 0;
				end_al(yypvt[-2].pl,0);
			//POP_SCOPE(); // similar to end_al()
			} break;
case 151:
# line 1326 "gram.y"
{	yyval.p = new name; } break;
case 152:
# line 1328 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
                                NOT_EXPECT_ID();
			} break;
case 153:
# line 1334 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 154:
# line 1339 "gram.y"
{ yyval.p = new name; } break;
case 155:
# line 1341 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
				NOT_EXPECT_ID();
			} break;
case 156:
# line 1347 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 157:
# line 1351 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-2].pn->tp;
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].p;
			} break;
case 158:
# line 1356 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-2].pn->tp;
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].p;
			} break;
case 159:
# line 1363 "gram.y"
{	yyval.p = new name; } break;
case 160:
# line 1365 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
			} break;
case 161:
# line 1375 "gram.y"
{
				yyval.p = 0; 
			} break;
case 162:
# line 1379 "gram.y"
{	
				if (yypvt[-0].p)
					if (yypvt[-1].p)
						yypvt[-1].sl->add(yypvt[-0].ps);
					else {
						yyval.sl =  new slist(yypvt[-0].ps);
						stmt_seen = 1;
					}
			} break;
case 163:
# line 1390 "gram.y"
{
				yyval.p = yypvt[-0].p;
				if (yypvt[-0].p)	stmt_seen = 1;
			} break;
case 164:
# line 1397 "gram.y"
{
				yyval.p = 0;
				check_decl();
			} break;
case 165:
# line 1404 "gram.y"
{	yyval.p = yypvt[-1].p;
			/*	if ($<pe>$ == dummy) error("empty condition");*/
				stmt_seen = 1;
			} break;
case 166:
# line 1411 "gram.y"
{//PUSH_BLOCK_SCOPE
			 	cd_vec[cdi] = cd;
				stmt_vec[cdi] = stmt_seen;
				tn_vec[cdi] = modified_tn;
				lcl_blk_vec[cdi++] = local_blk;
				lcl_tn_vec[cdi] = local_tn;
				local_blk = 0;
				local_tn = 0;
				cd = 0;
				stmt_seen = 0;
				modified_tn = 0;
			} break;
case 167:
# line 1424 "gram.y"
{	Pname n = name_unlist(cd);
				Pstmt ss = stmt_unlist(yypvt[-1].sl);
				yyval.p = new block(yypvt[-3].l,n,ss,yypvt[-0].l);
				if ( local_tn ) local_restore();
				if ( local_blk ) local_name();
				if (modified_tn) restore();
				cd = cd_vec[--cdi];
				stmt_seen = stmt_vec[cdi];
				modified_tn = tn_vec[cdi];
				local_tn = lcl_tn_vec[cdi];
				local_blk = lcl_blk_vec[cdi];
				if (cdi < 0) error('i',"block level(%d)",cdi);
				NOT_EXPECT_ID();
			//POP_SCOPE(); // similar to end_al()
			} break;
case 168:
# line 1440 "gram.y"
{	yyval.p = new block(yypvt[-1].l,0,0,yypvt[-0].l); NOT_EXPECT_ID();} break;
case 169:
# line 1442 "gram.y"
{	yyval.p = new block(yypvt[-2].l,0,0,yypvt[-0].l); NOT_EXPECT_ID();} break;
case 170:
# line 1446 "gram.y"
{	yyval.p = new estmt(SM,curloc,yypvt[-0].pe,0);	} break;
case 171:
# line 1448 "gram.y"
{	yyval.p = new stmt(BREAK,yypvt[-0].l,0); } break;
case 172:
# line 1450 "gram.y"
{	yyval.p = new stmt(CONTINUE,yypvt[-0].l,0); } break;
case 173:
# line 1452 "gram.y"
{	yyval.p = new lstmt(GOTO,yypvt[-1].l,yypvt[-0].pn,0); } break;
case 174:
# line 1453 "gram.y"
{ stmt_seen=1; } break;
case 175:
# line 1454 "gram.y"
{	yyval.p = new estmt(DO,yypvt[-4].l,yypvt[-0].pe,yypvt[-2].ps); } break;
case 176:
# line 1456 "gram.y"
{	
				if (stmt_seen)
					yyval.p = new estmt(ASM,curloc,(Pexpr)yypvt[-1].s,0);
				else {
					Pname n = new name(make_name('A'));
					n->tp = new basetype(ASM,(Pname)yypvt[-1].s);
					if (cd)
						cd->add_list(n);
					else
						cd = new nlist(n);
					yyval.p = 0;
				}
			} break;
case 177:
# line 1471 "gram.y"
{
			if ( NEXTTOK() != SM ) {
				error("`;' missing afterS");
				la_backup(yychar,yylval);
				yychar = SM;
			}
		  } break;
case 180:
# line 1482 "gram.y"
{	yyval.p = new estmt(SM,yypvt[-0].l,dummy,0); } break;
case 181:
# line 1484 "gram.y"
{	yyval.p = new estmt(RETURN,yypvt[-2].l,yypvt[-1].pe,0); } break;
case 182:
# line 1486 "gram.y"
{
				error("local linkage specification");
				yyval.p = yypvt[-0].pn;
			} break;
case 183:
# line 1491 "gram.y"
{	Pname n = yypvt[-0].pn;
				if (n)
					if (stmt_seen) {
						yyval.p = new block(n->where,n,0);
						yyval.ps->base = DCL;
					}
					else {
						if (cd)
							cd->add_list(n);
						else
							cd = new nlist(n);
						yyval.p = 0;
					}
			} break;
case 184:
# line 1506 "gram.y"
{
				Pname n = yypvt[-0].pn;
				error(&n->where,"%n's definition is nested (did you forget a ``}''?)",n);
				if (cd)
					cd->add_list(n);
				else
					cd = new nlist(n);
				yyval.p = 0;
			} break;
case 186:
# line 1517 "gram.y"
{	yyval.p = new ifstmt(yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps,0); } break;
case 187:
# line 1519 "gram.y"
{	yyval.p = new ifstmt(yypvt[-4].l,yypvt[-3].pe,yypvt[-2].ps,yypvt[-0].ps); } break;
case 188:
# line 1521 "gram.y"
{	yyval.p = new estmt(WHILE,yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps); } break;
case 189:
# line 1522 "gram.y"
{ stmt_seen=1; } break;
case 190:
# line 1523 "gram.y"
{	yyval.p = new forstmt(yypvt[-8].l,yypvt[-5].ps,yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].ps); } break;
case 191:
# line 1525 "gram.y"
{	yyval.p = new estmt(SWITCH,yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps); } break;
case 192:
# line 1526 "gram.y"
{ yyval.p = yypvt[-1].pn; stmt_seen=1; } break;
case 193:
# line 1527 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = new lstmt(LABEL,n->where,n,yypvt[-0].ps);
			} break;
case 194:
# line 1530 "gram.y"
{ yyval.p = new name(yypvt[-1].pn->string); stmt_seen=1; } break;
case 195:
# line 1531 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = new lstmt(LABEL,n->where,n,yypvt[-0].ps);
			} break;
case 196:
# line 1534 "gram.y"
{ stmt_seen=1; } break;
case 197:
# line 1535 "gram.y"
{	if (yypvt[-2].pe == dummy) error("empty case label");
				yyval.p = new estmt(CASE,yypvt[-4].l,yypvt[-2].pe,yypvt[-0].ps);
			} break;
case 198:
# line 1538 "gram.y"
{ stmt_seen=1; } break;
case 199:
# line 1539 "gram.y"
{	yyval.p = new stmt(DEFAULT,yypvt[-3].l,yypvt[-0].ps); } break;
case 200:
# line 1546 "gram.y"
{	Pexpr e = expr_unlist(yypvt[-0].el);
				while (e && e->e1==dummy) {
					register Pexpr ee2 = e->e2;
					if (ee2) error("EX inEL");
					delete e;
					e = ee2;
				}
				yyval.p = e;
			} break;
case 201:
# line 1558 "gram.y"
{	yyval.el = new elist(new expr(ELIST,yypvt[-0].pe,0)); } break;
case 202:
# line 1560 "gram.y"
{	yypvt[-2].el->add(new expr(ELIST,yypvt[-0].pe,0)); } break;
case 204:
# line 1565 "gram.y"
{
  			  	if ( in_arg_list ) 
       			  		error( "syntax error: IrL not permitted in AL" );
				else if ( in_binit_list )
					error( "syntax error: IrL not permitted inMIr" );
  			  	else 
					init_seen = 1;
				Pexpr e;
				if (yypvt[-1].p)
					e = yypvt[-1].pe;
				else
					e = new expr(ELIST,dummy,0);
				yyval.p = new expr(ILIST,e,0);
			} break;
case 205:
# line 1582 "gram.y"
{	bbinop:	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 206:
# line 1583 "gram.y"
{	goto bbinop; } break;
case 207:
# line 1584 "gram.y"
{	goto bbinop; } break;
case 208:
# line 1585 "gram.y"
{	goto bbinop; } break;
case 209:
# line 1586 "gram.y"
{	goto bbinop; } break;
case 210:
# line 1587 "gram.y"
{	goto bbinop; } break;
case 211:
# line 1588 "gram.y"
{	goto bbinop; } break;
case 212:
# line 1589 "gram.y"
{ 	goto bbinop; } break;
case 213:
# line 1590 "gram.y"
{	goto bbinop; } break;
case 214:
# line 1591 "gram.y"
{	goto bbinop; } break;
case 215:
# line 1592 "gram.y"
{	goto bbinop; } break;
case 216:
# line 1593 "gram.y"
{	goto bbinop; } break;
case 217:
# line 1594 "gram.y"
{	goto bbinop; } break;
case 218:
# line 1595 "gram.y"
{	goto bbinop; } break;
case 219:
# line 1596 "gram.y"
{	goto bbinop; } break;
case 220:
# line 1598 "gram.y"
{	yyval.p = new qexpr(yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].pe); } break;
case 221:
# line 1600 "gram.y"
{ yyval.p = new expr(DELETE,yypvt[-0].pe,0); } break;
case 222:
# line 1602 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `delete[v]' is redundant; use `delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 223:
# line 1610 "gram.y"
{	yyval.p = new expr(GDELETE,yypvt[-0].pe,0); } break;
case 224:
# line 1612 "gram.y"
{
				if(yypvt[-2].pe != dummy) { 
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `::delete[v]' is redundant; use `::delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 226:
# line 1623 "gram.y"
{	binop:	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 227:
# line 1624 "gram.y"
{	goto binop; } break;
case 228:
# line 1625 "gram.y"
{	goto binop; } break;
case 229:
# line 1626 "gram.y"
{	goto binop; } break;
case 230:
# line 1627 "gram.y"
{	goto binop; } break;
case 231:
# line 1628 "gram.y"
{	goto binop; } break;
case 232:
# line 1629 "gram.y"
{	goto binop; } break;
case 233:
# line 1630 "gram.y"
{ 	goto binop; } break;
case 234:
# line 1631 "gram.y"
{	goto binop; } break;
case 235:
# line 1632 "gram.y"
{	goto binop; } break;
case 236:
# line 1633 "gram.y"
{	goto binop; } break;
case 237:
# line 1634 "gram.y"
{	goto binop; } break;
case 238:
# line 1635 "gram.y"
{	goto binop; } break;
case 239:
# line 1636 "gram.y"
{	goto binop; } break;
case 240:
# line 1637 "gram.y"
{	goto binop; } break;
case 241:
# line 1639 "gram.y"
{	yyval.p = new qexpr(yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].pe); } break;
case 242:
# line 1641 "gram.y"
{	yyval.p = new expr(DELETE,yypvt[-0].pe,0); } break;
case 243:
# line 1643 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `delete[v]' is redundant; use `delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 244:
# line 1651 "gram.y"
{	yyval.p = new expr(GDELETE,yypvt[-0].pe,0); } break;
case 245:
# line 1653 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `::delete[v]' is redundant; use `::delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 246:
# line 1660 "gram.y"
{ 
			init_seen = 0; 
			} break;
case 247:
# line 1664 "gram.y"
{	yyval.p = dummy; } break;
case 248:
# line 1667 "gram.y"
{ goto new1; } break;
case 249:
# line 1669 "gram.y"
{	new1:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p = new texpr(NEW,t,0);
			} break;
case 250:
# line 1673 "gram.y"
{ goto new3; } break;
case 251:
# line 1675 "gram.y"
{	new3:
				Ptype t = yypvt[-0].pn->tp;
 				yyval.p = new texpr(GNEW,t,0);
 			} break;
case 252:
# line 1680 "gram.y"
{	yyval.p = new expr(yypvt[-0].t,yypvt[-1].pe,0); } break;
case 253:
# line 1682 "gram.y"
{	yyval.p = new texpr(CAST,yypvt[-1].pn->tp,yypvt[-0].pe); } break;
case 254:
# line 1684 "gram.y"
{	yyval.p = new expr(DEREF,yypvt[-0].pe,0); } break;
case 255:
# line 1686 "gram.y"
{	yyval.p = new expr(ADDROF,0,yypvt[-0].pe); } break;
case 256:
# line 1688 "gram.y"
{	yyval.p = new expr(UMINUS,0,yypvt[-0].pe); } break;
case 257:
# line 1690 "gram.y"
{	yyval.p = new expr(UPLUS,0,yypvt[-0].pe); } break;
case 258:
# line 1692 "gram.y"
{	yyval.p = new expr(NOT,0,yypvt[-0].pe); } break;
case 259:
# line 1694 "gram.y"
{	yyval.p = new expr(COMPL,0,yypvt[-0].pe); } break;
case 260:
# line 1696 "gram.y"
{	yyval.p = new expr(yypvt[-1].t,0,yypvt[-0].pe); } break;
case 261:
# line 1698 "gram.y"
{	
				yyval.p = new texpr(SIZEOF,0,yypvt[-0].pe); 
				in_sizeof = 0;
			} break;
case 262:
# line 1703 "gram.y"
{	
				yyval.p = new texpr(SIZEOF,yypvt[-0].pn->tp,0); 
				in_sizeof = 0;
			} break;
case 263:
# line 1708 "gram.y"
{	yyval.p = new expr(DEREF,yypvt[-3].pe,yypvt[-1].pe); } break;
case 264:
# line 1710 "gram.y"
{	yyval.p = new ref(REF,yypvt[-2].pe,yypvt[-0].pn); } break;
case 265:
# line 1712 "gram.y"
{	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 266:
# line 1714 "gram.y"
{	yyval.p = new ref(REF,yypvt[-2].pe,Ncopy(yypvt[-0].pn)); } break;
case 267:
# line 1716 "gram.y"
{	yyval.p = new ref(DOT,yypvt[-2].pe,yypvt[-0].pn); } break;
case 268:
# line 1718 "gram.y"
{	yyval.p = new ref(DOT,yypvt[-2].pe,Ncopy(yypvt[-0].pn)); } break;
case 270:
# line 1721 "gram.y"
{
			if ( init_seen )
     				error( "syntax error:IrL illegal within ()");
			} break;
case 271:
# line 1727 "gram.y"
{
				if ( yypvt[-1].p == dummy )
					error("syntax error: nullE");
				yyval.p = yypvt[-1].p;
			} break;
case 272:
# line 1733 "gram.y"
{	yyval.p = zero; } break;
case 273:
# line 1735 "gram.y"
{	yyval.p = new expr(ICON,0,0);
				yyval.pe->string = yypvt[-0].s;
			} break;
case 274:
# line 1739 "gram.y"
{	yyval.p = new expr(FCON,0,0);
				yyval.pe->string = yypvt[-0].s;
			} break;
case 275:
# line 1743 "gram.y"
{	yyval.p = new expr(STRING,0,0);
				yyval.pe->string = yypvt[-0].s;
			} break;
case 276:
# line 1747 "gram.y"
{	yyval.p = new expr(CCON,0,0);
				yyval.pe->string = yypvt[-0].s;
			} break;
case 277:
# line 1751 "gram.y"
{	yyval.p = new expr(THIS,0,0); } break;
case 278:
# line 1755 "gram.y"
{ 	yyval.p = new texpr(VALUE,tok_to_type(yypvt[-3].t),yypvt[-1].pe); } break;
case 279:
# line 1757 "gram.y"
{	yyval.p = new texpr(VALUE,yypvt[-3].pn->tp,yypvt[-1].pe); } break;
case 280:
# line 1758 "gram.y"
{ goto new2; } break;
case 281:
# line 1760 "gram.y"
{	new2:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p=new texpr(NEW,t,0);
				yyval.pe->e2 = yypvt[-2].pe;
			} break;
case 282:
# line 1765 "gram.y"
{ goto new4; } break;
case 283:
# line 1767 "gram.y"
{	new4:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p = new texpr(GNEW,t,0);
				yyval.pe->e2 = yypvt[-2].pe;
			} break;
case 284:
# line 1773 "gram.y"
{	
				Pexpr ee = yypvt[-1].pe;
				Pexpr e = yypvt[-3].pe;
				if (e->base==NEW || e->base==GNEW)
					e->e1 = ee;
				else
					yyval.p = new call(e,ee);
			} break;
case 285:
# line 1784 "gram.y"
{       
				yyval.pn = yypvt[-0].pn; 
				curr_scope = yypvt[-0].pn;
			} break;
case 286:
# line 1789 "gram.y"
{       yyval.pn = sta_name; } break;
case 287:
# line 1794 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 288:
# line 1796 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-1].pn;
			} break;
case 289:
# line 1800 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
			} break;
case 290:
# line 1804 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 291:
# line 1809 "gram.y"
{	yyval.p = yypvt[-0].p;
				sig_name(yyval.pn);
			} break;
case 292:
# line 1813 "gram.y"
{	yyval.p = yypvt[-0].p;
				sig_name(yyval.pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 293:
# line 1818 "gram.y"
{	
				if (strcmp(yypvt[-2].pn->string,yypvt[-0].pn->string)) error("syntax error: inconsistent destructor notation");
				yyval.p = new name(oper_name(DTOR));
				yyval.pn->n_oper = DTOR;
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 294:
# line 1830 "gram.y"
{ yyval.p = Ncast(yypvt[-2].p,yypvt[-1].pn); } break;
case 295:
# line 1833 "gram.y"
{ check_cast(); } break;
case 296:
# line 1837 "gram.y"
{
				TOK t = yypvt[-0].t;

				switch (t) {
				case FRIEND:
				case OVERLOAD:
				case REGISTER:
				case STATIC:
				case EXTERN:
				case AUTO:
				case VIRTUAL:
					error("%k in operatorT",t);
					t = INT;
					
				}

				yyval.p = new basetype(t,0);

			} break;
case 297:
# line 1856 "gram.y"
{ yyval.p = new basetype(TYPE,yypvt[-0].pn); } break;
case 298:
# line 1858 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) 
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t); 
				DECL_TYPE = 0;
			} break;
case 299:
# line 1864 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) 
			 		yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn);
				DECL_TYPE = 0;
			} break;
case 300:
# line 1871 "gram.y"
{ yyval.p = Ncast(yypvt[-1].p,yypvt[-0].pn); } break;
case 301:
# line 1874 "gram.y"
{ yyval.p = Ncast(yypvt[-1].p,yypvt[-0].pn); } break;
case 302:
# line 1877 "gram.y"
{
			//	ENTER_NAME(yypvt[-0].pn);
				yyval.p = Ndata(yypvt[-1].p,yypvt[-0].pn);
			} break;
case 303:
# line 1882 "gram.y"
{
			//	ENTER_NAME(yypvt[-1].pn);
			} break;
case 304:
# line 1886 "gram.y"
{	yyval.p = Ndata(yypvt[-4].p,yypvt[-3].pn);
				yyval.pn->n_initializer = yypvt[-0].pe;
			} break;
case 305:
# line 1892 "gram.y"
{//PUSH_ARG_SCOPE
				check_decl(); 
				in_arg_list=1; 
				yyval.pl = modified_tn;
				modified_tn = 0;
			} break;
case 306:
# line 1901 "gram.y"
{
			yyval.p = new fct(0,name_unlist(yypvt[-3].nl),yypvt[-2].t); 
			if ( NEXTTOK() != COLON ) in_arg_list=0;
			//in_arg_list=0;
			Pfct(yyval.pt)->f_const = (yypvt[-0].i & 1);
			if ( parsing_class_members
			||  (NEXTTOK()!=LC && yychar!=COLON) ) {
				end_al(yypvt[-4].pl,1);
			//POP_SCOPE(); // similar to end_al()
			} else
				end_al(yypvt[-4].pl,0);
		    } break;
case 307:
# line 1916 "gram.y"
{
				if (yypvt[-0].p)
					if (yypvt[-2].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else {
						error("AD syntax");
						yyval.nl = new nlist(yypvt[-0].pn); 
					}
				else
					error("AD syntax");
			} break;
case 308:
# line 1928 "gram.y"
{
				if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); 
			} break;
case 310:
# line 1934 "gram.y"
{	yyval.p = 0; } break;
case 311:
# line 1938 "gram.y"
{	yyval.t = 1; } break;
case 312:
# line 1940 "gram.y"
{	yyval.t = ELLIPSIS; } break;
case 313:
# line 1942 "gram.y"
{	yyval.t = ELLIPSIS; } break;
case 314:
# line 1946 "gram.y"
{
			yyval.p = new ptr(PTR,0); 
			EXPECT_ID();
			} break;
case 315:
# line 1951 "gram.y"
{
			yyval.p = new ptr(RPTR,0); 
			EXPECT_ID();
			} break;
case 316:
# line 1956 "gram.y"
{	yyval.p = doptr(PTR,yypvt[-0].t); } break;
case 317:
# line 1958 "gram.y"
{	
				switch ( yypvt[-0].t ) {
				case CONST:
                                     yypvt[-1].pp->rdo = 1; break;
				case VOLATILE:
				     error('w',"\"volatile\" not implemented (ignored)");
				     break;
				default:
				    error( "syntax error: *%k", yypvt[-0].t );
				}
				yyval.p = yypvt[-1].pp; 
			} break;
case 318:
# line 1971 "gram.y"
{	yyval.p = doptr(RPTR,yypvt[-0].t); } break;
case 319:
# line 1973 "gram.y"
{
			yyval.p = new ptr(PTR,0);
			yyval.pp->memof = Pclass(Pbase(yypvt[-0].pn->tp)->b_name->tp);
			EXPECT_ID();
			} break;
case 320:
# line 1979 "gram.y"
{	yyval.p = doptr(PTR,yypvt[-0].t);
				yyval.pp->memof = Pclass(Pbase(yypvt[-1].pn->tp)->b_name->tp);
			} break;
case 321:
# line 1984 "gram.y"
{ yyval.p = new vec(0,yypvt[-1].pe!=dummy?yypvt[-1].pe:0 ); } break;
case 322:
# line 1985 "gram.y"
{ yyval.p = new vec(0,0); } break;
	}
	goto yystack;  /* stack new state and value */
}
