/*
 * This file defines message structures and codes
 * shared by the common control (cmc), listener,
 * and programs that call the common control.
 */



/*
 * library routine declarations (libdk.c)
 * for a program that actually touches the switch.
 */
extern long cmread();
extern long ocmread();
/*
 * switch commands
 */
#define	RAM_ON	0226
#define	ROM_ON	0322
#define	R_CNTL	0264
#define	W_CNTL	0170



/*
 * Principal message structure.
 */
struct	dialout {
	char	type;		/* message type */
	char	srv;		/* service requested */
	short	param0;		/* parameters */
	short	param1;
	short	param2;
	short	param3;
	short	param4;
	short	param5;
};

/*
 * dialout struct for MPX mode output.
 */
struct	xmsg {
	char	x_ochan;
	char	x_esc;
	char	x_type;
	char	x_srv;
	short	x_param0;
	short	x_param1;
	short	x_param2;
	short	x_param3;
	short	x_param4;
	short	x_param5;
};

/*
 * dialout structure as received by cmc.
 */
struct	dialin {
	short	i_vhn;		/* virtual host number */
	short	i_rchan;	/* channel calling */
	struct	dialout dial;
};

/*
 * dialout structure as received with
 * ICHAN mode on (used by listener, terminal manager).
 */
struct	listenin {
	short	l_lchan;
	char	l_type;
	char	l_srv;
	short	l_param0;
	short	l_param1;
	short	l_param2;
	short	l_param3;
	short	l_param4;
	short	l_param5;
};


/*
 * message types
 */
#define	T_SRV		1	/* request for server process */
#define	T_LOC		2	/* generated by driver */
#define	T_CHG		3	/* status change on a channel */
#define	T_LSTNR		4	/* keep alive msg from listener */
#define	T_SYNC		5	/* synchronizer */
#define	T_STATUS	6	/* status requests */
#define	T_INDIR		7	/* indirect (third party) */
#define	T_PROXY		8	/* terminal manager */
#define	T_MODE		9	/* cmc modes */
#define	T_REPLY		10	/* handshake */
#define	T_TH		11	/* terminal handler */
#define	T_MAINT		12	/* maintenance msg */
#define	T_CMC		13	/* cmc/cmc msg */
#define	T_MGR		14	/* manager process */
#define	T_MAP		15	/* map a channel somewhere */
#define	T_NAME		16	/* access name manager */

/*
 * server process codes
 */
#define	D_SH		1	/* interactive shell (no login) */
#define	D_LOG		2	/* normal login */
#define	D_FS		3	/* fdaemon */
#define	D_XFS		4	/* xdaemon */
#define	D_XSH		5
#define	D_YSH		6
#define	D_TR		7
#define	D_RES2		8
#define	D_EXEC		9	/* sh -c */
#define	D_AUX		10	/* talk to cmc */
#define	D_BOOT		11	/* boot ploglam */
#define	D_NULL		12	/* don't do anything */

/*
 * mgr process codes
 */
#define	MGRBASE	64
#define	D_PROC		1	/* cpu manager */
#define	D_TIME		2	/* date and time */
#define	D_NAME		3	/* name translation */
#define	D_TTY		4	/* tty server */
#define	D_FMGR		5	/* file name manager */
#define	D_FSRV		6	/* file server */

/*
 * Channel mapping codes
 */
#define	R_MAPTO		1	/* map me to (sw, mod, ch) */
#define	R_LSPLICE	2	/* local splice */
#define	R_RSPLICE	3	/* remote splice */

/*
 * T_CHG codes
 */
#define	D_CLOSE		1	/* close a channel */
#define	D_ISCLOSED	2	/* channel is closed */
#define	D_OPEN		3	/* channel is open */
#define	D_OK		3	/* general acknowledgement */
#define	D_ACK		3	/* general acknowledgement */
#define	D_ACCEPT	4	/* login name accepted */
#define	D_FAIL		5
#define	D_PLOG		6	/* login name rejected, running login */
#define	D_PRY		7	/* pry up channels: inverse of D_NAIL */
#define	D_PRYALL	8	/* pry all nailed channels */
#define	D_MSG		9	/* msg follows */
#define	D_ON		10	/* carrier on */
#define	D_OFF		11	/* carrier off */
#define	D_WAIT		12	/* delay */

/*
 * maintenance codes
 */
#define	M_NAIL		1	/* nail down channels */
#define	M_PRY		2	/* pry up channels */
#define	M_STAT		3	/* read out things */
#define	M_TRACE		4	/* control cmc trace verbosity */
#define	M_SBOOT		5	/* boot a switch */
#define	M_MBOOT		6	/* reset a module */

/*
 * M_STAT codes
 */
#define	S_MOD		1	/* channel maps for a module */

/*
 * T_LOC codes
 */
#define	DL_CLOSE	1	/* same as T_CHG */
#define	DL_ISCLOSED	2	/* same as T_CHG */
#define	DL_OPEN		3	/* channel open */
#define	D_TIMER		4	/* 15 sec tick */





/*
 * TM/TH messages
 */
#define	DM_CLOSE	1	/* same as T_CHG */
#define	DM_ISCLOSED	2	/* same as T_CHG */
#define	DM_IO		3	/* ioctl */
#define	DM_HUP		4	/* hangup */
#define	DM_ON		5	/* carrier on */

/*
 * Boot Protocol
 */
#define	B_HEAD		1	/* load address */
#define	B_TAIL		2	/* end of message */
#define	B_GO		3	/* jump to start address */

#define	NAMEFILE	"/usr/dk/netnames"

struct dkaddr {
	short	area;
	short	exch;
	short	host;
};

struct dkaddr netname();
