      LOGICAL FUNCTION DODESQ(X,NX,T,DT,ERRPAR,ERPUTS,E)
C
C  STANDARD QUADRATURE ERROR ROUTINE FOR DODES.
C
C  INPUT
C
C    X      - X=X(T), THE APPROXIMATE SOLUTION FOR WHICH AN ERROR
C             CRITERION IS DESIRED.
C    NX     - THE LENGTH OF THE SOLUTION VECTOR X.
C    T      - CURRENT VALUE OF THE TIME VARIABLE.
C    DT     - CURRENT TIME-STEP.
C    ERRPAR - TWO PARAMETERS FOR USE IN DETERMINING THE DESIRED ERROR.
C             THE FINAL INTEGRAL SHOULD BE COMPUTED ACCURATE TO A REAL
C             ABSOLUTE ERROR OF ERRPAR(2).
C    ERPUTS - THIS PARAMETER IS IGNORED.
C    E      - X(I) IS ACCURATE TO A REAL ABSOLUTE ERROR OF E(I), FOR THE
C             SINGLE CURRENT TIME-STEP, I=1,...,NX.
C
C  COMMON INPUT -
C
C    TEND   - THE END OF THE INTEGRATION INTERVAL.
C    RERROR - THE REMAINDER OF THE INTEGRAL SHOULD BE DONE TO WITHIN
C             A REAL ABSOLUTE ERROR OF RERROR.
C             THE FIRST CALL SHOULD HAVE RERROR=ERRPAR(2).
C
C  OUTPUT
C
C    E      - E(I)=MAX(RERROR*ABS(DT/(TEND-(T-DT))),
C                      1.0E-3*ERRPAR(2)) ,   FOR I=1,...,NX.
C             THUS, THE FINAL INTEGRAL SHOULD BE ACCURATE TO WITHIN
C             A REAL ABSOLUTE ERROR OF ERRPAR(2).
C
C  FUNCTION VALUE -
C
C    DODESQ - .TRUE. IF EACH X(I) IS ACCURATE TO WITHIN AN
C             ABSOLUTE ERROR OF E(I), I=1,...,NX, OTHERWISE .FALSE. .
C
C  COMMON OUTPUT -
C
C    RERROR - IF (DODESQ) THEN
C             RERROR=RERROR - MAXIMUM(E(1),...,E(NX)), WHERE THE E
C             USED IS THE INPUT VALUE FOR THAT VARIABLE.
C             OTHERWISE, RERROR REMAINS UNCHANGED.
C
C  SCRATCH SPACE ALLOCATED - NONE.
C
C  ERROR STATES - NONE.
C
      COMMON /D0DESQ/TEND,RERROR
C
      DOUBLE PRECISION X(NX),T,DT,TEND
      REAL ERRPAR(2),E(NX),RERROR
      LOGICAL ERPUTS
C
      REAL EMAX,TEMP
C
      DODESQ=.TRUE.
      EMAX=0.0E0
C
      DO 10 I=1,NX
C
         TEMP=AMAX1(RERROR*ABS(SNGL(DT/(TEND-(T-DT)))),
     1              1.0E-3*ERRPAR(2))
C
         IF (E(I).GT.TEMP) DODESQ=.FALSE.
C
         EMAX=AMAX1(EMAX,E(I))
C
 10      E(I)=TEMP
C
      IF (DODESQ) RERROR=RERROR-EMAX
C
      RETURN
C
      END
