      SUBROUTINE D0DESG(T0,X0,T1,X1,NX,NT,F,OK)
C
C  GRAGG'S MODIFIED MID-POINT RULE FOR Y' = F(T,Y).
C
C  INPUT
C
C    T0     - INITIAL TIME.
C    X0     - X0=X(T0).
C    T1     - FINAL TIME.
C    NX     - THE LENGTH OF THE SOLUTION VECTOR.
C    NT     - THE NUMBER OF TIME STEPS TO BE USED IS 2*NT.
C    F      - THE RIGHT-HAND SIDE.
C             THE CALL F(T,X,NX,FTX) SHOULD SET FTX=F(T,X).
C             IF IT CANNOT COMPUTE F(T,X), OKAY=.FALSE. SHOULD BE
C             RETURNED IN COMMON /DODESF/OKAY .
C
C  COMMON INPUT -
C
C    IGMAX  - THE POINTER TO THE REAL VECTOR OF CURRENT MAXIMUM ABSOLUTE
C             VALUES ATTAINED BY EACH COMPONENT OF THE SOLUTION.
C             IGMAX=0 MEANS THIS VECTOR IS NOT USED.
C    IFTX0  - THE POINTER TO THE DOUBLE PRECISION VECTOR F(T0,X0).
C
C  OUTPUT
C
C    X1     - THE APPROXIMATE SOLUTION AT TIME T1.
C
C  COMMON OUTPUT -
C
C    OK     - OK=.TRUE., IF SUCCESSFUL. OTHERWISE, OK=.FALSE. .
C    IGMAX  - THE UPDATED MAXIMUM VALUES.
C    IFTX0  - THE VECTOR FTX0 IS LOADED IF NT=1.
C
C  SCRATCH SPACE ALLOCATED - 2*NX DOUBLE PRECISION WORDS.
C
C  ERROR STATES - NONE.
C
      COMMON /DODESM/IGMAX,IGMAXO
      COMMON /D0DESP/IFTX0
      COMMON /DODESF/OKAY
C
      DOUBLE PRECISION T0,X0(NX),T1,X1(NX)
      LOGICAL OK,OKAY
      EXTERNAL F
C
      COMMON /CSTAK/DS
      DOUBLE PRECISION DS(500)
      DOUBLE PRECISION WS(1)
      EQUIVALENCE (DS(1),WS(1))
C
C ... ALLOCATE SPACE FOR THE FUNCTION VALUES FTX AND SCRATCH VALUES XL.
C
      IFTX=ISTKGT(2*NX,4)
      IXL=IFTX+NX
C
      CALL D0DESR(T0,X0,T1,X1,NX,NT,F,WS(IFTX),WS(IXL),WS(IFTX0),IGMAX)
C
      OK=OKAY
C
      CALL ISTKRL(1)
C
      RETURN
C
      END
