/*
 * Random set of variables
 * used by more than one
 * routine.
 * variable 'fusuerr' added by hjt (see also dev/mem.c)
 */
struct inode *rootdir;          /* pointer to inode of root directory */
struct proc *runq;              /* head of linked list of running processes */
#ifdef  I_D_SPACE
int     cputype;                /* type of cpu =40, 45, or 70 */
#endif
int     fusuerr;                /* distinguish between legal/illegal memory
                                  accesses returning value '-1'  (hjt)   */
int     lbolt;                  /* time of day in 60th not in time */
time_t  time;                   /* time in sec from 1970 */
char    *panicstr;              /* pointer to last panic */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int     nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/tty.c
 */
int     nchrdev;

int     mpid;                   /* generic for unique process id's */
char    runin;                  /* scheduling flag */
char    runout;                 /* scheduling flag */
char    runrun;                 /* scheduling flag */
char    curpri;                 /* more scheduling */
int     backgr;                 /* added for prio tuning; hjt */
int     maxmem;                 /* actual max memory per process */
physadr lks;                    /* pointer to clock device */
daddr_t swplo;                  /* block number of swap space */
int     nswap;                  /* size of swap space */
int     updlock;                /* lock for sync */
daddr_t rablock;                /* block to be read ahead */
extern  char    regloc[];       /* locs. of saved user registers (trap.c) */
char    msgbuf[MSGBUFS];        /* saved "printf" characters */
dev_t   rootdev;                /* device of the root */
dev_t   swapdev;                /* swapping device */
dev_t   pipedev;                /* pipe device */
extern  int     icode[];        /* user init code */
extern  int     szicode;        /* its size */

dev_t getmdev();
daddr_t bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *geteblk();
struct buf *bread();
struct buf *breada();
struct filsys *getfs();
struct file *getf();
struct file *falloc();
int     uchar();
#ifdef INSTRM
/*
 * Instrumentation
 */
int     dk_busy;
long    dk_time[32];
long    dk_numb[3];
long    dk_wds[3];
long    tk_nin;
long    tk_nout;
#endif INSTRM

/*
 * Structure of the system-entry table
 */
extern struct sysent {
        char    sy_narg;                /* total number of arguments */
        char    sy_nrarg;               /* number of args in registers */
        int     (*sy_call)();           /* handler */
} sysent[];
