(* Copyright 1989 by AT&T Bell Laboratories *)
structure Mlex=
   struct
    structure UserDeclarations =
      struct
type lexresult = Token.token
type lexarg = {comLevel : int ref, lineNum : int ref, complain : string->unit}
val eof = fn {comLevel,lineNum,complain} => 
           (if !comLevel>0 then complain "unclosed comment" else ();
            Token.EOF)
val charlist = ref (nil : string list)
fun addString (s:string) = charlist := s :: (!charlist)
fun makeInt s = revfold (fn (c,a) => a*10 + (ord c - Ascii.zero)) (explode s) 0
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s1 =
"\009\009\009\009\009\009\009\009\009\217\219\009\009\009\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\
\\217\193\216\215\193\193\193\213\211\210\209\193\208\206\203\193\
\\201\201\201\201\201\201\201\201\201\201\200\199\193\197\193\193\
\\193\024\024\024\024\024\024\024\024\024\024\024\024\024\024\024\
\\024\024\024\024\024\024\024\024\024\024\024\196\193\195\193\194\
\\193\172\024\168\159\140\132\024\126\109\024\024\102\024\096\079\
\\024\024\072\049\042\024\039\027\024\024\024\023\022\021\010\009"
val s3 =
"\220\220\220\220\220\220\220\220\220\220\225\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\223\220\221\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\
\\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220\220"
val s5 =
"\226\226\226\226\226\226\226\226\226\226\240\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\239\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\227\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226"
val s7 =
"\241\241\241\241\241\241\241\241\241\243\245\241\241\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\
\\243\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\242\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\
\\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241\241"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\000\011\
\\012\012\012\012\012\012\012\012\012\012\011\000\011\011\011\011\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000"
val s11 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\000\011\
\\000\000\000\000\000\000\000\000\000\000\011\000\011\011\011\011\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\
\\012\012\012\012\012\012\012\012\012\012\000\000\000\000\000\000\
\\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\015\015\015\015\015\015\015\015\015\015\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\015\015\015\015\015\015\015\015\015\015\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\017\017\017\017\017\017\017\017\017\017\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\017\017\017\017\017\017\017\017\017\017\000\000\000\000\000\000\
\\000\000\000\000\000\018\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\020\020\020\020\020\020\020\020\020\020\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\020\020\020\020\020\020\020\020\020\020\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\035\028\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s28 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\029\025\025\025\025\025\025\000\000\000\000\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\030\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s30 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\031\025\025\025\025\025\025\000\000\000\000\000"
val s31 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\032\025\000\000\000\000\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\033\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s33 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\034\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\036\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\037\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s37 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\038\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\040\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\041\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\046\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\043\025\000\000\000\000\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\044\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\045\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\047\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\048\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\066\058\025\025\025\025\025\025\
\\025\025\025\025\050\025\025\025\025\025\025\000\000\000\000\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\051\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s51 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\052\025\025\025\025\025\000\000\000\000\000"
val s52 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\053\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\054\025\025\025\025\025\025\000\000\000\000\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\055\025\025\025\025\025\000\000\000\000\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\056\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\057\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\059\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\060\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\061\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s61 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\062\025\025\025\025\025\025\000\000\000\000\000"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\063\025\025\025\025\025\000\000\000\000\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\064\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\065\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\067\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s67 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\068\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s68 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\069\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s69 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\070\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s70 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\071\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s72 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\075\025\025\025\073\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s73 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\074\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s75 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\076\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\077\025\025\025\025\025\025\025\000\000\000\000\000"
val s77 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\078\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s79 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\095\025\025\025\025\025\025\025\025\025\
\\092\025\087\025\025\025\080\025\025\025\025\000\000\000\000\000"
val s80 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\081\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s81 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\082\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s82 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\083\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s83 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\084\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s84 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\085\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s85 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\086\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s87 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\088\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s88 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\089\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s89 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\090\025\025\025\025\025\025\025\000\000\000\000\000"
val s90 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\091\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s92 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\093\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s93 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\094\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s96 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\097\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s97 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\098\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s98 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\099\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s99 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\100\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s100 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\101\025\025\000\000\000\000\000"
val s102 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\107\025\025\025\025\025\025\025\025\025\103\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s103 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\104\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s104 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\105\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s105 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\106\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s107 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\108\025\025\025\025\025\025\000\000\000\000\000"
val s109 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\125\025\025\025\025\025\025\120\110\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s110 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\115\025\025\111\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s111 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\112\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s112 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\113\025\025\000\000\000\000\000"
val s113 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\114\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s115 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\116\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s116 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\117\025\025\025\025\025\000\000\000\000\000"
val s117 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\118\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s118 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\119\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s120 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\121\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s121 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\122\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s122 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\123\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s123 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\124\025\025\025\025\025\025\000\000\000\000\000"
val s126 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\127\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s127 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\128\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s128 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\129\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s129 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\130\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s130 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\131\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s132 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\139\025\
\\025\025\025\025\025\133\025\025\025\025\025\000\000\000\000\000"
val s133 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\134\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s134 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\135\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s135 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\136\025\025\025\025\025\025\000\000\000\000\000"
val s136 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\137\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s137 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\138\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s140 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\156\025\154\025\
\\025\149\025\025\025\025\025\025\141\025\025\000\000\000\000\000"
val s141 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\142\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s142 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\143\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s143 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\144\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s144 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\145\025\025\025\025\025\025\000\000\000\000\000"
val s145 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\146\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s146 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\147\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s147 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\148\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s149 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\150\025\025\025\025\025\025\000\000\000\000\000"
val s150 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\151\025\000\000\000\000\000"
val s151 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\152\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s152 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\153\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s154 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\155\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s156 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\157\025\025\025\025\025\025\025\000\000\000\000\000"
val s157 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\158\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s159 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\161\025\025\025\025\025\025\025\025\025\025\025\025\025\160\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s161 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\162\025\025\025\025\025\025\000\000\000\000\000"
val s162 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\163\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s163 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\164\025\025\025\025\025\025\000\000\000\000\000"
val s164 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\165\025\000\000\000\000\000"
val s165 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\166\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s166 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\167\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s168 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\169\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s169 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\170\025\025\025\025\025\025\025\000\000\000\000\000"
val s170 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\171\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s172 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\180\025\025\025\025\025\025\025\025\025\025\025\174\025\
\\025\025\025\173\025\025\025\025\025\025\025\000\000\000\000\000"
val s174 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\175\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s175 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\176\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s176 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\177\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s177 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\178\025\025\025\025\025\025\025\000\000\000\000\000"
val s178 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\179\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s180 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\181\025\025\025\025\025\025\025\000\000\000\000\000"
val s181 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\182\025\025\025\025\025\025\000\000\000\000\000"
val s182 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\186\025\025\025\025\025\025\183\025\000\000\000\000\000"
val s183 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\184\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s184 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\185\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s186 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\187\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s187 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\188\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s188 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\189\025\025\025\025\025\025\000\000\000\000\000"
val s189 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\190\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s190 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\191\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s191 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\025\000\000\000\000\000\000\026\000\
\\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000\000\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\025\
\\000\025\025\025\025\025\025\025\025\025\025\025\025\025\192\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\000\000\000\000"
val s197 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\000\011\
\\000\000\000\000\000\000\000\000\000\000\011\000\011\011\198\011\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000"
val s201 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\
\\202\202\202\202\202\202\202\202\202\202\000\000\000\000\000\000\
\\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s203 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\204\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s204 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\205\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s206 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\000\011\
\\000\000\000\000\000\000\000\000\000\000\011\000\011\011\207\011\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000"
val s211 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\212\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s213 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\214\000\000\000\000\000\000\026\000\
\\214\214\214\214\214\214\214\214\214\214\000\000\000\000\000\000\
\\000\214\214\214\214\214\214\214\214\214\214\214\214\214\214\214\
\\214\214\214\214\214\214\214\214\214\214\214\000\000\000\000\214\
\\000\214\214\214\214\214\214\214\214\214\214\214\214\214\214\214\
\\214\214\214\214\214\214\214\214\214\214\214\000\000\000\000\000"
val s217 =
"\000\000\000\000\000\000\000\000\000\218\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\218\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s221 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\222\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s223 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\224\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s226 =
"\226\226\226\226\226\226\226\226\226\226\000\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\000\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\000\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\
\\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226\226"
val s227 =
"\000\000\000\000\000\000\000\000\000\237\238\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\237\000\236\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\233\233\233\233\233\233\233\233\233\233\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\232\000\230\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\229\000\
\\000\000\000\000\228\000\000\000\000\000\000\000\000\000\000\000"
val s230 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\231\231\231\231\231\231\231\231\231\231\231\231\231\231\231\231\
\\231\231\231\231\231\231\231\231\231\231\231\231\231\231\231\231\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s233 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\234\234\234\234\234\234\234\234\234\234\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s234 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\235\235\235\235\235\235\235\235\235\235\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
val s243 =
"\000\000\000\000\000\000\000\000\000\244\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\244\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
in arrayoflist
[{fin = [], trans = s0},
{fin = [(N 1)], trans = s1},
{fin = [(N 1)], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 375)], trans = s5},
{fin = [(N 375)], trans = s5},
{fin = [(N 385)], trans = s7},
{fin = [(N 385)], trans = s7},
{fin = [(N 359)], trans = s0},
{fin = [(N 325),(N 359)], trans = s10},
{fin = [(N 325)], trans = s11},
{fin = [(N 352)], trans = s12},
{fin = [], trans = s13},
{fin = [], trans = s14},
{fin = [(N 345)], trans = s14},
{fin = [], trans = s16},
{fin = [(N 345)], trans = s17},
{fin = [], trans = s18},
{fin = [], trans = s19},
{fin = [(N 345)], trans = s19},
{fin = [(N 21),(N 359)], trans = s0},
{fin = [(N 7),(N 325),(N 359)], trans = s11},
{fin = [(N 19),(N 359)], trans = s0},
{fin = [(N 325),(N 359)], trans = s24},
{fin = [(N 325)], trans = s24},
{fin = [(N 306)], trans = s0},
{fin = [(N 325),(N 359)], trans = s27},
{fin = [(N 325)], trans = s28},
{fin = [(N 325)], trans = s29},
{fin = [(N 271),(N 325)], trans = s30},
{fin = [(N 325)], trans = s31},
{fin = [(N 325)], trans = s32},
{fin = [(N 325)], trans = s33},
{fin = [(N 280),(N 325)], trans = s24},
{fin = [(N 325)], trans = s35},
{fin = [(N 325)], trans = s36},
{fin = [(N 325)], trans = s37},
{fin = [(N 266),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s39},
{fin = [(N 325)], trans = s40},
{fin = [(N 260),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s42},
{fin = [(N 325)], trans = s43},
{fin = [(N 325)], trans = s44},
{fin = [(N 256),(N 325)], trans = s24},
{fin = [(N 325)], trans = s46},
{fin = [(N 325)], trans = s47},
{fin = [(N 251),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s49},
{fin = [(N 325)], trans = s50},
{fin = [(N 325)], trans = s51},
{fin = [(N 325)], trans = s52},
{fin = [(N 325)], trans = s53},
{fin = [(N 236),(N 325)], trans = s54},
{fin = [(N 325)], trans = s55},
{fin = [(N 325)], trans = s56},
{fin = [(N 246),(N 325)], trans = s24},
{fin = [(N 325)], trans = s58},
{fin = [(N 219),(N 325)], trans = s59},
{fin = [(N 325)], trans = s60},
{fin = [(N 325)], trans = s61},
{fin = [(N 325)], trans = s62},
{fin = [(N 325)], trans = s63},
{fin = [(N 325)], trans = s64},
{fin = [(N 229),(N 325)], trans = s24},
{fin = [(N 325)], trans = s66},
{fin = [(N 325)], trans = s67},
{fin = [(N 325)], trans = s68},
{fin = [(N 325)], trans = s69},
{fin = [(N 325)], trans = s70},
{fin = [(N 215),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s72},
{fin = [(N 325)], trans = s73},
{fin = [(N 207),(N 325)], trans = s24},
{fin = [(N 325)], trans = s75},
{fin = [(N 325)], trans = s76},
{fin = [(N 325)], trans = s77},
{fin = [(N 203),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s79},
{fin = [(N 325)], trans = s80},
{fin = [(N 325)], trans = s81},
{fin = [(N 325)], trans = s82},
{fin = [(N 325)], trans = s83},
{fin = [(N 325)], trans = s84},
{fin = [(N 325)], trans = s85},
{fin = [(N 197),(N 325)], trans = s24},
{fin = [(N 325)], trans = s87},
{fin = [(N 325)], trans = s88},
{fin = [(N 325)], trans = s89},
{fin = [(N 325)], trans = s90},
{fin = [(N 287),(N 325)], trans = s24},
{fin = [(N 183),(N 325)], trans = s92},
{fin = [(N 325)], trans = s93},
{fin = [(N 188),(N 325)], trans = s24},
{fin = [(N 180),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s96},
{fin = [(N 325)], trans = s97},
{fin = [(N 325)], trans = s98},
{fin = [(N 325)], trans = s99},
{fin = [(N 325)], trans = s100},
{fin = [(N 177),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s102},
{fin = [(N 325)], trans = s103},
{fin = [(N 325)], trans = s104},
{fin = [(N 325)], trans = s105},
{fin = [(N 170),(N 325)], trans = s24},
{fin = [(N 325)], trans = s107},
{fin = [(N 164),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s109},
{fin = [(N 139),(N 325)], trans = s110},
{fin = [(N 325)], trans = s111},
{fin = [(N 325)], trans = s112},
{fin = [(N 153),(N 325)], trans = s113},
{fin = [(N 160),(N 325)], trans = s24},
{fin = [(N 325)], trans = s115},
{fin = [(N 325)], trans = s116},
{fin = [(N 325)], trans = s117},
{fin = [(N 325)], trans = s118},
{fin = [(N 147),(N 325)], trans = s24},
{fin = [(N 325)], trans = s120},
{fin = [(N 325)], trans = s121},
{fin = [(N 325)], trans = s122},
{fin = [(N 325)], trans = s123},
{fin = [(N 302),(N 325)], trans = s24},
{fin = [(N 136),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s126},
{fin = [(N 325)], trans = s127},
{fin = [(N 325)], trans = s128},
{fin = [(N 325)], trans = s129},
{fin = [(N 325)], trans = s130},
{fin = [(N 133),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s132},
{fin = [(N 325)], trans = s133},
{fin = [(N 118),(N 325)], trans = s134},
{fin = [(N 325)], trans = s135},
{fin = [(N 325)], trans = s136},
{fin = [(N 325)], trans = s137},
{fin = [(N 126),(N 325)], trans = s24},
{fin = [(N 114),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s140},
{fin = [(N 325)], trans = s141},
{fin = [(N 325)], trans = s142},
{fin = [(N 325)], trans = s143},
{fin = [(N 325)], trans = s144},
{fin = [(N 325)], trans = s145},
{fin = [(N 325)], trans = s146},
{fin = [(N 325)], trans = s147},
{fin = [(N 105),(N 325)], trans = s24},
{fin = [(N 325)], trans = s149},
{fin = [(N 325)], trans = s150},
{fin = [(N 325)], trans = s151},
{fin = [(N 325)], trans = s152},
{fin = [(N 95),(N 325)], trans = s24},
{fin = [(N 325)], trans = s154},
{fin = [(N 88),(N 325)], trans = s24},
{fin = [(N 325)], trans = s156},
{fin = [(N 325)], trans = s157},
{fin = [(N 84),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s159},
{fin = [(N 108),(N 325)], trans = s24},
{fin = [(N 325)], trans = s161},
{fin = [(N 325)], trans = s162},
{fin = [(N 325)], trans = s163},
{fin = [(N 325)], trans = s164},
{fin = [(N 325)], trans = s165},
{fin = [(N 325)], trans = s166},
{fin = [(N 75),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s168},
{fin = [(N 325)], trans = s169},
{fin = [(N 325)], trans = s170},
{fin = [(N 66),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s172},
{fin = [(N 61),(N 325)], trans = s24},
{fin = [(N 325)], trans = s174},
{fin = [(N 35),(N 325)], trans = s175},
{fin = [(N 325)], trans = s176},
{fin = [(N 325)], trans = s177},
{fin = [(N 325)], trans = s178},
{fin = [(N 295),(N 325)], trans = s24},
{fin = [(N 325)], trans = s180},
{fin = [(N 325)], trans = s181},
{fin = [(N 325)], trans = s182},
{fin = [(N 325)], trans = s183},
{fin = [(N 325)], trans = s184},
{fin = [(N 55),(N 325)], trans = s24},
{fin = [(N 325)], trans = s186},
{fin = [(N 325)], trans = s187},
{fin = [(N 325)], trans = s188},
{fin = [(N 325)], trans = s189},
{fin = [(N 325)], trans = s190},
{fin = [(N 325)], trans = s191},
{fin = [(N 47),(N 325)], trans = s24},
{fin = [(N 325),(N 359)], trans = s11},
{fin = [(N 13),(N 325),(N 359)], trans = s24},
{fin = [(N 25),(N 359)], trans = s0},
{fin = [(N 23),(N 359)], trans = s0},
{fin = [(N 11),(N 325),(N 359)], trans = s197},
{fin = [(N 111),(N 325)], trans = s11},
{fin = [(N 27),(N 359)], trans = s0},
{fin = [(N 9),(N 325),(N 359)], trans = s11},
{fin = [(N 348),(N 359)], trans = s201},
{fin = [(N 348)], trans = s201},
{fin = [(N 359)], trans = s203},
{fin = [], trans = s204},
{fin = [(N 79),(N 310)], trans = s0},
{fin = [(N 325),(N 359)], trans = s206},
{fin = [(N 58),(N 325)], trans = s11},
{fin = [(N 17),(N 359)], trans = s0},
{fin = [(N 5),(N 325),(N 359)], trans = s11},
{fin = [(N 31),(N 359)], trans = s0},
{fin = [(N 29),(N 359)], trans = s211},
{fin = [(N 357)], trans = s0},
{fin = [(N 325),(N 359)], trans = s213},
{fin = [(N 314),(N 325)], trans = s213},
{fin = [(N 15),(N 325),(N 359)], trans = s11},
{fin = [(N 354),(N 359)], trans = s0},
{fin = [(N 1),(N 359)], trans = s217},
{fin = [(N 1)], trans = s217},
{fin = [(N 3)], trans = s0},
{fin = [(N 369)], trans = s0},
{fin = [(N 369)], trans = s221},
{fin = [(N 367)], trans = s0},
{fin = [(N 369)], trans = s223},
{fin = [(N 362)], trans = s0},
{fin = [(N 364)], trans = s0},
{fin = [(N 375)], trans = s226},
{fin = [(N 412)], trans = s227},
{fin = [(N 392)], trans = s0},
{fin = [(N 395)], trans = s0},
{fin = [], trans = s230},
{fin = [(N 405)], trans = s0},
{fin = [(N 398)], trans = s0},
{fin = [], trans = s233},
{fin = [], trans = s234},
{fin = [(N 410)], trans = s0},
{fin = [(N 401)], trans = s0},
{fin = [(N 381)], trans = s0},
{fin = [(N 378)], trans = s0},
{fin = [(N 371)], trans = s0},
{fin = [(N 373)], trans = s0},
{fin = [(N 389)], trans = s0},
{fin = [(N 387),(N 389)], trans = s0},
{fin = [(N 385),(N 389)], trans = s243},
{fin = [(N 385)], trans = s243},
{fin = [(N 383)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yypos = ref 1		(* location of next character to use *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (arg as {comLevel,lineNum,complain})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			open UserDeclarations Internal.StartStates
 in (yypos := i; case yyk of 

			(* Application actions *)

  1 => (continue())
| 105 => (Token.EXCEPTION)
| 108 => (Token.DO)
| 11 => (Token.EQUAL)
| 111 => (Token.DARROW)
| 114 => (Token.FN)
| 118 => (Token.FUN)
| 126 => (Token.FUNCTOR)
| 13 => (Token.WILD)
| 133 => (Token.HANDLE)
| 136 => (Token.IF)
| 139 => (Token.IN)
| 147 => (Token.INCLUDE)
| 15 => (Token.HASH)
| 153 => (Token.INFIX)
| 160 => (Token.INFIXR)
| 164 => (Token.LET)
| 17 => (Token.COMMA)
| 170 => (Token.LOCAL)
| 177 => (Token.NONFIX)
| 180 => (Token.OF)
| 183 => (Token.OP)
| 188 => (Token.OPEN)
| 19 => (Token.LBRACE)
| 197 => (Token.OVERLOAD)
| 203 => (Token.RAISE)
| 207 => (Token.REC)
| 21 => (Token.RBRACE)
| 215 => (Token.SHARING)
| 219 => (Token.SIG)
| 229 => (Token.SIGNATURE)
| 23 => (Token.LBRACKET)
| 236 => (Token.STRUCT)
| 246 => (Token.STRUCTURE)
| 25 => (Token.RBRACKET)
| 251 => (Token.THEN)
| 256 => (Token.TYPE)
| 260 => (Token.VAL)
| 266 => (Token.WHILE)
| 27 => (Token.SEMICOLON)
| 271 => (Token.WITH)
| 280 => (Token.WITHTYPE)
| 287 => (Token.ORELSE)
| 29 => (Token.LPAREN)
| 295 => (Token.ANDALSO)
| 3 => (inc lineNum; continue())
| 302 => (Token.IMPORT)
| 306 => (Token.IDDOT (Symbol.symbol(substring(yytext,0,size(yytext)-1))))
| 31 => (Token.RPAREN)
| 310 => (Token.DOTDOTDOT)
| 314 => (Token.TYVAR(Symbol.symbol yytext))
| 325 => (Token.ID(Symbol.symbol yytext))
| 345 => (Token.REAL yytext)
| 348 => (Token.INT(makeInt yytext
		    handle Overflow => (complain "integer too large"; 0)))
| 35 => (Token.AND)
| 352 => (Token.INT(~(makeInt(substring(yytext,1,size(yytext)-1)))
		    handle Overflow => (complain "integer too large"; 0)))
| 354 => (charlist := nil; YYBEGIN S; continue())
| 357 => (YYBEGIN A; comLevel := 1; continue())
| 359 => (complain "illegal token"; continue())
| 362 => (inc comLevel; continue())
| 364 => (inc lineNum; continue())
| 367 => (dec comLevel; if !comLevel=0 then YYBEGIN INITIAL else (); continue())
| 369 => (continue())
| 371 => (YYBEGIN INITIAL; Token.STRING(implode(rev(!charlist))))
| 373 => (complain "unclosed string"; YYBEGIN INITIAL; Token.STRING "")
| 375 => (addString yytext; continue())
| 378 => (inc lineNum; YYBEGIN F; continue())
| 381 => (YYBEGIN F; continue())
| 383 => (inc lineNum; continue())
| 385 => (continue())
| 387 => (YYBEGIN S; continue())
| 389 => (complain "unclosed string"; YYBEGIN INITIAL; Token.STRING "")
| 392 => (addString "\t"; continue())
| 395 => (addString "\n"; continue())
| 398 => (addString "\\"; continue())
| 401 => (addString(chr(Ascii.dquote)); continue())
| 405 => (addString(chr(ordof(yytext,2)-ord("@"))); continue())
| 410 => (let val x = ordof(yytext,1)*100
	     +ordof(yytext,2)*10
	     +ordof(yytext,3)
	     -(Ascii.zero*111)
  in (if x>255
      then complain ("illegal ascii escape '"^yytext^"'")
      else addString (chr x);
      continue())
  end)
| 412 => (complain "illegal string escape"; continue())
| 47 => (Token.ABSTRACTION)
| 5 => (Token.ASTERISK)
| 55 => (Token.ABSTYPE)
| 58 => (Token.ARROW)
| 61 => (Token.AS)
| 66 => (Token.CASE)
| 7 => (Token.BAR)
| 75 => (Token.DATATYPE)
| 79 => (Token.DOTDOTDOT)
| 84 => (Token.ELSE)
| 88 => (Token.END)
| 9 => (Token.COLON)
| 95 => (Token.EQTYPE)
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Internal.tab sub s
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = ordof(trans,NewChar)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yypos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yypos,!yypos)
    end
in continue end
  in lex
  end
end
