      SUBROUTINE DODES1(F,X,NX,TSTART,TSTOP,DT,ERROR,ERRPAR,HANDLE,
     1                  GLBMAX,ERPUTS)
C
C  TO SOLVE THE INITIAL VALUE PROBLEM FOR
C
C          DX(T)/DT = F(T,X(T)).
C
C  METHOD - RATIONAL EXTRAPOLATION OF GRAGGS MODIFIED MID-POINT RULE.
C
C  THE 3 EXTRA ARGUMENTS IN THIS SUBROUTINE PROVIDE MORE USER
C  CONTROL OVER THE ACCURACY OF THE INTEGRATION PROCESS.
C
C  INPUT
C
C    F      - CALL F(T,X,NX,FTX) SHOULD RETURN FTX(I)=F(T,X)(I),
C             FOR I=1,...,NX. IF IT CANNOT, IT SHOULD RETURN
C             OKAY=.FALSE. IN COMMON /DODESF/OKAY .
C             F SHOULD BE DECLARED EXTERNAL IN THE SUBPROGRAM
C             CALLING DODES.
C    X      - THE INITIAL VALUES FOR THE SOLUTION.
C    NX     - THE LENGTH OF THE SOLUTION VECTOR X.
C    TSTART - THE INITIAL TIME.
C    TSTOP  - THE FINAL TIME.
C    DT     - THE INITIAL TIME-STEP TO BE USED.
C             THE PERFORMANCE OF DODES IS SUBSTANTIALLY
C             INDEPENDENT OF THE VALUE OF DT CHOSEN BY THE USER.
C             IT IS SUFFICIENT THAT THE USERS CHOICE FOR DT MERELY BE
C             WITHIN SEVERAL ORDERS OF MAGNITUDE OF BEING CORRECT.
C             THE VALUE OF DT WILL BE AUTOMATICALLY CHANGED BY DODES
C             DURING THE INTEGRATION PROCESS IN SUCH A WAY AS TO GET
C             THE SOLUTION, TO THE DESIRED ACCURACY, AT THE LEAST
C             POSSIBLE COST.
C    ERROR  - ERROR TOLERANCE ROUTINE.
C
C                 LOGICAL FUNCTION ERROR(X,NX,T,DT,ERRPAR,ERPUTS,E)
C
C             HAS AS INPUT
C
C               X,T    - X=X(T), THE APPROXIMATE SOLUTION FOR WHICH
C                        AN ERROR CRITERION IS DESIRED.
C               NX     - THE LENGTH OF X.
C               DT     - THE TIME-STEP USED TO OBTAIN X(T).
C               ERRPAR - TWO PARAMETERS, AS GIVEN TO DODES1.
C               ERPUTS - THIS VARIABLE HAS THE SAME VALUE AS ERPUTS IN
C                        THE CALL TO DODES1.
C               E      - THE REAL ABSOLUTE ERROR IN X(I) IS E(I),
C                        I=1,...,NX, FOR THE SINGLE CURRENT TIME-STEP.
C
C             THE OUTPUT IS
C
C               ERRPAR - MAY BE ALTERED IF DESIRED.
C               E      - E(I) IS THE REAL TOLERABLE ABSOLUTE ERROR IN
C                        X(I), FOR I=1,...,NX. ALL THE E(I) MUST BE
C                        POSITIVE.
C
C             FUNCTION VALUE
C
C               ERROR  - ERROR=.TRUE. IF CONVERGED.
C                        ERROR=.FALSE. IF NOT.
C    ERRPAR - TWO PARAMETERS TO BE PASSED TO ERROR.
C    HANDLE - OUTPUT ROUTINE WITH A CALLING SEQUENCE OF THE FORM
C
C                     HANDLE(T0,X0,T1,X1,NX,DT,TSTOP,E)
C
C             HANDLE WILL BE CALLED AT THE END OF EACH TIME-STEP.
C
C             THE INPUT TO HANDLE IS AS FOLLOWS
C
C               X0,X1  - X0=X(T0) AND X1=X(T1).
C               T0,T1  - T0=T1 INDICATES A RESTART AND X1 IS FULL OF
C                        GARBAGE.
C               NX     - THE LENGTH OF THE SOLUTION VECTOR X.
C               DT     - THE PROPOSED TIME-STEP FOR THE NEXT STEP.
C               TSTOP  - THE CURRENT FINAL TIME.
C               E      - E(I) GIVES THE REAL ABSOLUTE ERROR IN X1(I),
C                        I=1,...,NX, FOR THE SINGLE CURRENT TIME-STEP.
C
C             THE OUTPUT FROM HANDLE MAY BE ANY OF
C
C               X1     - MAY BE ALTERED IF DESIRED.
C               DT     - THE PROPOSED TIME-STEP FOR THE NEXT STEP.
C               TSTOP  - THE FINAL TIME VALUE.
C
C             HANDLE SHOULD BE DECLARED EXTERNAL IN THE
C             SUBPROGRAM CALLING DODES.
C    GLBMAX - IF (GLBMAX) THEN THE GLOBAL MAXIMUM OF THE ABSOLUTE VALUE
C             OF THE SOLUTION IS TO BE RECORDED.
C             THE GLOBAL MAXIMUM INFORMATION IS STORED IN COMMON,
C             AS DESCRIBED IN DODES2.
C
C             IF THE ERROR SUBPROGRAM SUPPLIED BY THE USER IS DODESE,
C             THEN GLBMAX DETERMINES WHETHER OR NOT THE GLOBAL
C             MAXIMUM ABSOLUTE VALUE OF THE SOLUTION WILL BE USED IN
C             THAT SUBPROGRAM.
C    ERPUTS - IF (ERPUTS) THEN THE ERROR PER UNIT TIME-STEP CRITERION
C             IS TO BE USED IN THE ERROR ROUTINE.
C             OTHERWISE, THE ERROR PER TIME-STEP CRITERION IS TO BE
C             USED IN THE ERROR ROUTINE.
C
C             IF THE ERROR SUBPROGRAM SUPPLIED BY THE USER IS DODESE,
C             THEN ERPUTS DETERMINES WHETHER OR NOT THE ERROR
C             PER UNIT-TIME-STEP OR ERROR PER TIME-STEP ERROR
C             CRITERION WILL BE USED BY THAT SUBPROGRAM.
C
C  OUTPUT
C
C    X      - X=X(TSTOP), THE FINAL VALUE FOR THE SOLUTION.
C    TSTOP  - MAY BE ALTERED BY USER SUPPLIED ROUTINE HANDLE.
C    DT     - PROPOSED TIME-STEP FOR THE NEXT STEP, IF ANY.
C    ERRPAR - MAY BE ALTERED BY USER SUPPLIED ROUTINE ERROR.
C
C  SCRATCH SPACE OF LENGTH
C
C                    S(DODES1) .LE.
C
C    32 + 12*NX
C
C  DOUBLE PRECISION WORDS +
C
C    101 + ( IF (GLBMAX) THEN 2*NX , OTHERWISE 0 ) +
C
C    MAX( 2*NX DOUBLE PRECISION + S(F) ,
C
C         11*NX + MAX ( 10 DOUBLE PRECISION + 10 , S(ERROR) ) ,
C
C         NX + S(HANDLE) )
C
C  INTEGER WORDS IS ALLOCATED.
C
C  ERROR STATES
C
C    1 - NX.LT.1.
C    2 - DT HAS THE WRONG SIGN ON INPUT.
C    3 - DT=0 ON INPUT.
C    4 - DT RETURNED BY HANDLE HAS THE WRONG SIGN.
C    5 - DT=0 WAS RETURNED BY HANDLE. (RECOVERABLE)
C    6 - THE ERROR DESIRED IN X(I) IS NOT POSITIVE. (RECOVERABLE)
C    7 - DT=0. (RECOVERABLE)
C    8 - CANNOT RAISE DT IN HANDLE WHEN .NOT.OKAY.
C
      COMMON /DODESF/OKAY
C
      DOUBLE PRECISION X(NX),TSTART,TSTOP,DT
      REAL ERRPAR(2)
      LOGICAL GLBMAX,ERPUTS,OKAY
      EXTERNAL F,ERROR,HANDLE
C
      IF (TSTART.EQ.TSTOP) GO TO 10
C
      CALL DODES2(F,X,NX,TSTART,TSTOP,DT,ERROR,ERRPAR,HANDLE,
     1            GLBMAX,ERPUTS,10,16)
C
 10   RETURN
C
      END
