/* addressed signed long division: *dividend = *dividend/divisor */

aldiv:	.globl	aldiv
	link	a6,#0
	moveml	#0x3C00,sp@-	/* need d2,d3,d4,d5 registers */
	movl	#1,d5		/* sign of result */
	movl	a6@(8),a0	/* a0 = dividend pointer */
	movl	a0@,d0		/* d0 = dividend */
	jge	1f
	negl	d0
	negw	d5
1:
	movl	d0,d3		/* save positive dividend */
	movl	a6@(12),d1	/* divisor */
	jge	2f
	negl	d1
	negw	d5
2:
	movl	d1,d4		/* save positive divisor */

	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jcc	3f		/* no, divisor must be < 2 ** 16 */
	clrw	d0		/* yes, divide dividend */
	swap	d0		/*   by 2 ** 16 */
	divu	d1,d0		/* get the high order bits of quotient */
	movw	d0,d2		/* save quotient high */
	movw	d3,d0		/* dividend low + remainder*(2**16) */
	divu	d1,d0		/* get quotient low */
	swap	d0		/* temporarily save quotient low in high */
	movw	d2,d0		/* restore quotient high to low part of reg */
	swap	d0		/* put things right */
	jra	5f		/* return */
3:
	lsrl	#1,d0		/* shift dividend */
	lsrl	#1,d1		/* shift divisor */
	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jcc	3b		/* no, continue shift */
	divu	d1,d0		/* yes, divide, remainder is garbage */
	andl	#0xFFFF,d0	/* get rid of remainder */
	movl	d0,d2		/* save quotient */
	movl	d0,sp@-		/* call ulmul with quotient */
	movl	d4,sp@-		/*   and saved divisor on stack */
	jsr	ulmul		/*   as arguments */
	addql	#0x8,sp		/* restore sp */
	cmpl	d0,d3		/* original dividend >= lmul result? */
	jcc	4f		/* yes, quotient should be correct */
	subql	#1,d2		/* no, fix up quotient */
4:
	movl	d2,d0		/* move quotient to d0 */
5:
	tstw	d5		/* sign of result */
	jge	6f
	negl	d0
6:
	movl	d0,a0@		/* store result via pointer */
	moveml	sp@+,#0x003C	/* restore registers */
	unlk	a6
	rts
