/* mardyd.c:  RT68k S message gateway */
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/ipm.h>
#include <sys/enio.h>
#include <sys/ethernet.h>


int	debug;		/* should I print out stuff? */

main()
{
	int dbon(), dboff();
	int type = 0xBAD2;
	register fd, n;
	char buffer[1520];
	register struct mesghdr *mp;
	register char *p;

	signal(SIGIOT, dbon);
	signal(SIGEMT, dboff);
	fd = get_cm();
	eioctl(fd, ENIOTYPE, &type);
	while (n = read(fd, buffer, sizeof buffer)) {
		if (n < 14 + sizeof (struct mesghdr)) {
			dprintf("martyd: short (%d) frame\n", n);
			continue;
		}
		mp = (struct mesghdr *)(buffer + 14);
		p = msgalloc(mp->length);
		bcopy((char *)(mp+1), p, mp->length);
		if (msgsend(mp, p) == -1)
			msgfree(p);
		dprintf("martyd: ");
		dpr_header(mp);
		dprintf("\n");
	}
}

dprintf(fmt, a, b, c, d, e, f)
	char *fmt;
{
	if (debug == 0)
		return;
	fprintf(stderr, fmt, a, b, c, d, e, f);
}

dbon()
{
	debug = 1;
	signal(SIGIOT, dbon);
}

dboff()
{
	debug = 0;
	signal(SIGEMT, dboff);
}

dpr_header(mp)
	register struct mesghdr *mp;
{
	dprintf("%d.%d.%d.%d ", mp->orig.net, mp->orig.node,
		mp->orig.scope, mp->dest.sid);
	dprintf("%d.%d.%d.%d ", mp->dest.net, mp->dest.node,
		mp->dest.scope, mp->dest.sid);
	dprintf("%d 0", mp->length);
	p(mp->flags, MESG_IMPORTANT, 'I');
	p(mp->flags, MESG_RETURNED, 'R');
	p(mp->flags, MESG_FAST, 'F');
	dprintf("\n");
}

p(flags, bit, ch)
{
	dprintf("%c", flags & bit ? ch : '-');
}

get_cm()	/* find an open cm device */
{
	register i, fd;
	char name[64];

	for (i = 0; i < 10; i++) {
		sprintf(name, "/dev/cm0%d", i);	/* change to 'en' */
		if ((fd = open(name, 2)) != -1)
			return fd;
	}
	dprintf("martyd: Can't find cm file\n");
	exit(1);
}

eioctl(fd, cmd, arg)
{
	if (ioctl(fd, cmd, arg) == -1) {
		dprintf("martyd: bad ioctl(%d, 0x%x, 0x%x\n", 
			fd, cmd, arg);
		exit(1);
	}
}
