/ filename :	wsub.s
/ purpose  :	ethernet in/out [s] b|w functions
/ author   :	Randy Wright
/             	Copyright ((C)) 1993 Randy Wright
/
/$Log:	wsub.s,v $
/Revision 2.1  94/01/25  22:00:47  root
/cleaned up comments and rmd oub,inb.
/ready for beta.
/
/Revision 2.0  94/01/19  16:13:47  root
/*** empty log message ***
/
/Revision 1.1  93/11/14  00:17:05  root
/Initial revision
/
/
/	module name wsub
	.alignoff
	.intelorder

	.text
////		ee_insw( port, data, len ) int port; short *data;
/
/
/
	.globl ee_insw
ee_insw:
	push	%ebp
	movl	%ebp, %esp


	push	%es		/ just in case it needs to be preserved
	push	%edi		/ save this, it must be preserved

	push	%ds		/ put ds into es so that ed:di point to data
	pop	%es     	/ loads es with data seg 

	movl	%eax, 16(%ebp)	/ grab len
	movl	%ecx, %eax	/ put len into %ecx

	movl	%edi, 12(%ebp)	/ put data pointer in edi, must point to word
				/ aligned variable

	cld			/ clear direction
	movl	%edx, 8(%ebp)	/ put the port number into edx

	/////////////////////////////////////////////////////
	/////// this loop is used instead of rep insw to try
	/////// to avoid some chip bug
eel:

	insw			/ get the word from the port, repeat ecx times
/	jmp	eej		/ this adds some bus settling time
/ eej:				
	loop	eel		/
	/////////////////////////////////////////////////////

	pop	%edi		/ restore
	pop	%es		/ restore
	leave			/ restore %ebp
	ret

	.align	4

////		ee_insb( port, data, len ) int port; short *data;
/
/
/
	.globl ee_insb
ee_insb:
	push	%ebp
	movl	%ebp, %esp


	push	%es		/ just in case it needs to be preserved
	push	%edi		/ save this, it must be preserved

	push	%ds		/ put ds into es so that ed:di point to data
	pop	%es     	/ loads es with data seg 

	movl	%eax, 16(%ebp)	/ could be used
	movl	%ecx, %eax	/ put a 1 into %ecx

	movl	%edi, 12(%ebp)	/ put data pointer in edi, must point to word
				/ aligned variable

	movl	%edx, 8(%ebp)	/ put the port number into edx

eek:

	insb			/ get the word from the port, repeat ecx times
	jmp	eeh		/ this adds some bus settling time
eeh:				
	loop	eek		/


	pop	%edi		/ restore
	pop	%es		/ restore
	leave			/ restore %ebp
	ret

	.align	4

////		ee_outsw( port, data, len ) int port; short *data;
/
/
/
	.globl ee_outsw
ee_outsw:
	push	%ebp
	movl	%ebp, %esp


	push	%esi		/ save this, it must be preserved

	movl	%eax, 16(%ebp)	/ could be used to make a real insw
	movl	%ecx, %eax	/ put a 1 into %ecx

	movl	%esi, 12(%ebp)	/ put data pointer in esi, must point to word
				/ aligned variable

	cld			/ make sure we're going the right direction
	movl	%edx, 8(%ebp)	/ put the port number into edx

	/////////////////////////////////////////////////////
eeo:
	outsw			/ get the word from the port, repeat ecx times
/	jmp	eep		/ bus timing
/ eep:
	loop	eeo
	/////////////////////////////////////////////////////
	pop	%esi		/ restore

	leave			/ restore %ebp
	ret

	.align	4

////		ee_outsb( port, data, len ) int port; short *data;
/
/
/
	.globl ee_outsb
ee_outsb:
	push	%ebp
	movl	%ebp, %esp


	push	%esi		/ save this, it must be preserved

	movl	%eax, 16(%ebp)	/ could be used to make a real insw
	movl	%ecx, %eax	/ put a 1 into %ecx

	movl	%esi, 12(%ebp)	/ put data pointer in esi, must point to word
				/ aligned variable

	movl	%edx, 8(%ebp)	/ put the port number into edx

	rep
	outsb			/ get the byte from the port, repeat ecx times

	pop	%esi		/ restore

	leave			/ restore %ebp
	ret

	.align	4


//// 		e_outw( port, dat[i] )  int port,  dat;
/
/
/
	.align	4
	.globl e_outw
e_outw:
	push	%ebp
	movl	%ebp, %esp
	movl	%edx, $0	/ clear %edx
	movl	%edx, 8(%ebp)	/ load edx
	movl	%eax, 12(%ebp)	/ load eax
	outw	(%dx)  //, %ax  / send the word
	leave			/ an after thought to retreive %ebp
	ret
	.align	4


//// 		e_inw( port )  int port;
/
/
/
	.align	4
	.globl e_inw
e_inw:
	push	%ebp
	movl	%ebp, %esp
	movl	%edx, $0	/ clear %edx
	movl	%edx, 8(%ebp)	/ load edx

	/ movl	%eax, $0	/ clear %eax

	inw	(%dx)  //, %ax  / get the word into ax

	leave			/ an after thought to retreive %ebp
	ret

	.align	4
	.align	4


/// end wsub.s ////
