static char *rcsid ="$Header: code.c,v 1.2 84/12/05 17:28:30 root Exp $";
#include <stdio.h>
# include <signal.h>
# include "mfile1"
#ifdef CROSS
# include "/port/include/sys/types.h"
# include "/port/include/a.out.h"
# include "/port/include/stab.h"
#else
# include <sys/types.h>
# include <a.out.h>
# include <stab.h>
#endif

# ifdef ONEPASS
extern int usedregs;	/* bit == 1 if reg was used in subroutine */
extern char *rnames[];
# else ONEPASS
int usedregs = 0;	/* bit == 1 if reg was used in subroutine */
char *
rnames[]= {  /* keyed to register number tokens */

	"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
	"a0", "a1", "a2", "a3", "a4", "a5", "a6", "sp"
	};
# endif ONEPASS

int proflg = 0;	/* are we generating profiling code? */
int strftn = 0;  /* is the current function one which returns a value */
int gdebug;
int fdefflag;  /* are we within a function definition ? */
char NULLNAME[8];
int labelno;
int prolab, pblab;	/* label for prolog and for branch to it */

branch( n ){
	/* output a branch to label n */
	printf( "	jra	L%d\n", n );
	}

int lastloc = PROG;

defalign(n) {
	/* cause the alignment to become a multiple of n */
	n /= SZCHAR;
	if( lastloc != PROG && n > 1 ) printf( "	.align	2\n" );
	}

locctr( l ){
	register temp;
	/* l is PROG, ADATA, DATA, STRNG, ISTRNG, or STAB */

	if( l == lastloc ) return(l);
	temp = lastloc;
	lastloc = l;
	switch( l ){

	case PROG:
		printf( "	.text\n" );
		psline();
		break;

	case DATA:
	case ADATA:
		printf( "	.data\n" );
		break;

	case STRNG:
		printf( "	.data	1\n" );
		break;

	case ISTRNG:
		printf( "	.data	2\n" );
		break;

	case STAB:
		printf( "	.stab\n" );
		break;

	default:
		cerror( "illegal location counter" );
		}

	return( temp );
	}

deflab( n ){
	/* output something to define the current position as label n */
	printf( "L%d:\n", n );
	}

int crslab = 10;

getlab(){
	/* return a number usable for a label */
	return( ++crslab );
	}

efcode(){
	/* code for the end of a function */

	if( strftn ){  /* copy output (in r0) to caller */
		register struct symtab *p;
		register int stlab;
		register int count;
		int size;

		p = &stab[curftn];

		deflab( retlab );
		retlab = getlab();

		stlab = getlab();
		size = tsize( DECREF(p->stype), p->dimoff, p->sizoff ) / SZCHAR;
#ifndef LCOMM
		printf("	.data\n" );
		printf("	.align	2\n" );
		printf("L%d:	.space	%d\n", stlab, size);
		printf("	.text\n" );
#else
		printf("	.lcomm	L%d,%d\n", stlab, size);
#endif
		psline();
		printf( "	movl	d0,a0\n" );
		printf( "	movl	#L%d,a1\n" , stlab );
		count = size/4;
		while( count-- ) {
			printf( "	movl	a0@+,a1@+\n" );
		}
		if (size&2) {
			printf( "	movw	a0@+,a1@+\n" );
		}
		if (size&1) {
			printf( "	movb	a0@+,a1@+\n" );
		}
		printf( "	movl	#L%d,d0\n", stlab );
		/* turn off strftn flag, so return sequence will be generated */
		strftn = 0;
		}
/*	branch( retlab );
/* */
# ifdef ONEPASS
	p2bend();
# else ONEPASS
	printf(")L%d:\n]\n",retlab);
# endif ONEPASS
	fdefflag = 0;
	}

bfcode( a, n ) int a[]; {
	/* code for the beginning of a function; a is an array of
		indices in stab for the arguments; n is the number */
	register i;
	register temp;
	register struct symtab *p;
	int off;
	char type;

	locctr( PROG );
	p = &stab[curftn];
	defnam( p );
	temp = p->stype;
	temp = DECREF(temp);
	strftn = (temp==STRTY) || (temp==UNIONTY);

	retlab = getlab();

	if (gdebug) {
#ifdef STABDOT
		pstabdot(N_SLINE, lineno);
#else
		pstab(NULLNAME, N_SLINE);
		printf("0,%d,LL%d\n", lineno, labelno);
		printf("LL%d:\n", labelno++);
#endif
	}

	if( proflg ){
		i = getlab();
		printf( "	movl	#L%d,a1\n", i );
		printf( "	jbsr	mcount\n" );
		printf("	.data\n");
		printf("	.align	2\n");
		printf("L%d:	.long	0\n", i);
		printf("	.text\n");
		psline();
		}

	/* routine prolog */

# ifdef OLDPROLOG
	printf( "	link	a6,#_F%d\n", ftnno );
	printf( "	moveml	#_S%d,sp@\n", ftnno );
# else OLDPROLOG
	branch(prolab = getlab());
	deflab(pblab = getlab());
# endif OLDPROLOG

	usedregs = 0;

	off = ARGINIT;

	for( i=0; i<n; ++i ){
		p = &stab[a[i]];
		if( p->sclass == REGISTER ){
			temp = p->offset;  /* save register number */
			p->sclass = PARAM;  /* forget that it is a register */
			p->offset = NOOFFSET;
			oalloc( p, &off );
			if (p->stype==CHAR || p->stype==UCHAR) type = 'b';
			else if (p->stype==SHORT || p->stype==USHORT) type = 'w';
			else type = 'l';
			printf( "	mov%c	a6@(%d),%s\n",
					type, p->offset/SZCHAR, rnames[temp] );
			usedregs |= 1<<temp;
			p->offset = temp;  /* remember register number */
			p->sclass = REGISTER;   /* remember that it is a register */
			}
		else {
			if( oalloc( p, &off ) ) cerror( "bad argument" );
			}

		}
# ifdef OLDPROLOG
# ifdef SKY
	printf("	movl	_skyaddr,");
	skyref();
	printf("\n");
	printf("\taddql	#4,");
	skyref();
	printf("\n");
# endif SKY
# endif OLDPROLOG
/*	printf("| A%d = %d\n", ftnno, off/SZCHAR);
/* */
	fdefflag = 1;
	}

bccode(){ /* called just before the first executable statment */
		/* by now, the automatics and register variables are allocated */
	extern regvar;

	SETOFF( autooff, SZINT );
	/* set aside store area offset */
# ifdef ONEPASS
	p2bbeg( autooff, regvar );
# else ONEPASS
	printf("[%d\t%d\t%d\t%d\t\n",ftnno,autooff,regvar,usedregs);
# endif ONEPASS
	}

ejobcode( flag ){
	/* called just before final exit */
	/* flag is 1 if errors, 0 if none */
	}

aobeg(){
	/* called before removing automatics from stab */
	}

aocode(p) struct symtab *p; {
	/* called when automatic p removed from stab */
	}

aoend(){
	/* called after removing all automatics from stab */
	}

defnam( p ) register struct symtab *p; {
	/* define the current location as the name p->sname */

	if( p->sclass == EXTDEF ){
		printf( "	.globl	%s\n", exname( p->sname ) );
		}
	if( p->sclass == STATIC && p->slevel>1 ) deflab( p->offset );
	else printf( "%s:\n", exname( p->sname ) );

	}

bycode( t, i ){
#ifdef ASSTRINGS
static	int	lastoctal = 0;
#endif

	/* put byte i+1 in a string */

#ifdef ASSTRINGS

	i &= 077;
	if ( t < 0 ){
		if ( i != 0 )	printf( "\"\n" );
	} else {
		if ( i == 0 ) printf("\t.ascii\t\"");
		if ( t == '\\' || t == '"'){
			lastoctal = 0;
			printf("\\%c", t);
		}
			/*
			 *	We escape the colon in strings so that
			 *	c2 will, in its infinite wisdom, interpret
			 *	the characters preceding the colon as a label.
			 *	If we didn't escape the colon, c2 would
			 *	throw away any trailing blanks or tabs after
			 *	the colon, but reconstruct a assembly
			 *	language semantically correct program.
			 *	C2 hasn't been taught about strings.
			 */
		else if ( t == ':' || t < 040 || t >= 0177 ){
			lastoctal++;
			printf("\\%o",t);
		}
		else if ( lastoctal && '0' <= t && t <= '9' ){
			lastoctal = 0;
			printf("\"\n\t.ascii\t\"%c", t );
		}
		else
		{	
			lastoctal = 0;
			putchar(t);
		}
		if ( i == 077 ) printf("\"\n");
	}
#else

	i &= 07;
	if( t < 0 ){ /* end of the string */
		if( i != 0 ) printf( "\n" );
		}

	else { /* stash byte t into string */
		if( i == 0 ) printf( "	.byte	" );
		else printf( "," );
		printf( "0x%x", t );
		if( i == 07 ) printf( "\n" );
		}
#endif
	}

zecode( n ){
	/* n integer words of zeros */
	OFFSZ temp;

	if( n <= 0 ) return;
	printf( "	.space	%d\n", (SZINT/SZCHAR)*n );
	temp = n;
	inoff += temp*SZINT;
	}

fldal( t ) unsigned t; { /* return the alignment of field of type t */
	uerror( "illegal field type" );
	return( ALINT );
	}

fldty( p ) struct symtab *p; { /* fix up type of field p */
	;
	}

# ifdef BOZO
where(c){ /* print location of error  */
	/* c is either 'u', 'c', or 'w' */
	fprintf( stderr, "%s, line %d: ", ftitle, lineno );
	}
# endif BOZO

main( argc, argv ) char *argv[]; {

	return mainp1( argc, argv );
	}

genswitch(p,n) register struct sw *p; register n; {
	/*	p points to an array of structures, each consisting
		of a constant value and a label.
		The first label is >=0 if there is a default label;
		the label value is the label number.  The corresponding
		constant value field contains the type.
		The entries p[1] to p[n] are the nontrivial cases
		*/
	register i;
	register CONSZ j, range;
	int dlab, swlab;
	int type = p->sval;

	if (ISPTR(type)) type = UNSIGNED;
	else if (type != BTYPE(type)) {
		cerror ("strange switch type");
		return;
	}
	if (type==CHAR || type==UCHAR ||
	    type==SHORT || type==USHORT) for (i=1; i<=n; i++) {
		register v = p[i].sval;
		switch(type) {
		  case CHAR:	if (v < -128 || v > 127) goto delete; break;
		  case UCHAR:	if ((unsigned)v > 0xFF) goto delete; break;
		  case SHORT:	if (v < -32768 || v > 32767) goto delete; break;
		  case USHORT:	if ((unsigned)v > 0xFFFF) goto delete; break;
		}
		continue;
	  delete:
		for (j=i; j<n; j++) {
			p[j].sval = p[j+1].sval;
			p[j].slab = p[j+1].slab;
		}
		i -= 1;
		n -= 1;
	}

	range = p[n].sval-p[1].sval;

	if( range>0 && range <= 3*n && n>=4 ){ /* implement a direct switch */
		register char c = "?awwllfdsuemwwll"[type];

		dlab = p->slab >= 0 ? p->slab : getlab();

		if (type==CHAR)
			printf( "	extw	d0\n" );
		else if (type==UCHAR)
			printf( "	andw	#0xFF,d0\n" );
		if( p[1].sval ){
			printf( "	sub%c	#", c );
			printf( CONFMT, p[1].sval );
			printf( ",d0\n" );
			}

		/* note that this is a cl; it thus checks
		   for numbers below range as well as out of range.
		   */
		printf( "	cmp%c	#0x%x,d0\n", c, range );
		printf( "	bhi	L%d\n", dlab );

		printf( "	addw	d0,d0\n" );
		printf(	"	movw	pc@(6,d0:w),d0\n" );
		printf( "	jmp	pc@(2,d0:w)\n" );

		/* output table */
		printf("L%d:", (swlab = getlab()) );
		for( i=1,j=p[1].sval; i<=n; ++j )

			printf( "	.word	L%d-L%d\n", (j == p[i].sval ? p[i++].slab : dlab), swlab );

		if( p->slab< 0 ) deflab( dlab );
		return;

		}

	genbinary(p,1,n,0,type);
}

genbinary(p,lo,hi,lab,type)
  register struct sw *p;
  {	register int i,lab1;
	char c = "?abwllfdsuembwll"[type];

	if (lab) printf("L%d:",lab);	/* print label, if any */

	if (hi-lo > 4) {		/* if lots more, do another level */
	  i = lo + ((hi-lo)>>1);	/* index at which we'll break this time */
	  printf( "	cmp%c	#0x%x,d0\n", c, p[i].sval );
	  printf( "	beq	L%d\n", p[i].slab );
	  lab1 = getlab();
	  switch(type) {
	    case UCHAR:
	    case USHORT:
		printf( "	bhi	L%d\n", lab1);
		break;
	    default:
		printf( "	bgt	L%d\n", lab1);
		break;
	  }
	  genbinary(p,lo,i-1,0,type);
	  genbinary(p,i+1,hi,lab1,type);
	} else {			/* simple switch code for remaining cases */
	  for( i=lo; i<=hi; ++i ) {
	    printf( "	cmp%c	#0x%x,d0\n", c, p[i].sval );
	    printf( "	beq	L%d\n", p[i].slab );
	  }
	  if( p->slab>=0 ) branch( p->slab );
	}
}
