/*
 *	clock.c
 *      timekeeping & accounting
 */
#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\callout.h"
#include "h\systm.h"
#include "h\machine.h"

#define SCHMAG	10

struct alrm alarm[NTOUT];

extern struct gat_desc intr_32;
int idlemode=0;
int lbolt=0;
time_t time,tout;

void incupc (word,word*);

/*
 *	primary clock interrupt
 */
void t_clock(void)

	{
	register struct proc *pp;
	struct alrm *al1,*al2;

	intr_32.selector=0x158;		/* secondary clk int	*/

TCLK:	intack1();
	if (alarm[0].fun==0)		/* are there callouts?	*/
		goto NOTNOW;

	al2=alarm;
	while(al2->time<=0 && al2->fun!=NULL)
		++al2;
	al2->time--;

	if (!idlemode&&!lastmode)	/* callouts only from usermode	*/
		goto NOTNOW;

	lock();
	if(alarm[0].time<=0)
		{
		al1=alarm;
		while(al1->fun!=NULL && al1->time<=0)
			{
			(*al1->fun)(al1->arg);
			++al1;
			}
		al2=alarm;
#pragma warn -pia
		while(al2->fun=al1->fun)
#pragma warn +pia
			{
			al2->time=al1->time;
			al2->arg=al1->arg;
			al1++;
			al2++;
			}
		}

NOTNOW:
	if (!lastmode)
		{
		u->u_stime++;		/* charge system time	*/
		if (u->u_prof[3])
			incupc(cup->p_tss.ip,u->u_prof);
		}
	else
		{
		u->u_utime++;		/* charge user time	*/
		}
	if(++(cup->p_cpu)==0)           /* cpu time for sceduling	*/
		(cup->p_cpu)--;

	if(++lbolt>=HZ)
		{
		if (!lastmode&&!idlemode) goto GOOUT;

		lbolt-=HZ;

		time++;

		enable();

		if (time==tout)         /* sleep system call	*/
			wakeup ((int)&tout);

		if ((time & 3)==0)
			{
			runrun++;
			wakeup ((int)&lbolt);
			}

		for (pp=&proc[0];pp<&proc[NPROC];pp++)
		if (pp->p_stat)
			{
			if (pp->p_time!=127)
				pp->p_time++;
			if (pp->p_cpu > SCHMAG)
				pp->p_cpu -=SCHMAG;
			else
				pp->p_cpu=0;

			if (pp->p_pri > PUSER)	/* set priorities	*/
				{
				setpri (pp);
				}
			}
		if (runin!=0)			/* wake up swapper	*/
			{
			runin=0;
			wakeup((int)&runin);
			}
		if (lastmode)			/* handle signals	*/
			{
			if(issig())
				{
				psig(3);
				goto TCLK;
				}
			setpri(cup);
			}
		GOOUT:;
		}
	intr_32.selector=0x40;
	enable();
	}

/*
 *	clock it while in previous clok interrupt
 *	does the same as clk it from system level
 */

void t_clocka()
	{
	register struct alrm *al2;

	if (alarm[0].fun!=NULL)
		{
		al2=alarm;
		while(al2->time<=0 && al2->fun!=NULL)
			++al2;
		al2->time--;
		}
	u->u_stime++;

	if(++(cup->p_cpu)==0)
	(cup->p_cpu)--;

	++lbolt;

	intack1();

	}

/*
 *	timeout
 *	call a given fn after time has elapsed
 */

void timeout(fun,arg,tick)
int tick;
void (*fun)();
int arg;
	{
	struct alrm *al1,*al2;
	int t;
	word save;

	t=tick;
	al1=alarm;
	save=lock1();

	while(al1->fun!=NULL && al1->time <=t)
		{
		t-=al1->time;
		++al1;
		}
	al1->time-=t;
	al2=al1;

	while(al2->fun!=NULL)
		if (++al2>=&alarm[NTOUT-2])
			panic("TIMEOUT");
	while(al2>=al1)
		{
		(al2+1)->time=al2->time;
		(al2+1)->fun=al2->fun;
		(al2+1)->arg= al2->arg;
		al2--;
		}
	al1->time=t;
	al1->fun=fun;
	al1->arg=arg;
	unlock(save);
	}
/*
 *	incupc
 *	update profiling registers
 */
void incupc(pc,prof)
register word pc,*prof;
	{
	word w;
	pc-=prof[2];
	pc*=prof[3]>>15;
	if (pc<=prof[1])
		{
		pc+=prof[0];
		w=fuword(pc);
		if (w<0xffff)
			suword(pc,w);
		}

	}

/*
 *	initclock
 *	initialize system clock from CMOS
 */

int bcd(int);

void initclock()
	{
	word	count0;
	int	year,month,day;
	static	dayn[]={0,31,59,90,120,151,181,212,243,273,304,334};
	count0= (word)(TIMERFREQ/HZ);

	outbyte (TIMERC,TIMER0MOD);
	outbyte (TIMER0,count0&0xff);
	outbyte (TIMER0,count0>>8);

	count0=lock1();
	outbyte(CMOSADDR,CMOSYEAR);
	year=bcd(inbyte(CMOSDATA));
	outbyte(CMOSADDR,CMOSMONT);
	month=bcd(inbyte(CMOSDATA));
	outbyte(CMOSADDR,CMOSMDAY);
	day=bcd(inbyte(CMOSDATA))-1;
	time=(year-70)*365L;	  	/* sec/year		*/
	time+=((year-69)/4);	     	/* leap days 		*/
	time+=dayn[month-1];		/* days in a month	*/
	if ((year%4)==0&&month>2)
		time++;			/* this year is leap year*/
	time+=day;
	time*=86400L;
	outbyte(CMOSADDR,CMOSRHOR);
	time+=(bcd(inbyte(CMOSDATA))-1)*3600L;
	outbyte(CMOSADDR,CMOSRMIN);
	time+=(bcd(inbyte(CMOSDATA)))*60L;
	outbyte(CMOSADDR,CMOSRSEC);
	time+=(long)bcd(inbyte(CMOSDATA));
	unlock(count0);
	}
static bcd(zzz)
byte zzz;
	{
	return ((((zzz)>>4)&0xf)*10+(zzz&0xf));
	}
/*
 *	reprogram clock for DOS
 */
void closeclock()
	{
	outbyte (TIMERC,TIMER0MOD);
	outbyte (TIMER0,0);
	outbyte (TIMER0,0);
	}
