/*
 *	inode.h
 *	definition of the in core inode structure
 */

struct inode
	{
	char	i_flag;         /* see below			*/
	char	i_count;	/* reference count		*/
	dev_t	i_dev;		/* device of this inode		*/
	ino_t	i_number;	/* inode number			*/
	int	i_mode;		/* see below			*/
	u_char	i_nlink;	/* number of links		*/
	uid_t	i_uid;		/* owner uid			*/
	gid_t	i_gid;		/* owner gid			*/
	byte	i_size0;	/* bits 23..16 of length	*/
	word	i_size1;	/* bits 15..0  of length	*/
	blk_t	i_addr[8];	/* blocks of the file		*/
	blk_t	i_lastr;	/* last read-ahead block	*/
	};

#define I_SIZE(ip) (((dword)((ip)->i_size0)<<16)+(word)(ip)->i_size1)

/*
 *	The mount struct
 *	Every mounted fs has one
 */
struct mount
	{
	dev_t  m_dev;		/* device mounted		*/
	struct buf *m_bufp;	/* superblocks buffer		*/
	struct inode *m_inodp;	/* mounted inode		*/
	};


/* flags */

#define	ILOCK	01		/* inode is locked		*/
#define IUPD	02		/* inode modified		*/
#define IACC	04		/* inode accessed		*/
#define IMOUNT	010		/* inode mounted		*/
#define	IWANT	020		/* other proc waiting for inode	*/
#define ITEXT	040		/* pure text			*/

/* modes */

#define IALLOC  0100000		/* allocated			*/
#define IFMT     060000         /* mask for type		*/
#define  IFDIR   040000		/* inode is directory		*/
#define  IFCHR   020000		/* inode is char special	*/
#define  IFBLK   060000		/* inode is block special	*/
#define ILARG    010000		/* file is indirect 		*/
#define ISUID     04000		/* set owner id on exec		*/
#define ISGID     02000		/* set group id on exec		*/
#define ISVTX     01000		/* keep text on swap		*/
#define IREAD      0400		/* can be read			*/
#define IWRITE     0200		/* can be written		*/
#define IEXEC      0100		/* can be executed		*/

extern struct inode inode[];
extern struct mount mount[];
extern struct inode *rootdir;
extern blk_t  rablock;

struct inode *iget (dev_t,ino_t);
void	      iput (struct inode*);
void	      itunc (struct inode*);
struct inode *ialloc (dev_t);
void	      ifree (dev_t,ino_t);
void 	      iupdat (struct inode*,time_t);
struct inode *maknode (int);
void	      wdir (struct inode*);
void	      writei (struct inode*);
void 	      readi  (struct inode*);
void	      openi  (struct inode*,int);
void	      closei (struct inode*,int);
void	      iput (struct inode*);
void	      iupdat (struct inode*,time_t);
void	      itrunc (struct inode*);
struct inode *maknode (int);
void	      wdir (struct inode*);
struct inode *namei (int(),int);
struct inode *owner (void);
int	      access (struct inode*,int);
void	      plock (struct inode*);
void	      prele (struct inode*);
void	      pipe (int*);
int	      uchar (void),schar(void);