/* infield.c: routines to return pointers to field in internet headers */
#include "param.h"
#include "types.h"
#include "infield.h"
#include "stream.h"

/* These routines would also have the side effect of swabing bytes. */

infc(bp, offset)	/* find field 'offset' bytes in block chain 'bp' */
	register struct block *bp;
	register offset;
{
	register n;

	while (offset > 0 && bp != NULL) {
		n = min(offset, bp->wptr - bp->rptr);
		if (n < offset)
			bp = bp->next;
		offset -= n;
	}
	if (bp == NULL)
		return NULL;
	return bp->rptr + n;
}

u_short
in_checksum(bp, hlen)	/* compute and return the check sum */
	register struct block *bp;
	register hlen;
{
	register u_short sum = 0;
	register u_short *sp;

	sp = bp->rptr;
	while (hlen > 0 && bp) {
		sum += *sp;
		hlen -= sizeof (u_short);
		if (++sp >= bp->wptr) {
			bp = bp->next;
			if (bp != NULL)
				sp = (u_short *)bp->rptr;
		}
	}
	return ~sum;
}
