/* snm.c */
#include <sys/types.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <sys/ipm.h>
#include <sys/inet/tcp_user.h>
#include <sys/inet/udp_user.h>
#include <sys/inet/in.h>

#define MAXCONN 50	/* must be less than OPEN_MAX in limits.h */
#define TCP_PORT 2111
#define UDP_PORT 2112
#define MTU 1514	/* number of bytes of header and data */

struct neigh {
	struct tcpuser peer;
	int fd;
};

int debug = 0;
int rxpid, tcpon, rx, tx;
int ding(), debon(), deboff(), quit();

main(argc, argv)
int argc;
char *argv[];
{
	signal(SIGALRM, ding);
	signal(SIGIOT, debon);
	signal(SIGEMT, deboff);
	signal(SIGPIPE, SIG_IGN);
	signal(SIGTERM, quit);
	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	setpgrp(getpid(), getpid());
	tcpon = 1;
	if (argc > 1) {
		if (strchr(argv[1], 'd'))
			debug = 1;
		if (strchr(argv[1], 'u'))
			tcpon = 0;
		if (strchr(argv[1], 'r'))
			rx = 1;
		if (strchr(argv[1], 't'))
			tx = 1;
	}
	if (argc <= 1 || (rx == 0 && tx == 0) || (rx == 1 && tx == 1)) {
		fprintf(stderr, "usage: %s [-durt]\n", argv[0]);
		exit(1);
	}
	if (rx == 1)
		dorx();
	else
		dotx();
	printf("how in the world did I get here\n");
}

dotx()		/* do the transmit thing forever */
{
	static struct neigh n[MAXCONN];
	int ufd, mfd, sfd;
	char *p;
	struct mesghdr mh;

	signal(SIGPIPE, SIG_IGN);
	ufd = udp_datagram(0);
	mfd = msgbind(0);
	nodesid(fdsid(mfd));

	while (1) {
		if ((p = msgrecv(mfd, &mh)) == (char *)-1) {
			error("msgrecv returned -1");
			continue;
		}
		switch(tcpon ? mh.flags & 3 : MESG_FAST) {
		case 0:
		case MESG_IMPORTANT:
			if ((sfd = findfd(mh.dest.node, n)) < 0)
				sfd = newconn(mh.dest.node, n);
			if (sfd > 0) {
				if (tcp_send(sfd, &mh, p) < 0) {
					retmsg(&mh, p);
					clconn(sfd, n);
				}
				msgfree(p);
			} else {
				error("couldn't connect");
				retmsg(&mh, p);
			}
			break;
		case MESG_FAST:
			if (udpsend(ufd, &mh, p) < 0) {
				error("couldn't send udp message");
				retmsg(&mh, p);
				break;
			}
			msgfree(p);
			break;
		default:
			error("bad flags if mh");
			msgfree(p);
			break;
		}
	}
}

findfd(node, np)
u_short node;
struct neigh *np;
{
	struct neigh *ep;

	ep = &np[MAXCONN];
	while(np < ep) {
		if (np->fd > 0 && (np->peer.faddr & ~1) == n2a(node))
			return(np->fd);
		np++;
	}
	return(-1);
}

newconn(node, np)
u_short node;
struct neigh *np;
{
	struct neigh *ep;

	ep = &np[MAXCONN];
	while(np < ep && np->fd != 0)
		np++;
	if (np == ep)
		return(-1);
	if((np->fd = tcp_sock()) < 0) {
		error("tcp_sock() failed");
		np->fd = 0;
		return(-1);
	}
	bzero(np->peer, sizeof(np->peer));
	if((np->peer.faddr = n2a(node)) == -1) {
		error("n2a couldn't cvt node to address");
		bzero(np, sizeof(struct neigh));
		return(-1);
	}
	np->peer.fport = TCP_PORT;
	dbp("b4 tcp_connect\n");
	if (tcp_connect(np->fd, &np->peer) < 0) {
		close(np->fd);
		np->fd = tcp_sock();
		np->peer.faddr++;	/* try side B */
		if (tcp_connect(np->fd, &np->peer) < 0) {
			error("tcp_connect failed()");
			close(np->fd);
			bzero((char *)np, sizeof(struct neigh));
			return(-1);
		}
	}
	dbp("after tcp_connect()\n");
	return(np->fd);
}

acc_conx(fd, np)
int fd;
struct neigh *np;
{
	struct neigh *ep, *p, *qp;

	ep = &np[MAXCONN];
	p = np;
	dbp("acc_conn:top\n");
	while(p < ep && p->fd)
		p++;
	if (p->fd != 0) {
		fatal("rx:ran out of conx slots");
	}
	if ((p->fd = tcp_accept(fd, &p->peer)) < 0) {
		error("rx:accepting conx");
		bzero(p, sizeof(struct neigh));
		return(-1);
	}
	qp = np;
	while (qp < ep) {
		if (qp != p)	/* remove any connections to this same node */
			if (qp->peer.faddr == p->peer.faddr)
				clconn(qp->fd, np);
		qp++;
	}
	if (debug)
		printf("added new conn for %x\n", p->peer.faddr);
}


in_addr
n2a(node)
u_short node;
{
		return(0x80008000 | (u_int)node << 16);
}

tcp_send(fd, mhp, p)
int fd;
struct mesghdr *mhp;
char *p;
{

	if (write(fd, mhp, sizeof(struct mesghdr)) < 0)
		return(-1);
	if (write(fd, p, mhp->length) < 0)
		return(-1);
	return(0);
}

clconn(fd, np)
int fd;
struct neigh *np;
{
	struct neigh *ep;

	ep = &np[MAXCONN];
	while(np < ep) {
		if (np->fd == fd) {
			close(fd);
			bzero(np, sizeof(struct neigh));
			return(0);
		}
		np++;
	}
	return(-1);
}

dorx()
{
	static struct neigh n[MAXCONN];
	int lfd, ufd;
	static struct tcpuser luser;
	fd_set fv;
	struct neigh *ep, *np;
	int to = 0xefffffff;
	struct mesghdr mh;
	char junk[800];

	if ((ufd = udp_datagram(UDP_PORT)) < 0)
		fatal("rx:opening udp socket");
	if ((lfd = tcp_sock()) < 0)
		fatal("rx:opening tcp socket");
	luser.lport = TCP_PORT;
	tcp_listen(lfd, &luser);
	while(1) {
		FD_ZERO(fv);
		FD_SET(lfd, fv);
		FD_SET(ufd, fv);
		ep = &n[MAXCONN];
		np = n;
		while(np < ep) {
			if (np->fd != 0)
				FD_SET(np->fd, fv);
			np++;
		}
		if (select(getdtablesize(), &fv, (fd_set *)0, to) <= 0)
			continue;
		np = n;
		while(np < ep) {
			if (np->fd && FD_ISSET(np->fd, fv)) {
				mvmsg(np->fd, n);
			}
			np++;
		}
		if (FD_ISSET(ufd, fv))
			umvmsg(ufd);
		if (FD_ISSET(lfd, fv))
			acc_conx(lfd, n);
	}
}

umvmsg(fd)
int fd;
{
	char msg[MTU];
	struct mesghdr *mp;
	char *dp, *p;

	if (read(fd, msg, MTU) <= 0) {
		error("rx:reading udp socket");
		return(-1);
	}
	mp = (struct mesghdr *)(msg + sizeof(struct udpaddr));
	dp = (char *)mp + sizeof(struct mesghdr);
	alarm(2);
	p = msgalloc(mp->length);
	alarm(0);
	if ((int)p != -1) {
		bcopy(dp, p, mp->length);
		if (msgsend(mp, p) < 0) {
			error("rx:udp msgsend()");
			msgfree(p);
		}
	}

}

mvmsg(fd, np)
int fd;
struct neigh *np;
{
	struct mesghdr mh;
	char junk[4096], *p;
	int tot, n, rv;
	
	switch(read(fd, &mh, sizeof mh)) {
	case -1: /* we's got a problem */
		error("rx:stream read");
		clconn(fd, np);
		break;
	case 0: /* he went away */
		if (debug)
			printf("closed conx to %s\n",in_ntoa(np->peer.faddr));
		clconn(fd, np);
		break;
	default: /* got one */
		if (mh.length > MAXMESG) { /* bogus message */
			while((rv = min(mh.length, sizeof junk)) > 0) {
				read(fd, junk, rv);
				mh.length -= rv;
			}
			break;
		}
		alarm(2);
		p = msgalloc(mh.length);
		alarm(0);
		if ((int)p != -1) {
			tot = 0;
			while(tot < mh.length) {
				if((n=read(fd,p+tot,mh.length-tot))<=0){
					error("rx:reading from stream");
					clconn(fd, np);
					msgfree(p);
					break;
				}
				tot += n;
			}
			if (msgsend(&mh, p) == -1) {
				error("rx:msgsend()");
				msgfree(p);
			}
		} else	/* No space, pitch it */
			read(fd, junk, mh.length);
		break;
	}
}

error(nit)
char *nit;
{
	char msg[128];

	if (debug) {
		sprintf(msg, "snm:%d:", getpid());
		strcat(msg, nit);
		strcat(msg, "\n");
		perror(msg);
	}
}

retmsg(mhp, p)
struct mesghdr *mhp;
char *p;
{
	struct mesghdr rmh;

	bcopy(&mhp->dest, &rmh.orig, sizeof rmh.orig);
	bcopy(&mhp->orig, &rmh.dest, sizeof rmh.dest);
	rmh.length = mhp->length;
	rmh.flags = mhp->flags | MESG_RETURNED;
	if (msgsend(&rmh, p) < 0) {
		error("retmsg:msgsend");
		msgfree(p);
	}
}

fatal(msg)
char *msg;
{
	perror(msg);
	exit(-1);
}

udpsend(fd, mp, p)
int fd;
struct mesghdr *mp;
char *p;
{
	char pkt[MTU];
	struct udpaddr *up;
	int len;

	up = (struct udpaddr *)pkt;
	if ((up->host = n2a(mp->dest.node)) == -1) {
		error("n2a can't cvt node to address");
		return(-1);
	}
	up->port = UDP_PORT;
	bcopy((char *)mp,pkt+sizeof(struct udpaddr),sizeof(struct mesghdr));
	bcopy(p, pkt+sizeof(struct udpaddr)+sizeof(struct mesghdr),mp->length);
	len = sizeof(struct udpaddr)+sizeof(struct mesghdr)+mp->length;
	return(write(fd, pkt, len));
}

min(a,b)	{return a< b ? a : b; }

ding()
{
	signal(SIGALRM, ding);
}


deboff()
{
	signal(SIGEMT, deboff);
	fprintf(stderr, "snm:debugging turned off pid = %d\n", getpid());
	fflush(stderr);
	debug = 0;
}

debon()
{
	signal(SIGIOT, debon);
	fprintf(stderr, "snm:debugging turned on pid = %d\n", getpid());
	fflush(2);
	debug = 1;
}

dbp(str)
char *str;
{
	if (debug) {
		printf("snm:%d::", getpid());
		printf(str);
	}
}
quit()
{
	printf("snm:quitting from SIGTERM\n");
	exit(0);
}
