/* open.c: Test the open routine */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>

main()
{
	int fd;
	struct stat buf;

	unlink("junk");
	if ((fd = open("junk", O_RDWR|O_TRUNC|O_CREAT, 0644)) == -1)
		perror("open 1"), exit(1);
	write(fd, "Brantley W. Coile, ccp", 22);
	close(fd);
	if (stat("junk", &buf) == -1)
		perror("first stat");
	printf("buf.st_mode 0%o\n", buf.st_mode);
	if ((buf.st_mode & 0777) != 0644)
		perror("mode broke"), exit(1);
	if ((fd = open("junk", O_RDWR|O_CREAT, 0644)) == -1)
		perror("open 1.5"), exit(1);
	close(fd);
	stat("junk", &buf);
	if (buf.st_size == 0)
		q("didn't write");
	if ((fd = open("junk", O_WRONLY|O_TRUNC, 0)) == -1)
		perror("open 2"), exit(1);
	fstat(fd, &buf);
	if (buf.st_size != 0)
		q("Didn't truncate\n");
	if (open("junk", O_WRONLY|O_CREAT|O_EXCL, 0644) != -1)
		q("open with excl failed to stop me");
	close(fd);
	unlink("junk");
}

q(s)
	char *s;
{
	printf("%s\n", s);
	exit(1);
}
