/*
 * Basic system types and major/minor device constructing/busting macros.
 */

#ifndef _TYPES_
#define	_TYPES_
/* major part of a device */
#define	major(x) ((int)(((unsigned)(x) >> 8) & 0377))

/* minor part of a device */
#define	minor(x) ((int)((x) & 0377))

/* make a device number */
#define makedev(x, y)	((dev_t)(((x) << 8) | (y)))

typedef	unsigned int	u_int;
typedef	unsigned short	u_short;
typedef	unsigned char	u_char;
typedef unsigned long	u_long;

typedef	struct { int r[1]; } *	physadr;
typedef	long		daddr_t;
typedef	char *		caddr_t;
typedef	u_short		ino_t;
typedef short		cnt_t;
typedef	long		time_t;
typedef	int		label_t[13];
typedef	short		dev_t;
typedef	long		off_t;
typedef	long		paddr_t;
typedef	long		key_t;
typedef	u_short		uid_t;
typedef	u_short		gid_t;
typedef	long		portid_t;
typedef	u_short		mode_t;
typedef	short		pid_t;
typedef	short		nlink_t;
typedef	u_short		sid_t;

#ifndef NBBY
#include <sys/param.h>
#endif NBBY
/*
 *	Set of fds used with the select system call.
 *	The macros depend on NBPW, NBBY, & NOFILE from sys/param.h
 */

#define	FDWORDS	(NOFILE+NBPW*NBBY-1)/(NBPW*NBBY)
typedef	struct	fd_set {unsigned long fds_bits[FDWORDS];} fd_set;
#define	FD_SET(n,s)	(s).fds_bits[(n)/(NBPW*NBBY)] |= 1<<((n)%(NBPW*NBBY))
#define	FD_CLR(n,s)	(s).fds_bits[(n)/(NBPW*NBBY)]&=~(1<<((n)%(NBPW*NBBY)))
#define	FD_ISSET(n,s)	((s).fds_bits[(n)/(NBPW*NBBY)]&(1<<((n)%(NBPW*NBBY))))
#define FD_ZERO(a)	bzero((char *)&(a), sizeof (fd_set))
#endif _TYPES_
