/* udp_listen.c: get socket, bind address and wait for message */

#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>

udp_listen(sport, reply)
	udp_port sport;
	struct udpaddr *reply;
{
	struct udpuser u;
	int fd, sock;
	char buf[64];

	if ((fd = udp_sock()) == -1)
		return -1;
	if (write(fd, (char *)&u, sizeof u) == -1
	||  read(fd, (char *)&u, sizeof u) == -1
	||  u.code != UDPC_OK) {
		close(fd);
		return -1;
	}
	return fd;
}
