#ifndef runtime_h
#define runtime_h
typedef struct Frame *Frame;

#include "machine.h"

# ifdef mc68000
#define NSAVEREG 14		/* D0 to D7, A0 to A5; D0,D1,A0,A1 unsaved */
# else (vax)
#define NSAVEREG 12
# endif mc68000

struct Frame {
# ifdef vax
    Integer condition_handler;
# endif vax
    Integer mask;		/* register save mask */
# ifdef vax
    Address save_ap;		/* argument pointer */
# endif vax
    Address save_fp;		/* frame pointer */
    Address save_pc;		/* program counter */
    Word save_reg[NSAVEREG];	/* not necessarily there */
};
Frame findframe(/* f */);
Address return_addr(/*  */);
pushretval(/* len, isindirect */);
Address locals_base(/* frp */);
Address args_base(/* frp */);
Word savereg(/* n, frp */);
Word argn(/* n, frp */);
Address fparamaddr(/* a */);
wherecmd(/*  */);
dump(/*  */);
setcurfunc (/* f */);
up (/* n */);
down (/* n */);
findbeginning(/* f */);
Address firstline(/* f */);
runtofirst(/*  */);
Address lastaddr(/*  */);
Boolean isactive(/* f */);
callproc(/* procnode, arglist */);
procreturn(/* f */);
popenv(/*  */);
flushoutput(/*  */);
#endif runtime_h
