/*
 * Trap type values
 */

#define BUSERR	2	/* Bus Error/Segment Violation (SIGBUS) */
#define ADDRERR	3	/* Address Error (SIGSEGV) */
#define INSTERR	4	/* Illegal Instruction Trap (SIGILL) */
#define ZDVDERR	5	/* Zero Divide Trap (SIGFPE) */
#define CHKTRAP	6	/* CHK Trap (SIGSEGV) */
#define TRAPVFT	7	/* TRAPV instruction fault (SIGILL) */
#define PRIVFLT	8	/* privileged instruction fault (SIGILL) */
#define TRCTRAP	9	/* Trace Trap (SIGTRAP) */
#define L1010FT	10	/* Line 1010 Emulator Trap (SIGILL) */
#define L1111FT	11	/* Line 1111 Emulator Trap (SIGILL) */
#define COPROTV 13	/* Coprocessor Protocol Violation (SIGILL) */
#define FMTERR	14	/* Format error--Illegal Exception Format (SIGILL) */
#define UNINTR	15	/* Uninitialized Interrupt Vector Error */
#define STRAYFT	24	/* Spurious Interrupt */
#define SYSCALL	32	/* TRAP 0 - System Call Trap */
#define BPTFLT	33	/* TRAP 1 - Breakpoint Trap (SIGTRAP) */
#define IOTTRAP	34	/* TRAP 2 - Simulate DEC IOT Trap (SIGIOT) */
#define EMTTRAP	35	/* TRAP 3 - Simulate DEC EMT Trap (SIGEMT) */
#define FPETRAP	36	/* TRAP 4 - Floating Point Exception Trap (SIGFPE) */

#define RESCHED	0	/* Pseudo trap to signal rescheduling */


