
                                 Running net


The  command  nneett  is  the  part  of ccoohhuulliipp  that  actually  performs  the
networking tasks.  nneett executes all networking tasks that a true networking
package would implement as separate executable commands.

You should  read this chapter  carefully to see what  options are available
for nneett, and how to invoke  its features.  You can also use this chapter as
a reference while you are using nneett.

Please note that commands for  nneett are case sensitive: for example, command
ffttpp works, but commands FFttpp or FFTTPP do not.

                                 SSttaarrttiinngg UUpp

The command nneett has the following syntax:

     nneett [ _s_t_a_r_t_u_p._f_i_l_e ]

_s_t_a_r_t_u_p._f_i_l_e holds a set of commands  that initialize nneett. As you will see,
these commands  are simply ordinary  instruction to nneett, just  as you could
type interactively  into nneett. The rest  of this chapter will  show you what
these commands  mean, and how  you can modify  them to suit  the networking
environment in which you are working.

If you are  going to use ccoohhuulliipp to perform  a variety of networking tasks,
you may wish to have more than one startup file.  For example, you may need
one startup  file to SLIP into  the Internet via an  Internet provider, and
another to  access a  local network  via Ethernet.  For  details on  how to
modify your a startup file, see the chapter on installing ccoohhuulliipp.

If you do not name a  _s_t_a_r_t_u_p._f_i_l_e on nneett's command line, it reads the file
$NNEETTHHOOMMEE/ssttaarrttuupp.nneett. If  you do not  name a _s_t_a_r_t_u_p._f_i_l_e  on nneett's command
line and  nneett cannot find $NNEETTHHOOMMEE/ssttaarrttuupp.nneett, then you  must give nneett its
initialization commands by hand.

                             MMooddeess ooff OOppeerraattiioonn

nneett works in either of two modes: command mode and converse mode.

In _c_o_m_m_a_n_d mode, nneett displays the  prompt nneett>, and you can type any of the
commands described  below.  In _c_o_n_v_e_r_s_e  mode, keyboard input  is processed
according  to the  _c_u_r_r_e_n_t _s_e_s_s_i_o_n,  which may  be either  a TELNET  or FTP
session:

-> In a TELNET session, keyboard input is sent to the remote system and any
   output from the remote system is displayed on the console.

-> In an  FTP session, nneett displays the prompt  ffttpp>. nneett examines keyboard
   input to see if it is an FTP command.  if it is, then nneett executes it as
   such; if  not, it  passes it  directly to the  remote remote  host's FTP
   server.  For a list of FTP  commands, see the description of the command
   ffttpp, below.

While you are conversing with a remote host via FTP or TELNET, you can type
a  ``hot key''  to escape  back into  nneett's command  mode.  After  you have
pressed the hot  key, nneett displays the prompt nneett>.  You can then issue one
or more  commands to nneett. To  resume conversing with the  remote host, type
<rreettuurrnn>. You can use this to mechanism to close an interactive session, or
perform other  useful tasks;  these are  described below.  By  default, nneett
sets the hot key to <ccttrrll-]> (0x1D).

The keyboard also has ``cooked''  and ``raw'' states.  In cooked state, nneett
processes input one line at  a time.  Pressing <rreettuurrnn> passes the complete
line up to the application.  In  raw mode, nneett passes each character to the
application as you type it.

While the  keyboard is in  cooked mode, you  can use the  following editing
commands as you are typing input:

<ccttrrll-AA>  Move one word to the left.

<bbaacckkssppaaccee>
          Delete the previous character.

<ccttrrll-DD>  Move one character to the right.

<ccttrrll-EE>  Throw away the current line and redisplay the previous line.

<ccttrrll-FF>  Move one word to the right.

<ccttrrll-HH>  Delete the previous character.

<ccttrrll-RR>  Redisplay the current line.

<ccttrrll-SS>  Move one character to the left.

<ccttrrll-UU>  Delete the current line.

<ccttrrll-VV>  Do not  interpret the following  character.  Use this  to pass an
          editing command through to the remote site.

<ccttrrll-WW>  Delete the previous word.

<ccttrrll-YY>  Delete the current line.

nneett is in  the cooked state either when nneett  is in command mode or when you
are conversing with a remote host  via FTP.  When you are conversing with a
remote host via a TELNET session, the keyboard's state depends upon whether
the  remote end  has issued  (and the  local end  has accepted)  the TELNET
protocol's option  WWIILLLL EECCHHOO. For  details, see the description  of the nneett
command eecchhoo, below.

                                 HHoosstt NNaammeess

Many of the commands described below use the symbol <_h_o_s_t_i_d> to represent a
remote host  or gateway.  You can  specify the <_h_o_s_t_i_d> either  as a domain
name (e.g.,  ``raven.alaska.edu''), or as  a numeric IP  address written in
dotted decimal notation and enclosed by brackets (e.g., [4444.00.00.11]).

You can use domain names in  either of two ways.  The first way is to write
the name  and IP address  of the domain into  file $NNEETTHHOOMMEE/hhoossttss.nneett. (The
format of this file is described in the previous chapter.) The other way is
to interrogate  a remote domain-name  server.  The command  ddoommaaiinn lets you
set the  IP address  of a  domain-name server that  you have  permission to
interrogate.  For details, see the command ddoommaaiinn, described below.

                             SSyynnttaaxx ooff CCoommmmaannddss

The following  describes each of the commands  that nneett recognizes.  Square
brackets enclose optional  arguments.  The character `|' denotes an either-
or selection.  Commands are case sensitive, and are all in lower case.

<rreettuurrnn> -- SSeenndd aa CCoommmmaanndd

Return to converse  mode with the current TELNET or  FTP session.  If there
is no current session, nneett remains in command mode.

? -- PPrriinntt aa HHeellpp MMeessssaaggee

Help: print a list of all commands recognized.

! -- SSeenndd aa CCoommmmaanndd ttoo tthhee SShheellll

The command

     ! _c_o_m_m_a_n_d

sends  _c_o_m_m_a_n_d to  your  COHERENT shell  for  execution.  If  you give  the
command ! without a _c_o_m_m_a_n_d, nneett invokes the shell.

# -- IIggnnoorree aa CCoommmmaanndd

Ignore the command that follows.  You  can use this to write a comment into
a _s_t_a_r_t_u_p file.

aattttaacchh -- AAttttaacchh nneett TToo aa NNeettwwoorrkk

Command aattttaacchh configures and attaches a hardware interface to your system.
It has the following syntax:

     aattttaacchh _h_w_t_y_p_e _I_O__a_d_d_r_e_s_s _d_e_v_i_c_e _m_o_d_e _l_a_b_e_l _b_u_f_s_i_z_e _m_t_u [ _s_p_e_e_d ] [ _s_c_r_i_p_t ]

The following details the arguments to this command:

_h_w_t_y_p_e
     the kind of I/O device that is being attached, as follows:

     aassyy
        An asynchronous (serial) port.
     nnxx An  Ethernet card,  using the  device  driver nnee  to access  an NEC
        NE2000 Ethernet board, or a clone thereof.

_I_O__a_d_d_r_e_s_s
     The  base address  of  the control  registers for  the device.   Under
     ccoohhuulliipp, this is always zero.

_d_e_v_i_c_e
     Name the device by which you  are accessing the network.  If _h_w_t_y_p_e is
     aassyy, then this names the serial port you are using, e.g., /ddeevv/ccoomm33ffrr.
     If _h_w_t_y_p_e is nnxx, then set this to zero.

_m_o_d_e Set  how IP  datagrams  are encapsulated.   It  can be  either of  the
     following:

     sslliipp Enclose IP  datagrams within SLIP frames,  without a link header.
          Use this option if _h_w_t_y_p_e is set to aassyy.

     aarrppaa Use the  ARP to map  an IP address  to an Ethernet  address.  Use
          this option if _h_w_t_y_p_e is set to nnxx.

_l_a_b_e_l
     The name by which the interface will be known to the various commands,
     such as  ccoonnnneecctt, rroouuttee, and  ttrraaccee. When you  installed ccoohhuulliipp, this
     was set  to ssll00  for a  serial connection, or  to nnee00 for  an Ethernet
     connection.

_b_u_f_s_i_z_e
     This argument is ignored.

_m_t_u  The size  of the maximum  transmission unit, in bytes.   If a datagram
     exceeds this limit, ccoohhuulliipp fragments it at the IP level.

_s_p_e_e_d
     The  speed of  the  serial port  through  which the  network is  being
     accessed.  If  the type  of connection  is Ethernet, this  argument is
     ignored and is not required.

_s_c_r_i_p_t
     A dialing  script, through which ccoohhuulliipp can dial  into a remote site.
     You should  use this option if  you are using SLIP  to access a remote
     system via modem.

A _s_c_r_i_p_t has the following format:

     [ - ] _s_e_n_d_s_t_r_i_n_g _e_x_p_e_c_t_s_t_r_i_n_g [ _s_e_n_d_s_t_r_i_n_g _e_x_p_e_c_t_s_t_r_i_n_g ... ]

If the first  entry in the script is `-',  ccoohhuulliipp displays the send/expect
strings on the screen  as executes the script.  _s_e_n_d_s_t_r_i_n_g and _e_x_p_e_c_t_s_t_r_i_n_g
come in  pairs, with  the exception  of the the  last _s_e_n_d_s_t_r_i_n_g:  once the
remote  site goes  into SLIP  mode,  no more  strings are  forthcoming, and
ccoohhuulliipp waits silently for recognizable SLIP packets or a hangup.

_s_e_n_d_s_t_r_i_n_g can include the following escape sequences:

     \\   Literal `\'
     \EE   End of file
     \NN   NUL
     \bb   Backspace
     \nn   Newline
     \rr   Carriage return
     \ss   Space character
     \tt   Horizontal tab

You should  end each  _s_e_n_d_s_t_r_i_n_g with  a `\r', to  flush the string  to the
output device.

The  send-expect function  has  a 30-second  timeout.  Unlike  a UUCP  chat
script, a  ccoohhuulliipp script  does not  support alternate-send phrases  in the
event of timeout.  The following gives an example _s_c_r_i_p_t:

     ATE1V1Q0S0=0\r OK ATDP1234567\r ogin: mylogin\r ord: mypassword\r

The first pair,

     ATE1V1Q0S0=0\r OK

sends an  initialization string  to the modem  and awaits the  reply ``OK''
from the modem.

The second pair,

     ATDP1234567\r ogin:

dials the modem  and awaits the login prompt from  the remote system.  (The
string  ``1234567''  stands  for  the  remote  system's  telephone  number,
whatever it might happen to be.)

The third pair, mmyyllooggiinn\rr oorrdd:,  sends the your login identifier and awaits
the password prompt from  the remote system.  (Note that ``mylogin'' stands
for your login identifier, whatever it might happen to be.)

Finally, nneett sends the password string -- in this example, mmyyppaasssswwoorrdd\rr.

Note that aattttaacchh's scripting  mechanism gives you only limited control over
the port or modem.  If you  are dialing out through a modem that is plugged
into an enabled  port, you must disable the port  by hand before you invoke
nneett. Also note that nneett has  no mechanism for sending commands to the modem
after a  SLIP session has concluded; therefore,  you must re-initialize the
modem  by hand  after you  have  finished working  with the  remote system.
Hints on how to write a script to do this appear below.

Finally, note that  you can use a script to  access a remote system only if
you have  a permanently assigned IP number, assigned  either by an Internet
authority or by your Internet provider.  Some providers assign IP addresses
``on the  fly;'' in this case,  you must use a  different method of dialing
into  the  remote  system.   For  details,  see the  previous  chapter,  on
configuring ccoohhuulliipp.

ccdd -- CChhaannggee DDiirreeccttoorryy

This command changes the directory you are accessing on your local machine.
If  you are  running  an FTP  or  TELNET session,  it does  not change  the
directory that you are accessing on  the remote host.  It works exactly the
same as the ccdd command as described in the COHERENT Lexicon.

cclloossee -- CClloossee aa SSeessssiioonn OOnn YYoouurr EEnndd

Close  an FTP  or TELNET  session.  This  is an  alternative to  asking the
remote server to initiate a close  (i.e., sending the command qquuiitt via FTP,
or  the command  llooggoouutt via  TELNET.  When  either FTP  or TELNET  sees the
incoming  half of  a  TCP connection  close, it  automatically responds  by
closing the outgoing half of the connection.

cclloossee recognizes the syntax

     cclloossee [ _t_y_p_e [ _s_e_s_s_i_o_n ] ]

where _t_y_p_e  is the  type of  session to close  (either TELNET or  FTP), and
_s_e_s_s_i_o_n is  the number of  the session to  close.  If you  are running more
than one  _t_y_p_e of session  and do not  specify which _s_e_s_s_i_o_n  to close, nneett
closes the one that you opened most recently.

cclloossee is more graceful than the command rreesseett, in that it is less likely to
leave the remote TCP in a  ``half-open'' state.  Note, however, that if you
use nneett's cclloossee  command instead of closing from within  a session, it be a
few minutes  before the  fact that your  TCP session has  closed percolates
through the  net to your  remote host and  it closes the  connection on its
end; so wait a few minutes  before you attempt to log again into the remote
host.

ddiirr -- LLiisstt CCoonntteennttss ooff DDiirreeccttoorryy oonn RReemmoottee HHoosstt

The command  ddiirr resembles the command  of the same name  under MS-DOS.  It
displays on your screen the contents of a directory on the remote host; the
information displayed  includes the  name of each  file, its size,  and the
date and time it was last modified.

ccdd recognizes the following syntax:

     ddiirr [ _d_i_r_e_c_t_o_r_y ] [/ww]

If no  argument is  given, ccdd  displays the contents  of directory  you are
accessing on the  remote host.  The switch /ww tells  it to display only the
name, grouped into five columns.

The  command ffttpp  also implements  a  version of  the ddiirr  command.  It  is
described below.

ddoommaaiinn -- MMaanniippuullaattee IInnffoorrmmaattiioonn AAbboouutt DDoommaaiinnss

The  command   ddoommaaiinn  lets  you  manipulate   information  about  domains.
Information  about domains  is  kept in  file  $NNEETTHHOOMMEE/ddoommaaiinnss.ttxxtt. For  a
discussion of the  contents of this file, see the  previous chapter in this
manual.

ddoommaaiinn takes the following forms:

ddoommaaiinn aaddddsseerrvveerr _i_p__a_d_d_r_e_s_s
     Identify the site at _i_p__a_d_d_r_e_s_s  as a domain-name server that you have
     permission to interrogate.  Hereafter,  if nneett cannot find a domain in
     $NNEETTHHOOMMEE/ddoommaaiinnss.ttxxtt, it interrogates the system with _i_p__a_d_d_r_e_s_s. When
     the domain-name server returns information about a domain, nneett records
     it in $NNEETTHHOOMMEE/ddoommaaiinnss.ttxxtt, to spare the trouble having to interrogate
     the domain-name server repeated about the same domain.

ddoommaaiinn ddrrooppsseerrvveerr _i_p__a_d_d_r_e_s_s
     Drop the system at _i_p__a_d_d_r_e_s_s from your list of domain-name servers.

ddoommaaiinn ssuuffffiixx ._a_b_c
     Set to  ._a_b_c the suffix  used by default  with a partial  domain name.
     For example, the command

          domain suffix .edu

     sets the  default suffix  to .eedduu. Hereafter,  if you enter  a partial
     domain name  (e.g., rraavveenn or lleeppaannttoo) that nneett  does not recognize, it
     will interrogate the domain-name server for that name plus .eedduu (e.g.,
     (rraavveenn.eedduu or lleeppaannttoo.eedduu).

ddoommaaiinn ttrraaccee oonn|ooffff
     Turn domain-name tracing on  or off.  If domain-name tracing is turned
     on, nneett  displays information about its  interactions with the domain-
     name server.

eecchhoo -- CChhaannggee RReessppoonnssee ttoo tteellnneett EEcchhoo RReeqquueesstt

The TELNET protocol specifies that in the absence of a negotiated agreement
to the contrary, neither end echoes  data received from the other.  In this
mode, a  client TELNET session  echoes keyboard input  locally and performs
other line-discipline tasks, but sends nothing until you type <rreettuurrnn>.

When communicating from keyboard  to keyboard, nneett uses the standard local-
echo mode, so setting the  echo parameter has no effect.  However, COHERENT
sends a  TELNET WWIILLLL EECCHHOO instruction immediately  upon receiving a request
to connect from an incoming TELNET  session.  The command eecchhoo lets you set
whether  nneett accepts  a request  to  echo.  It  takes one  argument: either
aacccceepptt or rreeffuussee.  eecchhoo aacccceepptt tells nneett to return  the instruction DDOO EECCHHOO
in response to a WWIILLLL EECCHHOO  request, and begin to echo; whereas eecchhoo rreeffuussee
tells nneett  to return DDOONNTT  EECCHHOO and refuse  to echo.  rreeffuussee  is the normal
setting, because  echoing every character sent via  tteellnneett consumes a great
deal of  network resources.   Typing eecchhoo  without an argument  toggles the
response.

Do not confuse  the command eecchhoo with the server  eecchhoo. The latter responds
to ppiinngg requests from remote hosts.

eeooll -- DDiissppllaayy oorr MMooddiiffyy EEnndd-ooff-LLiinnee BBeehhaavviioorr

The  command  eeooll  manipulates the  TELNET  end-of-line  behavior when  the
command tteellnneett  is in remote-echo  mode.  It can take  one argument: either
uunniixx or ssttaannddaarrdd.

In ssttaannddaarrdd  mode, each key  is sent as-is.   In uunniixx mode,  nneett translates
carriage returns  into line feeds.  This command is  not necessary with all
UNIX systems;  use it only  when you find  that a given  system responds to
line feeds but not to carriage returns.

When you  installed ccoohhuulliipp,  the command eeooll  uunniixx was written  by default
into file ssttaarrttuupp.nneett.

If you  type eeooll without  an argument, it displays  the current end-of-line
mode.

eessccaappee -- DDiissppllaayy oorr CChhaannggee tthhee EEssccaappee CChhaarraacctteerr

The command eessccaappee displays or changes the ``escape character'' -- that is,
the character with which you can escape from conversation mode into command
mode.   If you  type eessccaappee  without an argument,  it displays  the current
escape character.

If you type it with a  one-character argument, nneett makes that character the
escape  character.   It would  not  be  a good  idea  to  make a  printable
character the escape character, lest  you need to type that character while
you are working.   If you type a control character,  that character may not
be echoed onto the screen, but eessccaappee recognizes it anyway.

By default, nneett sets its escape character to <ccttrrll-]> (0x1D).

eetthheerrssttaatt -- DDiissppllaayy EEtthheerrnneett SSttaattiissttiiccss

The  command  eetthheerrssttaatt   displays  statistics  for  your  NE2000  Ethernet
controller, if it is configured to keep statistics.

eexxiitt -- EExxiitt FFrroomm nneett

The command  eexxiitt exits you  from nneett and  returns you to  the program from
which you invoked  it (either the shell or a  shell script).  It attempt to
close all open sessions before it shuts itself down.

ffiinnggeerr -- DDiissppllaayy IInnffoorrmmaattiioonn AAbboouutt UUsseerrss

The command ffiinnggeerr displays  information about ``known users'' on a system.
To  become  a  ``known user,''  a  file  named  _u_s_e_r_i_d.ttxxtt  must reside  in
directory $NNEETTHHOOMMEE/ffiinnggeerr.  For example,  for user  ffrreedd to become  a known
user,   a   file   named  ffrreedd.ttxxtt   must   be   inserted  into   directory
$NNEETTHHOOMMEE.ffiinnggeerr.  The   user  can  describe  himself   in  this  file;  the
description can be serious or whimsical, as he desires.

ffiinnggeerr also recognizes  the file $NNEETTHHOOMMEE/ffiinnggeerr/aallll.ttxxtt. This file usually
is  used  to hold  information  about  the entire  system,  its users,  and
subordinate system; although it can, in fact, hold anything you want.

The command  ffiinnggeerr lets you  display a finger-file for  a recognized user.
It takes the following forms:

ffiinnggeerr _u_s_e_r
     Display  information about  _u_s_e_r,  who is  a recognized  user on  your
     system.

ffiinnggeerr @_h_o_s_t
     Display the name of each recongnized user on system _h_o_s_t, which can be
     a remote host or your local host.

ffiinnggeerr _u_s_e_r@_h_o_s_t
     Display  the contents  of the  finger-file for _u_s_e_r  who is  on system
     _h_o_s_t.

Using host station ffaarrhhoosstt as an example, typing the command

     finger @myhost

displays something like:

     Known users at myhost:
          alice
          joe
          all

Then typing the command

     finger all@myhost

retrieves  the  contents of  file  aallll.ttxxtt from  the  remote host's  finger
directory and displays it on the screen.

You can use  ffiinnggeerr to examine your own system,  if you wish, to see if the
connection is working correctly.

ffttpp -- FFiillee TTrraannssffeerr PPrroottooccooll

The command ffttpp  implements the Internet's file-transfer protocol (FTP; RFC
959).   With  it,  you can  log  into  a  remote  system and  perform  file
transfers.  (The  scope of what you  can do and where  you can work depends
upon what permissions the remote system grants you.)

When you use the command ffttpp to access a remote system, nneett established two
channels to that  remote host, both of which run  over one physical device.
One  channel  transfers  data  between  the  two hosts  --  usually  files,
directory  listings, or  messages  and prompts.   The  other channel  sends
commands from your  local host to the remote host,  and receives the remote
host's reply.   Thus, you can send  commands to the remote  host even while
the  remote host  is transferring  a file  to your  system --  although the
variety of commands that you can send varies depending upon what the remote
host is  doing at any given  moment.  The commands and  replies that can be
sent over the command channel are  precisely defined by FTP's RFC; a number
of these commands will be described in the following paragraphs.

The nneett command's  version of ffttpp implements many (though  by no means all)
of the  commands found  in a  full implementation of  ffttpp. Note,  too, that
because ffttpp  is a sub-command  of nneett, instead  of as a process  in its own
right, you  must escape from  ffttpp back into  nneett's command mode  to perform
some tasks; in particular, you must do so to close an FTP session.

To open an FTP control channel to a remote host, type:

     ffttpp _r_e_m_o_t_e._h_o_s_t

nneett opens the channel to the  remote host.  Usually, you will see a banner,
then a prompt for login and  password.  Many sites permit user aannoonnyymmoouuss to
log in;  for information, check a published description  of the site.  (For
information on how  to set up your machine so  that others users can log in
via  ffttpp, see  the next  chapter  in this  manual, which  describes how  to
administer ccoohhuulliipp.)

After you have  logged into the remote site, nneett  displays the prompt ffttpp>;
this indicates  that you  are in ``conversation  mode'' with ffttpp.  When you
type something, nneett checks whether it is one of the following ffttpp commands;
if it  is, nneett executes it;  otherwise, nneett passes it  intact to the remote
site.   nneett displays  the  remote server's  response directly  on your  the
screen.  Note  that while nneett  is transferring data  via ffttpp, the  only ffttpp
command you can execute is aabboorrtt, which aborts the file transfer.

If you fail  to log into the remote site,  or if something else goes wrong,
press the escape  key to return to nneett's command  mode, and from there type
the command cclloossee to close the ffttpp session.  Then you can try again.

The following lists the commands that you can enter at the ffttpp> prompt:

aabboorrtt
     Aborts a  transfer of data before it concludes.   The transfer of data
     can be  initiated by the commands  ggeett, ppuutt, or ddiirr.  If invoked while
     nneett is receiving a file,  aabboorrtt simply resets the data connection; the
     next incoming  data packet  generates the  message TCP RST  (reset) in
     response, which  clears the  remote server.   If invoked while  nneett is
     sending a file, aabboorrtt sends a premature EOF (end of file) message.  In
     either  case,  aabboorrtt  leaves  a  partial  copy  of  the  file  on  the
     destination machine, which must be removed by hand.

bbeellll Tell nneett to ring your  terminal's bell when it finishes transferring a
     file.

ccdd _d_i_r_e_c_t_o_r_y
     Change to  _d_i_r_e_c_t_o_r_y on the remote host.  You  must have permission to
     change to the target directory.

ccwwdd [ _d_i_r_e_c_t_o_r_y ]
     This command  changes the working directory --  that is, the directory
     you are using on the remote host.  It resembles the command ccdd, except
     that if  you do not  give it an  argument it displays the  name of the
     current working directory.

ddeellee _f_i_l_e
     Delete _f_i_l_e from  the host machine.  You can use  this command only if
     the remote host has granted you ``destroy'' permission.

ddiirr [_r_e_m_o_t_e__f_i_l_e [ _l_o_c_a_l__f_i_l_e ] ]
     nneett  sets  the command  LLIISSTT  on  the control  channel,  to print  the
     contents of the current working directory.  If you invoke ddiirr with one
     argument,  it prints  information  about ffiillee,  which  resides on  the
     remote host.  Note that _f_i_l_e can be a directory as well as an ordinary
     file; and  that it can be  either a full path name  or a relative path
     name.   If you  invoke ddiirr  with two arguments,  ddiirr assumes  that the
     second argument names a file on your local host, and writes its output
     into that file.

     You can  use other options  with ddiirr, but which  options are available
     vary from one remote host  to another.  Many UNIX-based hosts will let
     you a regular expression to  form the name of _r_e_m_o_t_e_f_i_l_e; for example,
     the command

          dir [A-M]*.gif

     displays  every  file whose  name  that begins  with  the letters  `A'
     through `M'  and ends with the string  ``.gif''.  Likewise, many UNIX-
     based remote hosts recognize the  option -tt, which prints the files in
     the order  in which they were last modified,  from youngest to oldest.
     For details on the options  that are potentially available to you, see
     the entry for llss in the COHERENT Lexicon.

ggeett _r_e_m_o_t_e__f_i_l_e [ _l_o_c_a_l__f_i_l_e ]
     nneett sends the  commands PPOORRTT and RREETTRR on the  control channel, to copy
     _r_e_m_o_t_e__f_i_l_e from  the remote host into _l_o_c_a_l__f_i_l_e  on your local host.
     If you do not name a _l_o_c_a_l__f_i_l_e, nneett copies _r_e_m_o_t_e__f_i_l_e into a file of
     the same name on your local system.

hhaasshh Toggle  hashing.   When  hashing  is  on,  ffttpp displays  the  ``hash''
     character `#'  for every  one kilobyte of  data it processes  during a
     file transfer.  By watching the  hash marks appear on your screen, you
     can get a rough idea of  how well (or how poorly) the file transfer is
     proceeding.  If the file transfer appears  to be hung, you can use the
     command aabboorrtt  to abort  the file transfer,  and try again  some other
     time.

lliisstt This is a synonym for the command ddiirr.

llss _r_e_m_o_t_e__f_i_l_e [ _l_o_c_a_l _f_i_l_e ]
     nneett  sends the  command NNLLSSTT  over  the control  channel to  print, in
     abbreviated form, the contents of the current working directory on the
     remote host.  If  you name a _l_o_c_a_l__f_i_l_e, llss writes  its data into that
     file on your local host instead  of to your screen.  Only the names of
     the files are shown, just as with the COHERENT command llss.

mmkkddiirr _d_i_r_e_c_t_o_r_y
     Create  _d_i_r_e_c_t_o_r_y  on the  remote  host.  The  remote  host must  have
     granted you ``create'' permission before you can use this command.

ppaassss _p_a_s_s_w_o_r_d
     nneett automatically invokes this  command while you are logging into the
     remote system: it requests you for your password, then passes what you
     type to the remote host.

     If  you wish  to change  your identity  after you  have logged  into a
     remote host, first invoke the command uusseerr, then ppaassss.

ppuutt _l_o_c_a_l__f_i_l_e [ _r_e_m_o_t_e__f_i_l_e ]
     nneett sends the commands PPOORRTT and  SSTTOORR over the control channel to copy
     _l_o_c_a_l__f_i_l_e from  your local into into _r_e_m_o_t_e__f_i_l_e  on the remote host.
     If  you do  not  name a  _r_e_m_o_t_e__f_i_l_e,  nneett writes  _l_o_c_a_l__f_i_l_e into  an
     identically named file on the  remote host.  The remote host must have
     granted you ``write'' permission before you can use the command.

ppwwdd  Print working  directory -- that  is, print the name  of the directory
     within which you are working on the remote host.

qquuiitt Close the current FFTTPP session.   nneett notifies the remote host that you
     are  quitting,  so  the  connection  is  closed gracefully.   This  is
     equivalent to the command bbyyee under most implementation of ffttpp.

rrmmddiirr _d_i_r_e_c_t_o_r_y
     Remove  _d_i_r_e_c_t_o_r_y  from the  remote  host.  Before  you  can use  this
     command, the remote host must have granted you ``destroy'' permission,
     and _d_i_r_e_c_t_o_r_y must be empty.

ttyyppee [aa|ii|ll_b_y_t_e_s_i_z_e]
     Send the command TTYYPPEE on the control channel to tell remote server the
     type of file to be transferred.  The following types are recognized:

     aa  ASCII mode: the file consists of printable characters, with the end
        of a line marked by a CR/LF sequence.

     ii  Image mode: send the file exactly as it appears on the remote host.
        Set this mode before you download any binary data, e.g., executable
        programs,  object  modules,   images,  or  archives  of  compressed
        material.

     ll_b_y_t_e_s_i_z_e
        The same as image mode,  except that nneett notifies the remote system
        that the  word length is _b_y_t_e_s_i_z_e (typically,  eight).  Use this to
        download  files  from  systems with  an  unusual  word size  (e.g.,
        DECSYSTEM-10s and 20s).

uusseerr _u_s_e_r_n_a_m_e
     This command  prompts you for  your user identifier, and  passes it to
     the remote  host.  This command is invoked  automatically when you are
     first logging into the remote host.

     You  can also  invoke uusseerr  after you  have logged  in, to  change you
     identity on  the remote host.  If  you do so, you  must follow it with
     the command ppaassss (described above).

iipp -- MMaanniippuullaattee tthhee IIPP HHaannddlleerr

The following  commands let you manipulate  the IP handler --  that is, the
portion of nneett that processes the Internet Protocol:

iipp aaddddrreessss [ _m_y_a_d_d_r_e_s_s ]
     Set your local IP address to _m_y_a_d_d_r_e_s_s. If invoked without an address,
     this command displays your local host's IP address.

iipp ssttaattuuss [ _c_l_e_a_r ]
     This command  displays information about your  local host's IP status.
     The first line of output displays some SLIP information (should you be
     using SLIP).   The second line  displays IP statistics,  such as total
     packet counts and error counters of various types.

     iipp ssttaattuuss also  displays statistics about the Internet Control Message
     Protocol (ICMP),  including the number  of ICMP messages  of each type
     sent or received.

iipp ttttll [ _v_a_l_u_e ]
     Set  the time-to-live  of outgoing  IP datagrams  to _v_a_l_u_e  data hops.
     Every  time a  remote system  handles a  datagram, it  decrements that
     datagram's time-to-live  value; a datagram ``dies''  when its time-to-
     live reaches  zero.  Should a datagram's  address be unresolvable, the
     time-to-live mechanism prevents  it from circulating endlessly through
     the network.  If you set _v_a_l_u_e to too low a value, a datagram will not
     live long enough to reach its destination; if you set it too high, you
     could be wasting network resources.

     If you  invoke this command  without a _v_a_l_u_e, it  displays the current
     value of the time-to-live parameter.

hheellpp -- DDiissppllaayy aa hheellpp ffiillee

The  command  hheellpp displays  the  contents  of a  help  file.   It has  the
following syntax:

     help [ _s_u_b_j_e_c_t ]

hheellpp displays  the contents of file  $NNEETTHHOOMMEE/_s_u_b_j_e_c_t.hhllpp, which presumably
contains  information  to help  you  with _s_u_b_j_e_c_t.  The  file is  displayed
through a pager; to quit, type the escape character <ccttrrll-]>.

If  you  do  not  specify  _s_u_b_j_e_c_t,  hheellpp displays  the  contents  of  file
$NNEETTHHOOMMEE/nneett.hhllpp. ccoohhuulliipp  comes with help files for some,  but not all, of
its commands.  You can prepare other help files if you wish.

hhoossttnnaammee -- SSeett tthhee LLooccaall HHoosstt'ss NNaammee

nneett uses a name to identify your local host to remote systems, when it uses
FTP or SMTP  to exchange files with a remote  system.  The command hhoossttnnaammee
lets you set the name of your local host.

hhoossttnnaammee recognizes the following syntax:

     hhoossttnnaammee [ _n_a_m_e ]

hhoossttnnaammee sets the name of your local host to _n_a_m_e. Note that _n_a_m_e must be a
text string, not an IP address.

If invoked without an argument, hhoossttnnaammee displays your local host's name.

You should set  your local host's name to its  UUCP name, which is recorded
in file /eettcc/uuuuccppnnaammee, although you are not required to do so.

kkiicckk -- KKiicckk OOuutt PPeennddiinngg TTeexxtt

The command kkiicckk flushes the TCP buffer, and launches all datagrams that it
is ``sitting  on''.  You can use  this if a TCP  session is being ``balky''
for any reason.

lloogg -- LLoogg SSeerrvveerr AAccttiivviittyy

The command lloogg lets you record all activity on the servers that you launch
on your local host.  It recognizes the following syntax:

     lloogg [ _l_o_g_f_i_l_e | ssttoopp ]

If invoked without an argument, lloogg tells you whether nneett is logging server
activity.  Logging entries appear as follows:

     Jul 28 22:02:45 198.162.16.89:1001 - open Finger
     Jul 28 22:02:57 198.162.16.89:1002 - open Telnet
     Jul 28 22:04:29 198.162.16.89:1003 - open FTP
     Jul 28 22:09:16 198.162.16.89:1004 - rw logged in, ID
     Jul 28 22:10:14 198.162.16.89:1003 - close FTP
     Jul 28 22:11:37 198.162.16.89:1004 - RETR /projects/smail/smail3.1.28.tz
     Jul 28 22:32:29 198.162.16.89:1008 - open FTP
     Jul 28 22:32:35 198.162.16.89:1008 - rw logged in, ID
     Jul 28 22:33:40 198.162.16.89:1004 - close FTP


If invoked with the argument _l_o_g_f_i_l_e,  lloogg turns on logging (if logging was
not yet on), and appends the logging information onto _l_o_g_f_i_l_e on your local
host.  You must have permission to  write into _l_o_g_f_i_l_e, or logging will not
work.  Because entries are appended onto _l_o_g_f_i_l_e, you can use the same file
repeatedly, to keep a running log of your network activity.

If invoked with the argument ssttoopp, lloogg stops logging.

ppiinngg -- RReeaacchh OOuutt aanndd TToouucchh AA RReemmoottee HHoosstt

The command ppiinngg sends a datagram to a remote host, then tells you how long
it took  the remote host  to respond.  This is  an easy way to  tell if the
remote  host is  ``on the  air,'' and,  if so,  how quickly  the connection
between your machines is functioning.

ppiinngg recognizes the following syntax:

     ppiinngg [ _r_e_m_o_t_e_h_o_s_t [ _i_n_t_e_r_v_a_l ] ] | cclleeaarr

The command ppiinngg _r_e_m_o_t_e_h_o_s_t ``pings'' _r_e_m_o_t_e_h_o_s_t. When it receives a reply,
nneett displays an information reply something like the following:

     12.34.5.6: echo reply id 0 seq 124, 55 ms

This indicates the round trip time was 55 milliseconds.  (A round-trip time
of zero usually indicates that  the remote system was inaccessible for some
reason.)

The command ppiinngg _r_e_m_o_t_e_h_o_s_t _i_n_t_e_r_v_a_l tells nneett to ``ping'' _r_e_m_o_t_e_h_o_s_t every
_i_n_t_e_r_v_a_l seconds.   You can use  this to command to  profile the connection
time between your local host and _r_e_m_o_t_e_h_o_s_t. Also, if your system is hooked
into a  network that drops  a connection when  activity ceases for  a given
interval, you can use this command to keep your system on the air.

To stop a continual ping, use the command ppiinngg cclleeaarr.

ppwwdd -- PPrriinntt WWoorrkkiinngg DDiirreeccttoorryy

This  command  is just  like  the  COHERENT command  ppwwdd:  it displays  the
directory you are accessing on your local host.

rreeccoorrdd -- RReeccoorrdd AAllll AAccttiivviittyy

The command rreeccoorrdd _l_o_g_f_i_l_e tells nneett to open _l_o_g_f_i_l_e and append onto it all
data it receives during the current  session.  nneett also appends all data it
sends on  the current  session, except  for TELNET sessions  in remote-echo
mode.

The command rreeccoorrdd ooffff tells nneett to stop recording and close _l_o_g_f_i_l_e.

Note that this command is not supported for FTP sessions.

rreesseett -- BBllooww AAwwaayy aa SSeessssiioonn

The command  rreesseett deletes the  TCP Control Block  (TCB) that belongs  to a
given session.   This immediately terminates  your half of a  session -- in
effect, it ``hangs up the phone'' on a session.

If you invoke rreesseett with a session's number as an argument, nneett deletes the
TCB for that session; if you invoke it without an argument, nneett deletes the
TCB of the current session, should there be one.

Use this command  with caution, because it does not  inform the remote host
that the connection no longer exists.  You should use it only to get rid of
a  lingering,  half-open connection  after  a remote  host  has crashed  or
otherwise gone ``off the air''.

rroouuttee -- MMaanniippuullaattee tthhee RRoouuttiinngg TTaabbllee

The command  rroouuttee manipulates the IP  routing table -- that  is, the table
that tells  nneett how to get  from here to there.  It  comes in the following
three basic forms:

rroouuttee
     Display the contents of the routing table.

rroouuttee ddrroopp _r_e_m_o_t_e._h_o_s_t
     Drop the  entry for _r_e_m_o_t_e._h_o_s_t  from the routing table.   If a packet
     arrives for the  deleted address and a default route is in effect, the
     default will be used.

rroouuttee aadddd _r_e_m_o_t_e._h_o_s_t[/_b_i_t_s]|ddeeffaauulltt _i_n_t_e_r_f_a_c_e [ _g_a_t_e_w_a_y [ _m_e_t_r_i_c ] ]
     Add a  route to the routing table.   _r_e_m_o_t_e._h_o_s_t identifies the remote
     system  to which  you  wish to  route  datagrams.  If  this system  is
     described  in file  $NNEETTHHOOMMEE/hhoossttss.nneett, you can  identify it  by name;
     otherwise, you must give its IP address.

     _i_n_t_e_r_f_a_c_e names the nneett  interface you are linking to _r_e_m_o_t_e._h_o_s_t. You
     must first have used the command aattttaacchh to define _i_n_t_e_r_f_a_c_e before you
     can use the it in a rroouuttee command.

     If _r_e_m_o_t_e._h_o_s_t is not local and  you are using Ethernet to access your
     network, you must also name  the _g_a_t_e_w_a_y through which your local host
     accesses _r_e_m_o_t_e._h_o_s_t. (This is not required for SLIP, because a serial
     connection goes  directly from your system to  the remote system, with
     no chance for the datagrams to  go astray.) If _g_a_t_e_w_a_y is described in
     file  $NNEETTHHOOMMEE/hhoossttss.nneett, you  can use its  name; otherwise,  you must
     give  its IP  address.  Again,  if  this system  is described  in file
     $NNEETTHHOOMMEE/hhoossttss.nneett, you  can identify it by  name; otherwise, you must
     give its IP address.

     The optional  suffix /_b_i_t_s to  _r_e_m_o_t_e._h_o_s_t specifies how  many bits of
     its  IP   address  are  to   be  considered  significant   in  routing
     comparisons.   If not  specified,  nneett assumes  that all  32 bits  are
     significant.   With this  option, you can  use a  single routing-table
     entry to  refer to many hosts  whose IP addresses begin  with the same
     bit-string.  For example, ARPA classes  A, B, and C networks would use
     suffixes of /8, /16, and /24 respectively.  For example, the command

          route add [44]/8 sl0 [44.64.0.2]

     tells nneett  to route to  [44.64.0.2] every IP address  that begins with
     ``44''.

     When an IP  address matches more than one entry  in the routing table,
     nneett selects the route that matches the IP address most tightly -- that
     is,  the entry  with  largest _b_i_t_s  parameter.   This lets  you set  a
     general rule for routing a large block of hosts, then set exceptions.

     The  special  destination  ddeeffaauulltt  is  used  to  route  datagrams  to
     addresses not  in the routing table; it is  equivalent to specifying a
     /_b_i_t_s suffix of 0 to  any destination _r_e_m_o_t_e._h_o_s_t. Be careful when you
     define default entries: two  nodes whose default entries point at each
     other  will ``ping-pong''  datagrams until  their  time-to-live fields
     expire.  If the  routing table has only one entry,  that should be the
     default.

     The following gives some more examples of the rroouuttee command:

          # Station with IP address [44.0.0.10] on local channel
          # needing an explicit route for some reason
          route add [44.0.0.10] ax0


          # Route datagrams to IP address 44.0.0.3 to SLIP line #0.
          # No gateway is needed because SLIP is point-to point.
          route add [44.0.0.3] sl0


          # Route all default traffic to the gateway on the local Ethernet
          # with IP address [44.0.0.1]
          route add default ec0 [44.0.0.1]


          # The local Ethernet has an ARPA Class-C address assignment;
          # route all IP addresses beginning with 192.4.8 to it
          route add [192.4.8]/24 nx0


sseessssiioonn -- DDiissppllaayy IInnffoorrmmaattiioonn AAbboouutt SSeessssiioonnss

The command sseessssiioonn displays information every session that running on your
local host.  The  information displayed includes session number, remote TCP
address, and the address of the  TCP control block.  nneett prints an asterisk
`*'   to the  description of  the current  session; to  enter or  return to
conversation mode with that session, type <rreettuurrnn>.

To enter  conversation mode with a session other  than the current session,
type sseessssiioonn followed by that session's number.

If  the TELNET  server is  enabled, nneett automatically  notifies you  when a
remote  user  initiates a  session  upon your  system.   By typing  sseessssiioonn
followed by the new session's  number, you can enter conversation mode with
that incoming session.

sshheellll -- IInnvvookkee tthhee CCOOHHEERREENNTT SShheellll

The command sshheellll invokes a COHERENT shell.  You can give commands directly
to COHERENT; nneett, meanwhile, continues to ``mind the store.''

When you exit from the shell  (either by typing <ccttrrll-DD> or eexxiitt), COHERENT
returns to working with nneett.

Note  that you  can also  use COHERENT's  virtual-console facility  to give
commands to  COHERENT while  working with  nneett. This is  in many  ways much
easier than invoking a subshell,  then returning; its main drawback is that
it is  quite easy to  forget that you  have a network  session running, and
walk away and leave yourself logged  into a system thousands of miles away.
For details on  virtual consoles, see the entry for  vviirrttuuaall ccoonnssoollee in the
COHERENT Lexicon.

ssmmttpp -- SSiimmppllee MMaaiill TTrraannssppoorrtt FFaacciilliittyy

The command ssmmttpp manipulates the SMTP server on your system.  It recognizes
the following sub-commands:

ssmmttpp ggaatteewwaayy [ _h_o_s_t_i_d ]
     Display or  sets the host to  be used as a  ``smart'' mail relay.  Any
     mail sent  to a _h_o_s_t_i_d not  in the host table will  instead be sent to
     the gateway for forwarding.

ssmmttpp kkiicckk
     Run through the outgoing-mail queue and attempt to deliver any pending
     mail.  This command is periodically invoked by a timer whenever nneett is
     running;  this command  allows the  user to  ``kick'' the  mail system
     manually.

     Note that if there was mail  queued up and not sent when you exit nneett,
     there will be zero-length files  with the suffix .llcckk extension in the
     directory  mmqquueeuuee.  These  mail  messages  will  not go  when  nneett  is
     restarted; you must delete these files by hand.

ssmmttpp mmaaxxcclliieennttss [ _m_a_x_i_m_u_m ]
     Display or set to  _m_a_x_i_m_u_m the maximum number of simultaneous outgoing
     SMTP  sessions that  nneett allows.   The  default is  ten; reduce  it if
     network congestion is a problem.

ssmmttpp mmooddee [qquueeuuee|rroouuttee]
     Use qquueeuuee  to stage messages  in the subdirectory rrqquueeuuee  so a mailing
     agent other than nneett can deal  with it.  By default, nneett sets the mode
     to rroouuttee.

ssmmttpp ttiimmeerr [ _s_e_c_o_n_d_s ]
     Display or set the interval, in seconds, between scans of the outbound
     mail queue.  For example, the command

          smtp timer 600

     tells nneett to check for outgoing  mail every ten minutes and attempt to
     deliver anything  it finds, subject to  the mmaaxxcclliieennttss limit.  Setting
     _s_e_c_o_n_d_s  to  zero  disables  queue-scanning  altogether: this  is  the
     default.  This  value is recommended for  stand-alone IP gateways that
     never handle mail.

ssmmttpp ttrraaccee [ _t_r_a_c_e__l_e_v_e_l ]
     Display or set  the trace level in the SMTP  client.  This permits you
     to watch SMTP's conversations as it delivers mail.  _t_r_a_c_e__v_a_l_u_e can be
     set to  0, 1, 5,  or 7.  Zero  disables tracing; this  is the default.
     Values 1, 5, and 7 give increasing levels of details.

Please  note that  this server  works  only with  the mail-router  bbmm. This
router works in a very non-standard  way, so you will have serious problems
if you attempt to use it for your mail.

ssttaarrtt -- IInnvvookkee aa SSeerrvveerr

The command ssttaarrtt starts  a specific Internet server.  Each server services
processes  any requests  that it  receives from  the outside  world.  ssttaarrtt
commands usually are embedded in a ssttaarrttuupp file.

To use it, simply type ssttaarrtt followed by the name of the server you wish to
start up.   The variety of servers available depends  upon how your version
of ccoohhuulliipp  was configured; among  the available servers  are eecchhoo, ffiinnggeerr,
ffttpp, ssmmttpp, tteellnneett, and tteelluunniixx.

The command ssttaarrtt tteelluunniixx takes  an optional third argument, which lets you
set the number  of the socket to which the  tteelluunniixx server is attached.  By
default, the tteelluunniixx is attached to socket 513; however, the command

     start telunix 23

connects the tteelluunniixx server to socket  23, which is the well-known port for
TELNET.  Connecting  tteelluunniixx to port  23 lets users who  access your system
via TELNET log in as they normally would, and so gain their normal suite of
permissions.  For  details on tteelluunniixx, see the  chapter on advanced ccoohhuulliipp
that follows in this manual.

ssttoopp -- SShhuutt DDoowwnn aa SSeerrvveerr

To shut down  a server, type the command ssttoopp  followed by the name of that
server.

Note that the command ssttoopp ppiinngg  stops new connections from being made, but
does  not affect  sessions  that are  in  progress.  To  close an  existing
session, use the command cclloossee.

ttccpp -- MMaanniippuullaattee TTCCPP

The command  ttccpp lets you  modify how nneett  manages TCP.  It  recognizes the
following sub-commands:

ttccpp iirrtttt [ _s_e_c_o_n_d_s ]
     Display  or set  nneett's  estimate initial  round trip  time (IRTT),  in
     seconds.  The default is five seconds.  TCP uses this estimate for new
     TCP connections -- that is,  when TCP establishes a new connection, it
     waits _s_e_c_o_n_d_s  before it retransmits  a datagram.  As  the TCP session
     progresses, TCP  can measure  how much time  is needed for  a datagram
     round  trip  -- i.e.,  the  interval between  TCP's  dispatching of  a
     datagram,  and  its  receipt  of  confirmation  that the  remote  host
     received it.

     If you  are running  a TCP  session over a  slow or busy  channel, you
     should  increase  the  IRTT.   This  helps  to  avoid  the  flurry  of
     retransmissions that  would otherwise  occur as the  smoothed estimate
     settles down to the correct value.

     You must issue  this command before you start servers,  or it will not
     affect incoming connections.  (A  typical IRTT for a ssttaarrttuupp script is
     2000.)

ttccpp kkiicckk _t_c_b__a_d_d_r_e_s_s
     If there is data on the send queue of a given TCP control block (TCB),
     this  command forces an  immediate retransmission.   _t_c_b__a_d_d_r_e_s_s gives
     the TCB's address; you can obtain  this value by using the command ttccpp
     ssttaattuuss.

ttccpp mmssss [ _b_y_t_e_s ]
     When your  system is establishing a TCP channel  with a remote system,
     your system  and it  negotiate the TCP  Maximum Segment Size  (MSS) --
     that is, the size of the  largest datagram to pass between them.  Each
     system offers its maximum, and the lesser of the two is selected.

     The command ttccpp  mmssss sets to _b_y_t_e_s the MSS  that your system will send
     to a remote system.  Changing the value of the MSS affects only future
     connections; existing connections are unaffected.  This value normally
     is set in your ssttaarrttuupp script.

     If you type ttccpp mmssss without a _b_y_t_e_s argument, nneett displays the current
     size of the MSS.

     By default,  ccoohhuulliipp sets  the MSS to  512 bytes.  When  you installed
     ccoohhuulliipp onto  your system, the  command ttccpp mmssss 11550000  was written into
     your ssttaarrttuupp file; this is  a more reasonable figure given the current
     state  of communications  equipment.  If you  find that  a third-party
     networking scheme  is handling fragmentation incorrectly,  set the MSS
     to 216; this  allows 40 bytes for IP and  TCP headers, and so prevents
     fragmentation.

ttccpp rreesseett _t_c_b__a_d_d_r_e_s_s
     Delete the  TCB control block  (TCB) that at _t_c_b__a_d_d_r_e_s_s.  This is the
     same  as  issuing  the rreesseett  command,  and  should  be  used just  as
     cautiously.

ttccpp rrtttt _t_c_b__a_d_d_r_e_s_s _m_i_l_l_i_s_e_c_o_n_d_s
     Set the round-trip  time (RTT) that is in the  TCP control block (TCB)
     _t_c_b__a_d_d_r_e_s_s  to  _m_i_l_l_i_s_e_c_o_n_d_s. This  replaces  whatever  RTT that  TCP
     computed for  the session  that this  TCB controls.  This  command can
     help speed up recovery from a  series of lost packets, because it lets
     you manually bypass the normal retransmission-timing mechanism.

     If you set the RTT to a bogus value, you can help cause a major tie-up
     on the Information  Superhighway.  Therefore, use this command only if
     you know _e_x_a_c_t_l_y what you are doing.

ttccpp ssttaattuuss [ _t_c_b__a_d_d_r_e_s_s ]
     This  command displays  information  about TCP  sessions  that are  in
     progress.

     If  you enter  this  command without  arguments, it  displays a  brief
     summary  of  all sessions.   The  summary  includes several  TCP-level
     statistics, plus a  summary of all existing TCP connections, including
     TCB address,  send and receive queue sizes,  local and remote sockets,
     and connection state.

     If you name a _t_c_b__a_d_d_r_e_s_s on the command line, nneett displays a detailed
     dump  of  the TCP  Control  Block  (TCB) at  this  address.  The  dump
     includes send and receive sequence numbers, and timer information.

ttccpp ttiimmeerrttyyppee [ lliinneeaarr|eexxppoonneennttiiaall ] [ _m_i_n_u_t_e_s ]
     Display or set the method used  to set the TCP retry/backoff timer and
     the maximum value to which it it will back off.

     When entered  without an argument, the  command ttccpp ttiimmeerrttyyppee displays
     the current type of timer, and the backoff time.

     When entered  with one argument, nneett attempts to  set the timer's type
     to that argument.  The argument must be lliinneeaarr or eexxppoonneennttiiaall.

     The optional argument _m_i_n_u_t_e_s sets the maximum backoff time.

The default is exponential timing, with a maximum backoff of 30 minutes.

ttccpp wwiinnddooww [ _b_y_t_e_s ]
     Display or set the size, in bytes, of the receive window that TCP uses
     when  it  creates a  new  connection.  This  command  does not  affect
     existing connections.   The default is 2,048  bytes.  If you encounter
     fragmentation problems  with third  party networking schemes,  set the
     TCP window to 1,080.

tteellnneett -- CCoonnvveerrssee WWiitthh AAnnootthheerr SSyysstteemm

The command tteellnneett uses the TELNET  protocol to connect with a remote host.
When the  connection is made, you  can converse with that  host, just as if
your machine were a terminal plugged into it.

The command tteellnneett takes the following syntax:

     tteellnneett _r_e_m_o_t_e._h_o_s_t [ _p_o_r_t ]

_r_e_m_o_t_e._h_o_s_t names the  host to contact; this can be  its domain name, or an
IP  address.   _p_o_r_t  names the  port  to  connect  to.   Some remote  hosts
establish special ports for special purposes;  or you may wish to contact a
well-known port for another protocol (e.g.,  SMPT or FTP) in order to debug
a connection  (or send  forged mail).   If you do  not name a  _p_o_r_t, tteellnneett
connects to port 23, which is the well-known port for the TELNET protocol.

ttrraaccee -- TTrraaccee tthhee HHaannddlliinngg ooff DDaattaaggrraammss

The  command  ttrraaccee  lets  you  establish  and customize  the  tracking  of
datagrams.  You can use the information that a trace yields to help debug a
connection.

ttrraaccee recognizes the following syntax:

     ttrraaccee [ _i_n_t_e_r_f_a_c_e _f_l_a_g_s [ aallllmmooddee|ccmmddmmooddee ] ]
     ttrraaccee ttoo _o_u_t_p_u_t_f_i_l_e

When  invoked without  arguments, ttrraaccee  lists  all defined  interfaces and
their tracing status.

The first argument, _i_n_t_e_r_f_a_c_e, names  the interface that you wish to trace.
The interface first have been defined through the command aattttaacchh before you
can trace it.

The  second  command _f_l_a_g_s,  is  a three-digit  number  that controls  some
aspects  of  tracing.  The  first  (leftmost) digit  controls  the type  of
tracing, as follows:

00  Decode protocol headers, but do not display data.
11  Decode protocol  headers; display only the data.   Data are displayed as
   ASCII characters,  64 per line; unprintable  characters are displayed as
   periods.
22  Decode  protocol  headers;  display both  data  and  headers.  Data  and
   headers are displayed in hexadecimal and ASCII, 16 characters per line.

The  second  (middle)  digit of  _f_l_a_g_s  controls  the  tracing of  incoming
datagrams: one enabled tracing, whereas zero disables it.

The  third  (rightmost)  digit of  _f_l_a_g_s  controls  the  tracing of  output
datagrams:  if one,  tracing  is enabled;  if  zero, it  is disabled.   one
enabled tracing, whereas zero disables it.

For  example, setting  _f_l_a_g_s to  001111 enables tracing  of both  incoming and
outgoing datagrams, but displays information only about the headers.

The optional third argument to ttrraaccee lets you select whether traced packets
are always displayed.  aallllmmooddee displays tracing all the time, regardless of
whether you are in command mode or conversation mode.  ccmmddmmooddee tells nneett to
display tracing only when it is in command mode.

Finally, the  command ttrraaccee  ttoo _o_u_t_p_u_t_f_i_l_e  redirects the tracing  from the
screen into _o_u_t_p_u_t_f_i_l_e. This command lets you examining tracing information
at your leisure.

uuddpp ssttaattuuss -- DDiissppllaayy SSttaattuuss ooff UUDDPP RReecceeiivvee QQuueeuueess

The  title says  it all:  this  command displays  the status  of every  UDP
receive queue.

uuppllooaadd -- WWrriittee FFiillee IInnttoo CCuurrrreenntt TTEELLNNEETT SSeessssiioonn

This command opens a file and writes its contents into the current session,
just as  if you had  typed those contents  from the keyboard.   When it has
finished  copying  the  file to  the  session,  nneett  displays the  message,
UUppllooaaddiinngg ooffff.

This  command is  valid only  with  a TELNET  session.  You  can use  it to
execute on the remote host a script that resides on your local host.

                            WWhheerree TToo GGoo FFrroomm HHeerree

For some technical background of the commands used in this chapter, see the
chapter _T_C_P/_I_P _H_i_s_t_o_r_y _a_n_d _D_e_s_i_g_n, which appears earlier in this manual.
























































