////////
/
/ Intel 8086 C runtime.
/ SMALL model.
/
////////

	.globl	vlmul
	.globl	vrmul

////////
/
/ unsigned long
/ vrmul(a, b);
/ unsigned long a;
/ unsigned long b;
/
/ unsigned long
/ vlmul(a, p);
/ unsigned long a;
/ unsigned long *p;
/
/ these two routines perform 32 bit unsigned multiplication.
/ they are called by the compiler when a user program performs an
/ unsigned long multiplication, and are called by the library routines
/ that perform long multiplication.
/
////////

alow	=	8
ahigh	=	10
blow	=	0
bhigh	=	2

vlmul:	mov	ax,bx			/ save bx
	mov	bx,sp			/ point bx at
	mov	bx,6(bx)		/ the operand and
	jmp	L0			/ go to common end.

vrmul:	mov	ax,bx			/ save bx
	mov	bx,sp			/ point bx at
	lea	bx,6(bx)		/ the operand.

L0:	push	si			/ standard
	push	di			/ c
	push	bp			/ function
	mov	bp,sp			/ linkage.

	push	ax			/ save saved bx.
	mov	ax,alow(bp)		/ multiply the low
	mul	blow(bx)		/ parts and
	mov	si,dx			/ stash both halves
	mov	di,ax			/ of the product.

	mov	ax,alow(bp)		/ do the first of the
	mul	bhigh(bx)		/ cross products and
	add	si,ax			/ add it in.

	mov	ax,ahigh(bp)		/ do the second of the
	mul	blow(bx)		/ cross products and
	add	si,ax			/ add it in.

	mov	dx,si			/ get the return value
	mov	ax,di			/ into the proper registers.

	pop	bx			/ restore saved bx.
	mov	sp,bp			/ standard
	pop	bp			/ c
	pop	di			/ function
	pop	si			/ linkage.
	ret				/ done.
