/* (-lgl
 *	Coherent 386 release 4.2
 *	Copyright (c) 1982, 1994 by Mark Williams Company.
 *	All rights reserved. May not be copied without permission.
 *	For copying permission and licensing info, write licensing@mwc.com
 -lgl) */
/*
 * Configurable information for "hai" (SCSI, tape support) device driver.
 */

#define __KERNEL__	1
#define _KERNEL		1

#include "conf.h"
#include <sys/haiscsi.h>

/*
 * Patchable bit maps
 *   Bit n is 1 in HAI_DISK if there is a hard disk at SCSI ID n.
 *   Bit n is 1 in HAI_TAPE if there is a tape at SCSI ID n.
 */

int HAI_DISK = HAI_DISK_SPEC;
int HAI_TAPE = HAI_TAPE_SPEC;
int HAI_CDROM = HAI_CDROM_SPEC;

/*
 * Number of heads and sectors per track are translation mode, and fixed
 * in the BIOS, so do not differ among attached drives.  Defaults shown.
 *
 * This is the default arrangement for cards like the Adaptec. Other cards
 * go through other gyrations. Because of its simplicity this arrangement
 * has been adopted for all non-BIOS supported drives. 
 *
 * Coherent cannot currently see beyond cylinder 1023 so these parameters
 * limit us to 1 GB drives. If you patch them higher have a bigger drive
 * than that.
 *
 * HAI_SD_HDS = 64;  number of heads on a drive (translation mode).
 *   If initialized zero, use BIOS values or default to 64.
 * HAI_SD_SPT = 32;  number of sectors per track (translation mode).
 *   If initialized zero, use BIOS values or default to 32.
 */

int	HAI_SD_HDS = HAI_SD_HDS_SPEC;
int	HAI_SD_SPT = HAI_SD_SPT_SPEC;

/* End of file */
