//////////
/ i8086 C string library.
/ strcspn()
/ ANSI 4.11.5.3.
//////////

//////////
/ size_t
/ strcspn(String1, String2)
/ char *String1, *String2;
/
/ Return the length of the initial segment of String1 which consists of
/ characters not in String2
//////////

#include <larges.h>

String1	=	LEFTARG
String2	=	String1+DPL

	Enter(strcspn_)
	Les	di, String1(bp)	/ String1 address String1 ES:DI
	mov	dx, di		/ Save for length calc
	cld
1:	movb	ah, Pes (di)	/ Get char from String 1
	inc	di
	orb	ah, ah
	je	3f		/ If equal done

	Lds	si, String2(bp)	/ address of String2 DS:SI
2:	lodsb			/ From character String1 AL
	orb	al, al
	je	1b		/ End of scan get next from String1
	cmpb	ah, al
	jne	2b		/ Try next in String2

3:	dec	di
	mov	ax, di
	sub	ax, dx
	Leave
