/*
 * char * getline(ifp, lineno) FILE *ifp; int *lineno;
 *
 * Function to get lines from an input file.
 * Returns the address of the line, or NULL for eof.
 *
 * lineno should usually be started at 1. lineno will
 * be incremented by the number of lines in the previous call.
 * Thus lineno will be the number of the line just gotten.
 *
 * # to end of line is passed. unless # is first char
 * \ whitespace through end of line is passed.
 */
#include <misc.h>

static char outSpace[] = "Out of space";
static char *line = NULL;
static int i;
static int size = 0;
static int oldline = 0;

static void
addchr(c)
{
	extern char *realloc();

	while (i >= size)
		if (NULL == (line = realloc(line, size += 80)))
			fatal("Out of space");
	line[i++] = c;
}

char *
getline(ifp, lineno)
FILE *ifp;
int *lineno;
{
	int c, octacc, octcnt;
	enum state { normal, incont, incomm, fullcomm, bsl } state;

	*lineno += oldline;
	for (state = normal, oldline = i = 0;;) {
		if (EOF == (c = fgetc(ifp))) {
			if (i)
				fprintf(stderr, 
					"line %d truncated at end\n", 
						*lineno + oldline);
			return (NULL);
		}

		switch (state) {
		case normal:
			switch (c) {
			case '\\':
				state = bsl;
				continue;

			case '\n':
				oldline++;
				addchr('\n');
				addchr(0);
				return (line);

			case '#':
				if (i) {
					state = incomm;
					continue;
				}
				state = fullcomm;
			}
			addchr(c);
			continue;

		case incont:
			if ('\n' == c) {
				oldline++;
				state = normal;
			}
			continue;

		case fullcomm:
			if ('\n' == c) {
				state = normal;
				oldline++;
				addchr('\n');
				addchr(0);
				return (line);
			}
			addchr(c);
			continue;

		case incomm:
			if ('\n' == c) {
				state = normal;
				oldline++;
				addchr('\n');
				addchr(0);
				return (line);
			}
			continue;

		case bsl:
			switch (c) {
			case ' ':
			case '\t':
				state = incont;
				continue;

			case '\n':
				oldline++;
				state = normal;
				continue;
			}
			state = normal;
			addchr('\\');
			addchr(c);
			continue;
		}
	}
	
}

#ifdef TEST
main()
{
	int line = 1;
	char *got;

	for (;;) {
		if (NULL == (got = getline(stdin, &line)))
			exit(0);
		printf("%d - %s\n", line, got);
	}
}
#endif
