/* RWDOCS */
#ifndef ICMP_H
#define ICMP_H
#include "mbuf.h"
#include "ip.h"

/* Internet Control Message Protocol */

/* Message types */
#define	ECHO_REPLY	0	/* Echo Reply */
#define	DEST_UNREACH	3	/* Destination Unreachable */
#define	QUENCH		4	/* Source Quench */
#define	REDIRECT	5	/* Redirect */
#define	ECHO_RQST	8	/* Echo Request - chgd because of termio.h
		included by W5GFE.  It defined ECHO -- K5JB */
#define	TIME_EXCEED	11	/* Time-to-live Exceeded */
#define	PARAM_PROB	12	/* Parameter Problem */
#define	TIMESTAMP	13	/* Timestamp */
#define	TIME_REPLY	14	/* Timestamp Reply */
#define	INFO_RQST	15	/* Information Request */
#define	INFO_REPLY	16	/* Information Reply */

/* Internal format of an ICMP header (checksum is missing) */
struct icmp {
	int32 type;
	int32 code;
 	union icmp_args {
		int32 unused;
		unsigned char pointer;
		int32 address;
		struct {
			int32 id;
			int32 seq;
		} echo;
	} args;
};
#define	ICMPLEN		8	/* Length of ICMP header on the net */
#define	NULLICMP	(union icmp_args *)0
	
/* Destination Unreachable codes */
#define	NET_UNREACH	0	/* Net unreachable */
#define	HOST_UNREACH	1	/* Host unreachable */
#define	PROT_UNREACH	2	/* Protocol unreachable */
#define	PORT_UNREACH	3	/* Port unreachable */
#define	FRAG_NEEDED	4	/* Fragmentation needed and DF set */
#define	ROUTE_FAIL	5	/* Source route failed */

/* Time Exceeded codes */
#define	TTL_EXCEED	0	/* Time-to-live exceeded */
#define	FRAG_EXCEED	1	/* Fragment reassembly time exceeded */

/* Redirect message codes */
#define	REDR_NET	0	/* Redirect for the network */
#define	REDR_HOST	1	/* Redirect for the host */
#define	REDR_TOS	2	/* Redirect for Type of Service, or-ed with prev */

struct icmp_errors {
	int32 checksum;		/* ICMP Checksum errors */
	unsigned nospace;		/* alloc_mbuf failed someplace */
	unsigned noloop;		/* No ICMP in response to an ICMP */
	unsigned bdcsts;		/* Ignore broadcast ICMPs */
};
#define	ICMP_TYPES	17
struct icmp_stats {
	unsigned input[ICMP_TYPES];	/* ICMP input stats by type */
	unsigned output[ICMP_TYPES];	/* ICMP output stats by type */
};

/* ICMP messages, decoded */
extern char *icmptypes[],*unreach[],*exceed[],*redirect[];

#ifdef GCC

void icmp_input(struct mbuf *bp,int32 protocol,int32 source,int32 dest,
	int32 tos,int32 length,int32 rxbroadcast);
int icmp_output(struct ip *ip,struct mbuf *data,int32 type,int32 code,
	union icmp_args *args);
struct mbuf *htonicmp(struct icmp *icmp,struct mbuf *data);
void ntohicmp(struct icmp *icmp,struct mbuf **bpp);
int doicmpstat();
void icmpclk();
int doping(int argc,char **argv);
void ptimeout(char *p);
int pingem(int32 dest,int32 seq,int32 id);
void echo_proc(int32 source,int32 dest,struct icmp *icmp);
int32 hash_ping(int32 dest);
struct ping *add_ping(int32 dest);
void del_ping(struct ping *pp);

#ifdef TRACE
void icmp_dump(struct mbuf **bpp,int32 source,int32 dest,int check);
#endif /* TRACE */

#else
void icmp_input(), ntohicmp(), icmpclk(), ptimeout(), echo_proc(), del_ping();
int icmp_output(), doicmpstat(), doping(), pingem();
int32 hash_ping();
struct mbuf *htonicmp();
struct ping *add_ping();

#ifdef TRACE
void icmp_dump();
#endif /* TRACE */

#endif /* GCC */

/* RWDOCE */
#endif /* ICMP_H */
