/* 7/29/91 Corrected placement of ifdef NETROM in arpadd() */
/* 2/18/92 Added a pseudo ROSE arp entry to try and trick ROSE ckts */
/* RWDOCS */
#include "config.h"

#if defined(ETHER)

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "timer.h"
#ifdef ETHER
#include "enet.h"
#endif
#include "iface.h"
#include "arp.h"
#include "cmdparse.h"
/* RWDOCE */
extern char badhost[];
extern char nospace[];

int doarpadd(),doarpdrop();

/* RWDOCS */
struct cmds arpcmds[] = {
{	"add", doarpadd, 4,
#ifdef ETHER
	"arp add <hostid> ether <ether addr>",	"arp add failed" },
#else
	NULL, NULL },
#endif

{	"drop", doarpdrop, 3,
#ifdef ETHER
	"arp drop <hostid> ether",
#else
	NULLCHAR,
#endif	/* ETHER */
	"not in table" },

{	"publish", doarpadd, 4,

#ifdef ETHER
	"arp publish <hostid> ether <ether addr>",
#else
	NULLCHAR, 
#endif /* ETHER */
	"arp publish failed" },

{	NULLCHAR, NULLFP, 0,
	"arp subcommands: add, drop, publish",
	NULLCHAR }
};
char *arptypes[] = {	/* little bit of wasted space here - K5JB */
	"Netrom",
	"Ethernet",
	"Exp-Ethernet",
	"Ax-25",
	"Pronet",
	"Chaos",
	"Blank",
	"Arcnet",
	"Appletalk"
};

int
doarp(argc,argv)
int argc;
char **argv;
{

/* RWDOCE */

	int subcmd(),dumparp();

	if(argc < 2){
		dumparp();
		return 0;
	}
	return subcmd(arpcmds,argc,argv);
}

/* RWDOCS */
#include <ctype.h>
int
doarpadd(argc,argv)
int argc;
char **argv;
{

/* RWDOCE */
	int16 hwalen,hardware,naddr;
	int32 addr,resolve();
	void free();
	int stop_timer();
	char *hwaddr;
	struct arp_tab *ap;
	struct arp_type *at;
	void arp_drop();
	int pub = 0;

	if(argv[0][0] == 'p')	/* Is this entry published? */
		pub = 1;
	if((addr = resolve(argv[1])) == 0){
		printf(badhost,argv[1]);
		return 1;
	}

	/* This is a kludge. It really ought to be table driven */
	switch(tolower(argv[2][0])){
#ifdef ETHER
	case 'e':	/* "ether" */
		hardware = ARP_ETHER;
		naddr = 1;
		break;
#endif
	default:
		printf("unknown hardware type \"%s\"\n",argv[2]);
		return -1;
	}
	/* If an entry already exists, clear it */
	if((ap = arp_lookup(hardware,addr)) != NULLARP)
		arp_drop(ap);

	at = &arp_type[hardware];
	if(at->scan == NULLFP){
		printf("Attach device first\n");
		return 1;
	}
	/* Allocate buffer for hardware address and fill with remaining args */
	hwalen = at->hwalen * naddr;
	if((hwaddr = malloc(hwalen)) == NULLCHAR){
		printf(nospace);
		return 0;
	}
	/* Destination address */
	(*at->scan)(hwaddr,&argv[3],argc - 3);
	ap = arp_add(addr,hardware,hwaddr,hwalen,pub);	/* Put in table */
	free(hwaddr);					/* Clean up */
	stop_timer(&ap->timer);			/* Make entry permanent */
	ap->timer.count = ap->timer.start = 0;
	return 0;
}
/* RWDOCS */
/* Remove an ARP entry */
int
doarpdrop(argc,argv)
int argc;
char **argv;
{

/* RWDOCE */
	int16 hardware;
	int32 addr,resolve();
	struct arp_tab *ap;
	void arp_drop();
	argc = argc;
	if((addr = resolve(argv[1])) == 0){
		printf(badhost,argv[1]);
		return 1;
	}
	/* This is a kludge. It really ought to be table driven */
	switch(tolower(argv[2][0])){
#ifdef ETHER
	case 'e':	/* "ether" */
		hardware = ARP_ETHER;
		break;
#endif
	default:
		hardware = 0;
		break;
	}
	if((ap = arp_lookup(hardware,addr)) == NULLARP)
		return -1;
	arp_drop(ap);
	return 0;
}
/* RWDOCS */
/* Dump ARP table */
int 
dumparp()
{

/* RWDOCE */
	register int i;
	extern struct arp_stat arp_stat;
	register struct arp_tab *ap;
	char e[128];
	char *inet_ntoa();


	printf("received %u badtype %u bogus addr %u reqst in %u replies %u reqst out %u\n",
	 arp_stat.recv,arp_stat.badtype,arp_stat.badaddr,arp_stat.inreq,
	 arp_stat.replies,arp_stat.outreq);

	printf("IP addr         Type           Time Q Addr\n");
	for(i=0;i<ARPSIZE;i++){
		for(ap = arp_tab[i];ap != (struct arp_tab *)0;ap = ap->next){
			printf("%-16s",inet_ntoa(ap->ip_addr));
			printf("%-15s",arptypes[ap->hardware]);
			printf("%-5ld",ap->timer.count*(long)MSPTICK/1000);
			if(ap->state == ARP_PENDING)
				printf("%-2u",len_q(ap->pending));
			else
				printf("  ");
			if(ap->state == ARP_VALID){
				if(arp_type[ap->hardware].format != NULLFP){
					(*arp_type[ap->hardware].format)(e,ap->hw_addr);
				} else {
					e[0] = '\0';
				}
				printf("%s",e);
			} else {
				printf("[unknown]");
			}
			if(ap->pub)
				printf(" (published)");
			printf("\n");
		}
	}
	return 0;
}
#endif /* ETHER */
