*   macros for C language routines
*
*
	macro
	bcall
	balr	14,15
	mend
*
	macro
	fcall
	balr	14,15
	mend
*
	macro
	mainloc
$main	csect
	mend
*
	macro
	codeloc
	gblc	&sec
&sec.c	csect
	mend
*
	macro
	dataloc
	gblc	&sec
&sec.p	csect
	mend
*
	macro
	strgloc
	gblc	&sec
&sec.p	csect
	mend
*
	macro
	istrloc
	gblc	&sec
&sec.s	csect
	mend
	macro
	litloc
	gblc	&sec
&sec.p	csect
	mend
*
	macro
	tvecloc
	gblc	&sec
&sec.p	csect
	mend
*
	macro
&loc	intaddr	&name
	gblc	&sec
	cnop	0,4
&loc	equ	*
	dc	a(&name)
	mend
*
	macro
&loc	intfunc	&name
	gblc	&sec
	cnop	0,4
&loc	equ	*
	dc	a(&name)
	mend
*
	macro
&loc	extaddr	&name
	cnop	0,4
&loc	equ	*
	dc	v(&name)
	mend
*
	macro
&loc	extfunc	&name
	cnop	0,4
&loc	equ	*
	dc	v(&name)
	mend
	macro
&name	startup
	gblc	&sec
&sec	setc	'&name'
&sec.c	csect
&sec.p	csect
&sec.c	csect
* Register usage
*
hgautop	equ	12
hgargp	equ	13
$base1	equ	10
$base2	equ	11
$base3	equ	9
$base4	equ	8
	mend
*
*
         macro
	subsave
	gblc	&sec
	mainloc
	stm	14,12,12(13)
	lr	$base1,15
	using	$main$,$base1
	l	$base2,72(13)
	using	&sec.p,$base2
	la	$base3,stack$
	st	13,4($base3)
	la	13,20($base3)
         mend
*
*
*
         macro
	 subretrn   &cc=0
	l	15,b$cexit
	ltr	15,15
	be	return$
	la	1,0
	lfunc	15,b$cexit
	bcall
return$	l	13,stack$+4
	lm	14,12,12(13)
	la	15,0
	br	14
b$cexit	dc	f'0'
         mend
*
	macro
	stackdo
	dc	c'stack'
stack$	dc	1000f'0'
	entry	stack$
	dc	c'end stack'
	mend
*
*
*
*
	 macro
&name    prolog     &ndp
	gblc	&sec
	gbla	&fnum
         lcla  &a
&a       seta  4*(&ndp)
&fnum	seta	&fnum+1
	codeloc
	cnop	0,4
	dc	cl12'&name'
	dc	f'&a'
&name	equ	*
	stm	0,15,&a.(13)	save registers
         lr    $base1,15
         using &name,$base1    first $  addresses this code
	l	$base2,b&sysndx
	using	&sec.p,$base2
	lr	12,13
	la	13,ss$&fnum.(13)
	l	$base3,c&sysndx
	l	$base4,d&sysndx
         b     go&sysndx
	cnop	0,4
b&sysndx	dc	a(&sec.p)
c&sysndx         dc    a(&sec.p+4096)
d&sysndx	dc	a(&name+4096)
go&sysndx	equ	*
         using &sec.p+4096,$base3
	using	&name+4096,$base4
         mend
*
*
         macro
&name    epilog     &ndp,&stk      number of declared parameters
	gbla	&fnum
         lcla  &a
&a       seta  &ndp*4
&name         lm    1,15,&a.+4(12)
	br	14
ss$&fnum	equ	&stk
         mend
*
*
*
	macro
	runmain
	la	13,20(13)
	lr	3,1
	lfunc	15,@gtarg@
	la	1,0
	bcall
	st	0,0(13)
	l	2,=v(#argv#)
	st	2,4(13)
	lfunc	15,@main@
	la	1,8
	bcall
	b	go&sysndx
@main@	intfunc	main
@gtarg@	extfunc	#gtargs
go&sysndx	equ	*
	mend
*
	macro
	movif	&fr,&r
	gbla	&fflg
	aif	(&fflg ne 0).ok2
&fflg	seta	1
	dataloc
	cnop	0,8
$fltcs	dc	xl8'4e00000000000000'
$fltmp	dc	d'0.0'
	codeloc
.ok2	anop
	ld	&fr,$fltcs
	std	&fr,$fltmp
	ltr	&r,&r
	bm	flt&sysndx
	st	&r,$fltmp+4
	ad	&fr,$fltmp
	b	flt&sysndx.a
flt&sysndx	equ	*
	lpr	&r,&r
	st	&r,$fltmp
	sd	&fr,$fltmp
flt&sysndx.a	equ	*
	mend
	macro
	movfi	&fr,&r
	gbla	&fflg
	aif	(&fflg ne 0).ok
&fflg	seta	1
	dataloc
	cnop	0,8
$fltcs	dc	xl8'4e00000000000000'
$fltmp	dc	d'0.0'
	codeloc
.ok	anop
	aw	&fr,$fltcs
	std	&fr,$fltmp
	l	&r,$fltmp
	bc	10,flb&sysndx
	lnr	&r,&r
flb&sysndx equ *
	mend
*
	macro
	entname	&name
	dataloc
	entry	&name
	mend
*
	macro
&name	defext
&name	equ	*
&name.p	equ	*
	mend
*
	macro
	lfunc	&reg,&add
	l	&reg,&add
	mend
*
	macro
	lc	&reg,&add
	sr	&reg,&reg
	ic	&reg,&add
	mend
*
*
*
* end of macros
*
