/*
 * manifest constants
 *  the following attempt to take into account things like
 *  system blocksize, the word length on the machine running UNIX
 *  and the resultant change in some of the structures.  Quite beneficial
 *  when used in conjunction with "sizeof" in the c compiler for attempting
 *  fairly machine independent code...
 */
#define	BLKSIZE		512
#define	BLKSIZEW	(BLKSIZE/4)	/* blocksize in words */
#define	DIRENTSZ	16		/* total bytes in directory entry */
#define	WORDSIZE	4		/* four byte words */

/*
 * signals
 * dont change
 */

 /* actually these will have to change slightly for 370 implentation.
  * certain things like iot and emt dont exist, but other kinds of program
  * interrupts do
  */
#define		SIGHUP	1	/* hangup */
#define		SIGINT	2	/* interrupt (rubout) */
#define		SIGQIT	3	/* quit (FS) */
#define		SIGINS	4	/* illegal instruction */
#define		SIGTRC	5	/* trace or breakpoint */
#define		SIGIOT	6	/* iot */
#define		SIGEMT	7	/* emt */
#define		SIGFPT	8	/* floating exception */
#define		SIGKIL	9	/* kill */
#define		SIGBUS	10	/* bus error */
#define		SIGSEG	11	/* segmentation violation */
#define		SIGSYS	12	/* sys */
#define		SIGPIPE	13	/* end of pipe */
#define		SIGPGM 14	/* 370 program interrupt */
#define	NSIG	(SIGPGM+16)

/*
 * fundamental constants
 * cannot be changed
 */

#define USIZE	1		/* size of user struct in pages */
#define	NULL	0
#define	NODEV	(-1)
#define	ROOTINO	1		/* i number of all roots */
#define	DIRSIZ	14		/* max characters per directory */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
	char	fil1byte;
	char	fil2byte;
	char	hibyte;
	char	lobyte;
};

/*
 * structure to access an integer
 */
struct
{
	int	integ;
};

/*
 * Certain processor registers
 */
 /* these don't exist at all on 370
#define PS	0177776
#define KL	0177560
#define SW	0177570
  */

