/*
 * Definition of the unix super block.
 * The root super block is allocated and
 * read in iinit/alloc.c. Subsequently
 * a super block is allocated and read
 * with each mount (smount/sys3.c) and
 * released with unmount (sumount/sys3.c).
 * A disk block is ripped off for storage.
 * See alloc.c for general alloc/free
 * routines for free list and I list.
 */

#define	SFREESIZ	50
#define	SINODESZ	50
#define	SPADSIZE	22
struct	filsys
{
	int	s_isize;	/* size in blocks of I list */
	int	s_fsize;	/* size in blocks of entire volume */
	int	s_nfree;	/* number of in core free blocks (0-FREESIZ) */
	int	s_free[SFREESIZ];	/* in core free blocks */
	int	s_ninode;	/* number of in core I nodes (0-FREESIZ) */
	int	s_inode[SINODESZ];	/* in core free I nodes */
	char	s_flock;	/* lock during free list manipulation */
	char	s_ilock;	/* lock during I list manipulation */
	char	s_fmod;		/* super block modified flag */
	char	s_ronly;	/* mounted read-only flag */
	int	s_time;		/* current date of last update */
 	int	pad[SPADSIZE]; 
};
